/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.adaptx.xpath.engine;

import org.exolab.adaptx.xpath.NodeSet;
import org.exolab.adaptx.xpath.XPathContext;
import org.exolab.adaptx.xpath.XPathException;
import org.exolab.adaptx.xpath.XPathExpression;
import org.exolab.adaptx.xpath.XPathNode;
import org.exolab.adaptx.xpath.XPathResult;
import org.exolab.adaptx.xpath.engine.ErrorExpr;
import org.exolab.adaptx.xpath.engine.FilterBase;
import org.exolab.adaptx.xpath.engine.LocationStep;
import org.exolab.adaptx.xpath.engine.MatchExpression;

public class PathExpr
extends XPathExpression
implements MatchExpression {
    public final int ABSOLUTE = 0;
    public final int RELATIVE = 1;
    private ErrorExpr error = null;
    private FilterBase _filter = null;
    private PathExpr _subPath = null;
    private PathExpr parent = null;

    public PathExpr() {
    }

    public PathExpr(ErrorExpr errorExpr) {
        this.error = errorExpr;
    }

    public PathExpr(FilterBase filterBase) {
        this._filter = filterBase;
    }

    public PathExpr(FilterBase filterBase, PathExpr pathExpr) {
        this._filter = filterBase;
        this._subPath = pathExpr;
        this._subPath.parent = this;
    }

    public XPathResult evaluate(XPathContext xPathContext) throws XPathException {
        if (this.error != null) {
            this.error.evaluate(xPathContext);
        }
        return this.evaluate(xPathContext, true);
    }

    protected NodeSet evaluate(XPathContext xPathContext, boolean bl) throws XPathException {
        XPathNode xPathNode = xPathContext.getNode();
        if (this._filter == null || xPathNode == null) {
            return xPathContext.newNodeSet(0);
        }
        XPathContext xPathContext2 = xPathContext;
        if (bl && this.isAbsolute() && xPathNode.getNodeType() != 9) {
            xPathNode = xPathNode.getRootNode();
            xPathContext2 = xPathContext.newContext(xPathNode);
        }
        NodeSet nodeSet = (NodeSet)this._filter.evaluate(xPathContext2);
        if (this._subPath != null && nodeSet.size() > 0) {
            NodeSet nodeSet2 = xPathContext2.newNodeSet();
            XPathContext xPathContext3 = xPathContext2.newContext(nodeSet, 0);
            int n = 0;
            while (n < nodeSet.size()) {
                xPathContext3.setPosition(n);
                nodeSet2.add(this._subPath.evaluate(xPathContext3, false));
                ++n;
            }
            nodeSet = nodeSet2;
        }
        if (nodeSet == null) {
            nodeSet = xPathContext.newNodeSet(0);
        }
        return nodeSet;
    }

    public double getDefaultPriority() {
        if (this._subPath != null) {
            return 0.5;
        }
        return this._filter.getDefaultPriority();
    }

    public short getExprType() {
        return 5;
    }

    public FilterBase getFilter() {
        return this._filter;
    }

    private boolean hasDescendantsAxis(FilterBase filterBase) {
        if (filterBase.getExprType() == 7) {
            LocationStep locationStep = (LocationStep)filterBase;
            short s = locationStep.getAxisIdentifier();
            return s == 4 || s == 5;
        }
        return false;
    }

    public boolean isAbsolute() {
        if (this._filter == null) {
            return true;
        }
        return this._filter.getAncestryOp() != 0;
    }

    public boolean matches(XPathNode xPathNode, XPathContext xPathContext) throws XPathException {
        Object object;
        if (this.error != null) {
            this.error.evaluate(xPathContext);
        }
        if (xPathNode == null || this._filter == null) {
            return false;
        }
        XPathContext xPathContext2 = xPathContext.newContext(xPathNode);
        if (this._subPath == null) {
            boolean bl = this.hasDescendantsAxis(this._filter);
            switch (this._filter.getAncestryOp()) {
                case 1: {
                    XPathNode xPathNode2 = xPathNode.getParentNode();
                    NodeSet nodeSet = xPathContext2.getNodeSet();
                    while (xPathNode2 != null) {
                        nodeSet.clear();
                        nodeSet.add(xPathNode2);
                        if (this._filter.matches(xPathNode, xPathContext2)) {
                            return true;
                        }
                        XPathNode xPathNode3 = xPathNode2 = bl ? xPathNode2.getParentNode() : null;
                    }
                    break;
                }
                default: {
                    XPathNode xPathNode4 = xPathNode;
                    NodeSet nodeSet = xPathContext2.getNodeSet();
                    while (xPathNode4 != null) {
                        nodeSet.clear();
                        nodeSet.add(xPathNode4);
                        if (this._filter.matches(xPathNode, xPathContext2)) {
                            return true;
                        }
                        xPathNode4 = xPathNode4.getParentNode();
                    }
                    break block0;
                }
            }
            return false;
        }
        PathExpr pathExpr = this;
        while (pathExpr._subPath != null) {
            pathExpr = pathExpr._subPath;
        }
        NodeSet nodeSet = xPathContext.newNodeSet(2);
        NodeSet nodeSet2 = xPathContext.newNodeSet(2);
        NodeSet nodeSet3 = null;
        nodeSet.add(xPathNode);
        while (pathExpr != null) {
            object = pathExpr._filter;
            boolean bl = this.hasDescendantsAxis((FilterBase)object);
            int n = 0;
            while (n < nodeSet.size()) {
                XPathNode xPathNode5 = nodeSet.item(n);
                switch (((FilterBase)object).getAncestryOp()) {
                    case 1: {
                        NodeSet nodeSet4;
                        XPathNode xPathNode6 = xPathNode5.getParentNode();
                        while (xPathNode6 != null) {
                            nodeSet4 = xPathContext2.getNodeSet();
                            nodeSet4.clear();
                            nodeSet4.add(xPathNode6);
                            if (((FilterBase)object).matches(xPathNode5, xPathContext2)) {
                                nodeSet2.add(xPathNode6);
                            }
                            XPathNode xPathNode7 = xPathNode6 = bl ? xPathNode6.getParentNode() : null;
                        }
                        break;
                    }
                    default: {
                        NodeSet nodeSet4;
                        XPathNode xPathNode6;
                        if (pathExpr == this) {
                            xPathNode6 = xPathNode5;
                            nodeSet4 = xPathContext2.getNodeSet();
                            while (xPathNode6 != null) {
                                nodeSet4.clear();
                                nodeSet4.add(xPathNode6);
                                if (((FilterBase)object).matches(xPathNode5, xPathContext2)) {
                                    return true;
                                }
                                xPathNode6 = xPathNode6.getParentNode();
                            }
                            break;
                        }
                        return false;
                    }
                }
                ++n;
            }
            if (nodeSet2.size() == 0) {
                return false;
            }
            nodeSet.clear();
            nodeSet3 = nodeSet;
            nodeSet = nodeSet2;
            nodeSet2 = nodeSet3;
            if (pathExpr == this) break;
            pathExpr = pathExpr.parent;
        }
        if (this.isAbsolute()) {
            object = xPathNode.getRootNode();
            return nodeSet.contains((XPathNode)object);
        }
        return nodeSet.size() > 0;
    }

    public void setFilter(FilterBase filterBase) {
        this._filter = filterBase;
    }

    public void setSubPath(PathExpr pathExpr) {
        if (this._subPath != null) {
            this._subPath.parent = null;
        }
        this._subPath = pathExpr;
        if (this._subPath != null) {
            this._subPath.parent = this;
        }
    }

    public String toString() {
        return this.toString(null);
    }

    private String toString(StringBuffer stringBuffer) {
        if (stringBuffer == null) {
            stringBuffer = new StringBuffer();
        }
        if (this._filter != null) {
            switch (this._filter.getAncestryOp()) {
                case 1: {
                    stringBuffer.append("/");
                    break;
                }
            }
            stringBuffer.append(this._filter.toString());
        }
        if (this._subPath != null) {
            this._subPath.toString(stringBuffer);
        }
        return stringBuffer.toString();
    }
}

