/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.adaptx.xpath.functions;

import org.exolab.adaptx.xpath.StringResult;
import org.exolab.adaptx.xpath.XPathContext;
import org.exolab.adaptx.xpath.XPathException;
import org.exolab.adaptx.xpath.XPathResult;
import org.exolab.adaptx.xpath.engine.FunctionCall;

public class Substring
extends FunctionCall {
    public Substring() {
        super("substring");
    }

    public XPathResult evaluate(XPathContext xPathContext) throws XPathException {
        int n = this.getParameterCount();
        if (n < 2 || n > 3) {
            throw new XPathException("invalid number of parameters for function: " + this);
        }
        XPathResult xPathResult = this.getParameter(0).evaluate(xPathContext);
        String string = xPathResult.stringValue();
        int n2 = 1;
        xPathResult = this.getParameter(1).evaluate(xPathContext);
        double d = xPathResult.numberValue();
        if (Double.isNaN(d) || Double.isInfinite(d)) {
            return StringResult.EMPTY;
        }
        n2 = (int)Math.round(d);
        if (n == 2) {
            n2 = n2 > 0 ? --n2 : 0;
            xPathResult = new StringResult(string.substring(n2));
        } else {
            xPathResult = this.getParameter(2).evaluate(xPathContext);
            d = xPathResult.numberValue();
            if (Double.isNaN(d)) {
                return StringResult.EMPTY;
            }
            if (Double.isInfinite(d)) {
                return new StringResult(string);
            }
            int n3 = (int)Math.round(d);
            int n4 = n2 + n3 - 1;
            n2 = n2 > 0 ? --n2 : 0;
            xPathResult = new StringResult(string.substring(n2, n4));
        }
        return xPathResult;
    }
}

