/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.adaptx.xslt.functions;

import org.exolab.adaptx.net.URIException;
import org.exolab.adaptx.net.URILocation;
import org.exolab.adaptx.util.ErrorObserver;
import org.exolab.adaptx.xml.dom2xpn.DocumentWrapperXPathNode;
import org.exolab.adaptx.xpath.NodeSet;
import org.exolab.adaptx.xpath.XPathContext;
import org.exolab.adaptx.xpath.XPathException;
import org.exolab.adaptx.xpath.XPathResult;
import org.exolab.adaptx.xslt.ProcessorState;
import org.exolab.adaptx.xslt.XSLTFunction;
import org.exolab.adaptx.xslt.util.Configuration;
import org.w3c.dom.Document;

public class DocumentFunctionCall
extends XSLTFunction {
    private ProcessorState ps = null;

    public DocumentFunctionCall(ProcessorState processorState) {
        super("document");
        this.ps = processorState;
    }

    public XPathResult call(XPathContext xPathContext, XPathResult[] xPathResultArray) throws XPathException {
        if (xPathResultArray.length < 1 || xPathResultArray.length > 2) {
            throw new XPathException("invalid number of parameters for function: " + this);
        }
        NodeSet nodeSet = new NodeSet();
        switch (xPathResultArray[0].getResultType()) {
            case 3: {
                NodeSet nodeSet2 = (NodeSet)xPathResultArray[0];
                int n = 0;
                while (n < nodeSet2.size()) {
                    String string = nodeSet2.item(n).getStringValue();
                    Document document = this.getDocument(string);
                    if (document == null) {
                        String string2 = "Unable to read document: " + string;
                        this.ps.getErrorObserver().receiveError(string2, 2);
                    }
                    if (document != null) {
                        nodeSet.add(new DocumentWrapperXPathNode(document));
                    }
                    ++n;
                }
                break;
            }
            default: {
                String string = xPathResultArray[0].stringValue();
                Document document = this.getDocument(string);
                if (document == null) {
                    String string3 = "Unable to read document: " + string;
                    this.ps.getErrorObserver().receiveError(string3, 2);
                }
                if (document == null) break;
                nodeSet.add(new DocumentWrapperXPathNode(document));
            }
        }
        return nodeSet;
    }

    private Document getDocument(String string) {
        Object object;
        Object object2;
        URILocation uRILocation = null;
        URILocation uRILocation2 = this.ps.getStylesheetLocation();
        if (string == null || string.length() == 0) {
            if (uRILocation2 == null) {
                return null;
            }
            uRILocation = uRILocation2;
        } else {
            object2 = null;
            if (uRILocation2 != null) {
                object2 = uRILocation2.getBaseURI();
            }
            object = this.ps.getURIResolver();
            try {
                uRILocation = object.resolve(string, (String)object2);
            }
            catch (URIException uRIException) {
                ErrorObserver errorObserver = this.ps.getErrorObserver();
                errorObserver.receiveError(uRIException.getMessage());
                return null;
            }
        }
        object2 = this.ps.getErrorObserver();
        object = Configuration.getDOMParser();
        return object.readDocument(uRILocation, (ErrorObserver)object2);
    }
}

