/*
 * Decompiled with CFR 0.152.
 */
package org.mitre.tjt.text;

import java.text.FieldPosition;
import java.text.NumberFormat;
import java.text.ParsePosition;

public class RomanNumberFormat
extends NumberFormat {
    public static final int I = 1;
    public static final int V = 5;
    public static final int X = 10;
    public static final int L = 50;
    public static final int C = 100;
    public static final int D = 500;
    public static final int M = 1000;
    private static final String validChars = "ivxlcdm";
    private static final int[] charValues = new int[]{1, 5, 10, 50, 100, 500, 1000};
    private boolean upperCaseFormat;

    public RomanNumberFormat(boolean bl) {
        this.upperCaseFormat = bl;
    }

    public StringBuffer format(double d, StringBuffer stringBuffer, FieldPosition fieldPosition) {
        return this.format((long)d, stringBuffer, fieldPosition);
    }

    public StringBuffer format(long l, StringBuffer stringBuffer, FieldPosition fieldPosition) {
        StringBuffer stringBuffer2 = new StringBuffer();
        while (l > 0L) {
            if (l >= 1000L) {
                stringBuffer2.append('m');
                l -= 1000L;
                continue;
            }
            if (l >= 500L && l < 900L) {
                stringBuffer2.append('d');
                l -= 500L;
                continue;
            }
            if (l >= 100L) {
                stringBuffer2.append('c');
                if (l >= 400L) {
                    l += 100L;
                    continue;
                }
                l -= 100L;
                continue;
            }
            if (l >= 50L && l < 90L) {
                stringBuffer2.append('l');
                l -= 50L;
                continue;
            }
            if (l >= 10L) {
                stringBuffer2.append('x');
                if (l >= 40L) {
                    l += 10L;
                    continue;
                }
                l -= 10L;
                continue;
            }
            if (l >= 5L && l < 9L) {
                stringBuffer2.append('v');
                l -= 5L;
                continue;
            }
            stringBuffer2.append('i');
            if (l >= 4L) {
                ++l;
                continue;
            }
            --l;
        }
        String string = stringBuffer2.toString();
        if (this.upperCaseFormat) {
            stringBuffer.append(string.toUpperCase());
        } else {
            stringBuffer.append(string);
        }
        return stringBuffer;
    }

    public static void main(String[] stringArray) throws Exception {
        if (stringArray.length < 2) {
            System.out.println("Usage: java RomanNumberSequence true|false number");
            System.exit(0);
        }
        boolean bl = Boolean.valueOf(stringArray[0]);
        long l = Long.parseLong(stringArray[1]);
        RomanNumberFormat romanNumberFormat = new RomanNumberFormat(bl);
        System.out.print("Formated number: ");
        String string = romanNumberFormat.format(l);
        System.out.println(string);
        System.out.print("Parsed number: ");
        long l2 = romanNumberFormat.parse(string).longValue();
        System.out.println(l2);
        System.out.println(l == l2 ? "Success" : "Failure");
    }

    public Number parse(String string, ParsePosition parsePosition) {
        string = string.toLowerCase();
        int n = string.length();
        long l = 0L;
        int n2 = parsePosition.getIndex();
        while (n2 < n) {
            int n3;
            char c = string.charAt(n2);
            int n4 = validChars.indexOf(c);
            if (n4 == -1) break;
            int n5 = n3 = n2 + 1 < n ? validChars.indexOf(string.charAt(n2 + 1)) : -1;
            l = n3 > n4 ? (l -= (long)charValues[n4]) : (l += (long)charValues[n4]);
            ++n2;
        }
        parsePosition.setIndex(n2);
        return new Long(l);
    }
}

