/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.jtf;

import java.io.IOException;
import java.io.OutputStream;
import org.exolab.exceptions.CWClassConstructorException;
import org.exolab.jtf.CWInvalidNodeException;
import org.exolab.jtf.CWNoTestsExecuted;
import org.exolab.jtf.CWTestCategory;
import org.exolab.jtf.CWTestNode;
import org.exolab.jtf.CWVerboseStream;

public class CWTestHarness {
    private CWTestNode _lastExecuted;
    private CWTestCategory _root;

    public CWTestHarness(String string) throws CWClassConstructorException {
        if (string.indexOf(".") != -1) {
            throw new CWClassConstructorException(String.valueOf(string) + " contains a .");
        }
        this._root = new CWTestCategory(string, "root");
        this._lastExecuted = null;
    }

    public boolean add(String string, CWTestNode cWTestNode) {
        return this.add(string, cWTestNode, false);
    }

    public boolean add(String string, CWTestNode cWTestNode, boolean bl) {
        boolean bl2 = false;
        if (!this.exists(string) || bl) {
            bl2 = this.put(string, cWTestNode);
        }
        return bl2;
    }

    public boolean execute(OutputStream outputStream, boolean bl) throws IOException {
        CWVerboseStream cWVerboseStream = new CWVerboseStream(outputStream, bl);
        this._root.execute(cWVerboseStream);
        this._lastExecuted = this._root;
        return this._root.result();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean execute(String string, OutputStream outputStream, boolean bl) throws CWInvalidNodeException, IOException {
        boolean bl2 = false;
        if (string.compareTo("*") == 0) {
            return this.execute(outputStream, bl);
        }
        int n = string.indexOf(".");
        String string2 = n < 0 ? string : string.substring(0, n);
        if (string2.compareTo(this._root.name()) != 0) throw new CWInvalidNodeException(String.valueOf(string2) + " is not a valid root node");
        CWTestNode cWTestNode = this.nodeAt(this._root, string.substring(n + 1));
        if (cWTestNode == null) throw new CWInvalidNodeException(String.valueOf(string) + " is not a valid entry point");
        CWVerboseStream cWVerboseStream = new CWVerboseStream(outputStream, bl);
        cWTestNode.execute(cWVerboseStream);
        this._lastExecuted = cWTestNode;
        return cWTestNode.result();
    }

    public boolean exists(String string) {
        boolean bl = false;
        if (this.nodeAt(string) != null) {
            bl = true;
        }
        return bl;
    }

    public void info(OutputStream outputStream) throws IOException {
        this._root.info(outputStream);
    }

    public CWTestNode nodeAt(String string) {
        return this.nodeAt(this._root, string);
    }

    private CWTestNode nodeAt(CWTestNode cWTestNode, String string) {
        CWTestNode cWTestNode2 = null;
        if (string.indexOf(".") >= 0) {
            int n = string.indexOf(".");
            String string2 = string.substring(0, n);
            String string3 = string.substring(n + 1);
            if (cWTestNode.exists(string2)) {
                cWTestNode2 = this.nodeAt(cWTestNode.nodeAt(string2), string3);
            } else {
                System.out.println("Failed to find branch " + string2);
            }
        } else if (cWTestNode.exists(string)) {
            cWTestNode2 = cWTestNode.nodeAt(string);
        }
        return cWTestNode2;
    }

    private boolean put(String string, CWTestNode cWTestNode) {
        boolean bl = false;
        if (string.indexOf(".") >= 0) {
            String string2 = string.substring(0, string.lastIndexOf("."));
            String string3 = string.substring(string.lastIndexOf(".") + 1);
            CWTestNode cWTestNode2 = this.nodeAt(this._root, string2);
            if (cWTestNode != null && cWTestNode instanceof CWTestCategory) {
                ((CWTestCategory)cWTestNode2).add(string3, cWTestNode);
                bl = true;
            }
        } else {
            this._root.add(string, cWTestNode);
            bl = true;
        }
        return bl;
    }

    public boolean result() throws IOException, CWNoTestsExecuted {
        boolean bl = false;
        if (this._lastExecuted == null) {
            throw new CWNoTestsExecuted("No tests have been executed");
        }
        bl = this._lastExecuted.result();
        return bl;
    }

    public void result(OutputStream outputStream) throws CWNoTestsExecuted, IOException {
        if (this._lastExecuted == null) {
            throw new CWNoTestsExecuted("No tests have been executed");
        }
        this._lastExecuted.result(outputStream);
    }
}

