/***************************************************************************
 *            cxp-file-list-store.h
 *
 *    9  3 23:50:52 2005
 *  Copyright  2005  Yasumichi Akahoshi
 *  yasumichi@users.sourceforge.jp
 ***************************************************************************/

/*
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifndef CXP_FILE_LIST_STORE_H
#define CXP_FILE_LIST_STORE_H

#include <glib.h>
#include <glib-object.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <unistd.h>


G_BEGIN_DECLS
#define CXP_TYPE_FILE_LIST_STORE         (cxp_file_list_store_get_type ())
#define CXP_FILE_LIST_STORE(o)           (G_TYPE_CHECK_INSTANCE_CAST ((o), CXP_TYPE_FILE_LIST_STORE, CxpFileListStore))
#define CXP_FILE_LIST_STORE_CLASS(k)     (G_TYPE_CHECK_CLASS_CAST((k), CXP_TYPE_FILE_LIST_STORE, CxpFileListStoreClass))
#define CXP_IS_FILE_LIST_STORE(o)        (G_TYPE_CHECK_INSTANCE_TYPE ((o), CXP_TYPE_FILE_LIST_STORE))
#define CXP_IS_FILE_LIST_STORE_CLASS(k)  (G_TYPE_CHECK_CLASS_TYPE ((k), CXP_TYPE_FILE_LIST_STORE))
#define CXP_FILE_LIST_STORE_GET_CLASS(o) (G_TYPE_INSTANCE_GET_CLASS ((o), CXP_TYPE_FILE_LIST_STORE, CxpFileListStoreClass))
	enum
{
	FILE_LIST_COL_RECORD = 0,
	FILE_LIST_COL_FULLPATH,
	FILE_LIST_COL_MIMETYPE,
	FILE_LIST_COL_FILESIZE,
	FILE_LIST_COL_FILEMODE,
	FILE_LIST_COL_FILETIME,
	FILE_LIST_COL_EDITABLE,
	FILE_LIST_N_COLUMNS,
};

enum
{
	SORT_ID_NONE = 0,
	SORT_ID_NAME,
	SORT_ID_SIZE,
	SORT_ID_TYPE,
	SORT_ID_TIME,
};

typedef struct CxpFileListStorePrivate CxpFileListStorePrivate;

typedef struct
{
	GObject parent;
	CxpFileListStorePrivate *priv;
} CxpFileListStore;

typedef struct
{
	GObjectClass parent_class;
	/* Add Signal Functions Here */
} CxpFileListStoreClass;

typedef struct
{
	gchar *fullpath;
	gchar *mime_type;
	off_t file_size;
	mode_t file_mode;
	time_t file_mtime;

	/* admin stuff used by the custom list model */
	guint pos;		/* pos within the array */
	gboolean editable;
} CxpFileInfo;

GType cxp_file_list_store_get_type ();
CxpFileListStore *cxp_file_list_store_new ();
void cxp_file_list_store_append_file (CxpFileListStore * obj,
				      const gchar * fullpath,
				      GtkTreeIter * iter);
void cxp_file_list_store_clear (CxpFileListStore * obj);
void cxp_file_list_store_rename_file (CxpFileListStore * obj,
				      GtkTreeIter * iter,
				      const gchar * fullpath);
void cxp_file_list_store_set_editable (CxpFileListStore * obj,
				       GtkTreeIter * iter, gboolean editable);
gboolean cxp_file_list_store_remove (CxpFileListStore * obj,
				     GtkTreeIter * iter);

void cxp_file_list_store_resort (CxpFileListStore * cxp_file_list_store);	/* test */

#endif /* CXP_FILE_LIST_STORE_H */
