/* -*- C++ -*-
#S#
#
# This Program is part of MyDic (EP-WING Dictionary Reader
# Copyright (C) 1995-1997 Takashi Nemoto
#
#    This program is free software; you can redistribute it and/or modify
#    it under the terms of the GNU General Public License as published by
#    the Free Software Foundation; either version 2 of the License, or
#    (at your option) any later version.
#
#    This program is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details. (File "COPYING")
#
#    Note!: General Public Licence is copyrighted by the Free Software 
#           Foundation,  but this code is copyrighted by me.
#
#    Send bugs and comments to tnemoto@mxt.meshnet.or.jp
#
#E#
*/

#ifndef __tag_h__
#define __tag_h__
#include "def.h"

class TAG {
protected:
  int block;
  int offset;
public:
  TAG(int p=0,int o=0){ block=p; offset=o; };
  TAG(byte* data);
  TAG(const TAG& t);
  const TAG& operator = (const TAG& t);
  void Block(int p);
  void Offset(int o);
  int Block() const ;
  int Offset() const ;

  int TagPack() const { return (block<<11) + offset; };
  void TagUnpack(int i){ block=(i>>11) & 0x1fffff; offset=i & 2047; };

  friend bool operator == (const TAG& t,const TAG& t);
  friend bool operator != (const TAG& t,const TAG& t);
  friend bool operator < (const TAG& t,const TAG& t);
};

inline TAG GetBCDTag(byte* start){
  return TAG(GetBCD(start,8),GetBCD(start+4,4));
};

#endif

