/*
 * Copyright (c) 2008-2009 Internet Initiative Japan Inc. All rights reserved.
 *
 * The terms and conditions of the accompanying program
 * shall be provided separately by Internet Initiative Japan Inc.
 * Any use, reproduction or distribution of the program are permitted
 * provided that you agree to be bound to such terms and conditions.
 *
 * $Id: dkimdigest.h 653 2009-02-28 20:35:27Z takahiko $
 */

#ifndef __DKIM_DIGEST_H__
#define __DKIM_DIGEST_H__

#include <openssl/evp.h>

#include "strarray.h"
#include "mailheaders.h"
#include "dkim.h"
#include "dkimpolicy.h"
#include "dkimsignature.h"

typedef struct DkimDigest DkimDigest;

extern DkimDigest *DkimDigest_new(const DkimPolicy *policy, dkim_digestalg_t digest_alg,
                                  dkim_pubkeyalg_t pubkey_alg, dkim_canonalg_t header_canon_alg,
                                  dkim_canonalg_t body_canon_alg, long long body_length_limit,
                                  dkim_stat_t *dstat);
extern DkimDigest *DkimDigest_newWithSignature(const DkimPolicy *policy,
                                               const DkimSignature *signature, dkim_stat_t *dstat);
extern void DkimDigest_free(DkimDigest *self);
extern dkim_stat_t DkimDigest_updateBody(DkimDigest *self, const unsigned char *buf, size_t len);
extern dkim_stat_t DkimDigest_verifyMessage(DkimDigest *self, const MailHeaders *headers,
                                            const DkimSignature *signature, EVP_PKEY *pkey);
extern dkim_stat_t DkimDigest_signMessage(DkimDigest *self, const MailHeaders *headers,
                                          DkimSignature *signature, EVP_PKEY *pkey);
extern dkim_stat_t DkimDigest_openCanonDump(DkimDigest *self, const char *fnHeaderDump,
                                            const char *fnBodyDump);

#endif /* __DKIM_DIGEST_H__ */
