/*
 * Copyright (c) 2009 Internet Initiative Japan Inc. All rights reserved.
 *
 * The terms and conditions of the accompanying program
 * shall be provided separately by Internet Initiative Japan Inc.
 * Any use, reproduction or distribution of the program are permitted
 * provided that you agree to be bound to such terms and conditions.
 *
 * $Id: dkimpolicy.h 766 2009-03-22 08:16:29Z takahiko $
 */

#ifndef __DKIM_POLICY_H__
#define __DKIM_POLICY_H__

#include <stdbool.h>
#include "strarray.h"

#define DkimPolicy_MEMBER	    \
    bool sendmail813;           \
    StrArray *author_priority;  \
    void (*logger) (int priority, const char *message, ...);

struct DkimPolicy {
    DkimPolicy_MEMBER;
};

extern void DkimPolicy_init(DkimPolicy *self);
extern void DkimPolicy_cleanup(DkimPolicy *self);

#endif /* __DKIM_POLICY_H__ */
