/***************************************************************************
 *   Copyright (C) 2008 by Kitsune                                         *
 *   sutoka@gmail.com                                                      *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 or 3 of the License,   *
 *   or (at your option) any later version.                                *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/


#include <QtGui>
#include <KApplication>
#include <KIcon>
#include <KStatusBar>
#include <KMenuBar>
#include <KLocale>
#include <KActionCollection>
#include <KStandardAction>
#include <QLineEdit>
#include <QCloseEvent>
#include <QVariant>

#include <iostream>

#include "foxkit.h"
#include "webview.h"

class QUrl;

QUrl foxkit::s_home("http://www.kde.org");
bool foxkit::s_allowNoTabs(false); //FIXME: Must make sure theres a tab before calling m_activeTab before this can be used

foxkit::foxkit(NetManager *net) : KXmlGuiWindow(0), tabs(this), m_progress(this), m_addressBar(this)
{
        setObjectName("foxkit:" + QString::number(uint(this)));
        std::cout << "CREATE:foxkit," << uint(this) << ";parent:" << uint(parent()) << std::endl;
        setWindowTitle(i18n("Foxkit Web Browser"));
        netman = net;
        cookies = new cookieViewer(qobject_cast<cookieMonster*>(netman->cookieJar()));
        tabs.hideTabs();

        setCentralWidget(&tabs);

        createActions();
        setupGUI();

        m_progress.setMaximumSize(150, 20);
        statusBar()->addPermanentWidget(&m_progress, -5);

        connect(&tabs, SIGNAL(currentChanged(int)),
                this, SLOT(tabPageChanged(int)));
}

//TODO: Prompt on multiple tabs open. Save session.
void foxkit::closeEvent(QCloseEvent *event)
{
        if ( true ) {
                event->accept();
        } else {
                event->ignore();
        }
}

foxkit::~foxkit()
{
        std::cout << "DESTROY:foxkit," << uint(this) << ";parent:" << uint(parent()) << std::endl;
        cookies->close();
        cookies->deleteLater();
}

void foxkit::createActions()
{
        m_clearAddress = new KAction(KIcon("edit-clear-locationbar-ltr.png"), i18n("Clear the address bar"), this);
            m_clearAddress->setStatusTip(i18n("Clears the address currently in the address bar, then gives the bar focus."));
            m_clearAddress->setShortcut(Qt::CTRL + Qt::Key_L);
            actionCollection()->addAction("clearaddress", m_clearAddress);
            connect(m_clearAddress, SIGNAL(triggered()), this, SLOT(clearAddressBar()));
        m_newWindow = new KAction(KIcon("window-new.png"), i18n("New Window"), this);
            m_newWindow->setStatusTip(i18n("Open a new Window."));
            m_newWindow->setShortcut(i18n("Ctrl+N"));
            actionCollection()->addAction("newwindow", m_newWindow);
            connect(m_newWindow, SIGNAL(triggered()), this, SIGNAL(newWindow()));
        m_saveContents = new KAction(KIcon("document-save.png"), i18n("Save Page"), this);
            m_saveContents->setStatusTip(i18n("Saves the contents of the current page to your local system."));
            actionCollection()->addAction("savepage", m_saveContents);
        m_newTab = new KAction(KIcon("tab-new.png"), i18n("New Tab"), this);
            m_newTab->setStatusTip(i18n("Creates a new tab."));
            m_newTab->setShortcut(i18n("Ctrl+T"));
            actionCollection()->addAction("newtab", m_newTab);
            connect(m_newTab, SIGNAL(triggered()), this, SLOT(newView()));
        m_closeTab = new KAction(KIcon("tab-close.png"), i18n("Close Tab"), this);
            m_closeTab->setStatusTip(i18n("Closes the current tab."));
            m_closeTab->setShortcut(i18n("Ctrl+W"));
            connect(m_closeTab, SIGNAL(triggered()), this, SLOT(closeTab()));
            actionCollection()->addAction("closetab", m_closeTab);

        KStandardAction::back(this, SLOT(pageBack()), actionCollection());
        KStandardAction::forward(this, SLOT(pageForward()), actionCollection());
        m_reload = new KAction(KIcon("view-refresh.png"), i18n("Reload"), this);
            m_reload->setStatusTip(i18n("Reloads the current tab."));
            m_reload->setShortcut(i18n("F5"));
            connect(m_reload, SIGNAL(triggered()), this, SLOT(pageReload()));
            actionCollection()->addAction("reload", m_reload);
        KStandardAction::quit(kapp, SLOT(quit()), actionCollection());

        //No Standard Action for Stop?
        m_stop = new KAction(KIcon("process-stop.png"), i18n("Stop"), this);
            m_stop->setStatusTip(i18n("Stop loading the current page."));
            actionCollection()->addAction("stop", m_stop);
            connect(m_stop, SIGNAL(triggered()), this, SLOT(pageStop()));

        m_cookieViwer = new KAction(KIcon("process-stop.png"), i18n("Cookie Viewer"), this);
            m_cookieViwer->setStatusTip(i18n("View all cookies.."));
            actionCollection()->addAction("cookieViewer", m_cookieViwer);
            connect(m_cookieViwer, SIGNAL(triggered()), cookies, SLOT(show()));

        addressWidgetAction = new KAction(this);
            addressWidgetAction->setDefaultWidget(&m_addressBar);
            actionCollection()->addAction("addressedit", addressWidgetAction);
            m_addressBar.setEditable(true);
            m_addressBar.addItem(s_home.toString(), QVariant(s_home.toString()));
            m_addressBar.addItem("http://gitorious.org/projects/foxkit", QVariant("http://gitorious.org/projects/foxkit"));
            m_addressBar.addItem("http://www.kde-apps.org/content/show.php/Foxkit+Web+Browser?content=82962", QVariant("http://www.kde-apps.org/content/show.php/Foxkit+Web+Browser?content=82962"));
            connect(m_addressBar.lineEdit(), SIGNAL(returnPressed()), this, SLOT(addressEntered()));

        // Toolbar buttons for the tabwidget
        QToolButton *addTabButton = new QToolButton(this);
            addTabButton->setDefaultAction(m_newTab);
            addTabButton->setAutoRaise(true);
            addTabButton->setToolButtonStyle(Qt::ToolButtonIconOnly);
            tabs.setCornerWidget(addTabButton, Qt::TopLeftCorner);
        QToolButton *closeTabButton = new QToolButton(this);
            closeTabButton->setDefaultAction(m_closeTab);
            closeTabButton->setAutoRaise(true);
            closeTabButton->setToolButtonStyle(Qt::ToolButtonIconOnly);
            tabs.setCornerWidget(closeTabButton, Qt::TopRightCorner);

}

void foxkit::addressEntered()
{
        QString tmpString = m_addressBar.currentText();
        if( tmpString.indexOf(":") == -1 ) {
                tmpString.prepend("http://"); // Falls back to http: if no protocol is used
                m_addressBar.lineEdit()->setText(tmpString);
        }
        setUrl(tmpString);
}

void foxkit::setUrl(QString urlString)
{
       m_activeView->load(urlString);
}

void foxkit::setCurrentUrl(QUrl url,void* address)
{
        QString foo(url.toString());
        if (address == tabs.currentWidget()) {
                m_addressBar.lineEdit()->setText(foo);
        }
        tabs.setTabToolTip(addressToIndex(address), foo);
}

void foxkit::setCurrentTitle(QString title, void* address)
{
        if(title.isEmpty())
        {
                setWindowTitle(i18n("%1 - Foxkit Web Browser").arg("(Untitled)"));
                tabs.setTabText(addressToIndex(address), "(Untitled)"); //FIXME change this back to title
                return;
        }
        QString tabTitle(title);
        if(tabTitle.length() > TruncateLengthShort)
        {
                tabTitle.truncate(TruncateLengthShort -3 );
                tabTitle.append("...");
        }
        tabs.setTabText(addressToIndex(address), tabTitle);

        if (address == tabs.currentWidget())
        {
                QString windowTitle(title);
                if(windowTitle.length() > TruncateLengthLong)
                {
                        windowTitle.truncate(TruncateLengthLong -3 );
                        windowTitle.append("...");
                }
                setWindowTitle(i18n("%1 - Foxkit Web Browser").arg(windowTitle));
                setStatusBarText(title, address);
        }
}

void foxkit::setIcon(QIcon icon, void* address)
{
        tabs.setTabIcon(addressToIndex(address), icon);
}

void foxkit::setStatusBarText(QString text, void* address)
{
        if (address == tabs.currentWidget()) {
                statusBar()->showMessage(text);
        }
}

void foxkit::clearAddressBar()
{
        m_addressBar.lineEdit()->clear();
        m_addressBar.lineEdit()->setFocus(Qt::OtherFocusReason);
}

void foxkit::tabPageChanged(int index)
{
        Q_UNUSED(index);

        if(tabs.count() == 0)
        {   //Special action needed if no tabs are open
                m_progress.setValue(100);
                m_progress.hide();
                statusBar()->showMessage("No tabs open.");
                setWindowTitle(i18n("Foxkit Web Browser"));
                m_addressBar.lineEdit()->clear();
                return;
        }

        QPointer<webView> oldView;
        oldView = m_activeView; // activeView hasn't been updated to the new tab yet.
        if(oldView)
        { //The old tab still exists. Any data to save to the object should be done now.
                oldView->setAddressEditString(m_addressBar.currentText());
        }

        m_activeView = qobject_cast<webView*>(tabs.currentWidget()); // The activeView is now accurate
        if(!m_activeView)
        {
                std::cout << "FAILURE:activeViewIsNull" << std::endl << std::flush;
                abort(); // Add these checks in other places that m_activeView is used?
        }
        m_progress.setValue(m_activeView->getProgress());
        if(m_activeView->getProgress() >= 100)
                m_progress.hide();
        statusBar()->showMessage(m_activeView->getStatusText());
        m_addressBar.setEditText( *(m_activeView->getAddressEditString()) );
        QString viewTitle;
        if(m_activeView->title().isEmpty())
                viewTitle = m_activeView->url().toString();
        else
                viewTitle = m_activeView->title();

        if(viewTitle.length() > TruncateLengthLong)
        {
                viewTitle.truncate(TruncateLengthLong -3 );
                viewTitle.append("...");
        }
        if(!viewTitle.isEmpty())
                setWindowTitle(i18n("%1 - Foxkit Web Browser").arg( viewTitle ));
        else
                setWindowTitle(i18n("Foxkit Web Browser"));
        m_activeView->setFocus(Qt::OtherFocusReason);

        // TODO: Check to see if we're at the start/end of the
        //history, and disable buttons accordingly.
}

/**
 * If newWin is true, will instead send a signal to the parent class
 * asking for a new window, giving the QNetReq with it, then returning immediately.
 * Will result in a new Window or Tab (depending on newWin) opened to 'request'.
 * @param newWin 
 * @param request 
 */
void foxkit::newView(bool newWin, QNetworkRequest request)
{
        if(newWin == true)
        {
                emit newWindow(request);
                return;
        }

        webView *tmp = new webView(this);
        tmp->page()->setNetworkAccessManager(netman);

        int bar = tabs.addTab(tmp, "(Untitled)");
        if(tabs.count() > 1)
                tabs.showTabs();
        if(bar == tabs.currentIndex())
                m_activeView = qobject_cast<webView*>(tabs.widget(bar));

        connect(tmp, SIGNAL(urlChanged(QUrl, void*)),
                this, SLOT(setCurrentUrl(QUrl, void*)));
        connect(tmp, SIGNAL(titleChanged( const QString&, void* )),
                this, SLOT(setCurrentTitle(QString, void*)));
        connect(tmp, SIGNAL(statusBarMessage( const QString&, void*)),
                this, SLOT(setStatusBarText(QString, void*)));
        connect(tmp, SIGNAL(linkHovered( const QString&, void*)),
                this, SLOT(setStatusBarText(QString, void*)));
        connect(tmp, SIGNAL(iconChanged( QIcon, void*)),
                this, SLOT(setIcon(QIcon, void*)));
        connect(tmp, SIGNAL(loadProgress(int, void*)),
                this, SLOT(loadProgress(int, void*)));
        connect(tmp->page(), SIGNAL(newViewRequest(bool, QNetworkRequest)),
                this, SLOT(newView(bool, QNetworkRequest)));
        connect(tmp, SIGNAL(newViewRequest(bool, QNetworkRequest)),
                this, SLOT(newView(bool, QNetworkRequest)));

        tmp->load(request);
}

//TODO Nothing ever calls this with a value for index? RMB on tabBar might be the only user...
void foxkit::closeTab(signed int index)
{
        if(index == CLOSECURRENT)
                index = tabs.currentIndex(); // We wanna close the current tab.

        //TODO: Make a nice little template for a blank page and show that instead (call it 'about:foxkit'?)
        if(tabs.count() <= 2 && !s_allowNoTabs)
        {
                if(tabs.count() <= 1)
                        newView(false, QNetworkRequest(QUrl("about:blank")));
                tabs.hideTabs();
        }
        else if(tabs.count() <= 1 && s_allowNoTabs) //We don't need tabs with zero or 1 tabs
                tabs.hideTabs();

        webView *moo = qobject_cast<webView*>(tabs.widget(index));
            moo->disconnect();
            moo->stop();
            moo->page()->disconnect();
            moo->deleteLater();
}

void foxkit::loadProgress(int progress, void* address)
{
        if (address == tabs.currentWidget()) { // Ignore messages from other tabs
                if (progress != 100) {
                        m_progress.setValue(progress);
                        m_progress.show();
                } else
                        m_progress.hide();
        }
}

/**
 * This function takes the address of a webView and finds that webView in the tab bar.
 * If the webView isn't found, the application WILL abort. Only use for views that should
 * be in this window. It accepts a void pointer, so it should be possible to have other 
 * types of central widgets in the future.
 * @param address 
 * @return 
 */
int foxkit::addressToIndex(void* address)
{
        int count = tabs.count();
        for(int i = 0; i < count; i++)
        {
                if(address == tabs.widget(i))
                {
                        return i;
                }
        }
        std::cout << "ERROR:addressToIndex,noMatchFound:" << address << std::endl << std::flush;
        abort();
        return -1;
}
