/***************************************************************************
 *   Copyright (C) 2008 by Kitsune                                         *
 *   sutoka@gmail.com                                                      *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 or 3 of the License,   *
 *   or (at your option) any later version.                                *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#include "tools.h"

#include <QTableWidgetItem>
#include <KIcon>
#include <iostream>

cookieViewer::cookieViewer(cookieMonster *jar)
 : QTableWidget(0)
{
        setObjectName("cookieViewer:" + QString::number(uint(this)));
        std::cout << "CREATE:cookieViewer," << uint(this) << ";parent:" << uint(parent()) << std::endl;
        setWindowTitle("Cookie List, F5 for refresh");
        m_refresh = new QAction("Refresh Cookies", this);
        m_refresh->setShortcut(Qt::Key_F5);
        m_refresh->setShortcutContext(Qt::ApplicationShortcut);
        connect(m_refresh, SIGNAL(triggered()), this, SLOT(refreshCookies()));
        addAction(m_refresh);
        m_jar = jar;
        QStringList moo;
        moo << "Domain" << "Path";
        setColumnCount(2);
        refreshCookies();
}


cookieViewer::~cookieViewer()
{
        std::cout << "DESTROY:cookieViewer," << uint(this) << ";parent:" << uint(parent()) << std::endl;
        delete m_refresh;
}

void cookieViewer::refreshCookies()
{
        cookieList = new QList<QNetworkCookie>(m_jar->getCookies());
        int count = cookieList->count();
        clear();
        setRowCount(count);
        QTableWidgetItem* moo;
        for(int i = 0; i < count; i++)
        {
                moo = new QTableWidgetItem(cookieList->at(i).domain());
                setItem(i, 0, moo);
                moo = new QTableWidgetItem(cookieList->at(i).path());
                setItem(i, 1, moo);
        }
        QStringList foo;
        foo << "Domain" << "Path";
        setHorizontalHeaderLabels(foo);
        delete cookieList;
}


