/***************************************************************************
 *   Copyright (C) 2008 by Kitsune                                         *
 *   sutoka@gmail.com                                                      *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 or 3 of the License,   *
 *   or (at your option) any later version.                                *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#include "webpage.h"

#include <iostream>
#include <QWebFrame>
#include <QNetworkReply>

webPage::webPage(QObject* parent) : QWebPage(parent), m_mouseButtons(Qt::NoButton), m_kbdMods(Qt::NoModifier)
{
        setObjectName("webPage:" + QString::number(uint(this)));
        std::cout << "CREATE:webPage," << uint(this) << ";parent:" << uint(parent) << std::endl;
}


webPage::~webPage()
{
        std::cout << "DESTROY:webPage," << uint(this) << ";parent:" << uint(parent()) << std::endl;
}

bool webPage::acceptNavigationRequest(QWebFrame *frame, const QNetworkRequest &request, NavigationType type)
{
        if (type == QWebPage::NavigationTypeLinkClicked)
        {
                if(m_mouseButtons == Qt::MidButton) {
                        emit newViewRequest(false, request);
                        return false;
                }
                else if(m_mouseButtons == Qt::LeftButton && m_kbdMods & Qt::ControlModifier) {
                        emit newViewRequest(true, request); // FIXME for now this will just open a new tab.
                        return false;
                }
        }

        return QWebPage::acceptNavigationRequest(frame, request, type);
}

void webPage::setKeys(Qt::MouseButtons mouse, Qt::KeyboardModifiers key)
{
        m_mouseButtons = mouse;
        m_kbdMods = key;

}

void webPage::handleUnsupportedContent(QNetworkReply * reply)
{
        // Would this ever be called when theres no error?
        QString errorHtml;
        errorHtml = "<html><head><title>Error loading: %1</title></head>";
        errorHtml += "<body><h1>%2</h1><br>Error when loading: %1";
        errorHtml.arg(reply->url().toString()).arg(reply->errorString());

        if(mainFrame()->url() == reply->url())
        {
                mainFrame()->setHtml(errorHtml, reply->url());
                return;
        }
}
