/*
 *  Copyright (C) 2005 Kouji TAKAO <kouji@netlab.jp>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifndef __GPASS_VIEW_H__
#define __GPASS_VIEW_H__

#include <glade/glade-xml.h>

G_BEGIN_DECLS

/***********************************************************
 *
 * GPassViewResult
 *
 ***********************************************************/
typedef enum {
    GPASS_VIEW_RESULT_FAILED  = 0,
    GPASS_VIEW_RESULT_SUCCEED = 1,
} GPassViewResult;

GType gpass_view_result_get_type(void);
#define GPASS_TYPE_VIEW_RESULT (gpass_view_result_get_type())

/***********************************************************
 *
 * GPassView
 *
 ***********************************************************/
#define GPASS_TYPE_VIEW (gpass_view_get_type())
#define GPASS_VIEW(obj) \
    (G_TYPE_CHECK_INSTANCE_CAST((obj), GPASS_TYPE_VIEW, GPassView))
#define GPASS_VIEW_CLASS(klass) \
    (G_TYPE_CHECK_CLASS_CAST((klass), GPASS_TYPE_VIEW, GPassViewClass))
#define GPASS_IS_VIEW(obj) \
    (G_TYPE_CHECK_INSTANCE_TYPE((obj), GPASS_TYPE_VIEW))
#define GPASS_IS_VIEW_CLASS(klass) \
    (G_TYPE_CHECK_CLASS_TYPE((klass), GPASS_TYPE_VIEW))
#define GPASS_VIEW_GET_CLASS(obj) \
    (G_TYPE_INSTANCE_GET_CLASS((obj), GPASS_TYPE_VIEW, GPassViewClass))

typedef struct {
    GObject parent;
    
    gpointer model;
    gchar *template;
    GladeXML *xml;
    GtkWidget *window;
    GtkWidget *first_widget;
    GMainLoop *main_loop;
    GPassViewResult result;
} GPassView;

typedef struct {
    GObjectClass parent;
    GError *(*loaded_glade_xml)(GPassView *self);
    GError *(*run)(GPassView *self, GPassViewResult *result);
} GPassViewClass;

GType gpass_view_get_type(void);

GError *gpass_view_run(GPassView *self, GPassViewResult *result);
void gpass_view_shutdown_main_loop(GPassView *self);

void gpass_view_self_from_widget(GtkWidget *widget, gpointer **self);
void gpass_view_show_error_message(GPassView *self, const gchar *msg,
                                   GtkWidget *focus_widget);

G_END_DECLS

#endif /* #ifndef __GPASS_VIEW_H__ */
