/*********************************************************************************/
/**	                                                            		**/
/**                              r.param.scale                 			**/
/**       GRASS module for extracting multi-scale surface parameters.		**/
/**  										**/
/**                                                         			**/
/**			  Jo Wood, V 1.1, 11th December, 1994			**/
/**                                $Id: main.c,v 1.4 2002/03/26 14:59:58 markus Exp $      					**/
/*********************************************************************************/

#define MAIN

#include "param.h"	

int main(int argc, char **argv)
{

    /*--------------------------------------------------------------------------*/
    /*                                 INITIALISE				*/
    /*--------------------------------------------------------------------------*/ 



    /*--------------------------------------------------------------------------*/
    /*                               GET INPUT FROM USER			*/
    /*--------------------------------------------------------------------------*/

    interface(argc,argv);


    /*--------------------------------------------------------------------------*/
    /*                        OPEN INPUT AND OUTPUT RASTER FILES		*/
    /*--------------------------------------------------------------------------*/

    /* Make sure that the current projection is not lat/long */
    if ((G_projection() == PROJECTION_LL))
         G_fatal_error ("lat/long databases not supported - sorry.");

    open_files();


    /*--------------------------------------------------------------------------*/
    /*                       PROCESS SURFACE FOR FEATURE DETECTION 		*/
    /*--------------------------------------------------------------------------*/

    process();   

    /*--------------------------------------------------------------------------*/
    /*                     CLOSE ALL OPENED FILES AND FREE MEMORY		*/
    /*--------------------------------------------------------------------------*/

    close_down();

    if (mparam == FEATURE)
    {
	write_cols();
	write_cats();
    }

    return 0;
}
