
#==============================================================================#
# $Id: facade.rb,v 1.2 2004/01/23 00:38:03 yuya Exp $
# $Source: /cvsroot/gruby/gruby/lib/grb/chart/bar/facade.rb,v $
#==============================================================================#

require 'grb/chart/xy_base/facade'
require 'grb/chart/bar/property'
require 'grb/chart/bar/chart'
require 'grb/chart/base/parts/legend'

#==============================================================================#

module GRb

  module Chart

    class BarChartFacade < XYChartFacadeBase

      protected

      def create_property_chart
        return GRb::Chart::BarChartProperty.new
      end

      def create_legend(property)
        font   = property.font.create_font
        legend = GRb::Chart::Legend.new(property)

        @data.each { |item|
          legend.add(font, item[:name], GRb::Chart::Legend::Marker::Color.new(item[:fill], item[:line]))
        }

        return legend
      end

      def create_chart_layer(property, major_scale, items)
        chart = GRb::Chart::BarChart.new(property, major_scale, items)

        @data.each { |v|
          chart.add_value_set(v[:name], v[:line], v[:fill], v[:value])
        }

        return chart
      end

      # FIXME: change method name
      def count_items
        return @data.collect { |item| item[:value].size }.max
      end

    end # BarChartFacade

  end # Graph

end # GRb

#==============================================================================#
#==============================================================================#
