
#==============================================================================#
# $Id: fill.rb,v 1.2 2004/01/23 05:24:11 yuya Exp $
# $Source: /cvsroot/gruby/gruby/lib/grb/chart/base/decorator/fill.rb,v $
#==============================================================================#

require 'grb/chart/base/decorator/singular_base'

#==============================================================================#

module GRb

  module Chart

    class FillDecorator < SingularDecoratorBase

      def initialize(child = nil)
        super(child)

        @color   = nil
        @opacity = 100
      end

      attr_accessor :color, :opacity

      def draw_self(image, box)
        image.rect(box.x, box.y, box.x2, box.y2, nil, {:color => @color, :opacity => @opacity})
      end

      def draw_child(image, box)
        @child.draw(image, box)
      end

    end # FillDecorator

  end # Chart

end # GRb

#==============================================================================#

if $0 == __FILE__
  require 'grb/image'

  image = GRb::Image.create(400, 300)

  decorator = GRb::Chart::Decorator::Fill.new
  decorator.color   = GRb::Color.blue
  decorator.opacity = 50
  decorator.draw(image, GRb::Chart::Box.new(0, 0, 200, 300))

  decorator = GRb::Chart::Decorator::Fill.new
  decorator.color   = GRb::Color.red
  decorator.opacity = 100
  decorator.draw(image, GRb::Chart::Box.new(200, 0, 200, 300))

  image.write_png_file(__FILE__ + '.png')
end

#==============================================================================#
#==============================================================================#
