
#==============================================================================#
# $Id: font.rb,v 1.2 2004/01/23 05:02:46 yuya Exp $
# $Source: /cvsroot/gruby/gruby/lib/grb/chart/base/property/font.rb,v $
#==============================================================================#

require 'grb/chart/base/property/base'
require 'grb/chart/base/utility/font'

#==============================================================================#

module GRb

  module Chart

    class FontProperty < PropertyBase

      def initialize
        @color    = nil
        @name     = nil # for GD Font
        @bold     = nil # for GD Font
        @italic   = nil # for GD Font
        @vertical = nil # for GD Font
        @filepath = nil # for TrueType Font
        @size     = nil # for TrueType Font
        @angle    = nil # for TrueType Font
      end

      attr_accessor :color, :name, :bold, :italic, :vertical, :filepath, :size, :angle

      def create_font
        if @name
          color    = @color    || Color.black
          bold     = @bold     || false
          italic   = @italic   || false
          vertical = @vertical || false
          return GRb::Chart::Font.gd(@name, bold, italic, color, vertical)
        elsif @filepath
          color = @color || Color.black
          size  = @size  || 10
          angle = @angle || 0
          return GRb::Chart::Font.truetype(@filepath, size, color, angle)
        else
          raise(ArgumentError, "Can't create font. [name] and [filepath] is nil.")
        end
      end

    end # FontProperty

  end # Chart

end # GRb

#==============================================================================#
#==============================================================================#
