/***************************************************************************
 *   Copyright (C) 2004 by TAM(Teppei Tamra)                               *
 *   tam-t@par.odn.ne.jp                                                   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#ifndef HONOKAPLUGINBASE_H
#define HONOKAPLUGINBASE_H

#include <cstdio>
#include <cstdlib>
#include <vector>
#include <set>
#include <scim.h>
#define Uses_SCIM_CONFIG_BASE

#define HONOKA_PLUGIN_VERSION 9

using namespace std;
using namespace scim;

#include <honokasetupcore.h>
#include <honokatimer.h>

#define HONOKA_CONFIG_PLUGINLOADER_PREFIX           "/IMEngine/Honoka/PluginLoader"
#define HONOKA_CONFIG_KEY_CONVERTOR_PREFIX         "/IMEngine/Honoka/Key/Convertor"
#define HONOKA_CONFIG_KEY_PREEDITOR_PREFIX         "/IMEngine/Honoka/Key/PreEditor"
#define HONOKA_CONFIG_KEY_PREDICTOR_PREFIX         "/IMEngine/Honoka/Key/Predictor"



/**
@author TAM (Teppei Tamra)
*/

namespace Honoka {

#define HonokaPluginRegister(pName) \
    extern "C" { \
        HonokaPluginBase *getHonokaPluginInstance(ConfigPointer cfg) { return new pName(cfg); } \
        void deleteHonokaPluginInstance(HonokaPluginBase *o) { delete static_cast<pName *>(o); } \
        int getHonokaPluginVersion() { return(HONOKA_PLUGIN_VERSION); } \
    }

#define HonokaPluginSetup(pName) \
    extern "C" { \
        HonokaSetupCorePage *HonokaPluginSetup() { return pName::setup(); }; \
    }
#ifndef HonokaSetup
#define     HonokaSetupItem         HonokaSetupCoreItem
#define     HonokaSetupEntryItem    HonokaSetupCoreEntryItem
#define     HonokaSetupFileItem     HonokaSetupCoreFileItem
#define     HonokaSetupKeyItem      HonokaSetupCoreKeyItem
#define     HonokaSetupBoolItem     HonokaSetupCoreBoolItem
#define     HonokaSetupIntItem      HonokaSetupCoreIntItem
#define     HonokaSetupSelectItem   HonokaSetupCoreSelectItem
#define     HonokaSetupPage         HonokaSetupCorePage
#define     HonokaSetup             HonokaSetupCore
#endif



class HonokaPluginBase{
protected:
    HonokaPluginBase(const String pluginType);
    ~HonokaPluginBase();
    int appendDelayEvent(uint32 delay);
    bool removeTimerEventId(int id);
    void clearTimerEvents();

public:
    
    String getPluginType();
    virtual String getName();
    bool findTimerEventId(int id);
    virtual void timerEvent(int id);

private:
    String type;
    set<int> timerEventId;
};

}

using namespace Honoka;

#endif
