/***************************************************************************
 *   Copyright (C) 2004 by TAM(Teppei Tamra)                               *
 *   tam-t@par.odn.ne.jp                                                   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#include "anthyconversion.h"

#ifdef HAVE_CONFIG_H
  #include <config.h>
#endif

#ifdef HAVE_GETTEXT
  #include <libintl.h>
  #define _(String) dgettext(GETTEXT_PACKAGE,String)
  #define N_(String) (String)
#else
  #define _(String) (String)
  #define N_(String) (String)
  #define bindtextdomain(Package,Directory)
  #define textdomain(domain)
  #define bind_textdomain_codeset(domain,codeset)
#endif

// プライグイン化のおまじないです。
//HonokaPluginRegister(AnthyConversion);


AnthyConversion::AnthyConversion(ConfigPointer cfg) : Convertor(cfg)
{
    m_iconv.set_encoding ("EUC-JP");
    pos = 0;
    current = false;
    anthy_init();
    context = anthy_create_context();
}


AnthyConversion::~AnthyConversion()
{
}

bool AnthyConversion::isConnected() {
    return current;
}

void AnthyConversion::reset(){
    //anthy_release_context(context);
    //anthy_init();
    //context = anthy_create_context();
    anthy_reset_context(context);
    return;
}

void AnthyConversion::setYomiText(WideString yomi) {
    yomiText = yomi;
}

int AnthyConversion::ren_conversion() {
    if (!current) return 0;
    /*
    WideString yt;
    for(int i = 0;i < yomiText.length();i ++) {
        if (yomiText[i] == 0x30F4) {
            yt.push_back(0x30A6);
            yt.push_back(0x309B);
        }
        else yt.push_back(yomiText[i]);
    }
    yomiText = yt;
    */
    String y;
    anthy_reset_context(context);
    m_iconv.convert(y,yomiText);
    anthy_set_string(context,y.c_str());
    struct anthy_conv_stat stat;
    anthy_get_stat(context,&stat);
    pos = 0;
    buildResult();
    
    return stat.nr_segment;
}

const vector<Segment> AnthyConversion::getSegmentList() {
    vector<Segment> result;
    for(unsigned int i = 0;i < convResult.size();i ++) result.push_back(Segment(convResult[i].kouho[convResult[i].pos].kanji,convResult[i].Yomi));
    return result;
};


int AnthyConversion::setPos(int p){
    if ((p < convResult.size()) && (p >= 0)) pos = p;
    return pos;
}

int AnthyConversion::getPos() {
    return pos;
}

ResultList AnthyConversion::getResultList(int p,ResultType kt){
    if (p == -1) p = pos;
    if (p >= convResult.size()) return ResultList();
    if ((kt != DEFAULT) || (p >= convResult.size())) return ResultList();
    setPos(p);
    return convResult[p];
}

bool AnthyConversion::select(int p) {
    if (p < convResult[pos].count()) {
        convResult[pos].pos = p;
        return true;
    }
    return false;
}

bool AnthyConversion::resizeRegion(int w) {
    //if ((convResult[pos].kouho[convResult[pos].pos].length() + w) < 1) return false;
    if ((convResult[pos].Yomi.length() + w) < 1) return false;
    if ((pos >= (convResult.size() - 1)) && (w > 0)) return false;
    anthy_resize_segment(context,pos,w);
    buildResult();
    return true;
}

void AnthyConversion::updateFrequency() {
    for(unsigned int i = 0;i < convResult.size();i ++) {
        anthy_commit_segment(context,i,convResult[i].pos);
    }
    return;
}

bool AnthyConversion::connect() {
    return current;
}
void AnthyConversion::disconnect() {
    return;
}

void AnthyConversion::selected() {
    current = true;
}

void AnthyConversion::unSelected() {
    current = false;
}


void AnthyConversion::buildResult() {
    struct anthy_conv_stat stat;
    anthy_get_stat(context,&stat);
    int slen = 0;
    convResult.clear();
    for(int i = 0;i < stat.nr_segment;i ++) {
        ResultList l;
        l.kType = DEFAULT;
        l.Title = utf8_mbstowcs(String(_("lookup result")));
        struct anthy_segment_stat sstat;
        anthy_get_segment_stat(context,i,&sstat);
        //l.count = sstat.nr_candidate;
        //l.Yomi = yomiText.substr(slen,sstat.seg_len);
        //slen += sstat.seg_len;
        l.pos = 0;
        for(int j = 0;j < sstat.nr_candidate;j ++) {
            char res[256];
            int c = anthy_get_segment(context,i,j,0,0);
            if (c > 255) c = 255;
            anthy_get_segment(context,i,j,res,c + 1);
            WideString w;
            m_iconv.convert(w,String(res));
            l.kouho.push_back(w);
            //if ((w == yomiText.substr(slen,w.length())) && (l.Yomi.length() < w.length())) {
            //    l.Yomi = w;
            //    slen += w.length();
            //}
        }
        char res[256];
        int c = anthy_get_segment(context,i,NTH_UNCONVERTED_CANDIDATE,0,0);
        if (c > 255) c = 255;
        anthy_get_segment(context,i,NTH_UNCONVERTED_CANDIDATE,res,c + 1);
        WideString w;
        m_iconv.convert(w,String(res));
        l.Yomi = w;
        
        convResult.push_back(l);
    }
}

String AnthyConversion::getName()
{
    return String("Anthy");
}

String AnthyConversion::getPropertyName()
{
    return String(_("AnthyConversion"));
}


