/*
 * IIIMF-SKK, Japanese Language Engine for 
 *                        IIIMF (Internet/Intranet Input Method Framework)
 * 
 * Copyright (C) 2002 Motonobu Ichimura <famao@kondara.org>
 *
 * All rights reserved.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of this software and associated documentation files (the
 * "Software"), to deal in the Software without restriction, including
 * without limitation the rights to use, copy, modify, merge, publish,
 * distribute, and/or sell copies of the Software, and to permit persons
 * to whom the Software is furnished to do so, provided that the above
 * copyright notice(s) and this permission notice appear in all copies of
 * the Software and that both the above copyright notice(s) and this
 * permission notice appear in supporting documentation.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
 * OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT
 * OF THIRD PARTY RIGHTS. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR
 * HOLDERS INCLUDED IN THIS NOTICE BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL
 * INDIRECT OR CONSEQUENTIAL DAMAGES, OR ANY DAMAGES WHATSOEVER RESULTING
 * FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT,
 * NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION
 * WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
 *
 * Except as contained in this notice, the name of a copyright holder
 * shall not be used in advertising or otherwise to promote the sale, use
 * or other dealings in this Software without prior written authorization
 * of the copyright holder.
 *
 */

/* $Id: iiimpIM.h,v 1.1.1.1 2002/04/06 02:23:31 famao Exp $ */

/* vi:set ts=4 sw=4: */


/*
Copyright 1990-2001 Sun Microsystems, Inc. All Rights Reserved.

Permission is hereby granted, free of charge, to any person obtaining a
copy of this software and associated documentation files (the
"Software"), to deal in the Software without restriction, including
without limitation the rights to use, copy, modify, merge, publish,
distribute, sublicense, and/or sell copies of the Software, and to
permit persons to whom the Software is furnished to do so, subject to
the following conditions: The above copyright notice and this
permission notice shall be included in all copies or substantial
portions of the Software.


THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
IN NO EVENT SHALL THE OPEN GROUP OR SUN MICROSYSTEMS, INC. BE LIABLE
FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF
CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH
THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE EVEN IF
ADVISED IN ADVANCE OF THE POSSIBILITY OF SUCH DAMAGES.


Except as contained in this notice, the names of The Open Group and/or
Sun Microsystems, Inc. shall not be used in advertising or otherwise to
promote the sale, use or other dealings in this Software without prior
written authorization from The Open Group and/or Sun Microsystems,
Inc., as applicable.


X Window System is a trademark of The Open Group

OSF/1, OSF/Motif and Motif are registered trademarks, and OSF, the OSF
logo, LBX, X Window System, and Xinerama are trademarks of the Open
Group. All other trademarks and registered trademarks mentioned herein
are the property of their respective owners. No right, title or
interest in or to any trademark, service mark, logo or trade name of
Sun Microsystems, Inc. or its licensors is granted.

*/

#ifndef iiimpIM_H
#define iiimpIM_H

#include "commonIM.h"
#include "iiimp.h"

extern XIM _IIIMP_OpenIM(XLCd lcd, Display *dpy, XrmDatabase rdb,
			 char *res_name, char *res_class);

#define ATTRNUM 10
#define PADDING(length) ((4 - ((length) % 4)) % 4)

/* private XIM data for IIIMP */
typedef struct {
  struct _XtransConnInfo *trans_conn; /* transport connection object */
  char		*address;
} TransSpecRec;

typedef struct _IIIMObject *IIIMObject;

typedef struct {
  CARD32 keycode;
  CARD32 keychar;
  CARD32 modifier;
  CARD32 time_stamp;
} XIMTriggerKey;

typedef struct {
  unsigned short count_keys;
  XIMTriggerKey *keylist;
} XIMTriggerKeys;

typedef struct _IIIMMessageListRec {
  unsigned char 		*p;
  struct _IIIMMessageListRec	*next;
} IIIMMessageList;

typedef struct _IIIMReplyListRec {
  int				opcode;
  int				icid;
  struct _IIIMReplyListRec	*next;
} IIIMReplyList;

typedef struct _XIMIIimpIMRec {
  XIMText	*supported_languages;
  int		count_languages;
  TransSpecRec	*spec;
  Window	cb_window;
  IIIMMessageList *message;
  IIIMReplyList	*reply_list;
  int		read_timeout;
  int		iiimp_cb_registered;
  char		*engine_name;
  char		*primary_locale;
  char		*client_type;
  CARD16	input_method_id;
  XIC		current_ic;
  XIMTriggerKeys on_keys;
  XIMTriggerKeys off_keys;

  IIIMObject	iiim_object;

  XIMMethods	switch_methods;

} XIMIIimpIMRec;

extern void ChangePreeditState(XicCommon);
extern void SetConversionMode(XicCommon, int);
extern void PutBackXKeyEvent(XicCommon);
extern void HoldXKeyEvent(XicCommon, XEvent *);

#define IsConversionMode(ic)  (XIM_IS_IIIMP(ic->core.im) && XIC_IIIMP(ic, filtered))

/* private XIC data for IIIMP */
typedef struct _XICKeyEventList {
  XKeyEvent			key_event;
  struct _XICKeyEventList *	next;
} XICKeyEventListRec;

typedef struct _XICIIimpIMRec {
  int		icid;
  Bool		filtered;
  char		*mb;		/* For IM_COMMIT_STRING(Server->Client) */
  KeySym	keysym_return;	/* For IM_FORWARD_EVENT(Server->Client) */

  XICKeyEventListRec	*key_event_list;
  int		key_event_num;

  XKeyEvent	keyevent_return;
  Bool		has_keyevent_return;

  int		key_event_forwarded;

  struct _aux   *aux;

  XICMethods	switch_methods;

} XICIIimpIMRec;

typedef enum {
  CONV_ON = 0,
  CONV_OFF = 1
} XICConversionMode;

typedef enum {
  CREATE_IC = 0,
  SET_IC = 1
} XICSetMode;

typedef enum {
  INPUT_LANGUAGE = 1,
  CHARACTER_SUBSETS = 2,
  INPUT_METHOD = 3
} ICAttributeID;

#define IIIMP_CLIENT_TYPE "XIM IIIMP ADAPTOR"

typedef enum {
  IM_GUI_OBJECT = 0,
  IM_LWE_OBJECT = 1,
  IM_SYNTAX_RULE_OBJECT = 2,
  IM_MANAGER_RULE_OBJECT = 3,
  IM_PRELOADING_LWE_OBJECT = 4
} IMObjectCategory;

typedef enum {
  INPUTMETHOD_LIST = 0x1001,
  OBJECT_DESCRIPTER_LIST = 0x1010,
  CLIENT_DESCRIPTER = 0x1011,
  CCDEF = 0x1030,
  GUI_OBJECT = 0x1033,
  LWE_OBJECT = 0x1034,
  OS_VERSION	= 0x2001,
  OS_NAME	= 0x2002,
  OS_ARCH	= 0x2003
} IMAttributeID;

typedef struct {
  ICAttributeID attribute_id;
  int		value_length;
  XPointer	value;
} XICAttribute;

typedef struct _IIIMObject {
  IMObjectCategory	obj_cat;	/* object category */
  unsigned int		obj_size;	/* object size */
  IMAttributeID		id;		/* CCDEF, GUI_OBJECT, LWE_OBJECT */
  unsigned int		id_dyn;		/* dynamic assigned id */
  char *		domain;		/* reversed domain */
  CARD16 *		name;		/* HRN */
  int			name_length;	/* HRN len in UTF16-char unit */
  char *		signature;	/* Object signature */
  char *		scope;		/* usability id or `generic' */

  char *		path;		/* path for object */
  char *		basepath;	/* base path for include tag */
  char *		encoding;	/* encoding of CCDEF */

  struct _IIIMObject *	next;
} IIIMObjectRec;

extern char *	IIIMP_GetIMValues(XIM xim, XIMArg *arg);
extern char*	IIIMP_SetIMValues(XIM xim, XIMArg *arg);

extern Status IIIMP_OpenIM_SWITCH(XIM xim, XLCd lcd);
extern Status IIIMP_CreateIC_SWITCH(XIC xic, XIMArg *arg);

/* iiimpHandler.c */
extern Bool	IMConnect(XimCommon im, int retry_count);
extern Bool	IMDisconnect(XimCommon im);
extern int	IMCreateIC(XimCommon im);
extern Bool	IMGetICValues(XicCommon ic, XICAttribute *ic_attr,
			      int attr_count);
extern Bool	IMSetPrimaryLocale(XicCommon ic, char *input_locale);
extern Bool	IMSetICValues(XicCommon ic, XICAttribute *ic_attr,
			      int attr_count);
extern Bool	IMCheckIMWindow(XicCommon ic, Window window);
extern Bool	IMSetFocus(XicCommon ic, Bool reconnect);
extern Bool	IMUnsetFocus(XicCommon ic);
extern Bool	IMResetIC(XicCommon ic);
extern Bool	IMForwardEvent(XIC xic, XEvent *ev);
extern Bool	IMTriggerNotify(XicCommon ic, XICConversionMode conv_mode);
extern Bool	IMSetIMValues(XimCommon im);
extern Bool	IMGetIMValue(XimCommon im, int attr_id);
extern Bool	IMAuxSetValues(XicCommon ic, unsigned char * p,
			       int len, XPointer ret);
extern Bool	IMDestroyIC(XicCommon ic);
extern Bool	IMCBFilter(Display * d, Window w, XEvent * ev,
			   XPointer client_data);

/* iiimpConv.c */
extern int	IMConvertFromUTF8ToUTF16(char *from_buf, size_t from_left,
					 char **to_buf, size_t *to_left);
extern int	IMConvertFromUTF8(char *from_buf, size_t from_left,
				  char **to_buf, size_t *to_left);
extern int	IIimpConvertToUTF16(char *from_buf, size_t from_left,
				    char **to_buf, size_t *to_left);
extern int	IIimpConvertFromUTF16(char *from_buf, size_t from_left,
				      char **to_buf, size_t * to_left);
extern int	IMStringToXIMText(unsigned char *p, XIMText *text,
				  Bool useUnicode);
extern int	IMTextToXIMText(unsigned char *p, XIMText *text,
				IMFeedbackList **feedback_list_ret,
				Bool useUnicode);
extern int	IMTextListToXIMTextList(unsigned char *p,
					XIMText **text_list,
					IMFeedbackList ***feedback_array,
					int *numberm,
					Bool useUnicode);
extern int	IIimpWcstoMbs(XimCommon im, wchar_t *from, int from_len,
			      char *to, int to_len, Status *state);
extern int	IIimpMbstoWcs(XimCommon im, char *from, int from_len,
			      wchar_t *to, int to_len, Status *state);

/* iiimpClientDescriptor.c */
extern void	makeClientDescripter(Display *dpy, char *client_name,
				     XICAttribute *ic_attr,
				     int icid);
#endif
