########################################################
# K3D_WITH_SUPERLU

AC_DEFUN([K3D_WITH_SUPERLU], [
AC_SUBST(K3D_SUPERLU_CFLAGS)
AC_SUBST(K3D_SUPERLU_LIBS)
AC_SUBST(K3D_QUADRILATERAL_REMESHING_SUBDIR)
AC_ARG_WITH(superlu,[  --with-superlu[[=PATH]]   build SuperLU-based plugins [[yes]]],[],[withval=yes])
if test x$withval != xno; then
	if test x$withval = xyes; then
		k3d_superlu_prefix=/usr
	else
		k3d_superlu_prefix=$withval
	fi

	AC_MSG_CHECKING([for SuperLU])
	AC_CHECK_HEADER([$k3d_superlu_prefix/include/superlu/dsp_defs.h],
	[
		K3D_SUPERLU_CFLAGS="-I$k3d_superlu_prefix/include"
		K3D_SUPERLU_LIBS="-I$k3d_superlu_prefix/lib -lsuperlu"

		K3D_QUADRILATERAL_REMESHING_SUBDIR="quadrilateral_remeshing"
	],
	[
	AC_MSG_RESULT([not found.])
	])
fi
])

