/***************************************************************************
*   Copyright (C) 2004 by  ͤ                                            *
*   tasuku@linux-life.net                                                 *
*                                                                         *
*   This program is free software; you can redistribute it and/or modify  *
*   it under the terms of the GNU General Public License as published by  *
*   the Free Software Foundation; either version 2 of the License, or     *
*   (at your option) any later version.                                   *
*                                                                         *
*   This program is distributed in the hope that it will be useful,       *
*   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
*   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
*   GNU General Public License for more details.                          *
*                                                                         *
*   You should have received a copy of the GNU General Public License     *
*   along with this program; if not, write to the                         *
*   Free Software Foundation, Inc.,                                       *
*   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
***************************************************************************/
#include "appendcommand.h"
#include "dlgedit.h"
#include <qheader.h>

AppendCommand::AppendCommand( KListView* parent, QString to )
{
	m_parent = parent;
	m_succeed = true;
	dlgEdit dlgedit( parent );
	dlgedit.setEditMode( dlgEdit::APPEND, parent->header()->count() == 4 );
	dlgedit.setTo( to );
	dlgedit.exec();
	if( dlgedit.result() ){
		m_item = new WordItem( m_parent, dlgedit.word() );
	}else{
		m_succeed = false;
	}
}

bool AppendCommand::succeed()
{
	return m_succeed;
}

QString AppendCommand::name() const
{
	return i18n( "appended %1 to %2" ).arg( m_item->word().from ).arg( m_item->word().to );
}

void AppendCommand::execute()
{
	m_parent->clearSelection();
	m_parent->insertItem( m_item );
	m_parent->setSelected( m_item, true );
}

void AppendCommand::unexecute()
{
	m_parent->clearSelection();
	m_parent->takeItem( m_item );
}
