/***************************************************************************
 *   Copyright (C) 2004 by  ͤ                                            *
 *   tasuku@linux-life.net                                                 *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#ifndef __CANNA_H__
#define __CANNA_H__

#include "dictionary.h"
#include <qstringlist.h>
#include <qprocess.h>

class Canna : public Dictionary
{
	Q_OBJECT
	struct _canna_api {
		int  (*Initialize)(char *);
		void  (*Finalize)(void);
		int  (*ListDic)(int, char *, char *, int);
		int  (*GetWordTextDic)(int, const char *, const char *, char *, int);
		int (*MountDic)( int, const char*, int );
		int (*DefineDic)( int, const char*, const char* );
		int (*DeleteDic)( int, const char*, const char* );
		int (*CreateDic)(int, const char *, int);
		int (*RemoveDic)(int, const char *, int);
	};

public:
	Canna( QString name );
	~Canna();
	QString name(){ return m_dicname; };
	static bool isAvailable();
	static QStringList lsdic();
	static bool mkdic( QString& dicname );
	void rmdic();
	bool expand(  KListView* lvw );
	bool save( KListView* lvw );
	DictionaryType type(){ return Dictionary::Canna; };

	static QString escape( QString from );
	static QString unescape( QString from );

private:
	struct _canna_api RKFunc;
	QString m_dicname;
	void* m_libcanna;

	bool addWord( Word word );
	bool delWord( Word& word );
	bool mount();
	void unmount();
	static QString dotCanna();
	static bool checkEditDotCanna();
	static bool checkRestartXIM();

	int m_count;
	int m_counter;
	int m_progress;
	void countup();

	QValueList<Word> m_add, m_del;

	QProcess* proc;
	static char* searchuname();

	bool m_blXIMRestart;

	void ximStart();
	void ximStop();
private slots:
	void slotRemove();
// 	void slotRemoved();

};

#endif // __CANNA_H__
