/***************************************************************************
 *   Copyright (C) 2004 by  ͤ                                            *
 *   tasuku@linux-life.net                                                 *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#ifndef _KANNADIC_H_
#define _KANNADIC_H_

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "word.h"
#include "dictionary.h"

#include <kaction.h>
#include <kcommand.h>
#include <kmainwindow.h>
#include <qptrlist.h>
#include <qtimer.h>

class KannaDic : public KMainWindow
{
	Q_OBJECT
public:
	KannaDic();
	~KannaDic();

private slots:
	void setEditEnabled();

	void slotDicNew();
	void slotDicOpen();
	void slotDicSave();
	void slotDicSaveAs();
	void slotDicDelete();
	void slotDicDeleted( bool );
	void slotAppend();
	void slotEdit();
	void slotDelete();

	void slotCut();
	void slotCopy();
	void slotPaste();
	void slotSelectAll();
	void slotDeselect();

	void slotShowMenubar( bool );
	void slotShowToolbar( bool );
	void slotShowStatusbar( bool );

	void slotPopup( KListView*, QListViewItem*, const QPoint& );

	void slotImportMSIME();
	void slotImportPubdic();
	void slotImportDixchange();
	void slotTypeInfo();
	void slotPreferences();
private:
	bool m_blChangable;
	void readConfiguration( bool blOpened );
	void writeConfiguration();

	QPtrList<KAction> actEdit;

	KToggleAction* actShowMenubar;
	KToggleAction* actShowToolbar;
	KToggleAction* actShowStatusbar;
	KSelectAction* actDictionaryType;

	KCommandHistory* m_cmdHistory;

	KListView* lvwDictionary;

	Dictionary* m_dic;

	QTimer* m_timer;

	void setupCentralWidget();
	void setupAcitons();
	void setupStatusBar();

	void dicOpen( Dictionary::DictionaryType dictype, QString dicname );
	void dicCreate( Dictionary::DictionaryType dictype, QString dicname );

	void columnChange( int i );
	bool CheckChangedAndSaved();

protected:
	virtual bool queryClose();
};
#endif // _KANNADIC_H_
