/* xui.c for kan netmaj */
#include "xnet.h"

/* Υեδؿtgifܸ첽ѥå򻲹(Ȥ
   ۤȤɤΤޤޤäƤȤȴǤ롣ޡưФ褤) */

#define MAXSTRING 256

#define CONV_ATTR(code,len)     ((unsigned long)((code)<<16)+(len))
#define CONVATTR_INDIRECT               1
#define CONVATTR_SPOT_LOCATION          3
#define CONVATTR_COLORMAP               6
#define CONVATTR_COLOR                  7
#define CONVATTR_INPUT_STYLE            128
#define CONVARG_OVERTHESPOT             4L

#define CONV_OFF		0
#define WAIT_CONV_ON		1
#define CONV_ON			2
#define WAIT_CONV_OFF		3

#define LATIN			0
#define ESC			1
#define ESC_24			2
#define ESC_28			3
#define ESC_GL			4
#define ESC_GR			5
#define KANJI_GL		6
#define KANJI_GR		7

#define KINPUT2_SELECTION	"_JAPANESE_CONVERSION"
#define KINPUT_SELECTION	"JAPANESE_CONVERSION"
#define TARGET			"COMPOUND_TEXT"
#define CONV_REQUEST		"CONVERSION_REQUEST"
#define CONV_NOTIFY		"CONVERSION_NOTIFY"
#define CONV_END		"CONVERSION_END"
#define CONV_END_REQ		"CONVERSION_END_REQUEST"

static int		conv_mode = CONV_OFF;
static Atom		conv_selection = None;
static Window		conv_owner_win = None;
static Atom		conv_target = None;
static Atom		conv_property = None;
static Atom		conv_req = None;
static Atom		conv_notify = None;
static Atom		conv_end = None;
static Atom		conv_end_req = None;
static Atom conv_attr = None;
static Atom conv_attr_notify = None;
static Window		conv_win;

char	kinputConvSelName[MAXSTRING] = KINPUT2_SELECTION;

extern Display *display;


Atom
InternAtom(name)
     char *name;
{
  Atom ret;
  char msg[80];

  if((ret = XInternAtom(display, name, False)) == None) {
    sprintf(msg, "Can't Intern Atom from %s.\n", name);
    fprintf(stderr, "%s", msg);
  }

  return ret;
}

extern int textCurX, textCurY, textCursorH;
extern Colormap colormap;

void TellTextCursorPosition(xp, yp)
  int *xp, *yp;
{
    *xp = textCurX; *yp = textCurY + textCursorH;
}

void
KinputTellCursorPosition(x, y)
     int x, y;
{
  Window owin;
  char msg[80];
  char *str1;
  XClientMessageEvent xcme;
  unsigned long data[10];
  int len = 0;

  if (conv_attr == None || conv_attr_notify == None)
    return;

  if((owin = XGetSelectionOwner(display, conv_selection)) == None) {
    str1 = XGetAtomName(display, conv_selection);
    sprintf(msg, "There is no Selection Owner of %s.\n", str1);
    fprintf(stderr, "%s", msg);
    XFree(str1);
    conv_owner_win = None;
    conv_mode = CONV_OFF;
    return;
  }

  if(conv_owner_win != owin)
    return;

  data[len++] = CONV_ATTR(CONVATTR_SPOT_LOCATION, 1);
  data[len++] = (x << 16) | (y & 0xffff);

  data[len++] = CONV_ATTR(CONVATTR_INPUT_STYLE, 1);
  data[len++] = CONVARG_OVERTHESPOT;

/* ʬkinput2ǤϤκݤʸطʤοꤷƤ
   ΤǤ뤬ꤷ㤦ȤΤޤޤˤʤä㤦Τ
   顼ޥåפ򿷵˺äƤkinput2ǥ顼
   Ф礬(Ȥμ¤˥顼Ф) */
/*  data[len++] = CONV_ATTR(CONVATTR_COLORMAP, 1);
  data[len++] = colormap;

  data[len++] = CONV_ATTR(CONVATTR_COLOR, 2);
  data[len++] = cols.mess;
  data[len++] = cols.board; */

  XChangeProperty(display, get_wid(talk_win), conv_attr, conv_attr, 32,
		  PropModeReplace, (unsigned char *)data, len);

  xcme.type = ClientMessage;
  xcme.display = display;
  xcme.window = owin;
  xcme.message_type = conv_attr_notify;
  xcme.format = 32;
  xcme.data.l[0] = conv_selection;
  xcme.data.l[1] = get_wid(talk_win);
  xcme.data.l[2] = CONV_ATTR(CONVATTR_INDIRECT, 1);
  xcme.data.l[3] = conv_attr;
  if (XSendEvent(display, owin, False, NoEventMask, (XEvent *)&xcme)
      == 0) {
    fprintf(stderr, "Failing in changing conversion property.\n");
    return;
  }
}


void
KinputBeginConversion ()
{
  XClientMessageEvent xcme;
  Window owin;
  char msg[80];
  char *str1;

  if(conv_selection == None &&
     (conv_selection = InternAtom(kinputConvSelName)) == None)
    return;

  if(conv_target == None && (conv_target = InternAtom(TARGET)) == None)
    return;

  conv_property = None;

  if(conv_req == None && (conv_req = InternAtom(CONV_REQUEST)) == None)
    return;

  if(conv_notify == None && (conv_notify = InternAtom(CONV_NOTIFY)) == None)
    return;

  if(conv_end == None && (conv_end = InternAtom(CONV_END)) == None)
    return;

  if(conv_end_req == None && (conv_end_req = InternAtom(CONV_END_REQ)) == None)
    return;

  if(conv_attr == None &&
     (conv_attr = InternAtom("CONVERSION_ATTRIBUTE")) == None)
    return;

  if(conv_attr_notify == None &&
     (conv_attr_notify = InternAtom("CONVERSION_ATTRIBUTE_NOTIFY")) == None)
    return;

  if((owin = XGetSelectionOwner(display, conv_selection)) == None) {
    str1 = XGetAtomName(display, conv_selection);
    sprintf(msg, "There is no Selection Owner of %s.\n", str1);
    fprintf(stderr, "%s", msg);
    XFree(str1);
    conv_owner_win = None;
    conv_mode = CONV_OFF;
    return;
  }

  switch(conv_mode) {
  case WAIT_CONV_ON :
    fprintf(stderr, "Waiting for start conversion.\n");
    return;
  case CONV_ON :
    if (conv_owner_win == owin)
      return;
    break;
  }

  xcme.type = ClientMessage;
  xcme.display = display;
  xcme.window = owin;
  xcme.message_type = conv_req;
  xcme.format = 32;
  xcme.data.l[0] = conv_selection;
  xcme.data.l[1] = get_wid(talk_win);
  xcme.data.l[2] = conv_target;
  xcme.data.l[3] = conv_property;
  xcme.data.l[4] = conv_attr;

  if(XSendEvent(display, owin, False, NoEventMask, (XEvent *)&xcme)
     == 0) {
    fprintf(stderr, "Failing in connecting owner.\n");
    return;
  }

  conv_owner_win = owin;
  conv_mode = WAIT_CONV_ON;

  if (XSendEvent(display, owin, False, NoEventMask, (XEvent *)&xcme)
      == 0) {
    fprintf(stderr, "Failing in changing conversion property.\n");
    return;
  }

/*
  {
    int curX, curY;

    TellTextCursorPosition(&curX, &curY);
    KinputTellCursorPosition(curX, curY);
  }*/
}

void
KinputCheckClientMessage (xclient)
     XClientMessageEvent *xclient;
{
  Window twin = get_wid(talk_win);

  if(xclient->message_type == conv_notify) {
    if( conv_mode != WAIT_CONV_ON ||
       xclient->window != twin ||
       xclient->format != 32 ||
       xclient->data.l[0] != conv_selection) {
      return;
    }
    if( xclient->data.l[2] == None ||
       xclient->data.l[1] != conv_target) {
      conv_mode = CONV_OFF;
      return;
    }
    conv_mode = CONV_ON;
    conv_property = xclient->data.l[2];
    conv_win = xclient->data.l[3];
  }
  else if(xclient->message_type == conv_end) {
    if((conv_mode != WAIT_CONV_OFF && conv_mode != CONV_ON) ||
       xclient->window != twin ||
       xclient->format != 32 ||
       xclient->data.l[0] != conv_selection ||
       (xclient->data.l[1] != conv_owner_win &&
	xclient->data.l[1] != conv_win)) {
      return;
    }
    conv_mode = CONV_OFF;
  }
}

void
KinputCheckConvProperty (xprop, dst)
     XPropertyEvent *xprop;
     register char *dst;
{
  Atom act_target;
  int act_format;
  unsigned long nitems;
  unsigned long remain_bytes;
  unsigned char *data;
  Window twin = get_wid(talk_win);

  if( xprop->window != twin ||
     xprop->atom != conv_property ||
     xprop->state != PropertyNewValue ||
     conv_mode != CONV_ON) {
    return;
  }

  if(XGetWindowProperty(display, twin, conv_property,
			0, MAXSTRING/sizeof(long),
			True, conv_target, &act_target, &act_format,
			&nitems, &remain_bytes, &data) != Success) {
    fprintf(stderr, "XGetWindowProperty failed.\n");
    return;
  }
  if (remain_bytes > 0)
    XDeleteProperty(display, twin, conv_property);

  if(act_target == None || conv_target != act_target)
    return;
  if(act_format != 8) {
    XFree(data);
    return;
  }

  conv_string(dst, data);

  XFree(data);
}

void
KinputEndConversion ()
{
  Window owin;
  char msg[80];
  char *str1;
  XClientMessageEvent xcme;

  switch(conv_mode) {
  case WAIT_CONV_ON :
    fprintf(stderr, "Waiting for start conversion.\n");
    return;
  case WAIT_CONV_OFF :
  case CONV_OFF :
    return;
  }

  if((owin = XGetSelectionOwner(display, conv_selection)) == None) {
    str1 = XGetAtomName(display, conv_selection);
    sprintf(msg, "There is no Selection Owner of %s.\n", str1);
    fprintf(stderr, msg);
    XFree(str1);
    conv_owner_win = None;
    conv_mode = CONV_OFF;
    return;
  }

  if(conv_owner_win != owin) {
    conv_mode = CONV_OFF;
    return;
  }

  xcme.type = ClientMessage;
  xcme.display = display;
  xcme.window = owin;
  xcme.message_type = conv_end_req;
  xcme.format = 32;
  xcme.data.l[0] = conv_selection;
  xcme.data.l[1] = get_wid(talk_win);
  if(XSendEvent(display, owin, False, NoEventMask, (XEvent *)&xcme)
     == 0) {
    fprintf(stderr, "Failing in disconnecting owner.\n");
    conv_mode = CONV_OFF;
    return;
  }

  conv_mode = WAIT_CONV_OFF;
}
