/* res.c for kan netmaj */
#include "xnet.h"
#include "bitmap/misc.h"
#include <sys/time.h>

int selected, mp;
extern int river_x[4];
extern int prev_num[4];
int in_res, in_choice;


/* this function is a part of original xsleep in netmaj */
void
xsleep(time_out)
     int time_out;
{
  fd_set fds;
  struct timeval to,*top;
  int ret = 0;

  top = 0;
  FD_ZERO( &fds );
  if (time_out >= 0) {
    to.tv_sec = time_out/10;
    to.tv_usec = (time_out % 10)*100000;
    top = &to;
  }
  select( 1, &fds, (fd_set *)0, (fd_set *)0, top);
}


extern int readable_socket;

void 
wait_selected(gp)
     global_t *gp;
{
    while(selected == SEL_NONE) {
	ui_event_wait (gp, 0);
	if (readable_socket)
	  callback(gp);
    }
}

void
select_pai(num, x, y)
     int num, x, y;
{
  if (num > prev_num[mp])
    selected = SEL_NONE;
  else if (num == prev_num[mp] && x < ftwsize/4)
    selected = num - 1;
  else
    selected = num;
}

void
select_dialog1(num, sel)
     int num, sel;
{
  selected = SEL_REACH + sel;
}

void
select_dialog2(num, sel)
     int num, sel;
{
  selected = SEL_TIE + sel;
}

void
select_cancel(num, sel)
     int num, sel;
{
  selected = SEL_CANCEL;
}

void
draw_dlg1()
{
  ThreeDframe2(dlg1, 0, 0, win_width(dlg1), win_height(dlg1), 1);
  draw_button(dlg1_but);
}

void
draw_dlg2()
{
  ThreeDframe2(dlg2, 0, 0, win_width(dlg2), win_height(dlg2), 1);
  draw_button(dlg2_but);
}


int select_set[3][4], skind;

void
select_naki(num, x, y)
     int num, x, y;
{
  selected = num;
  set_reg_responsive(naki_sel, 0);
}

void
draw_dlg3()
{
  int i, j;

  ThreeDframe2(dlg3, 0, 0, win_width(dlg3), win_height(dlg3), 1);
  for (i = 0; i < 3; i++) {
    if (select_set[i][0] == -1)
      break;
    for (j = 0; j < skind; j++)
      draw_pai (dlg3, select_set[i][j], 0, 1, 2+j*ftwsize, i*(fthsize+5)+2+fthsize);
  }
  set_reg_responsive(naki_sel, 1);
  draw_button(dlg3_but);
}

void
choice (gp, n_draw, argv, kind)
     global_t *gp;
     int n_draw, argv[], kind;
{
  int x, y, i, j, but;

  if (kind == SEL_TIE) {
    skind = 3;
    for (i = 0; i < n_draw; i++) {
      j = -1;
      while (hand[vself].closed[++j] != argv[i]);
      while ((P_KIND(argv[i]) == P_KIND(hand[vself].closed[++j]))
	     || (P_KIND(rvp->out) == P_KIND(hand[vself].closed[j])));

      if (rvp->out < argv[i]) {
	select_set[i][0] = rvp->out;
	select_set[i][1] = argv[i];
	select_set[i][2] = hand[vself].closed[j];
      }
      else {
	select_set[i][0] = argv[i];
	if (P_KIND(rvp->out) < P_KIND(hand[vself].closed[j])) {
	  select_set[i][1] = rvp->out;
	  select_set[i][2] = hand[vself].closed[j];
	}
	else {
	  select_set[i][1] = hand[vself].closed[j];
	  select_set[i][2] = rvp->out;
	}
      }
    }
    select_set[i][0] = -1;
  }
  else {
    skind = 4;
    for (i = 0; i < n_draw; i++)
      for (j = 0; j < 4; j++)
	select_set[i][j] = (argv[i]/4)*4+j;
    select_set[i][0] = -1;
  }

  get_drawing_pos(pplayer[cur_player], 0, &x, &y);
  x = river_x[cur_player]+fywsize+ftwsize/4;
  y = y+2;
  if (x > win_width(main_win) - win_width(dlg3)) {
    x = win_width(main_win) - win_width(dlg3);
    y += fthsize;
  }
  move_win(dlg3, x, y);
  win_map(dlg3);

  selected = SEL_NONE;
  wait_selected(gp);
  win_unmap(dlg3);
  set_reg_responsive(dlg3_but, 0);
  win_flush();
}


int
ui_res (gp, howp)
     global_t *gp;
     int *howp;
{
  int c, i, j, ret, pai, x, y;
  int pais[5];
  extern int auto_stop;

  mp = vself;

  while(1) {
    *howp = 0;
    c = 0;
    
    if (auto_stop) {
      result_t y;
      
      if (!hand[vself].reach && (T_GET(rvp->attr) != T_HN_KAN)
	  && (T_GET(rvp->attr) != T_HN_KAN_C)) {
	if (hand_can_pon(gp, vself, rvp->out)
	    || (hand_can_kan(gp, vself, rvp->out) == 2)
	    || ((cur_player+1)%4 == vself
		&& hand_can_tiex(gp, vself, rvp->out)))
	  c = ' ';
      }
      if (c == 0)
	{
	  hand_insert (gp, vself, rvp->out);
	  if (result_calc_yaku (gp, vself, &y) > 0)
	    c = ' ';
	  hand_delete (gp, vself, rvp->out, 0);
	}
    }

    if (c == 0 || c != ' ') {
      extern int play_speed;
      xsleep(play_speed);
      return R_ACK;
    }

    get_drawing_pos(pplayer[cur_player], 0, &x, &y);
    x = river_x[cur_player]+fywsize+ftwsize/4;
    y = y+2;
    if (x > win_width(main_win) - win_width(dlg2)) {
      x = win_width(main_win) - win_width(dlg2);
      y += fthsize;
    }
    move_win(dlg2, x, y);
    selected = SEL_NONE;
    win_map(dlg2);
    set_reg_responsive(dlg2_but, 1);
    in_res = 1;
    wait_selected(gp);
    in_res = 0;
    win_unmap(dlg2);
    set_reg_responsive(dlg2_but, 0);
    win_flush();

    if (selected != SEL_TIE)
      return (selected%20<<R_SHFT);

    if ((cur_player+1)%4 != vself)
      continue;
    for (i = 0, j = 0; j < hand[vself].closed_num; j++) {
      pai = hand[vself].closed[j];
      if (i != 0 && P_KIND(pai) == P_KIND(pais[i - 1]))
	continue;
      if (hand_can_tie(gp, vself, rvp->out, pai))
	pais[i++] = pai;
    }
    if (i == 0)
      continue;
    if (i == 1) {
      *howp = pais[0];
      return R_TIE;
    }

    in_res = 1;
    choice(gp, i, pais, SEL_TIE);
    in_res = 0;

    if (selected != SEL_CANCEL) {
      *howp = pais[selected];
      return R_TIE;
    }
  }
}

void
ui_choice (gp)
     global_t *gp;
{
  int i, j, ret, pai, w, h, x, y;
  int pais[5];
  struct object obj, obj2;

  while(1) {
    selected = SEL_NONE;
    get_drawing_pos(pplayer[vself], 1, &x, &y);
    move_win(dlg1, x+(hand[vself].closed_num+1)*ftwsize+ftwsize/4,
	     y-8-win_height(dlg1));
    set_reg_responsive(pai_sel, 1);
    win_map(dlg1);

    in_choice = 1;
    wait_selected(gp);
    in_choice = 0;

    win_unmap(dlg1);
    set_reg_responsive(dlg1_but, 0);
    set_reg_responsive(pai_sel, 0);

    if (selected == SEL_CANCEL) {
      ask_pai = hand[vself].closed[hand[vself].closed_num-1];
      return;
    }
    else if (selected < hand[vself].closed_num) {
      ask_pai = hand[vself].closed[selected];
      return;
    }

    switch(selected)
      {
      case SEL_REACH:
	ask_attr = (ask_attr == T_RV) ? T_RV_RCH : T_RV;
	get_obj_from_win(main_win, 12, &obj);
	get_obj_from_win(main_win, 10, &obj2);
	if (ask_attr == T_RV_RCH)
	  misc2pixmap(main_win, reachbou_xpm, obj.x, obj.y+obj2.hgt*3);
	else
	  win_cleararea(main_win, obj.x, obj.y+obj2.hgt*3, obj.wth, obj.hgt);
	mapping(main_win, obj.x, obj.y+obj2.hgt*3, obj.wth, obj.hgt);
	break;
      case SEL_KAN2:
	i = 0;
	for (j = 0; j < hand[vself].closed_num; j++) {
	  pai = hand[vself].closed[j];
	  if (i != 0 && P_KIND(pai) == P_KIND(pais[i - 1]))
	    continue;
	  if (hand_can_kan(gp, vself, pai)%2 == 1)
	    pais[i++] = pai;
	}
	if (i == 0)
	  break;
	if (i == 1) {
	  ask_attr = T_HN_KAN;
	  ask_pai = pais[0];
	  return;
	}
	in_choice = 1;
	choice(gp, i, pais, SEL_KAN);
	in_choice = 0;
	if (selected != SEL_CANCEL) {
	  ask_pai = pais[ret];
	  ask_attr = T_HN_KAN;
	  return;
	}
	break;
      case SEL_TUMO:
	ask_attr = T_HN_TSM;
	return;
      }
  }
}
