/*
 *
 * Copyright (C) 2002 George Staikos <staikos@kde.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public License
 * along with this library; see the file COPYING.LIB.  If not, write to
 * the Free Software Foundation, Inc., 51 Franklin Steet, Fifth Floor,
 * Boston, MA 02110-1301, USA.
 */

#include <kdebug.h>

#include "kdetvsrcplugin.h"

KdetvSourcePlugin::KdetvSourcePlugin(Kdetv *ktv, const QString& cfgkey, QObject *o, const char* n)
    : KdetvPluginBase(ktv, cfgkey, o, n),
      _device(QString::null),
      _source(QString::null),
      _encoding(QString::null),
      _isVideoDesktop(false)
{
}

KdetvSourcePlugin::~KdetvSourcePlugin()
{
}

bool KdetvSourcePlugin::setVolume( int, int )
{
    return false;
}

bool KdetvSourcePlugin::isTuner(const QString &dev)
{
	kdDebug() << "-->" << _tuners.size() << " tuners detected" << endl;
	kdDebug() << "-->" << "_tuners[" << dev << "] is " << _tuners[dev] << endl;
	return _tuners[dev];
}

#include "kdetvsrcplugin.moc"

