/***************************************************************************
                           greedyh.h
                           ---------
    begin                : Wed Jul 21 2004
    copyright            : (C) 2004 by Dirk Ziegelmeier
    email                : dziegel@gmx.de
 ***************************************************************************/

/*
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 */

#include <qspinbox.h>
#include <qlabel.h>
#include <qlayout.h>
#include <qpushbutton.h>

#include <kdebug.h>
#include <klocale.h>
#include <kconfig.h>

#include "greedyh.h"
#include "dscalerfiltergreedyh.h"

GreedyHPlugin::GreedyHPlugin(Kdetv *ktv, const QString& cfgkey, QObject *parent, const char* name)
    : KdetvFilterPlugin(ktv, cfgkey, parent, name)
{
    DScalerFilterGreedyH* f = new DScalerFilterGreedyH();
    _filter = f;

    f->GreedyMaxComb         = _cfg->readNumEntry("Max Comb",         MAXCOMB_DEFAULT);
    f->GreedyMotionThreshold = _cfg->readNumEntry("Motion Threshold", MOTIONTHRESHOLD_DEFAULT);
    f->GreedyMotionSense     = _cfg->readNumEntry("Motion Sense",     MOTIONSENSE_DEFAULT);
}

GreedyHPlugin::~GreedyHPlugin()
{
    delete _filter;
}

QWidget* GreedyHPlugin::configWidget(QWidget* parent, const char* name)
{
    DScalerFilterGreedyH* f = static_cast<DScalerFilterGreedyH*>(_filter);

    QFrame *w = new QFrame(parent, name);
    w->setMargin(4);
    QGridLayout *g = new QGridLayout(w, 4, 2);

    g->addWidget(new QLabel(i18n("Max comb:"), w), 0, 0);
    _spMaxComb = new QSpinBox(0, 255, 1, w, "MaxCombSpin");
    _spMaxComb->setValue(f->GreedyMaxComb);
    g->addWidget(_spMaxComb, 0, 1);

    g->addWidget(new QLabel(i18n("Motion threshold:"), w), 1, 0);
    _spMotionThreshold = new QSpinBox(0, 255, 1, w, "MotionThresholdSpin");
    _spMotionThreshold->setValue(f->GreedyMotionThreshold);
    g->addWidget(_spMotionThreshold, 1, 1);

    g->addWidget(new QLabel(i18n("Motion sense:"), w), 2, 0);
    _spMotionSense = new QSpinBox(0, 255, 1, w, "MotionSenseSpin");
    _spMotionSense->setValue(f->GreedyMotionSense);
    g->addWidget(_spMotionSense, 2, 1);

    QButton* b = new QPushButton(i18n("Defaults"), w, "Defaults");
    connect(b, SIGNAL( clicked() ),
            this, SLOT( defaults() ));
    g->addWidget(b, 3, 1);

    return w;
}

void GreedyHPlugin::defaults()
{
    DScalerFilterGreedyH* f = static_cast<DScalerFilterGreedyH*>(_filter);

    f->GreedyMaxComb         = MAXCOMB_DEFAULT;
    f->GreedyMotionThreshold = MOTIONTHRESHOLD_DEFAULT;
    f->GreedyMotionSense     = MOTIONSENSE_DEFAULT;

    _spMaxComb->setValue(f->GreedyMaxComb);
    _spMotionThreshold->setValue(f->GreedyMotionThreshold);
    _spMotionSense->setValue(f->GreedyMotionSense);
}

void GreedyHPlugin::saveConfig()
{
    DScalerFilterGreedyH* f = static_cast<DScalerFilterGreedyH*>(_filter);

    f->GreedyMaxComb         = _spMaxComb->value();
    f->GreedyMotionThreshold = _spMotionThreshold->value();
    f->GreedyMotionSense     = _spMotionSense->value();

    _cfg->writeEntry("Max Comb",         f->GreedyMaxComb);
    _cfg->writeEntry("Motion Threshold", f->GreedyMotionThreshold);
    _cfg->writeEntry("Motion Sense",     f->GreedyMotionSense);
    _cfg->sync();
}

extern "C" {
    KDETV_EXPORT GreedyHPlugin* create_greedyh(Kdetv* ktv)
    {
        return new GreedyHPlugin(ktv, "deinterlace-greedyh", 0, "GreedyH deinterlacefilter");
    }
}

#include "greedyh.moc"
