// -*- c++ -*-

/*
 *
 * Copyright (C) 2004 Dirk Ziegelmeier <dziegel@gmx.de>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public License
 * along with this library; see the file COPYING.LIB.  If not, write to
 * the Free Software Foundation, Inc., 51 Franklin Steet, Fifth Floor,
 * Boston, MA 02110-1301, USA.
 */

#ifndef __OVERLAYCONTROLLER
#define __OVERLAYCONTROLLER

#include <qwidget.h>

class QEvent;
class QTimer;

class OverlayController : public QWidget
{
    Q_OBJECT


public:
    OverlayController(QWidget* parent);
    ~OverlayController();


signals:
    void updateClipping();
    void moved();
    void resized();
    void repaintScreen();
    void enableVideo(bool);


protected:
    bool eventFilter(QObject*, QEvent*);
    bool x11Event(XEvent*);
    void scheduleRepaintScreen();
    void scheduleReclip();


protected slots:
    void doRepaintScreen();
    void doReclip();


private:
    bool _filterRefresh;
    int  _visibility;
    QWidget* _w;
    QWidget* _top;
    QWidget* _root;

    QTimer* _repaintTimer;
    QTimer* _reclipTimer;
};

#endif
