/***************************************************************************
 *   Copyright (C) 2008 by Joerg Zopes   *
 *   joerg.zopes@linux-specialist.com   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/


#ifndef _KNDISWRAPPER_H_
#define _KNDISWRAPPER_H_

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <qmultilineedit.h>
#include <qapplication.h>
#include <kmainwindow.h>
#include <qmessagebox.h>
#include <qpushbutton.h>
#include <qfiledialog.h>
#include <qpopupmenu.h>
#include "instwizard.h"
#include "wikilookup.h"
#include <wifisetup.h>
#include <qprocess.h>
#include <qtooltip.h>
#include <qpixmap.h>
#include <qpixmap.h>
#include <qlabel.h>
#include <qtable.h>
#include <qtimer.h>
#include <qfont.h>
#include <cstdlib>
#include <cstring>

/**
 * @short Application Main Window
 * @author Joerg Zopes <joerg.zopes@linux-specialist.com>
 * @version 0.2.5
 */
class kndiswrapper : public QWidget
{
    Q_OBJECT
    public:
        kndiswrapper();
        virtual ~kndiswrapper();

    private:
        QMultiLineEdit  * comment;
        QLabel          * logoLabel;
        QTable          * hardwareList;
        QProcess        * removeProcess;
        QProcess        * moduleCheck;
        QProcess        * infoProcess;
        QProcess        * getConfProcess;
        QProcess        * restoreProcess;
        QProcess        * findNDISProcess;
        QProcess        * configNetworkProcess;
        QProcess        * moduleLoadedCheckProcess;
        QPushButton     * quitButton;
        QPushButton     * reloadButton;
        QPushButton     * addDriverButton;
        QPushButton     * removeDriverButton;
        QPushButton     * restoreDriverButton;
        QPushButton     * configNetworkButton;
        QPopupMenu      * contextMenu;
        int               quitButtonEndPosition;
        int               reloadButtonEndPosition;
        int               removeDriverButtonEndPosition;
        int               restoreDriverButtonEndPosition;
        int               configNetworkButtonEndPosition;
        bool              getConfFlag;
        bool              invokeSetup;
        bool              disablerootcheck;
        bool              disablenetconf;
        QTimer          * moveButtonTimer;
        QString           ndiswrapperPath;
        QString           moduleCheckOutput;
        QString           workingCards;

        int quit;
        int hwList;
        int disabled;
        int addDriver;
        int delDriver;
        int reloadList;
        int restoreDriver;
        int netconf;

        void getConf();
        void initWidget();
        void addNewRow(QString);
        void activateControls(int);
        void resizeEvent(QResizeEvent *);

    private slots:
        void slot_wikiRequested();
        void slot_infoProcessExited();
        void slot_reloadButtonClicked();
        void slot_removeProcessExited();
        void slot_moduleCheckRequested();
        void slot_getConfProcessExited();
        void slot_restoreProcessExited();
        void slot_infoProcessRequested();
        void slot_findNDISProcessExited();
        void slot_configNetworkRequested();
        void slot_addDriverButtonClicked();
        void slot_buttonMoveTimerTimeout();
        void slot_moduleCheckProcessExited();
        void slot_removeDriverButtonClicked();
        void slot_restoreDriverButtonClicked();
        void slot_configNetworkProcessExited();
        void slot_moduleLoadedCheckProcessExited();
        void slot_moduleCheckProcessReadyReadStdout();
        void slot_hardwareListRightClicked(int, int ,const QPoint &);
};

#endif // _KNDISWRAPPER_H_
