/***************************************************************************
 *   Copyright (C) 2008 by Joerg Zopes   *
 *   joerg.zopes@linux-specialist.com   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#include "setupdialog.h"

setupDialog::setupDialog(QWidget *parent, const char *name) : QDialog(parent, name, true)
{
  result="NOTRANS";
	this->setFixedSize(350,340);
	doneButton = new QPushButton("done",this,"doneButton");
  commentLabel = new QTextEdit("You are starting the application for the first time or you have invoced the programm with --setup option. Please select a language file","Languages",this,"commentLabel");
  commentLabel->setReadOnly(true);
  commentLabel->setFont(QFont("Helvetic",10,QFont::Normal,false));
  flagLabel = new QLabel("",this,"flagLabel");
  flagLabel->setPixmap(QPixmap(language_xpm));
  languageSelectComboBox = new QComboBox(this,"languageSelectComboBox");
  connect(doneButton,SIGNAL(clicked()),this,SLOT(slot_doneButtonClicked()));
}


setupDialog::~setupDialog()
{
}

void setupDialog::resizeEvent(QResizeEvent * e){
QDir tempDir("/usr/local/translations/kndiswrapper");
     tempDir.setNameFilter("*.qm");
QStringList fileList = tempDir.entryList();
QString entry;

    for ( QStringList::Iterator it = fileList.begin(); it != fileList.end(); ++it ) {
        entry = *it;
        languageSelectComboBox->insertItem(entry);
    }

  flagLabel->setGeometry(5,5,340,160);
  commentLabel->setGeometry(5,170,this->width()-10,80);
  languageSelectComboBox->setGeometry(5,commentLabel->y()+commentLabel->height()+5,this->width()-10,30);
  doneButton->setGeometry(this->width()-60,this->height()-50,55,40);
}


QString setupDialog::getResult(){

    return result;
}

void setupDialog::slot_doneButtonClicked(){
    result = languageSelectComboBox->currentText();
    this->done(0);
}

#include "setupdialog.moc"
