/***************************************************************************
 *   Copyright (C) 2008 by Joerg Zopes   *
 *   joerg.zopes@linux-specialist.com   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#ifndef SETUPDIALOG_H
#define SETUPDIALOG_H

#include <qdialog.h>
#include <qpushbutton.h>
#include <qtextedit.h>
#include <qcombobox.h>
#include <qpixmap.h>
#include <qlabel.h>
#include <qfont.h>
#include <qdir.h>

/**
	@author Joerg Zopes <joerg.zopes@linux-specialist.com>
*/
class setupDialog : public QDialog
{
Q_OBJECT
public:
    setupDialog(QWidget *parent = 0, const char *name = 0);

    ~setupDialog();
    QString getResult();
private:
    QString result;
    QPushButton		  * doneButton;
    QTextEdit       * commentLabel;
    QComboBox       * languageSelectComboBox;
    QLabel          * flagLabel;

    void resizeEvent(QResizeEvent *);

private slots:
    void slot_doneButtonClicked();

};

/* XPM */
static const char * language_xpm[] = {
"340 160 4189 2",
"   c None",
".  c #FFFFFF",
"+  c #FEFEFF",
"@  c #FDFCFC",
"#  c #FAFBFB",
"$  c #F9FAF9",
"%  c #F8F8F7",
"&  c #F5F6F6",
"*  c #F4F4F4",
"=  c #F2F2F2",
"-  c #F0F0F0",
";  c #EFEFEF",
">  c #EEEDEE",
",  c #ECEBEB",
"'  c #EAEAEA",
")  c #E8E8E8",
"!  c #E7E7E7",
"~  c #E5E5E5",
"{  c #E3E4E4",
"]  c #E1E1E2",
"^  c #DFE0E0",
"/  c #DEDFDF",
"(  c #DDDCDC",
"_  c #DBDBDA",
":  c #D9D9D9",
"<  c #D8D8D7",
"[  c #D5D6D6",
"}  c #D4D4D5",
"|  c #D3D3D3",
"1  c #D1D1D0",
"2  c #CFCFCF",
"3  c #CDCDCE",
"4  c #CCCCCC",
"5  c #CACACA",
"6  c #C9C8C8",
"7  c #C7C7C7",
"8  c #C5C5C6",
"9  c #C3C3C3",
"0  c #C2C2C2",
"a  c #C0C0C1",
"b  c #BEBFBF",
"c  c #BDBDBD",
"d  c #BBBBBB",
"e  c #BABABA",
"f  c #B8B8B8",
"g  c #B7B6B6",
"h  c #B5B5B4",
"i  c #B3B3B3",
"j  c #B1B2B1",
"k  c #B0B0B0",
"l  c #AEAFAE",
"m  c #ADADAD",
"n  c #ABABAB",
"o  c #A9AAA9",
"p  c #A8A8A8",
"q  c #A6A7A7",
"r  c #A5A5A5",
"s  c #A3A3A3",
"t  c #A2A1A1",
"u  c #A0A0A0",
"v  c #9E9F9F",
"w  c #9D9D9D",
"x  c #9B9C9B",
"y  c #9A9999",
"z  c #979897",
"A  c #969697",
"B  c #949494",
"C  c #939393",
"D  c #929192",
"E  c #8F908F",
"F  c #8E8F8D",
"G  c #8A8E8B",
"H  c #878D87",
"I  c #848D84",
"J  c #808C81",
"K  c #7D8B7E",
"L  c #7A8B7B",
"M  c #768A78",
"N  c #738975",
"O  c #708971",
"P  c #6C886F",
"Q  c #69886C",
"R  c #668768",
"S  c #628665",
"T  c #5F8562",
"U  c #5B855F",
"V  c #58845C",
"W  c #558359",
"X  c #528255",
"Y  c #4F8153",
"Z  c #4C8150",
"`  c #4A804D",
" . c #47804B",
".. c #447F48",
"+. c #417F46",
"@. c #3E7F43",
"#. c #3B7E41",
"$. c #397D3E",
"%. c #367C3B",
"&. c #337C39",
"*. c #317C36",
"=. c #2E7B33",
"-. c #2B7B31",
";. c #287A2E",
">. c #25792C",
",. c #237929",
"'. c #1F7826",
"). c #1D7724",
"!. c #1A7721",
"~. c #17761F",
"{. c #16761D",
"]. c #18771E",
"^. c #1B791E",
"/. c #1E7A1E",
"(. c #207C1E",
"_. c #227E1F",
":. c #257F20",
"<. c #288020",
"[. c #2A8221",
"}. c #2D8422",
"|. c #308522",
"1. c #328723",
"2. c #348823",
"3. c #368923",
"4. c #398A24",
"5. c #3C8C25",
"6. c #3E8D25",
"7. c #418F25",
"8. c #439026",
"9. c #459227",
"0. c #499427",
"a. c #4B9528",
"b. c #4D9628",
"c. c #509829",
"d. c #539929",
"e. c #559A29",
"f. c #589C2A",
"g. c #5A9D2B",
"h. c #5D9F2B",
"i. c #5FA12B",
"j. c #61A22C",
"k. c #64A42D",
"l. c #67A42D",
"m. c #6AA62D",
"n. c #6BA82E",
"o. c #6EA92E",
"p. c #71AA2F",
"q. c #74AC30",
"r. c #76AE30",
"s. c #79AF31",
"t. c #7BB032",
"u. c #7EB232",
"v. c #80B333",
"w. c #83B432",
"x. c #85B633",
"y. c #87B734",
"z. c #8AB935",
"A. c #A2C73A",
"B. c #BAD53E",
"C. c #D4E343",
"D. c #ECF149",
"E. c #FCF951",
"F. c #EDED67",
"G. c #DEE07D",
"H. c #D0D393",
"I. c #C2C9A7",
"J. c #C0C6AA",
"K. c #BEC5AE",
"L. c #BBC2B2",
"M. c #B8C0B5",
"N. c #B6BEB9",
"O. c #B4BBBC",
"P. c #B1BAC0",
"Q. c #AEB8C4",
"R. c #ACB5C7",
"S. c #A9B3CC",
"T. c #A7B1CF",
"U. c #A5AED3",
"V. c #A2ADD7",
"W. c #A0AADA",
"X. c #9DA8DF",
"Y. c #9AA6E3",
"Z. c #98A4E6",
"`. c #95A2EA",
" + c #93A0EE",
".+ c #919EF1",
"++ c #8E9BF4",
"@+ c #8B9AF9",
"#+ c #8997FD",
"$+ c #8695FE",
"%+ c #8292FC",
"&+ c #7F8EF9",
"*+ c #7C8BF6",
"=+ c #7888F4",
"-+ c #7685F1",
";+ c #7282EE",
">+ c #6F7FEC",
",+ c #6C7CEA",
"'+ c #6979E6",
")+ c #6576E4",
"!+ c #6172E2",
"~+ c #5E6FDE",
"{+ c #5B6DDC",
"]+ c #5869D9",
"^+ c #5466D7",
"/+ c #5263D4",
"(+ c #4E60D1",
"_+ c #4B5DCF",
":+ c #475ACC",
"<+ c #4658CB",
"[+ c #4658CA",
"}+ c #4558CA",
"|+ c #4557CA",
"1+ c #4557C9",
"2+ c #4457CA",
"3+ c #4456C9",
"4+ c #4356C9",
"5+ c #4356C8",
"6+ c #4256C9",
"7+ c #4255C8",
"8+ c #4254C7",
"9+ c #4155C7",
"0+ c #4154C7",
"a+ c #4154C6",
"b+ c #4054C6",
"c+ c #4053C6",
"d+ c #4052C5",
"e+ c #3F52C5",
"f+ c #3E52C5",
"g+ c #3E51C5",
"h+ c #3E51C4",
"i+ c #3E50C4",
"j+ c #3D50C4",
"k+ c #3D4FC3",
"l+ c #3C4FC3",
"m+ c #3C4FC2",
"n+ c #3B4EC3",
"o+ c #3B4EC2",
"p+ c #3B4DC2",
"q+ c #3A4EC1",
"r+ c #3A4DC1",
"s+ c #394DC1",
"t+ c #394CC0",
"u+ c #384CC0",
"v+ c #384BC0",
"w+ c #374BBF",
"x+ c #364ABF",
"y+ c #364ABE",
"z+ c #3549BE",
"A+ c #3549BD",
"B+ c #3548BD",
"C+ c #3448BD",
"D+ c #3448BC",
"E+ c #3347BC",
"F+ c #3346BB",
"G+ c #3246BB",
"H+ c #3145BA",
"I+ c #3144BA",
"J+ c #3044BA",
"K+ c #3044B9",
"L+ c #3043B9",
"M+ c #2F43B8",
"N+ c #2F43B9",
"O+ c #2E42B8",
"P+ c #2E43B7",
"Q+ c #2E42B7",
"R+ c #2D42B7",
"S+ c #2D41B7",
"T+ c #2C40B7",
"U+ c #2C41B6",
"V+ c #2C40B6",
"W+ c #2C40B5",
"X+ c #2B3FB5",
"Y+ c #2B40B5",
"Z+ c #2A3FB5",
"`+ c #2A3EB4",
" @ c #2A3EB5",
".@ c #293DB4",
"+@ c #283DB3",
"@@ c #293DB3",
"#@ c #283CB2",
"$@ c #273CB2",
"%@ c #273BB2",
"&@ c #263BB2",
"*@ c #263AB2",
"=@ c #253BB2",
"-@ c #263BB1",
";@ c #253AB1",
">@ c #2539B0",
",@ c #2439B0",
"'@ c #2338AF",
")@ c #2337AF",
"!@ c #2337AE",
"~@ c #2137AE",
"{@ c #2136AE",
"]@ c #2136AD",
"^@ c #2035AD",
"/@ c #2035AC",
"(@ c #1F34AC",
"_@ c #1F34AB",
":@ c #1E34AC",
"<@ c #1E34AB",
"[@ c #1E33AB",
"}@ c #1E33AA",
"|@ c #1D33AA",
"1@ c #1D32AA",
"2@ c #1D31AA",
"3@ c #1D31A9",
"4@ c #1C31AA",
"5@ c #FDFDFD",
"6@ c #FBFCFC",
"7@ c #FAFAFA",
"8@ c #F8F9F9",
"9@ c #F7F7F6",
"0@ c #F4F5F5",
"a@ c #F4F3F3",
"b@ c #F2F1F1",
"c@ c #EFEFF0",
"d@ c #EEEEEE",
"e@ c #EDEDEC",
"f@ c #EBEBEB",
"g@ c #E9E9E9",
"h@ c #E8E7E7",
"i@ c #E6E6E6",
"j@ c #E4E4E5",
"k@ c #E2E3E2",
"l@ c #E0E1E0",
"m@ c #DFDFDF",
"n@ c #DEDDDD",
"o@ c #DBDBDC",
"p@ c #DADADA",
"q@ c #D8D8D8",
"r@ c #D7D7D7",
"s@ c #D5D5D5",
"t@ c #D3D4D3",
"u@ c #D1D2D1",
"v@ c #D0D0D0",
"w@ c #CECECE",
"x@ c #CCCDCC",
"y@ c #CBCBCB",
"z@ c #C9C9C9",
"A@ c #C7C7C8",
"B@ c #C6C6C6",
"C@ c #C5C4C5",
"D@ c #C3C2C2",
"E@ c #C1C1C1",
"F@ c #BFC0C0",
"G@ c #BEBEBD",
"H@ c #BDBCBC",
"I@ c #BBBBBA",
"J@ c #B9B9B9",
"K@ c #B8B7B8",
"L@ c #B6B5B6",
"M@ c #B4B5B4",
"N@ c #B2B2B2",
"O@ c #B1B1B1",
"P@ c #AFAFAF",
"Q@ c #AEAEAE",
"R@ c #ADADAC",
"S@ c #AAABAA",
"T@ c #A9A9A9",
"U@ c #A7A7A7",
"V@ c #A6A6A5",
"W@ c #A4A4A4",
"X@ c #A1A1A1",
"Y@ c #9F9F9F",
"Z@ c #9E9E9E",
"`@ c #9C9C9C",
" # c #9A9A9A",
".# c #989998",
"+# c #989798",
"@# c #969695",
"## c #929293",
"$# c #919191",
"%# c #8B8F8C",
"&# c #888E89",
"*# c #858D86",
"=# c #828C82",
"-# c #7F8C80",
";# c #7B8B7D",
"># c #788A7A",
",# c #758976",
"'# c #718973",
")# c #6E8870",
"!# c #6A886D",
"~# c #68866A",
"{# c #648667",
"]# c #618564",
"^# c #5D8560",
"/# c #5B845E",
"(# c #57845A",
"_# c #548357",
":# c #508254",
"<# c #4E8152",
"[# c #4B814F",
"}# c #49804C",
"|# c #467F4A",
"1# c #438047",
"2# c #407F44",
"3# c #3D7E42",
"4# c #3A7D40",
"5# c #387D3C",
"6# c #357C3A",
"7# c #327C37",
"8# c #2F7B35",
"9# c #2C7B32",
"0# c #297A2F",
"a# c #27792D",
"b# c #24792B",
"c# c #217828",
"d# c #1E7826",
"e# c #1B7722",
"f# c #197620",
"g# c #17771D",
"h# c #1A791E",
"i# c #1C7A1E",
"j# c #1E7B1F",
"k# c #217D1F",
"l# c #247E20",
"m# c #268020",
"n# c #298121",
"o# c #2B8221",
"p# c #2E8422",
"q# c #338723",
"r# c #368823",
"s# c #388A24",
"t# c #3A8B24",
"u# c #3D8D25",
"v# c #408E25",
"w# c #429026",
"x# c #459126",
"y# c #479226",
"z# c #4A9427",
"A# c #4C9527",
"B# c #4F9729",
"C# c #519928",
"D# c #549A2A",
"E# c #579C2A",
"F# c #599C2A",
"G# c #5B9E2B",
"H# c #5E9F2C",
"I# c #61A12C",
"J# c #62A32D",
"K# c #65A42D",
"L# c #68A62D",
"M# c #6AA72E",
"N# c #6DA92F",
"O# c #70AA2F",
"P# c #72AC30",
"Q# c #75AD30",
"R# c #77AE31",
"S# c #7AB032",
"T# c #7CB132",
"U# c #82B432",
"V# c #84B533",
"W# c #86B634",
"X# c #89B834",
"Y# c #95C036",
"Z# c #AECE3C",
"`# c #C6DB41",
" $ c #DFEA46",
".$ c #F7F84A",
"+$ c #F4F45C",
"@$ c #E7E772",
"#$ c #D8DA87",
"$$ c #C9CE9D",
"%$ c #C1C8A8",
"&$ c #BFC5AB",
"*$ c #BCC4AF",
"=$ c #BAC1B4",
"-$ c #B7BFB7",
";$ c #B5BDBB",
">$ c #B2BABE",
",$ c #AFB8C2",
"'$ c #AEB6C6",
")$ c #ABB4C9",
"!$ c #A9B2CD",
"~$ c #A6B0D1",
"{$ c #A3ADD5",
"]$ c #A0ACD8",
"^$ c #9EAADC",
"/$ c #9CA8E0",
"($ c #99A5E4",
"_$ c #97A2E8",
":$ c #95A0EB",
"<$ c #929EF0",
"[$ c #8F9CF3",
"}$ c #8C9BF7",
"|$ c #8A98FA",
"1$ c #8896FF",
"2$ c #8493FD",
"3$ c #8190FA",
"4$ c #7E8CF8",
"5$ c #7B8AF5",
"6$ c #7787F3",
"7$ c #7483F0",
"8$ c #7181ED",
"9$ c #6D7DEB",
"0$ c #6A7AE8",
"a$ c #6678E5",
"b$ c #6374E2",
"c$ c #6071DF",
"d$ c #5C6EDD",
"e$ c #5A6BDB",
"f$ c #5667D8",
"g$ c #5365D6",
"h$ c #5062D2",
"i$ c #4D5ED0",
"j$ c #495CCD",
"k$ c #4558CB",
"l$ c #4457C9",
"m$ c #4456C8",
"n$ c #4355C8",
"o$ c #4154C8",
"p$ c #4054C7",
"q$ c #4053C7",
"r$ c #3F53C5",
"s$ c #3F52C6",
"t$ c #3C50C3",
"u$ c #3D50C3",
"v$ c #3B4FC2",
"w$ c #3A4DC2",
"x$ c #394CC1",
"y$ c #394DC0",
"z$ c #374ABF",
"A$ c #374ABE",
"B$ c #3649BE",
"C$ c #3447BD",
"D$ c #3447BC",
"E$ c #3347BB",
"F$ c #3146BA",
"G$ c #3145B9",
"H$ c #2F44B9",
"I$ c #3043B8",
"J$ c #2E43B8",
"K$ c #2D42B8",
"L$ c #2A3FB4",
"M$ c #293FB4",
"N$ c #293EB4",
"O$ c #293EB3",
"P$ c #283CB3",
"Q$ c #273BB1",
"R$ c #253AB0",
"S$ c #243AB0",
"T$ c #2438B0",
"U$ c #2339B0",
"V$ c #2238AF",
"W$ c #2237AE",
"X$ c #2236AE",
"Y$ c #2036AC",
"Z$ c #2034AC",
"`$ c #1F33AB",
" % c #1C32AA",
".% c #1C32A9",
"+% c #1B31A9",
"@% c #FEFFFE",
"#% c #FBFBFB",
"$% c #F9F9F9",
"%% c #F8F7F7",
"&% c #F6F6F5",
"*% c #F3F3F2",
"=% c #F1F0F1",
"-% c #EDEEED",
";% c #E7E7E6",
">% c #E4E4E3",
",% c #E1E2E1",
"'% c #E0E0E0",
")% c #DEDFDE",
"!% c #DCDDDD",
"~% c #DBDBDB",
"{% c #DAD9DA",
"]% c #D7D7D8",
"^% c #D6D6D5",
"/% c #D5D4D4",
"(% c #D3D2D2",
"_% c #D1D1D1",
":% c #CDCDCD",
"<% c #CBCCCC",
"[% c #C8C9C8",
"}% c #C4C4C4",
"|% c #C1C2C2",
"1% c #C0C0C0",
"2% c #BEBDBD",
"3% c #BABAB9",
"4% c #B7B7B7",
"5% c #B5B5B5",
"6% c #B3B4B3",
"7% c #AAAAAA",
"8% c #A8A8A9",
"9% c #A6A6A6",
"0% c #A4A3A4",
"a% c #A2A2A2",
"b% c #9F9F9E",
"c% c #9B9B9B",
"d% c #989898",
"e% c #959495",
"f% c #939394",
"g% c #919291",
"h% c #8F9090",
"i% c #8D8F8E",
"j% c #888D87",
"k% c #848C84",
"l% c #808B81",
"m% c #7D8C7E",
"n% c #7A8A7B",
"o% c #778978",
"p% c #708872",
"q% c #6D886F",
"r% c #69876C",
"s% c #668668",
"t% c #638666",
"u% c #5F8563",
"v% c #5C845F",
"w% c #59835C",
"x% c #568359",
"y% c #528256",
"z% c #508253",
"A% c #4A814E",
"B% c #447F49",
"C% c #3F7E43",
"D% c #367D3C",
"E% c #2B7A31",
"F% c #227929",
"G% c #207826",
"H% c #1C7723",
"I% c #18761F",
"J% c #16761C",
"K% c #19771D",
"L% c #1B791D",
"M% c #1E7B1E",
"N% c #207C1F",
"O% c #237E1F",
"P% c #257F1F",
"Q% c #278121",
"R% c #2A8220",
"S% c #2D8322",
"T% c #2F8522",
"U% c #318623",
"V% c #348722",
"W% c #398B24",
"X% c #439126",
"Y% c #469227",
"Z% c #489427",
"`% c #4B9427",
" & c #4E9628",
".& c #4F9828",
"+& c #5C9F2B",
"@& c #5FA02B",
"#& c #62A22C",
"$& c #64A32D",
"%& c #66A52D",
"&& c #69A62D",
"*& c #6CA72E",
"=& c #6FA92F",
"-& c #71AB30",
";& c #73AC30",
">& c #75AE30",
",& c #7AB131",
"'& c #7EB131",
")& c #82B532",
"!& c #87B834",
"~& c #A1C639",
"{& c #BAD43E",
"]& c #D2E243",
"^& c #EAF148",
"/& c #FDFA50",
"(& c #EEED65",
"_& c #E0E17C",
":& c #D1D492",
"<& c #C3C9A6",
"[& c #BDC4AD",
"}& c #BBC2B1",
"|& c #B9C0B4",
"1& c #B4BCBD",
"2& c #AFB7C4",
"3& c #ACB5C8",
"4& c #AAB3CC",
"5& c #A4AFD2",
"6& c #A2ADD6",
"7& c #A0ABDA",
"8& c #9DA9DE",
"9& c #9AA6E2",
"0& c #96A2E9",
"a& c #939FED",
"b& c #909EF1",
"c& c #8B99F8",
"d& c #8997FC",
"e& c #8391FC",
"f& c #7988F4",
"g& c #7585F1",
"h& c #7283EF",
"i& c #6C7CE9",
"j& c #6979E7",
"k& c #6272E2",
"l& c #5F6FDE",
"m& c #586AD9",
"n& c #5467D6",
"o& c #4F61D1",
"p& c #485ACC",
"q& c #4355C9",
"r& c #4355C7",
"s& c #4255C7",
"t& c #3F53C6",
"u& c #4052C6",
"v& c #3D51C4",
"w& c #3B4EC1",
"x& c #394BC0",
"y& c #374CC0",
"z& c #384BBF",
"A& c #3346BC",
"B& c #3246BA",
"C& c #2F42B8",
"D& c #2F42B7",
"E& c #2B41B6",
"F& c #2B40B6",
"G& c #2B3EB5",
"H& c #283DB4",
"I& c #293CB4",
"J& c #273CB3",
"K& c #263AB1",
"L& c #2439AF",
"M& c #2438AF",
"N& c #2338B0",
"O& c #2236AD",
"P& c #2135AD",
"Q& c #1F35AC",
"R& c #1C31A9",
"S& c #FDFEFD",
"T& c #FCFCFC",
"U& c #F8F8F8",
"V& c #F7F6F7",
"W& c #F5F5F5",
"X& c #F4F4F3",
"Y& c #EFEEEF",
"Z& c #EDECEC",
"`& c #E9EAE9",
" * c #E4E5E4",
".* c #E3E3E3",
"+* c #E1E1E1",
"@* c #DFDFE0",
"#* c #DDDEDD",
"$* c #DCDCDC",
"%* c #D9D8D9",
"&* c #D7D7D6",
"** c #D5D5D6",
"=* c #D3D3D4",
"-* c #D1D2D2",
";* c #CDCDCC",
">* c #C9CAC9",
",* c #C8C7C8",
"'* c #C6C7C6",
")* c #C4C4C5",
"!* c #C2C2C1",
"~* c #BFBFBF",
"{* c #BEBEBE",
"]* c #BDBDBC",
"^* c #BBBABB",
"/* c #B9B9BA",
"(* c #B7B7B8",
"_* c #B6B6B6",
":* c #AFB0B0",
"<* c #ACACAD",
"[* c #A4A4A5",
"}* c #A2A3A3",
"|* c #A09F9F",
"1* c #9B9A9A",
"2* c #999999",
"3* c #979797",
"4* c #969595",
"5* c #939293",
"6* c #909191",
"7* c #8F8F8F",
"8* c #8C8F8C",
"9* c #898D89",
"0* c #868D86",
"a* c #838C83",
"b* c #7F8B80",
"c* c #758A76",
"d* c #718873",
"e* c #6B876E",
"f* c #68876B",
"g* c #5D8561",
"h* c #538258",
"i* c #4E8252",
"j* c #4C814F",
"k* c #48804D",
"l* c #46804A",
"m* c #437F47",
"n* c #407F45",
"o* c #3B7E3F",
"p* c #377D3C",
"q* c #357D3A",
"r* c #2F7C35",
"s* c #2C7A33",
"t* c #297A30",
"u* c #1E7825",
"v* c #1A781E",
"w* c #1E7C1E",
"x* c #217C1F",
"y* c #288120",
"z* c #2B8321",
"A* c #2E8421",
"B* c #338722",
"C* c #358823",
"D* c #388924",
"E* c #3C8D25",
"F* c #4C9627",
"G* c #4E9728",
"H* c #539A29",
"I* c #569B2A",
"J* c #599D2A",
"K* c #5B9E2A",
"L* c #5EA02B",
"M* c #60A12C",
"N* c #68A52D",
"O* c #6DA82E",
"P* c #6FAA2F",
"Q* c #72AB30",
"R* c #75AC30",
"S* c #7CB131",
"T* c #81B433",
"U* c #84B633",
"V* c #86B733",
"W* c #94BF36",
"X* c #ACCD3C",
"Y* c #C5DB40",
"Z* c #DEE945",
"`* c #F6F74A",
" = c #F6F45A",
".= c #E7E870",
"+= c #D8DB86",
"@= c #C9CF9B",
"#= c #C2C8A8",
"$= c #BFC6AB",
"%= c #BDC3AF",
"&= c #BAC1B3",
"*= c #B8BFB7",
"== c #B2BABF",
"-= c #B0B9C2",
";= c #ABB4CA",
">= c #A8B2CD",
",= c #A6B0D0",
"'= c #A4AED4",
")= c #A1ACD9",
"!= c #9FA9DC",
"~= c #97A3E7",
"{= c #94A1EB",
"]= c #919FEF",
"^= c #909DF2",
"/= c #8C9AF7",
"(= c #8A99FA",
"_= c #8897FE",
":= c #8594FD",
"<= c #8290FB",
"[= c #7E8DF8",
"}= c #7484F0",
"|= c #6E7DEA",
"1= c #6778E5",
"2= c #6071E0",
"3= c #5D6EDE",
"4= c #5768D8",
"5= c #5365D5",
"6= c #5062D3",
"7= c #4A5BCD",
"8= c #3C4FC4",
"9= c #3C4EC2",
"0= c #3A4EC2",
"a= c #374BBE",
"b= c #3348BC",
"c= c #3247BB",
"d= c #3145BB",
"e= c #3146BB",
"f= c #3245BB",
"g= c #3045B9",
"h= c #2D41B6",
"i= c #293EB5",
"j= c #2539B1",
"k= c #2237AF",
"l= c #2036AD",
"m= c #1D33AB",
"n= c #1C30A9",
"o= c #F7F8F8",
"p= c #F6F6F6",
"q= c #F4F5F4",
"r= c #F2F3F2",
"s= c #F1F1F1",
"t= c #EFF0F0",
"u= c #EBECEC",
"v= c #E8E9E8",
"w= c #E3E4E3",
"x= c #E2E2E2",
"y= c #DFDFDE",
"z= c #DDDCDD",
"A= c #D6D6D6",
"B= c #D2D3D2",
"C= c #CFCFD0",
"D= c #CDCECE",
"E= c #C9C8C9",
"F= c #C5C5C5",
"G= c #C1C0C1",
"H= c #BCBCBB",
"I= c #B9B8B8",
"J= c #B5B6B5",
"K= c #B4B4B3",
"L= c #B0B1B0",
"M= c #ACACAC",
"N= c #A6A6A7",
"O= c #A1A2A2",
"P= c #A0A1A0",
"Q= c #9E9E9F",
"R= c #9D9C9D",
"S= c #9C9B9C",
"T= c #949595",
"U= c #929191",
"V= c #909090",
"W= c #8E8F8E",
"X= c #8A8E8A",
"Y= c #878E88",
"Z= c #848D85",
"`= c #778A78",
" - c #748975",
".- c #708972",
"+- c #668669",
"@- c #638665",
"#- c #608562",
"$- c #5C8460",
"%- c #59845C",
"&- c #4D8151",
"*- c #47804C",
"=- c #427F47",
"-- c #3E7E43",
";- c #3C7E41",
">- c #3A7D3E",
",- c #367D3B",
"'- c #347D39",
")- c #307B36",
"!- c #2E7B34",
"~- c #2B7A32",
"{- c #29792F",
"]- c #23782A",
"^- c #207827",
"/- c #1B7621",
"(- c #17771E",
"_- c #16771C",
":- c #18771D",
"<- c #1D7B1E",
"[- c #237D1F",
"}- c #278020",
"|- c #2C8321",
"1- c #318622",
"2- c #378923",
"3- c #3B8C25",
"4- c #3E8D24",
"5- c #469226",
"6- c #489327",
"7- c #4F9829",
"8- c #529929",
"9- c #579B2A",
"0- c #5A9D2A",
"a- c #62A12C",
"b- c #64A42C",
"c- c #69A62E",
"d- c #6CA82E",
"e- c #79AE30",
"f- c #7BB031",
"g- c #7EB132",
"h- c #80B332",
"i- c #83B533",
"j- c #89B935",
"k- c #9FC639",
"l- c #B8D33E",
"m- c #D1E143",
"n- c #E9F047",
"o- c #FEFB4E",
"p- c #EFEE65",
"q- c #E0E27A",
"r- c #D2D590",
"s- c #C3C8A6",
"t- c #C1C7AA",
"u- c #BEC5AD",
"v- c #BBC2B0",
"w- c #B9C0B5",
"x- c #B4BCBC",
"y- c #B2BAC0",
"z- c #AFB8C4",
"A- c #ACB6C7",
"B- c #AAB4CB",
"C- c #A5AFD3",
"D- c #9FABDB",
"E- c #9DA8DE",
"F- c #9BA7E2",
"G- c #98A4E5",
"H- c #8E9CF4",
"I- c #8C9AF8",
"J- c #8998FC",
"K- c #8695FF",
"L- c #8392FC",
"M- c #808FF9",
"N- c #7D8BF7",
"O- c #7685F2",
"P- c #6273E1",
"Q- c #5E70DF",
"R- c #5C6CDD",
"S- c #5969D9",
"T- c #5566D7",
"U- c #5264D4",
"V- c #4E61D2",
"W- c #4357C9",
"X- c #4153C7",
"Y- c #384DC1",
"Z- c #3449BD",
"`- c #3045BA",
" ; c #2C41B7",
".; c #283EB4",
"+; c #283BB2",
"@; c #263AB0",
"#; c #2339AF",
"$; c #FCFBFC",
"%; c #F9F8F8",
"&; c #F7F7F7",
"*; c #EDEDED",
"=; c #E9EAEA",
"-; c #E3E3E2",
";; c #DEDDDE",
">; c #DBDCDB",
",; c #DADBDA",
"'; c #D8D9D8",
"); c #D6D7D6",
"!; c #D4D4D3",
"~; c #D2D2D1",
"{; c #D0D1D1",
"]; c #CECFCF",
"^; c #C8C8C8",
"/; c #C5C4C4",
"(; c #BEBFBE",
"_; c #BABBBB",
":; c #B9BAB9",
"<; c #B4B4B5",
"[; c #B3B2B3",
"}; c #B2B1B1",
"|; c #B0AFAF",
"1; c #AAABAB",
"2; c #9F9FA0",
"3; c #969696",
"4; c #949594",
"5; c #929393",
"6; c #90908F",
"7; c #8C8E8C",
"8; c #868D87",
"9; c #828C84",
"0; c #7C8B7D",
"a; c #798B7A",
"b; c #758A77",
"c; c #728974",
"d; c #6F8871",
"e; c #67876A",
"f; c #618664",
"g; c #5E8561",
"h; c #5A855E",
"i; c #58835B",
"j; c #548358",
"k; c #518255",
"l; c #4B8150",
"m; c #49804D",
"n; c #45804A",
"o; c #3D7E43",
"p; c #3A7E40",
"q; c #387D3D",
"r; c #327C38",
"s; c #2D7A33",
"t; c #2A7A30",
"u; c #24792A",
"v; c #217928",
"w; c #1C7722",
"x; c #197721",
"y; c #16761E",
"z; c #17771C",
"A; c #19781D",
"B; c #267F20",
"C; c #298120",
"D; c #308622",
"E; c #378A24",
"F; c #3D8D24",
"G; c #408D25",
"H; c #428F25",
"I; c #479227",
"J; c #519829",
"K; c #589D2A",
"L; c #5E9F2B",
"M; c #62A32C",
"N; c #65A32D",
"O; c #77AE30",
"P; c #79B031",
"Q; c #7BB131",
"R; c #81B332",
"S; c #86B633",
"T; c #88B834",
"U; c #93BD36",
"V; c #ABCC3B",
"W; c #C3DA40",
"X; c #DCE845",
"Y; c #F5F64A",
"Z; c #F7F559",
"`; c #E8E86F",
" > c #D9DC84",
".> c #CAD09B",
"+> c #B7BFB6",
"@> c #B5BDBA",
"#> c #ADB7C5",
"$> c #ACB5CA",
"%> c #A9B2CC",
"&> c #A4AED5",
"*> c #A1ABD8",
"=> c #9EA9DC",
"-> c #9CA7E0",
";> c #95A1EB",
">> c #929EEF",
",> c #8F9CF2",
"'> c #8D9AF6",
")> c #8B99FA",
"!> c #8796FE",
"~> c #8190FB",
"{> c #7F8EF8",
"]> c #7887F3",
"^> c #7181EE",
"/> c #6E7EEB",
"(> c #6877E6",
"_> c #6474E3",
":> c #6172E1",
"<> c #5E6EDD",
"[> c #5668D8",
"}> c #5465D5",
"|> c #4C5FD0",
"1> c #495CCE",
"2> c #4659CB",
"3> c #3C4EC3",
"4> c #3247BC",
"5> c #3245BA",
"6> c #253BB1",
"7> c #2338AE",
"8> c #2137AD",
"9> c #1E32AB",
"0> c #F5F5F4",
"a> c #F3F2F2",
"b> c #ECECEC",
"c> c #E6E5E5",
"d> c #E4E3E3",
"e> c #E2E1E2",
"f> c #DDDDDD",
"g> c #D9DADA",
"h> c #D5D5D4",
"i> c #D3D2D3",
"j> c #D1D1D2",
"k> c #D0D0CF",
"l> c #CACBCA",
"m> c #BDBDBE",
"n> c #BCBBBC",
"o> c #B8B8B9",
"p> c #B7B6B7",
"q> c #B4B3B3",
"r> c #B1B1B0",
"s> c #AFAFAE",
"t> c #ADADAE",
"u> c #ABACAC",
"v> c #A4A3A3",
"w> c #A1A0A1",
"x> c #9C9B9B",
"y> c #969797",
"z> c #959595",
"A> c #919192",
"B> c #8B8E8B",
"C> c #878D88",
"D> c #818C82",
"E> c #7D8B7F",
"F> c #7B8B7C",
"G> c #748A75",
"H> c #6A876C",
"I> c #668769",
"J> c #608563",
"K> c #4A814F",
"L> c #47814B",
"M> c #458049",
"N> c #427F46",
"O> c #317C37",
"P> c #26792D",
"Q> c #207926",
"R> c #1D7824",
"S> c #1A7722",
"T> c #18781D",
"U> c #1F7B1F",
"V> c #227D1F",
"W> c #2A8121",
"X> c #2D8321",
"Y> c #2F8521",
"Z> c #318523",
"`> c #348723",
" , c #368924",
"., c #3B8B24",
"+, c #418F26",
"@, c #4B9428",
"#, c #559B2A",
"$, c #63A32C",
"%, c #66A42D",
"&, c #6BA72F",
"*, c #6EA92F",
"=, c #73AB30",
"-, c #78AF31",
";, c #7AB031",
">, c #7DB231",
",, c #7FB333",
"', c #9EC538",
"), c #B6D33D",
"!, c #CFE142",
"~, c #E7EF48",
"{, c #FFFB4D",
"], c #F0EF63",
"^, c #E1E279",
"/, c #D2D68F",
"(, c #C4C9A4",
"_, c #C0C6A9",
":, c #BEC4AD",
"<, c #B9C1B4",
"[, c #B7BEB8",
"}, c #B2B9C0",
"|, c #AFB7C3",
"1, c #AAB3CB",
"2, c #A8B1CF",
"3, c #A5B0D3",
"4, c #9BA6E1",
"5, c #99A4E5",
"6, c #95A2E9",
"7, c #93A0ED",
"8, c #919EF0",
"9, c #8795FF",
"0, c #8492FC",
"a, c #7D8CF7",
"b, c #7A89F4",
"c, c #7786F2",
"d, c #7080EC",
"e, c #6D7DE9",
"f, c #6677E4",
"g, c #6273E2",
"h, c #5F70DF",
"i, c #5C6DDC",
"j, c #596ADA",
"k, c #4E60D2",
"l, c #4B5ECF",
"m, c #485ACD",
"n, c #4153C6",
"o, c #4053C5",
"p, c #3F52C4",
"q, c #3D51C5",
"r, c #000000",
"s, c #CC0000",
"t, c #003366",
"u, c #6699CC",
"v, c #FF3366",
"w, c #666666",
"x, c #FEFEFD",
"y, c #F0F0F1",
"z, c #ECEDED",
"A, c #EAE9E9",
"B, c #E4E5E5",
"C, c #DDDEDE",
"D, c #D4D3D4",
"E, c #D2D2D2",
"F, c #D0D0D1",
"G, c #CFCECE",
"H, c #CBCCCB",
"I, c #CAC9CA",
"J, c #C4C5C5",
"K, c #B2B3B3",
"L, c #B0B0AF",
"M, c #ADACAD",
"N, c #A7A8A8",
"O, c #A3A3A2",
"P, c #A1A2A1",
"Q, c #9A9A9B",
"R, c #959494",
"S, c #939392",
"T, c #908F8F",
"U, c #8C8F8D",
"V, c #6C886E",
"W, c #68876A",
"X, c #658667",
"Y, c #5B855E",
"Z, c #49814D",
"`, c #438048",
" ' c #417E45",
".' c #3B7D40",
"+' c #357C3B",
"@' c #2F7B36",
"#' c #2A7B30",
"$' c #287A2D",
"%' c #197720",
"&' c #17761E",
"*' c #1A781D",
"=' c #2E8322",
"-' c #328722",
";' c #3F8E25",
">' c #419025",
",' c #449127",
"'' c #499327",
")' c #4C9528",
"!' c #509828",
"~' c #549A29",
"{' c #569B29",
"]' c #68A52E",
"^' c #6DA82F",
"/' c #7CB032",
"(' c #80B433",
"_' c #91BD36",
":' c #A9CB3B",
"<' c #C2D940",
"[' c #DBE745",
"}' c #F3F54A",
"|' c #F7F558",
"1' c #E9E96D",
"2' c #DADD83",
"3' c #CBD099",
"4' c #C2C8A7",
"5' c #C0C6AB",
"6' c #BDC4AE",
"7' c #BAC1B2",
"8' c #B8BFB6",
"9' c #B3BBBE",
"0' c #B1B9C1",
"a' c #AEB6C5",
"b' c #ACB4C9",
"c' c #A9B3CD",
"d' c #A1ACD8",
"e' c #9CA7DF",
"f' c #929FEE",
"g' c #8D9BF6",
"h' c #8B98F9",
"i' c #8593FE",
"j' c #7B8AF6",
"k' c #6B7BE9",
"l' c #6778E6",
"m' c #6475E3",
"n' c #6172E0",
"o' c #5E6FDD",
"p' c #5769D9",
"q' c #5465D6",
"r' c #5163D3",
"s' c #4D5FD1",
"t' c #4A5CCE",
"u' c #4759CB",
"v' c #4557CB",
"w' c #4456CA",
"x' c #4457C8",
"y' c #4256C8",
"z' c #3F51C5",
"A' c #3C50C2",
"B' c #3B4DC1",
"C' c #FF9999",
"D' c #336699",
"E' c #1B30A9",
"F' c #FAF9FA",
"G' c #F7F7F8",
"H' c #F7F6F6",
"I' c #EAEBEA",
"J' c #E1E1E0",
"K' c #DFDEDE",
"L' c #D9D9DA",
"M' c #D7D6D7",
"N' c #CDCCCC",
"O' c #C8C9C9",
"P' c #C5C6C5",
"Q' c #C3C3C4",
"R' c #C2C3C2",
"S' c #BCBCBC",
"T' c #B6B5B5",
"U' c #B2B2B3",
"V' c #AEAFAF",
"W' c #AEAEAD",
"X' c #ACACAB",
"Y' c #A8A9A8",
"Z' c #A6A5A5",
"`' c #9F9E9F",
" ) c #9B9B9C",
".) c #9A9A99",
"+) c #999898",
"@) c #979796",
"#) c #949394",
"$) c #929292",
"%) c #909190",
"&) c #8F8F8E",
"*) c #888E88",
"=) c #848C85",
"-) c #7E8B7F",
";) c #778A79",
">) c #748A76",
",) c #6D876F",
"') c #59835D",
")) c #558459",
"!) c #538256",
"~) c #48804B",
"{) c #448049",
"]) c #3F7F44",
"^) c #3A7E3E",
"/) c #347C39",
"() c #317B36",
"_) c #2B7B32",
":) c #287A2F",
"<) c #23792A",
"[) c #217927",
"}) c #1D7825",
"|) c #18771F",
"1) c #1D7A1E",
"2) c #1F7C1F",
"3) c #298221",
"4) c #348822",
"5) c #3B8C24",
"6) c #459226",
"7) c #489326",
"8) c #4F9728",
"9) c #549B2A",
"0) c #5C9E2B",
"a) c #63A32D",
"b) c #68A62E",
"c) c #6DA92E",
"d) c #76AD30",
"e) c #7DB132",
"f) c #7FB332",
"g) c #82B433",
"h) c #8AB834",
"i) c #9CC338",
"j) c #B5D13D",
"k) c #CEE042",
"l) c #E6EE47",
"m) c #FEFC4C",
"n) c #F0F061",
"o) c #E2E377",
"p) c #D3D78D",
"q) c #C4CAA4",
"r) c #C1C7A9",
"s) c #BFC5AD",
"t) c #BCC3B0",
"u) c #AFB8C3",
"v) c #ADB6C7",
"w) c #A8B2CF",
"x) c #A6AFD2",
"y) c #A3ADD6",
"z) c #96A3E9",
"A) c #94A1ED",
"B) c #8C99F8",
"C) c #8998FB",
"D) c #8696FF",
"E) c #8393FC",
"F) c #7989F4",
"G) c #7686F2",
"H) c #7383EF",
"I) c #7080ED",
"J) c #6C7DEA",
"K) c #6373E1",
"L) c #5667D7",
"M) c #5264D5",
"N) c #4F60D2",
"O) c #4C5ECF",
"P) c #4458CA",
"Q) c #3B4FC1",
"R) c #FFCCCC",
"S) c #1C30A8",
"T) c #1B30A8",
"U) c #1A31A8",
"V) c #FAFBFA",
"W) c #F9F8F9",
"X) c #F3F3F4",
"Y) c #F1F0F0",
"Z) c #EFEEEE",
"`) c #E7E8E8",
" ! c #E7E6E6",
".! c #E5E5E4",
"+! c #DFE0DF",
"@! c #DEDEDE",
"#! c #D9D9D8",
"$! c #D8D7D7",
"%! c #D2D3D3",
"&! c #CCCBCB",
"*! c #CACAC9",
"=! c #C5C5C4",
"-! c #C0C0BF",
";! c #BCBDBC",
">! c #B9BABA",
",! c #B5B4B5",
"'! c #ACADAD",
")! c #9D9D9C",
"!! c #9B9B9A",
"~! c #8D8F8C",
"{! c #898E8A",
"]! c #838D84",
"^! c #808C80",
"/! c #7C8B7E",
"(! c #798A7A",
"_! c #768A77",
":! c #6F8870",
"<! c #69876A",
"[! c #628565",
"}! c #5F8561",
"|! c #57845B",
"1! c #437F48",
"2! c #3E7E42",
"3! c #387D3E",
"4! c #337C38",
"5! c #307C35",
"6! c #2A7A31",
"7! c #277A2E",
"8! c #25792B",
"9! c #227928",
"0! c #1F7825",
"a! c #288021",
"b! c #2A8321",
"c! c #2D8421",
"d! c #328622",
"e! c #3A8B25",
"f! c #3C8C24",
"g! c #3E8E25",
"h! c #449126",
"i! c #4E9629",
"j! c #519828",
"k! c #5DA02B",
"l! c #60A02C",
"m! c #63A22D",
"n! c #67A52D",
"o! c #6AA62E",
"p! c #71AB2F",
"q! c #7FB232",
"r! c #81B432",
"s! c #90BD36",
"t! c #A8CA3B",
"u! c #C1D83F",
"v! c #D9E645",
"w! c #F1F54A",
"x! c #F9F657",
"y! c #E9EA6C",
"z! c #DBDD82",
"A! c #CDD198",
"B! c #C0C5AB",
"C! c #B6BEBA",
"D! c #B3BBBD",
"E! c #ABB4C8",
"F! c #A6B1D0",
"G! c #A1ACD7",
"H! c #939FEF",
"I! c #8F9DF2",
"J! c #8B99F9",
"K! c #8897FD",
"L! c #8593FD",
"M! c #8291FB",
"N! c #7F8DF9",
"O! c #7B8BF6",
"P! c #7584F0",
"Q! c #6E7FEB",
"R! c #6B7BE8",
"S! c #6878E6",
"T! c #6575E4",
"U! c #5769D8",
"V! c #5466D6",
"W! c #5162D3",
"X! c #4D60D1",
"Y! c #4A5DCE",
"Z! c #4659CC",
"`! c #4657CA",
" ~ c #3E52C6",
".~ c #1A30A8",
"+~ c #FBFBFC",
"@~ c #F3F3F3",
"#~ c #F1F2F1",
"$~ c #E5E5E6",
"%~ c #E3E3E4",
"&~ c #E0E0E1",
"*~ c #D7D6D6",
"=~ c #D2D1D1",
"-~ c #D0CFD0",
";~ c #CCCCCD",
">~ c #C9C9C8",
",~ c #C7C8C7",
"'~ c #C5C6C6",
")~ c #C2C2C3",
"!~ c #BDBEBD",
"~~ c #B8B9B9",
"{~ c #B8B7B7",
"]~ c #B4B3B4",
"^~ c #B1B0B0",
"/~ c #ADAEAE",
"(~ c #ABAAAA",
"_~ c #A9A8A9",
":~ c #A0A1A1",
"<~ c #9F9E9E",
"[~ c #9D9D9E",
"}~ c #989899",
"|~ c #959695",
"1~ c #919090",
"2~ c #8B8F8B",
"3~ c #888D88",
"4~ c #858D85",
"5~ c #748976",
"6~ c #6A886C",
"7~ c #5D8460",
"8~ c #5A845D",
"9~ c #56835A",
"0~ c #538257",
"a~ c #4D8152",
"b~ c #3D7E41",
"c~ c #3A7D3F",
"d~ c #317B37",
"e~ c #2F7B34",
"f~ c #2C7A32",
"g~ c #15761C",
"h~ c #247E1F",
"i~ c #2F8421",
"j~ c #408E26",
"k~ c #4A9527",
"l~ c #4D9528",
"m~ c #519929",
"n~ c #5EA02C",
"o~ c #66A42E",
"p~ c #6BA72E",
"q~ c #7DB131",
"r~ c #8AB934",
"s~ c #9BC238",
"t~ c #B3D03C",
"u~ c #CCDF41",
"v~ c #E5EC46",
"w~ c #FDFB4C",
"x~ c #F1F160",
"y~ c #E3E476",
"z~ c #D4D78D",
"A~ c #C6CAA2",
"B~ c #BEC5AC",
"C~ c #BCC2B0",
"D~ c #BAC0B4",
"E~ c #B7BFB8",
"F~ c #B4BDBB",
"G~ c #B0B8C4",
"H~ c #AAB4CA",
"I~ c #A8B1CE",
"J~ c #A5AFD2",
"K~ c #A0ABD9",
"L~ c #9EA9DD",
"M~ c #9BA6E2",
"N~ c #96A3E8",
"O~ c #93A0EC",
"P~ c #8E9CF3",
"Q~ c #8796FF",
"R~ c #7D8DF7",
"S~ c #6776E5",
"T~ c #5F71DF",
"U~ c #5D6DDC",
"V~ c #5364D4",
"W~ c #4F61D2",
"X~ c #4659CA",
"Y~ c #3E52C4",
"Z~ c #394EC1",
"`~ c #1B31A8",
" { c #FAFAFB",
".{ c #ECECEB",
"+{ c #E8E7E8",
"@{ c #E6E7E6",
"#{ c #E2E1E1",
"${ c #D4D4D4",
"%{ c #CFCECF",
"&{ c #C7C6C6",
"*{ c #C2C1C1",
"={ c #BDBCBD",
"-{ c #BBBBBC",
";{ c #B4B4B4",
">{ c #B1B2B2",
",{ c #AAA9A9",
"'{ c #A5A5A4",
"){ c #A09FA0",
"!{ c #989797",
"~{ c #8D8F8D",
"{{ c #878E87",
"]{ c #838D83",
"^{ c #7F8C81",
"/{ c #7A8B7A",
"({ c #758A78",
"_{ c #6B886E",
":{ c #658668",
"<{ c #57835B",
"[{ c #4F8253",
"}{ c #47804A",
"|{ c #448048",
"1{ c #417F45",
"2{ c #397D3D",
"3{ c #307B35",
"4{ c #27792E",
"5{ c #1D7723",
"6{ c #16771D",
"7{ c #1C791E",
"8{ c #207D1E",
"9{ c #237E20",
"0{ c #3C8D24",
"a{ c #469327",
"b{ c #4C9428",
"c{ c #589C2B",
"d{ c #5B9D2B",
"e{ c #72AA30",
"f{ c #74AC2F",
"g{ c #81B333",
"h{ c #85B733",
"i{ c #8EBB35",
"j{ c #A6CA3A",
"k{ c #BFD740",
"l{ c #D8E544",
"m{ c #F1F349",
"n{ c #F9F755",
"o{ c #EBEA6B",
"p{ c #DCDE81",
"q{ c #CDD197",
"r{ c #BFC6AA",
"s{ c #BBC1B2",
"t{ c #B8C0B6",
"u{ c #B6BDBA",
"v{ c #AFB7C5",
"w{ c #A7B0D0",
"x{ c #A2ACD8",
"y{ c #9FAADB",
"z{ c #9CA8DF",
"A{ c #97A3E6",
"B{ c #939FEE",
"C{ c #909DF1",
"D{ c #8896FD",
"E{ c #6E7EEC",
"F{ c #6B7CE8",
"G{ c #6272E0",
"H{ c #5A6CDB",
"I{ c #5869D8",
"J{ c #4D60D0",
"K{ c #3B4FC3",
"L{ c #F5F4F4",
"M{ c #F3F2F3",
"N{ c #EBEAEA",
"O{ c #E8E8E9",
"P{ c #E7E7E8",
"Q{ c #E6E5E6",
"R{ c #E4E4E4",
"S{ c #E1E0E0",
"T{ c #DBDCDC",
"U{ c #CDCCCD",
"V{ c #CBCBCA",
"W{ c #BFBFC0",
"X{ c #B9B8B9",
"Y{ c #B8B8B7",
"Z{ c #B5B6B6",
"`{ c #B1B0B1",
" ] c #ACABAC",
".] c #AAAAAB",
"+] c #A9A8A8",
"@] c #A5A6A6",
"#] c #A3A2A2",
"$] c #9D9E9D",
"%] c #979697",
"&] c #949493",
"*] c #8E8F8F",
"=] c #8B8E8C",
"-] c #858C86",
";] c #828D82",
">] c #7E8C7F",
",] c #7B8A7C",
"'] c #788A79",
")] c #718972",
"!] c #6E886F",
"~] c #6A876D",
"{] c #5A845C",
"]] c #538357",
"^] c #4D8251",
"/] c #407E44",
"(] c #377D3D",
"_] c #347C3A",
":] c #26792C",
"<] c #1E7725",
"[] c #19771F",
"}] c #15761D",
"|] c #1F7C1E",
"1] c #318522",
"2] c #388A23",
"3] c #408F25",
"4] c #459127",
"5] c #4C9628",
"6] c #529829",
"7] c #599C2B",
"8] c #5F9F2B",
"9] c #72AB2F",
"0] c #87B733",
"a] c #99C238",
"b] c #B2CF3D",
"c] c #CBDE41",
"d] c #E3ED47",
"e] c #FCFA4C",
"f] c #F2F15F",
"g] c #E4E575",
"h] c #D5D88B",
"i] c #C6CCA1",
"j] c #C2C7A8",
"k] c #BFC5AC",
"l] c #B1BABF",
"m] c #ADB6C6",
"n] c #AAB3CA",
"o] c #A7B1CE",
"p] c #9BA7E0",
"q] c #99A4E4",
"r] c #93A1EC",
"s] c #919EEF",
"t] c #8A98FB",
"u] c #808FFA",
"v] c #7D8CF8",
"w] c #7483EF",
"x] c #6D7DEA",
"y] c #6A7AE7",
"z] c #6373E2",
"A] c #6070E0",
"B] c #4F61D3",
"C] c #4C5ED0",
"D] c #495BCD",
"E] c #4254C8",
"F] c #3C50C4",
"G] c #1A2FA7",
"H] c #F5F6F5",
"I] c #E6E7E7",
"J] c #DBDADB",
"K] c #CDCECD",
"L] c #CCCBCC",
"M] c #C6C7C7",
"N] c #C1C2C1",
"O] c #BEBEBF",
"P] c #BCBBBB",
"Q] c #BAB9BA",
"R] c #B1B1B2",
"S] c #AAA9AA",
"T] c #A5A4A5",
"U] c #9E9F9E",
"V] c #9C9C9D",
"W] c #9A999A",
"X] c #8F8F90",
"Y] c #8D8E8D",
"Z] c #7F8B81",
"`] c #768977",
" ^ c #728A74",
".^ c #6F8971",
"+^ c #69876B",
"@^ c #58845B",
"#^ c #558358",
"$^ c #4F8252",
"%^ c #46804B",
"&^ c #307C36",
"*^ c #28792E",
"=^ c #227828",
"-^ c #1D7823",
";^ c #1B7A1E",
">^ c #1D7B1F",
",^ c #2F8422",
"'^ c #378A23",
")^ c #3D8C25",
"!^ c #4B9527",
"~^ c #509728",
"{^ c #579C2B",
"]^ c #5FA02C",
"^^ c #64A32C",
"/^ c #80B432",
"(^ c #83B433",
"_^ c #8DBB35",
":^ c #A5C83A",
"<^ c #BED73F",
"[^ c #D6E444",
"}^ c #EFF349",
"|^ c #FAF853",
"1^ c #EBEB69",
"2^ c #DDDF7F",
"3^ c #CED296",
"4^ c #BEC4AE",
"5^ c #B8BFB5",
"6^ c #B3BCBD",
"7^ c #AEB7C5",
"8^ c #98A3E7",
"9^ c #8D9BF5",
"0^ c #8594FE",
"a^ c #8391FB",
"b^ c #7182EE",
"c^ c #6B7CE9",
"d^ c #6575E3",
"e^ c #5B6CDB",
"f^ c #5162D4",
"g^ c #4A5CCF",
"h^ c #3E50C3",
"i^ c #000033",
"j^ c #F6F7F6",
"k^ c #F1F1F2",
"l^ c #EDECED",
"m^ c #E1E0E1",
"n^ c #DCDBDB",
"o^ c #DADAD9",
"p^ c #D6D7D7",
"q^ c #CECFCE",
"r^ c #C0BFBF",
"s^ c #B6B6B5",
"t^ c #A4A4A3",
"u^ c #A2A3A2",
"v^ c #9E9D9E",
"w^ c #989999",
"x^ c #959596",
"y^ c #939292",
"z^ c #888D89",
"A^ c #6B876D",
"B^ c #678769",
"C^ c #56845A",
"D^ c #518354",
"E^ c #4D8252",
"F^ c #48814C",
"G^ c #327B37",
"H^ c #2C7B31",
"I^ c #267A2D",
"J^ c #63A167",
"K^ c #C4DCC6",
"L^ c #F1F6F1",
"M^ c #FAFCFA",
"N^ c #E4EFE4",
"O^ c #9DC59E",
"P^ c #298128",
"Q^ c #579C4E",
"R^ c #CAE0C7",
"S^ c #F7FAF7",
"T^ c #EFF6EE",
"U^ c #ADCEA5",
"V^ c #408F2D",
"W^ c #6CA856",
"X^ c #D9E8D2",
"Y^ c #FBFCFA",
"Z^ c #E6F0E2",
"`^ c #91BE7B",
" / c #63A22C",
"./ c #A0C670",
"+/ c #DCEACA",
"@/ c #F7FAF2",
"#/ c #FCFDFA",
"$/ c #EFF5E6",
"%/ c #C8DEA6",
"&/ c #89B83C",
"*/ c #98C137",
"=/ c #C2D967",
"-/ c #F3F8D8",
";/ c #FEFEFB",
">/ c #FEFEE7",
",/ c #F7F79C",
"'/ c #C7CC9F",
")/ c #C2C7A9",
"!/ c #C3CAB9",
"~/ c #E8EAE5",
"{/ c #E5E7E9",
"]/ c #B6BFC8",
"^/ c #A3AED5",
"// c #9CA7E1",
"(/ c #99A5E5",
"_/ c #94A1EC",
":/ c #8F9DF3",
"</ c #8493FC",
"[/ c #7E8CF7",
"}/ c #7A8AF5",
"|/ c #7484EF",
"1/ c #6677E5",
"2/ c #596BDB",
"3/ c #4F62D2",
"4/ c #3D51C3",
"5/ c #384CC1",
"6/ c #1C31A8",
"7/ c #1A30A9",
"8/ c #1A2FA8",
"9/ c #E0DFE0",
"0/ c #D8D7D8",
"a/ c #D2D2D3",
"b/ c #C6C6C7",
"c/ c #C3C4C3",
"d/ c #C1C0C0",
"e/ c #BFBEBF",
"f/ c #BBBCBC",
"g/ c #B8B9B8",
"h/ c #B6B7B7",
"i/ c #A9AAAA",
"j/ c #A6A7A6",
"k/ c #A4A5A4",
"l/ c #9FA0A0",
"m/ c #989897",
"n/ c #979696",
"o/ c #929291",
"p/ c #8E8E8E",
"q/ c #7D8B7D",
"r/ c #798B7B",
"s/ c #768978",
"t/ c #738974",
"u/ c #68876C",
"v/ c #638565",
"w/ c #3B7E40",
"x/ c #2D7B33",
"y/ c #70A974",
"z/ c #ADCFAD",
"A/ c #237D20",
"B/ c #F4F8F3",
"C/ c #B0D1A8",
"D/ c #589D40",
"E/ c #F5F9F3",
"F/ c #61A22D",
"G/ c #6FA92E",
"H/ c #A6CA7C",
"I/ c #D2E4B4",
"J/ c #88B833",
"K/ c #8BB935",
"L/ c #AFCE52",
"M/ c #FBFCF5",
"N/ c #C2C8B3",
"O/ c #F7F8F6",
"P/ c #F2F3F5",
"Q/ c #AFB7CA",
"R/ c #A7B1D0",
"S/ c #A4AFD4",
"T/ c #A2ACD7",
"U/ c #97A4E6",
"V/ c #8E9BF5",
"W/ c #8996FC",
"X/ c #8694FE",
"Y/ c #7584F1",
"Z/ c #7281EE",
"`/ c #6F7EEC",
" ( c #6879E7",
".( c #6576E3",
"+( c #6272E1",
"@( c #5B6CDC",
"#( c #5566D6",
"$( c #4B5CCE",
"%( c #4559CB",
"&( c #F0F0EF",
"*( c #EEEFEE",
"=( c #E5E6E6",
"-( c #E2E2E3",
";( c #DDDDDE",
">( c #DCDBDC",
",( c #D8D8D9",
"'( c #CACBCB",
")( c #C9C9CA",
"!( c #C4C5C4",
"~( c #BCBCBD",
"{( c #A1A1A0",
"]( c #999998",
"^( c #969596",
"/( c #949393",
"(( c #919091",
"_( c #728973",
":( c #5A845E",
"<( c #57835A",
"[( c #48804C",
"}( c #3A7E3F",
"|( c #DCEADD",
"1( c #75AE7A",
"2( c #1F7B24",
"3( c #207C24",
"4( c #549B56",
"5( c #F1F6F0",
"6( c #CFE3CC",
"7( c #4E9642",
"8( c #3B8C2C",
"9( c #9CC594",
"0( c #EFF5ED",
"a( c #ADCEA0",
"b( c #D6E7CF",
"c( c #5D9F3D",
"d( c #61A141",
"e( c #DBE9D3",
"f( c #E9F2DF",
"g( c #B0D085",
"h( c #81B339",
"i( c #82B437",
"j( c #A1C666",
"k( c #97C037",
"l( c #DCE9AA",
"m( c #F8FAD6",
"n( c #F8F85E",
"o( c #F5F36F",
"p( c #F9F9E2",
"q( c #BFC6AC",
"r( c #DFE3DA",
"s( c #E8EBE8",
"t( c #BBC2C0",
"u( c #B8BFC4",
"v( c #E4E7EA",
"w( c #D1D6E1",
"x( c #A5B0D1",
"y( c #A1ABD9",
"z( c #94A0EB",
"A( c #7D8DF8",
"B( c #7886F2",
"C( c #7081ED",
"D( c #6D7EEA",
"E( c #6374E3",
"F( c #5D6DDD",
"G( c #5061D3",
"H( c #4255C9",
"I( c #F5F5F6",
"J( c #EEEEED",
"K( c #EBEBEC",
"L( c #E7E6E7",
"M( c #C8C8C9",
"N( c #C4C4C3",
"O( c #AFAEAE",
"P( c #ACABAB",
"Q( c #A9A9AA",
"R( c #A7A6A6",
"S( c #A3A3A4",
"T( c #959594",
"U( c #919292",
"V( c #838C84",
"W( c #49814E",
"X( c #417E46",
"Y( c #1A7621",
"Z( c #44914B",
"`( c #73AC75",
" _ c #D8E8D9",
"._ c #FEFEFE",
"+_ c #589C4D",
"@_ c #328623",
"#_ c #418F2F",
"$_ c #E0ECDB",
"%_ c #70AB55",
"&_ c #77AF58",
"*_ c #589B2B",
"=_ c #65A42C",
"-_ c #74AB30",
";_ c #95C05B",
">_ c #AFD082",
",_ c #C8DEA7",
"'_ c #E9F2DC",
")_ c #F3F8DF",
"!_ c #F0F46F",
"~_ c #FBFA51",
"{_ c #E5E79A",
"]_ c #C0C7AA",
"^_ c #F4F5F2",
"/_ c #BDC4C0",
"(_ c #B7BFCA",
"__ c #ECEEF3",
":_ c #9FAADA",
"<_ c #8694FF",
"[_ c #7C8BF7",
"}_ c #7686F1",
"|_ c #6675E4",
"1_ c #5163D4",
"2_ c #4155C8",
"3_ c #3A4CC1",
"4_ c #F1F2F2",
"5_ c #CAC9C9",
"6_ c #C3C2C3",
"7_ c #A7A8A7",
"8_ c #5E8560",
"9_ c #548257",
"0_ c #508255",
"a_ c #2A7A2F",
"b_ c #2F8335",
"c_ c #D0E3D1",
"d_ c #348827",
"e_ c #428F26",
"f_ c #F7FAF6",
"g_ c #4E962D",
"h_ c #569B2E",
"i_ c #62A22D",
"j_ c #6AA72D",
"k_ c #84B544",
"l_ c #E4EFD5",
"m_ c #96BF36",
"n_ c #ADCD3B",
"o_ c #FCFDF7",
"p_ c #F7F84E",
"q_ c #F5F35B",
"r_ c #E6E771",
"s_ c #D8DB8A",
"t_ c #BDC3B0",
"u_ c #FCFDFC",
"v_ c #F9FAFB",
"w_ c #A0ABD8",
"x_ c #99A5E3",
"y_ c #94A0EC",
"z_ c #8896FE",
"A_ c #7787F2",
"B_ c #5D6FDD",
"C_ c #4F62D3",
"D_ c #4D5FD0",
"E_ c #4559CA",
"F_ c #1A30A7",
"G_ c #192FA8",
"H_ c #192FA7",
"I_ c #EEEDED",
"J_ c #EBECEB",
"K_ c #E6E6E7",
"L_ c #DDDDDC",
"M_ c #D4D5D5",
"N_ c #CFD0CF",
"O_ c #CECDCD",
"P_ c #C4C3C3",
"Q_ c #B6B6B7",
"R_ c #AFAEAF",
"S_ c #9C9D9D",
"T_ c #8B8E8A",
"U_ c #818B82",
"V_ c #6C876F",
"W_ c #628666",
"X_ c #5D845F",
"Y_ c #4C8250",
"Z_ c #49804E",
"`_ c #3F7E44",
" : c #3C7D41",
".: c #397E3E",
"+: c #B3D2B5",
"@: c #DEEBDF",
"#: c #98C299",
"$: c #72AC72",
"%: c #449143",
"&: c #378924",
"*: c #FAFCF9",
"=: c #4F962D",
"-: c #509729",
";: c #579C2F",
">: c #5A9E2A",
",: c #70A933",
"': c #76AD31",
"): c #D3E4BB",
"!: c #ECF4E1",
"~: c #C5DCA3",
"{: c #B1D07F",
"]: c #98C254",
"^: c #A0C639",
"/: c #FDFEFA",
"(: c #FDFA54",
"_: c #EFED66",
":: c #DFE17B",
"<: c #D2D594",
"[: c #A0ABDB",
"}: c #7C8CF7",
"|: c #7382EF",
"1: c #6F80EB",
"2: c #6879E6",
"3: c #5C6CDC",
"4: c #4558C9",
"5: c #4556C9",
"6: c #3F51C4",
"7: c #3A4DC0",
"8: c #EEEFEF",
"9: c #ECECED",
"0: c #E6E6E5",
"a: c #DBDADA",
"b: c #C2C3C3",
"c: c #B7B8B7",
"d: c #ABAAAB",
"e: c #A8A7A7",
"f: c #A6A5A6",
"g: c #A5A4A4",
"h: c #9A9B9A",
"i: c #979798",
"j: c #929392",
"k: c #919190",
"l: c #828D83",
"m: c #7C8B7C",
"n: c #718874",
"o: c #67866A",
"p: c #618563",
"q: c #427F48",
"r: c #347D3B",
"s: c #F4F8F4",
"t: c #2B8330",
"u: c #1C7A1D",
"v: c #469244",
"w: c #3A8C24",
"x: c #E3EEDE",
"y: c #71AC55",
"z: c #78AF56",
"A: c #6FA938",
"B: c #6BA62D",
"C: c #8ABA58",
"D: c #74AD2F",
"E: c #F8FBF5",
"F: c #88B842",
"G: c #9AC255",
"H: c #ADCD3C",
"I: c #C5DA41",
"J: c #F9FBE3",
"K: c #F7F67C",
"L: c #E7E86F",
"M: c #D5D8B0",
"N: c #BCC3AF",
"O: c #BAC0C4",
"P: c #AEB7C6",
"Q: c #A8B3CE",
"R: c #9BA8E0",
"S: c #9AA5E3",
"T: c #929FEF",
"U: c #8C9BF6",
"V: c #8797FD",
"W: c #8494FD",
"X: c #7F8DF8",
"Y: c #7887F2",
"Z: c #7180EE",
"`: c #6777E5",
" < c #5D6EDD",
".< c #192EA7",
"+< c #EAEBEB",
"@< c #E9E8E8",
"#< c #C7C6C7",
"$< c #C6C5C6",
"%< c #B5B5B6",
"&< c #B3B4B4",
"*< c #B2B1B2",
"=< c #A9A9A8",
"-< c #A7A7A6",
";< c #678669",
">< c #5C8560",
",< c #528356",
"'< c #1E7724",
")< c #17771F",
"!< c #F3F8F3",
"~< c #6EA970",
"{< c #257F26",
"]< c #4B944A",
"^< c #D6E7D5",
"/< c #398A23",
"(< c #AFCFA0",
"_< c #D5E6CC",
":< c #61A23D",
"<< c #64A33F",
"[< c #D7E7CD",
"}< c #5FA12C",
"|< c #F0F6EB",
"1< c #ABCD8B",
"2< c #6FA937",
"3< c #83B652",
"4< c #E0ECD3",
"5< c #F8FAF4",
"6< c #AECE7C",
"7< c #86B739",
"8< c #9CC45B",
"9< c #E8F1D9",
"0< c #B7D33D",
"a< c #D0E143",
"b< c #F5F8AE",
"c< c #FBFBDA",
"d< c #E3E487",
"e< c #D6D99B",
"f< c #F1F2EA",
"g< c #E1E3E1",
"h< c #E7E9EB",
"i< c #B6BEC9",
"j< c #B0B8C9",
"k< c #D2D7E3",
"l< c #E9ECF4",
"m< c #9DA8DD",
"n< c #919DF1",
"o< c #8F9BF5",
"p< c #808EF9",
"q< c #7D8CF6",
"r< c #7382EE",
"s< c #6F80EC",
"t< c #697AE7",
"u< c #586ADA",
"v< c #5567D7",
"w< c #1A2EA7",
"x< c #182FA7",
"y< c #EEEEEF",
"z< c #E7E8E7",
"A< c #E5E4E5",
"B< c #E2E3E3",
"C< c #D9D8D8",
"D< c #D2D1D2",
"E< c #C8C8C7",
"F< c #BFC0BF",
"G< c #BFBEBE",
"H< c #B3B3B2",
"I< c #AFAFB0",
"J< c #A8A8A7",
"K< c #A2A2A3",
"L< c #9FA09F",
"M< c #9B9A9B",
"N< c #949495",
"O< c #898E89",
"P< c #718974",
"Q< c #6B886D",
"R< c #ABCDAD",
"S< c #2E8321",
"T< c #5C9F3E",
"U< c #F3F8F1",
"V< c #BFD9AA",
"W< c #C2DBA6",
"X< c #CFE2B5",
"Y< c #DBE845",
"Z< c #F6F65D",
"`< c #FEFEF4",
" [ c #BCC3C1",
".[ c #FDFEFE",
"+[ c #BBC2DF",
"@[ c #97A4E8",
"#[ c #7B8BF5",
"$[ c #7888F2",
"%[ c #6375E3",
"&[ c #6171E1",
"*[ c #5E6EDE",
"=[ c #495BCE",
"-[ c #E5E6E5",
";[ c #DEDEDF",
">[ c #D5D4D5",
",[ c #D0CFCF",
"'[ c #CECDCE",
")[ c #C6C6C5",
"![ c #A3A4A3",
"~[ c #909091",
"{[ c #888E87",
"][ c #718872",
"^[ c #638566",
"/[ c #397D3F",
"([ c #267F2B",
"_[ c #B1D1B2",
":[ c #F5F9F5",
"<[ c #D0E3CF",
"[[ c #6EA96B",
"}[ c #2E8522",
"|[ c #3C8B25",
"1[ c #479327",
"2[ c #71AB54",
"3[ c #D8E8CF",
"4[ c #E9F2E4",
"5[ c #9BC480",
"6[ c #6AA636",
"7[ c #C0D9A8",
"8[ c #F3F8EF",
"9[ c #C2DBA8",
"0[ c #73AC34",
"a[ c #85B53E",
"b[ c #D3E5B9",
"c[ c #F9FBF6",
"d[ c #FBFCF8",
"e[ c #E5EFD4",
"f[ c #B1D079",
"g[ c #CFE042",
"h[ c #E8EE48",
"i[ c #FFFC4D",
"j[ c #F3F283",
"k[ c #F8F8E1",
"l[ c #FDFDFB",
"m[ c #F7F8F3",
"n[ c #D9DDCC",
"o[ c #FDFDFC",
"p[ c #B7BFB9",
"q[ c #BCC2C8",
"r[ c #E5E8EB",
"s[ c #ECEEF4",
"t[ c #BEC5DF",
"u[ c #9AA7E1",
"v[ c #94A0ED",
"w[ c #8E9CF5",
"x[ c #8B9AF8",
"y[ c #7282EF",
"z[ c #5C6DDD",
"A[ c #4E61D1",
"B[ c #182EA7",
"C[ c #E0E0DF",
"D[ c #D5D6D5",
"E[ c #C9CACA",
"F[ c #A1A1A2",
"G[ c #828C83",
"H[ c #4F8152",
"I[ c #48814D",
"J[ c #327B38",
"K[ c #2C7B33",
"L[ c #1C7823",
"M[ c #358923",
"N[ c #3F8D25",
"O[ c #419026",
"P[ c #53992A",
"Q[ c #68A53E",
"R[ c #ECF4E6",
"S[ c #74AD30",
"T[ c #86B734",
"U[ c #C1D840",
"V[ c #DAE744",
"W[ c #F7F657",
"X[ c #E9EA6D",
"Y[ c #DADC83",
"Z[ c #CCD099",
"`[ c #C5CBB2",
" } c #B1B9C2",
".} c #ABB5C9",
"+} c #A7B0D1",
"@} c #909CF3",
"#} c #7E8EF8",
"$} c #7C8AF6",
"%} c #7281ED",
"&} c #6A7BE8",
"*} c #5D6FDE",
"=} c #5366D6",
"-} c #192EA6",
";} c #EFF0EF",
">} c #EBEAEB",
",} c #D4D5D4",
"'} c #CACACB",
")} c #B0B1B1",
"!} c #ABABAC",
"~} c #A5A5A6",
"{} c #A1A0A0",
"]} c #969796",
"^} c #5D855F",
"/} c #59845D",
"(} c #508153",
"_} c #347D3A",
":} c #237829",
"<} c #217827",
"[} c #1A791D",
"}} c #257E20",
"|} c #388B24",
"1} c #439025",
"2} c #F7FAF5",
"3} c #8FBD75",
"4} c #599D2F",
"5} c #67A43E",
"6} c #C6DDB6",
"7} c #CBE0BB",
"8} c #71AA30",
"9} c #77AF31",
"0} c #7AAF31",
"a} c #9DC438",
"b} c #CEDF42",
"c} c #FEFEF8",
"d} c #E2E5B6",
"e} c #C5CCA5",
"f} c #C7CBB1",
"g} c #E8EBE3",
"h} c #E8EAE6",
"i} c #B5BCBC",
"j} c #B0B8C3",
"k} c #8090FA",
"l} c #7A89F5",
"m} c #707FED",
"n} c #6676E4",
"o} c #6274E1",
"p} c #192FA6",
"q} c #182DA6",
"r} c #EFEFEE",
"s} c #EAEAE9",
"t} c #DEDEDD",
"u} c #D4D3D3",
"v} c #CCCCCB",
"w} c #AAAAA9",
"x} c #999A99",
"y} c #979898",
"z} c #6C886D",
"A} c #658768",
"B} c #628564",
"C} c #3E7F42",
"D} c #357D3B",
"E} c #3D8C24",
"F} c #BDD8AF",
"G} c #F9FBF8",
"H} c #7EB355",
"I} c #76AE31",
"J} c #85B634",
"K} c #8FBC36",
"L} c #A8CA3A",
"M} c #C0D83F",
"N} c #D9E644",
"O} c #F9F756",
"P} c #F7F7C8",
"Q} c #C5CBC4",
"R} c #B6BDB9",
"S} c #B3BCBE",
"T} c #A3AED4",
"U} c #9FAADC",
"V} c #7888F3",
"W} c #7485F1",
"X} c #182EA6",
"Y} c #E0E1E1",
"Z} c #CFD0D0",
"`} c #ADAEAD",
" | c #7A8B7C",
".| c #788B79",
"+| c #2E7B35",
"@| c #2C7A31",
"#| c #1F7B1E",
"$| c #278021",
"%| c #2C8221",
"&| c #4D9527",
"*| c #549A2F",
"=| c #ACCD98",
"-| c #E8F1E2",
";| c #FCFDFB",
">| c #F5F9F2",
",| c #CEE2C0",
"'| c #7DB154",
")| c #6EA82E",
"!| c #9BC338",
"~| c #B3D13C",
"{| c #CCDF42",
"]| c #E4EC47",
"^| c #FDFB4B",
"/| c #F1F060",
"(| c #E2E47A",
"_| c #EAECC7",
":| c #F7F8F2",
"<| c #FBFBFA",
"[| c #EBEDE7",
"}| c #C7CDC2",
"|| c #B5BDBC",
"1| c #A7B2CE",
"2| c #A2AED5",
"3| c #9DA9DD",
"4| c #9BA7E1",
"5| c #919FF0",
"6| c #8F9BF4",
"7| c #8A97FB",
"8| c #8393FD",
"9| c #818FF9",
"0| c #485BCD",
"a| c #660000",
"b| c #DCDDDC",
"c| c #D7D8D7",
"d| c #D0D1D0",
"e| c #BBBCBB",
"f| c #BAB9B9",
"g| c #B7B8B8",
"h| c #B0AFB0",
"i| c #ADACAC",
"j| c #6C876E",
"k| c #5E8562",
"l| c #5C855F",
"m| c #548258",
"n| c #4E8253",
"o| c #449026",
"p| c #5D9F2C",
"q| c #68A42D",
"r| c #6CA82F",
"s| c #6EAA2E",
"t| c #7DB232",
"u| c #A6C93A",
"v| c #BFD83F",
"w| c #F0F449",
"x| c #F9F754",
"y| c #EBEB6B",
"z| c #DCDE80",
"A| c #CED297",
"B| c #C2C9A6",
"C| c #BDC3AE",
"D| c #ACB5C9",
"E| c #98A3E6",
"F| c #92A0EE",
"G| c #7987F3",
"H| c #5063D3",
"I| c #4E5FD1",
"J| c #475ACB",
"K| c #DFDEDF",
"L| c #CCCDCD",
"M| c #C7C8C8",
"N| c #BABABB",
"O| c #A8A9A9",
"P| c #A7A7A8",
"Q| c #6D8870",
"R| c #6B876C",
"S| c #638667",
"T| c #608564",
"U| c #1E7824",
"V| c #19761F",
"W| c #277F20",
"X| c #2B8322",
"Y| c #429025",
"Z| c #65A52D",
"`| c #69A52E",
" 1 c #78AE31",
".1 c #89B835",
"+1 c #99C237",
"@1 c #B2D03C",
"#1 c #CBDE42",
"$1 c #E2EC46",
"%1 c #FBFA4B",
"&1 c #F2F25E",
"*1 c #D5D98A",
"=1 c #C6CCA0",
"-1 c #B7BEB7",
";1 c #B2BBBF",
">1 c #ADB5C7",
",1 c #A8B2CE",
"'1 c #A5B0D2",
")1 c #8F9CF4",
"!1 c #8D9AF7",
"~1 c #7E8DF7",
"{1 c #6776E4",
"]1 c #596BDA",
"^1 c #172DA6",
"/1 c #182DA5",
"(1 c #C0C1C0",
"_1 c #708871",
":1 c #628664",
"<1 c #5C845E",
"[1 c #3B7D41",
"}1 c #2D7B34",
"|1 c #227829",
"11 c #19781E",
"21 c #1C791D",
"31 c #227E20",
"41 c #388923",
"51 c #4C9427",
"61 c #52992A",
"71 c #559A2A",
"81 c #5A9E2B",
"91 c #69A72D",
"01 c #8CBA35",
"a1 c #A5C939",
"b1 c #BED63F",
"c1 c #D6E544",
"d1 c #EEF249",
"e1 c #FBF853",
"f1 c #EBEB6A",
"g1 c #DCDE7F",
"h1 c #CFD295",
"i1 c #A4AFD3",
"j1 c #98A4E7",
"k1 c #95A1EA",
"l1 c #7C8BF5",
"m1 c #7988F3",
"n1 c #7585F0",
"o1 c #6475E4",
"p1 c #6173E0",
"q1 c #192DA6",
"r1 c #E8E8E7",
"s1 c #D6D6D7",
"t1 c #CBCACB",
"u1 c #B3B2B2",
"v1 c #ABABAA",
"w1 c #9B9C9C",
"x1 c #5D8461",
"y1 c #518254",
"z1 c #4A804F",
"A1 c #457F4A",
"B1 c #2E7C35",
"C1 c #277A2C",
"D1 c #187720",
"E1 c #268021",
"F1 c #569C2A",
"G1 c #599D2B",
"H1 c #70A92F",
"I1 c #73AC2F",
"J1 c #7AAF32",
"K1 c #B0CF3D",
"L1 c #C9DD41",
"M1 c #E2EB47",
"N1 c #FAF94B",
"O1 c #F3F25D",
"P1 c #E4E573",
"Q1 c #D6D989",
"R1 c #C1C7A8",
"S1 c #B2BBBE",
"T1 c #9EAADD",
"U1 c #8895FF",
"V1 c #818FFB",
"W1 c #7B89F5",
"X1 c #7384F0",
"Y1 c #7180EC",
"Z1 c #5668D7",
"`1 c #5364D5",
" 2 c #5061D2",
".2 c #AEAEAF",
"+2 c #9C9D9C",
"@2 c #908F90",
"#2 c #798A7B",
"$2 c #2E7A34",
"%2 c #2B7B30",
"&2 c #1C7724",
"*2 c #1A7720",
"=2 c #3A8B23",
"-2 c #4D9728",
";2 c #85B734",
">2 c #8BBA34",
",2 c #A3C839",
"'2 c #BCD63F",
")2 c #D4E344",
"!2 c #EDF249",
"~2 c #FBF952",
"{2 c #ECEC68",
"]2 c #DEE07E",
"^2 c #CFD394",
"/2 c #C3C8A7",
"(2 c #B9C0B6",
"_2 c #A4AED3",
":2 c #9BA6E3",
"<2 c #5E70DE",
"[2 c #4A5DCF",
"}2 c #4759CC",
"|2 c #182CA5",
"12 c #BEBDBE",
"22 c #BABBBA",
"32 c #AEADAE",
"42 c #7F8C7F",
"52 c #4E8251",
"62 c #24782A",
"72 c #247F1F",
"82 c #2C8222",
"92 c #308523",
"02 c #60A22C",
"a2 c #96C037",
"b2 c #AFCE3C",
"c2 c #C7DC41",
"d2 c #E0EA46",
"e2 c #F8F94B",
"f2 c #F4F35D",
"g2 c #E5E772",
"h2 c #D6D988",
"i2 c #C8CD9E",
"j2 c #C2C8A9",
"k2 c #B9C1B3",
"l2 c #B3BBBF",
"m2 c #B0B8C2",
"n2 c #7786F3",
"o2 c #596ADB",
"p2 c #5364D6",
"q2 c #172EA6",
"r2 c #172DA5",
"s2 c #D1D0D1",
"t2 c #C4C3C4",
"u2 c #C0C1C1",
"v2 c #B7B7B6",
"w2 c #B3B3B4",
"x2 c #B2B2B1",
"y2 c #B0B0B1",
"z2 c #A2A1A2",
"A2 c #9D9C9C",
"B2 c #999A9A",
"C2 c #8D8E8E",
"D2 c #818C81",
"E2 c #738A75",
"F2 c #6F8972",
"G2 c #6D886E",
"H2 c #69886B",
"I2 c #658669",
"J2 c #59845B",
"K2 c #4C8151",
"L2 c #18781E",
"M2 c #1B7A1D",
"N2 c #2C8422",
"O2 c #469126",
"P2 c #67A52E",
"Q2 c #A1C739",
"R2 c #BBD53F",
"S2 c #D3E343",
"T2 c #EBF148",
"U2 c #FCFA51",
"V2 c #EDED66",
"W2 c #DFE07D",
"X2 c #C2C8A6",
"Y2 c #B2B9C1",
"Z2 c #8D9CF5",
"`2 c #8291FC",
" 3 c #6878E7",
".3 c #5C6CDB",
"+3 c #5869DA",
"@3 c #172CA5",
"#3 c #E0DFDF",
"$3 c #CECECF",
"%3 c #BBBABA",
"&3 c #A8A7A8",
"*3 c #9D9E9E",
"=3 c #7F8B7F",
"-3 c #648666",
";3 c #317C38",
">3 c #1E7726",
",3 c #479326",
"'3 c #4A9428",
")3 c #4F9628",
"!3 c #549929",
"~3 c #7EB332",
"{3 c #84B534",
"]3 c #89B934",
"^3 c #AECD3C",
"/3 c #F5F45B",
"(3 c #D8DB87",
"_3 c #BCC4B0",
":3 c #A9B2CE",
"<3 c #8191FA",
"[3 c #6E7EEA",
"}3 c #6777E6",
"|3 c #6375E2",
"13 c #172CA6",
"23 c #162CA5",
"33 c #E4E3E4",
"43 c #D6D5D6",
"53 c #CBCACA",
"63 c #C2C1C2",
"73 c #C1C1C0",
"83 c #A7A6A7",
"93 c #99999A",
"03 c #538356",
"a3 c #4A804E",
"b3 c #3E7E44",
"c3 c #3C7D40",
"d3 c #377C3B",
"e3 c #297A2E",
"f3 c #398B23",
"g3 c #469127",
"h3 c #559B29",
"i3 c #A0C539",
"j3 c #B9D33E",
"k3 c #D1E243",
"l3 c #EAF048",
"m3 c #FDFA4F",
"n3 c #EEEE66",
"o3 c #E0E17B",
"p3 c #D1D591",
"q3 c #BCC3B1",
"r3 c #B9C1B5",
"s3 c #ACB6C8",
"t3 c #A3ADD7",
"u3 c #99A4E6",
"v3 c #96A2EA",
"w3 c #8795FE",
"x3 c #E3E2E3",
"y3 c #8C8E8D",
"z3 c #758977",
"A3 c #58845A",
"B3 c #407E45",
"C3 c #17761D",
"D3 c #358824",
"E3 c #4E9729",
"F3 c #6BA62E",
"G3 c #94BE36",
"H3 c #ACCD3B",
"I3 c #DDE946",
"J3 c #F6F64A",
"K3 c #F6F55A",
"L3 c #E7E770",
"M3 c #D9DB85",
"N3 c #C0C6AC",
"O3 c #B3BABE",
"P3 c #ADB6C5",
"Q3 c #97A3E8",
"R3 c #909CF2",
"S3 c #7180ED",
"T3 c #6E7DEB",
"U3 c #6474E2",
"V3 c #162CA4",
"W3 c #AEADAD",
"X3 c #3E7F44",
"Y3 c #18761E",
"Z3 c #5D9E2B",
"`3 c #6BA82F",
" 4 c #75AD31",
".4 c #78AF30",
"+4 c #84B634",
"@4 c #88B733",
"#4 c #9FC538",
"$4 c #D0E142",
"%4 c #E9EF48",
"&4 c #EFEE64",
"*4 c #D1D590",
"=4 c #BCC2B1",
"-4 c #B6BEB8",
";4 c #A9B3CB",
">4 c #9EA9DE",
",4 c #909EF0",
"'4 c #8C9AF9",
")4 c #7F8FF9",
"!4 c #6577E4",
"~4 c #5F70DE",
"{4 c #596AD9",
"]4 c #4458C9",
"^4 c #172CA4",
"/4 c #DADADB",
"(4 c #868E86",
"_4 c #6E8871",
":4 c #58835A",
"<4 c #589D2B",
"[4 c #92BD36",
"}4 c #AACC3B",
"|4 c #DCE745",
"14 c #F4F64A",
"24 c #F7F658",
"34 c #E8E96E",
"44 c #CBCF9A",
"54 c #BAC2B2",
"64 c #909DF3",
"74 c #8191FB",
"84 c #6B7AE8",
"94 c #4A5CCD",
"04 c #E1E2E2",
"a4 c #C3C4C4",
"b4 c #939493",
"c4 c #1B7721",
"d4 c #2C8322",
"e4 c #2E8521",
"f4 c #B6D23D",
"g4 c #CEE143",
"h4 c #E1E379",
"i4 c #D3D68E",
"j4 c #C0C7A9",
"k4 c #98A5E6",
"l4 c #808EFA",
"m4 c #162DA5",
"n4 c #162BA4",
"o4 c #6C876D",
"p4 c #5DA02C",
"q4 c #90BC36",
"r4 c #C2D93F",
"s4 c #DAE745",
"t4 c #F8F657",
"u4 c #CBD098",
"v4 c #BDC4AF",
"w4 c #9AA5E4",
"x4 c #95A2EB",
"y4 c #6A7BE9",
"z4 c #6878E5",
"A4 c #152CA4",
"B4 c #B6B7B6",
"C4 c #A8B0A9",
"D4 c #DEE1DE",
"E4 c #F7F8F7",
"F4 c #EEF1EE",
"G4 c #C1CBC2",
"H4 c #738D75",
"I4 c #83A085",
"J4 c #D8E2D9",
"K4 c #FBFCFB",
"L4 c #EFF3F0",
"M4 c #B4C9B5",
"N4 c #58875B",
"O4 c #4B864F",
"P4 c #B8CFBA",
"Q4 c #F5F8F6",
"R4 c #EDF3ED",
"S4 c #A7C5A9",
"T4 c #3B8040",
"U4 c #428947",
"V4 c #B6D2B8",
"W4 c #F2F7F2",
"X4 c #B2D1B5",
"Y4 c #318436",
"Z4 c #187620",
"`4 c #278120",
" 5 c #9CC438",
".5 c #B4D13D",
"+5 c #CDE042",
"@5 c #E6ED47",
"#5 c #FFFC4C",
"$5 c #F1F061",
"%5 c #E2E478",
"&5 c #C5CAA3",
"*5 c #B4BDBC",
"=5 c #A6AFD3",
"-5 c #7989F5",
";5 c #6070DF",
">5 c #596BD9",
",5 c #152BA4",
"'5 c #B0B7B0",
")5 c #C9D3C9",
"!5 c #68866B",
"~5 c #7A987D",
"{5 c #C7D7C8",
"]5 c #C9DACA",
"^5 c #A8C7AA",
"/5 c #39833E",
"(5 c #E6EFE7",
"_5 c #DBEADC",
":5 c #1F7B26",
"<5 c #338623",
"[5 c #499328",
"}5 c #60A02B",
"|5 c #8FBB36",
"15 c #A7CA3B",
"25 c #D8E645",
"35 c #F2F449",
"45 c #F8F756",
"55 c #EAEB6C",
"65 c #DBDD81",
"75 c #B5BEB9",
"85 c #9FA9DB",
"95 c #9DA8E0",
"05 c #8A98F9",
"a5 c #5B6BDB",
"b5 c #5768D9",
"c5 c #DAD9D9",
"d5 c #A5A6A5",
"e5 c #A3A4A4",
"f5 c #8F918F",
"g5 c #EBEDEB",
"h5 c #B1BAB1",
"i5 c #7B8E7D",
"j5 c #778D79",
"k5 c #94A595",
"l5 c #F5F7F5",
"m5 c #BFCEC0",
"n5 c #C9D6C9",
"o5 c #5E8962",
"p5 c #8CAC8E",
"q5 c #4B814E",
"r5 c #D8E5D9",
"s5 c #5C9361",
"t5 c #428246",
"u5 c #A8C6AA",
"v5 c #E9F1EA",
"w5 c #9BC19E",
"x5 c #BCD6BD",
"y5 c #34843A",
"z5 c #2E8236",
"A5 c #B3D2B6",
"B5 c #80B484",
"C5 c #207B1E",
"D5 c #247F20",
"E5 c #298220",
"F5 c #338823",
"G5 c #69A52D",
"H5 c #6EA82F",
"I5 c #70AA30",
"J5 c #73AB2F",
"K5 c #8AB835",
"L5 c #B3D03D",
"M5 c #E5ED46",
"N5 c #FDFA4C",
"O5 c #F2F060",
"P5 c #D5D88C",
"Q5 c #C6CBA2",
"R5 c #A2AED6",
"S5 c #98A5E5",
"T5 c #8997FB",
"U5 c #8492FD",
"V5 c #7383F0",
"W5 c #6D7CEA",
"X5 c #5567D8",
"Y5 c #94A195",
"Z5 c #ABB7AC",
"`5 c #C2CCC3",
" 6 c #E6EAE7",
".6 c #E7EDE8",
"+6 c #749876",
"@6 c #4E8153",
"#6 c #659869",
"$6 c #448549",
"%6 c #2A7B31",
"&6 c #DCE9DD",
"*6 c #38853D",
"=6 c #328538",
"-6 c #CBE1CD",
";6 c #207D1F",
">6 c #258020",
",6 c #288121",
"'6 c #499428",
")6 c #77AD30",
"!6 c #79AF30",
"~6 c #88B734",
"{6 c #BFD73F",
"]6 c #D7E544",
"^6 c #F0F349",
"/6 c #DCDF80",
"(6 c #CDD296",
"_6 c #B5BDB9",
":6 c #5868D9",
"<6 c #162AA4",
"[6 c #DCDCDB",
"}6 c #C3C3C2",
"|6 c #8E918E",
"16 c #848D86",
"26 c #8A978B",
"36 c #E4E7E4",
"46 c #5A855D",
"56 c #428146",
"66 c #F8FAF8",
"76 c #F0F6F0",
"86 c #3B8B25",
"96 c #5F9F2C",
"06 c #7FB233",
"a6 c #99C138",
"b6 c #B1CF3D",
"c6 c #CADE41",
"d6 c #E2EC47",
"e6 c #F3F15E",
"f6 c #E4E574",
"g6 c #D6D88A",
"h6 c #B4BCBB",
"i6 c #A6B0D2",
"j6 c #003333",
"k6 c #003399",
"l6 c #FFFF00",
"m6 c #152BA5",
"n6 c #152AA4",
"o6 c #9A9B9B",
"p6 c #8A8D8A",
"q6 c #D4D9D4",
"r6 c #EBEEEB",
"s6 c #BFC9C0",
"t6 c #A5B5A7",
"u6 c #849B85",
"v6 c #58855B",
"w6 c #F9FBFA",
"x6 c #358723",
"y6 c #A4C839",
"z6 c #BDD63F",
"A6 c #EFF249",
"B6 c #ECEC69",
"C6 c #CED394",
"D6 c #B9BFB6",
"E6 c #B4BBBD",
"F6 c #AEB7C4",
"G6 c #ABB5C8",
"H6 c #A6B1CF",
"I6 c #97A4E7",
"J6 c #C0BFC0",
"K6 c #999899",
"L6 c #F8F9F8",
"M6 c #7F9281",
"N6 c #839B85",
"O6 c #608663",
"P6 c #5E8460",
"Q6 c #EAEFEA",
"R6 c #6D9671",
"S6 c #E1EDE2",
"T6 c #308623",
"U6 c #B1CF3C",
"V6 c #E1EB46",
"W6 c #F9F94C",
"X6 c #E5E673",
"Y6 c #C7CD9F",
"Z6 c #BEC6AC",
"`6 c #152BA3",
" 7 c #152AA3",
".7 c #DCDCDD",
"+7 c #DADBDB",
"@7 c #D9DAD9",
"#7 c #A6B4A6",
"$7 c #748B76",
"%7 c #889F8A",
"&7 c #E3E8E3",
"*7 c #C0D0C1",
"=7 c #C0D1C1",
"-7 c #558659",
";7 c #86AA88",
">7 c #4A834F",
",7 c #A3C7A6",
"'7 c #B8D4BB",
")7 c #308436",
"!7 c #217C27",
"~7 c #84B788",
"{7 c #C9DFCA",
"]7 c #308521",
"^7 c #368A23",
"/7 c #69A72E",
"(7 c #82B533",
"_7 c #A3C73A",
":7 c #BCD53E",
"<7 c #D5E343",
"[7 c #ECED68",
"}7 c #B1B9C0",
"|7 c #D3D4D4",
"17 c #B5B4B4",
"27 c #CED4CE",
"37 c #719773",
"47 c #F8FAF9",
"57 c #E3ECE4",
"67 c #38863D",
"77 c #ECF3ED",
"87 c #559B57",
"97 c #227C1F",
"07 c #288221",
"a7 c #77AF30",
"b7 c #C8DC41",
"c7 c #F8F84B",
"d7 c #F4F35C",
"e7 c #E5E672",
"f7 c #D7DA88",
"g7 c #C8CD9D",
"h7 c #B5BCBB",
"i7 c #929FF0",
"j7 c #142BA3",
"k7 c #142AA3",
"l7 c #CBCBCC",
"m7 c #8E8E8D",
"n7 c #838D85",
"o7 c #818B81",
"p7 c #7F9180",
"q7 c #CFD6CF",
"r7 c #DFE5DF",
"s7 c #99AF9A",
"t7 c #58835C",
"u7 c #7A9F7D",
"v7 c #DAE5DB",
"w7 c #F3F7F3",
"x7 c #C5D7C7",
"y7 c #5E9161",
"z7 c #3C8A42",
"A7 c #B5D3B7",
"B7 c #F9FBF9",
"C7 c #CDE1CE",
"D7 c #5A9E5B",
"E7 c #2C8421",
"F7 c #70AB2F",
"G7 c #A2C63A",
"H7 c #BAD43F",
"I7 c #ECF148",
"J7 c #DFE17C",
"K7 c #D0D492",
"L7 c #BCC2B2",
"M7 c #92A0ED",
"N7 c #ACADAC",
"O7 c #A3A2A3",
"P7 c #618663",
"Q7 c #3B7D3F",
"R7 c #1C7822",
"S7 c #2B8222",
"T7 c #95BF36",
"U7 c #C6DC41",
"V7 c #F7F84B",
"W7 c #A5AFD1",
"X7 c #142AA2",
"Y7 c #ABACAB",
"Z7 c #A0A0A1",
"`7 c #808C82",
" 8 c #7D8C7F",
".8 c #4F8254",
"+8 c #28792F",
"@8 c #257A2C",
"#8 c #B9D43E",
"$8 c #EEEE65",
"%8 c #C3C9A5",
"&8 c #B7BEB9",
"*8 c #ADB6C8",
"=8 c #A3ACD7",
"-8 c #1429A3",
";8 c #A0A09F",
">8 c #648767",
",8 c #518355",
"'8 c #277A2D",
")8 c #25792A",
"!8 c #4F9629",
"~8 c #60A12B",
"{8 c #7BB132",
"]8 c #94BE37",
"^8 c #C4DA40",
"/8 c #DDE945",
"(8 c #E8E870",
"_8 c #CACF9C",
":8 c #8B98FA",
"<8 c #1329A2",
"[8 c #A2A2A1",
"}8 c #417F47",
"|8 c #367C3C",
"18 c #B7D23E",
"28 c #E8EF48",
"38 c #EFEF64",
"48 c #E1E27A",
"58 c #142AA4",
"68 c #B4B5B5",
"78 c #A4A5A5",
"88 c #959696",
"98 c #8D8E8C",
"08 c #2D7A32",
"a8 c #197621",
"b8 c #19791D",
"c8 c #C3D940",
"d8 c #DADC84",
"e8 c #B2BBBD",
"f8 c #B0B9C1",
"g8 c #929EEE",
"h8 c #1429A2",
"i8 c #CECECD",
"j8 c #C6C5C5",
"k8 c #7E8B7E",
"l8 c #7B8B7B",
"m8 c #708973",
"n8 c #528257",
"o8 c #207927",
"p8 c #257E1F",
"q8 c #368824",
"r8 c #61A12D",
"s8 c #85B533",
"t8 c #9EC438",
"u8 c #B5D23D",
"v8 c #CEE142",
"w8 c #E7EE48",
"x8 c #E1E378",
"y8 c #D3D78E",
"z8 c #9FABDA",
"A8 c #99A5E6",
"B8 c #CFCFCE",
"C8 c #808B80",
"D8 c #217829",
"E8 c #5B9D2A",
"F8 c #7CB031",
"G8 c #A9CA3B",
"H8 c #C1D940",
"I8 c #E9E96C",
"J8 c #DBDC83",
"K8 c #CCD199",
"L8 c #C2C7A7",
"M8 c #A2ABD8",
"N8 c #FF6600",
"O8 c #663300",
"P8 c #132AA3",
"Q8 c #9E9D9D",
"R8 c #7A8A7C",
"S8 c #608662",
"T8 c #1B781E",
"U8 c #4A9528",
"V8 c #4D9627",
"W8 c #85B534",
"X8 c #E5EE47",
"Y8 c #E3E477",
"Z8 c #C4CBA3",
"`8 c #A2ADD5",
" 9 c #FFCC00",
".9 c #666600",
"+9 c #330000",
"@9 c #3D7F43",
"#9 c #247D1F",
"$9 c #569A2A",
"%9 c #8FBB35",
"&9 c #F1F44A",
"*9 c #EAEA6C",
"=9 c #DBDE81",
"-9 c #CCD197",
";9 c #8E9BF6",
">9 c #8996FD",
",9 c #1328A2",
"'9 c #788A78",
")9 c #457F49",
"!9 c #3D7D41",
"~9 c #357C39",
"{9 c #1D7725",
"]9 c #7CB231",
"^9 c #9AC238",
"/9 c #CBDF41",
"(9 c #E4EC46",
"_9 c #FCFB4C",
":9 c #F2F160",
"<9 c #E3E576",
"[9 c #D5D78B",
"}9 c #98A5E4",
"|9 c #8A98FC",
"19 c #142BA4",
"29 c #1329A3",
"39 c #5B845F",
"49 c #2D7A34",
"59 c #16771E",
"69 c #A5C93A",
"79 c #F9F854",
"89 c #8897FC",
"99 c #2034AD",
"09 c #1E32AA",
"a9 c #162BA5",
"b9 c #1329A1",
"c9 c #548356",
"d9 c #4B804F",
"e9 c #3F7E45",
"f9 c #3A8C25",
"g9 c #489227",
"h9 c #B2CF3C",
"i9 c #CADE42",
"j9 c #E3EC47",
"k9 c #FBFA4C",
"l9 c #F3F15F",
"m9 c #D6D98B",
"n9 c #C7CCA0",
"o9 c #A6AFD1",
"p9 c #96A2E8",
"q9 c #818FFA",
"r9 c #1D32A9",
"s9 c #1229A2",
"t9 c #1E7A1F",
"u9 c #66A52E",
"v9 c #A4C83A",
"w9 c #BDD63E",
"x9 c #EEF348",
"y9 c #FAF953",
"z9 c #EBEC68",
"A9 c #CED395",
"B9 c #B0B9C0",
"C9 c #AFB8C5",
"D9 c #A1ADD7",
"E9 c #1D32AB",
"F9 c #8F8E8F",
"G9 c #8C8E8B",
"H9 c #818C83",
"I9 c #6E8970",
"J9 c #3C7E42",
"K9 c #1E7C1F",
"L9 c #3F8E26",
"M9 c #003300",
"N9 c #1228A1",
"O9 c #738A74",
"P9 c #4D8250",
"Q9 c #26792B",
"R9 c #1D7A1F",
"S9 c #006633",
"T9 c #2237AD",
"U9 c #2135AC",
"V9 c #1A2EA8",
"W9 c #1228A2",
"X9 c #1227A2",
"Y9 c #538358",
"Z9 c #2D7B32",
"`9 c #1B7723",
" 0 c #72AC2F",
".0 c #1B2FA7",
"+0 c #1227A1",
"@0 c #337D39",
"#0 c #1A7622",
"$0 c #7EB231",
"%0 c #1328A1",
"&0 c #1128A1",
"*0 c #1127A1",
"=0 c #C7C7C6",
"-0 c #768A79",
";0 c #6A876B",
">0 c #3F7F43",
",0 c #227D20",
"'0 c #79AE31",
")0 c #1B2FA8",
"!0 c #508354",
"~0 c #1227A0",
"{0 c #397E3F",
"]0 c #328523",
"^0 c #499326",
"/0 c #539829",
"(0 c #87B833",
"_0 c #192EA8",
":0 c #162BA3",
"<0 c #132AA2",
"[0 c #1127A0",
"}0 c #C1C1C2",
"|0 c #70AA2E",
"10 c #1F35AB",
"20 c #182DA7",
"30 c #1027A0",
"40 c #858C85",
"50 c #1B30A7",
"60 c #1126A0",
"70 c #9E9E9D",
"80 c #8E948F",
"90 c #DDE0DD",
"00 c #D2D7D3",
"a0 c #7B8C7C",
"b0 c #8B9B8C",
"c0 c #E2E7E3",
"d0 c #DAE1DB",
"e0 c #79947B",
"f0 c #8EAB90",
"g0 c #D4DFD5",
"h0 c #EAF0EA",
"i0 c #B1C8B3",
"j0 c #518655",
"k0 c #447F47",
"l0 c #407F46",
"m0 c #217929",
"n0 c #90BC35",
"o0 c #BDBEBE",
"p0 c #D6D9D6",
"q0 c #B3BEB4",
"r0 c #EBEEEC",
"s0 c #CFD9D0",
"t0 c #98B19A",
"u0 c #BCD1BD",
"v0 c #428047",
"w0 c #1F35AD",
"x0 c #11279F",
"y0 c #D8DBD8",
"z0 c #889289",
"A0 c #AEB7AE",
"B0 c #CDD5CE",
"C0 c #768E78",
"D0 c #A6B7A7",
"E0 c #5F8461",
"F0 c #E5ECE6",
"G0 c #9AB69C",
"H0 c #57865B",
"I0 c #538556",
"J0 c #78A17B",
"K0 c #F3F6F3",
"L0 c #1F7725",
"M0 c #3A8A24",
"N0 c #6FAA2E",
"O0 c #A8C93B",
"P0 c #283DB2",
"Q0 c #1026A0",
"R0 c #969F97",
"S0 c #7E8B80",
"T0 c #808F81",
"U0 c #839884",
"V0 c #6F8C71",
"W0 c #769C79",
"X0 c #94B397",
"Y0 c #B2C9B4",
"Z0 c #E0E9E1",
"`0 c #5A9C2B",
" a c #9AC338",
".a c #2B3EB4",
"+a c #2A3DB4",
"@a c #273CB1",
"#a c #172BA4",
"$a c #828E83",
"%a c #68906B",
"&a c #DDE6DD",
"*a c #3C7E40",
"=a c #2B7A30",
"-a c #2C3FB5",
";a c #2B3FB6",
">a c #2A3DB3",
",a c #2238AE",
"'a c #0F269F",
")a c #C7D6C9",
"!a c #E6EDE6",
"~a c #AEC6B0",
"{a c #8EB091",
"]a c #659569",
"^a c #357D39",
"/a c #3E8C24",
"(a c #569C29",
"_a c #99C137",
":a c #283EB3",
"<a c #2136AC",
"[a c #0F26A0",
"}a c #F7F9F7",
"|a c #5D8C60",
"1a c #669569",
"2a c #8CBA34",
"3a c #D5E444",
"4a c #1B31AA",
"5a c #10269F",
"6a c #F6F8F6",
"7a c #8EAE90",
"8a c #508454",
"9a c #6B986F",
"0a c #DCE7DD",
"aa c #377C3C",
"ba c #293CB3",
"ca c #1126A1",
"da c #0F259F",
"ea c #959995",
"fa c #001639",
"ga c #002C72",
"ha c #E20A16",
"ia c #1128A0",
"ja c #1025A0",
"ka c #9A9C9A",
"la c #608664",
"ma c #5B895E",
"na c #C2D4C3",
"oa c #D7E4D8",
"pa c #82AA85",
"qa c #3F6095",
"ra c #2439B1",
"sa c #10259F",
"ta c #9C9C9B",
"ua c #778977",
"va c #307B37",
"wa c #7F95B8",
"xa c #BFCADB",
"ya c #B2B3B2",
"za c #263CB2",
"Aa c #0E249F",
"Ba c #2E7A33",
"Ca c #1E34AA",
"Da c #182EA5",
"Ea c #1026A1",
"Fa c #0F249F",
"Ga c #BCBDBD",
"Ha c #898D8A",
"Ia c #0E249E",
"Ja c #B9B9B8",
"Ka c #307C37",
"La c #2A8120",
"Ma c #273AB1",
"Na c #0F25A0",
"Oa c #8A8E89",
"Pa c #3D7F42",
"Qa c #2F7C36",
"Ra c #0E259F",
"Sa c #0E259E",
"Ta c #0F249E",
"Ua c #69886D",
"Va c #508154",
"Wa c #207B1F",
"Xa c #217D1E",
"Ya c #182CA6",
"Za c #7E8C7E",
"`a c #528357",
" b c #0F259E",
".b c #0D249E",
"+b c #668667",
"@b c #267F1F",
"#b c #1930A8",
"$b c #0E249D",
"%b c #AFB0AF",
"&b c #4B804E",
"*b c #F0848A",
"=b c #1E35AC",
"-b c #10259E",
";b c #0E239E",
">b c #518256",
",b c #387E3E",
"'b c #1F33AC",
")b c #1027A1",
"!b c #10279F",
"~b c #0D249D",
"{b c #0E239D",
"]b c #0D239D",
"^b c #728975",
"/b c #273DB3",
"(b c #0D239E",
"_b c #868D88",
":b c #2F42B9",
"<b c #2539AF",
"[b c #1228A0",
"}b c #3649BD",
"|b c #3548BC",
"1b c #3447BB",
"2b c #2D40B0",
"3b c #C3C8E8",
"4b c #F9FAFD",
"5b c #B3BAE2",
"6b c #2035AB",
"7b c #4152B7",
"8b c #D1D5EE",
"9b c #C6CCE9",
"0b c #3548B2",
"ab c #2F42AF",
"bb c #C7CCE9",
"cb c #F6F7FB",
"db c #C9CEEA",
"eb c #4859B9",
"fb c #172EA5",
"gb c #5F6EC1",
"hb c #C3C9E8",
"ib c #F1F2F9",
"jb c #FAFAFD",
"kb c #E3E6F4",
"lb c #9AA3D7",
"mb c #2034A7",
"nb c #FF3300",
"ob c #3347BD",
"pb c #B4BBE3",
"qb c #828DD0",
"rb c #DFE2F3",
"sb c #B8BFE4",
"tb c #C4C9E8",
"ub c #F3F4FA",
"vb c #3549B1",
"wb c #6C79C6",
"xb c #A9B1DD",
"yb c #0C239D",
"zb c #3144B9",
"Ab c #2D42B6",
"Bb c #2D40B7",
"Cb c #2135AE",
"Db c #B9BFE4",
"Eb c #7481CA",
"Fb c #F8F9FC",
"Gb c #AFB7E1",
"Hb c #293CAE",
"Ib c #7683CB",
"Jb c #D2D6ED",
"Kb c #3144B0",
"Lb c #CBD0EB",
"Mb c #9EA8DA",
"Nb c #DBDEF1",
"Ob c #7582C9",
"Pb c #1E33A8",
"Qb c #1C30A6",
"Rb c #4F60BA",
"Sb c #F0F1F9",
"Tb c #0D229D",
"Ub c #4456B9",
"Vb c #253BAE",
"Wb c #3A4DB4",
"Xb c #2438AC",
"Yb c #4D5EBB",
"Zb c #4A5AB9",
"`b c #DEE1F2",
" c c #4557B6",
".c c #717EC7",
"+c c #9BA4D8",
"@c c #D7DBEF",
"#c c #0F269E",
"$c c #0C229D",
"%c c #2E41B8",
"&c c #263CB1",
"*c c #2337AC",
"=c c #2034A9",
"-c c #1F34A8",
";c c #F9FAFC",
">c c #2D40AD",
",c c #D0D4EC",
"'c c #0C229C",
")c c #1E32A8",
"!c c #1F33A8",
"~c c #F5F6FB",
"{c c #B3BAE1",
"]c c #959FD5",
"^c c #6D7AC6",
"/c c #3B4DB2",
"(c c #858E86",
"_c c #6F8970",
":c c #658767",
"<c c #3246BC",
"[c c #2B3FB4",
"}c c #4455B7",
"|c c #4E5FBA",
"1c c #D8DCF0",
"2c c #F4F5FA",
"3c c #283CAB",
"4c c #3C4DB3",
"5c c #0D239C",
"6c c #2E41B7",
"7c c #2C3FB6",
"8c c #2E42AF",
"9c c #3447B0",
"0c c #D1D5ED",
"ac c #969FD6",
"bc c #6A78C5",
"cc c #1C31A5",
"dc c #4254B5",
"ec c #D3D7EE",
"fc c #0B229C",
"gc c #5E8461",
"hc c #BAC0E4",
"ic c #EBECF7",
"jc c #2B3FAD",
"kc c #AAB2DE",
"lc c #0B219D",
"mc c #738976",
"nc c #283CB4",
"oc c #2F42AE",
"pc c #CACFEA",
"qc c #2439A9",
"rc c #AFB6DF",
"sc c #F4F5FB",
"tc c #F7F8FC",
"uc c #CDD2EB",
"vc c #6371C2",
"wc c #0C239C",
"xc c #868E87",
"yc c #1229A1",
"zc c #0B219C",
"Ac c #939494",
"Bc c #2F44B8",
"Cc c #273BB3",
"Dc c #0B219B",
"Ec c #2D40B6",
"Fc c #0A219C",
"Gc c #0D229C",
"Hc c #0C229B",
"Ic c #0A219B",
"Jc c #528355",
"Kc c #0C219C",
"Lc c #0A209B",
"Mc c #4D8150",
"Nc c #3043BA",
"Oc c #2D41B8",
"Pc c #1930A7",
"Qc c #0B209B",
"Rc c #798A79",
"Sc c #67876B",
"Tc c #3D4FC4",
"Uc c #2A3EB3",
"Vc c #0B229D",
"Wc c #0A209A",
"Xc c #568459",
"Yc c #3649BF",
"Zc c #354ABE",
"`c c #3548BE",
" d c #2E43B9",
".d c #0C219B",
"+d c #374BC0",
"@d c #3449BC",
"#d c #09209B",
"$d c #2A3FB6",
"%d c #1A31A9",
"&d c #091F9B",
"*d c #364ABD",
"=d c #2F44BA",
"-d c #091F9A",
";d c #0A1F9A",
">d c #0B239D",
",d c #09209A",
"'d c #3A4CC0",
")d c #878D89",
"!d c #3E50C5",
"~d c #8C8E8E",
"{d c #2E42B9",
"]d c #1529A3",
"^d c #092099",
"/d c #091F99",
"(d c #6E7BCD",
"_d c #C9CEEC",
":d c #F2F3FA",
"<d c #FAFBFD",
"[d c #E6E8F6",
"}d c #A3ACDF",
"|d c #3448B7",
"1d c #5464C2",
"2d c #C9CEEB",
"3d c #EEF0F9",
"4d c #A6AFDF",
"5d c #3143B5",
"6d c #5666C2",
"7d c #D2D7EF",
"8d c #E1E4F4",
"9d c #7986CE",
"0d c #394CB5",
"ad c #F1F3FA",
"bd c #3447B2",
"cd c #162CA6",
"dd c #0B229B",
"ed c #081F9A",
"fd c #081F99",
"gd c #354ABD",
"hd c #7987D0",
"id c #B1B8E3",
"jd c #A9B1E0",
"kd c #4153BA",
"ld c #F3F4FB",
"md c #2E43B1",
"nd c #E5E8F5",
"od c #DCDFF2",
"pd c #253AAE",
"qd c #688769",
"rd c #384CBF",
"sd c #3749BE",
"td c #DEE1F3",
"ud c #828ED4",
"vd c #3245B7",
"wd c #3044B8",
"xd c #606FC7",
"yd c #F1F2FA",
"zd c #CED2ED",
"Ad c #4759BE",
"Bd c #3144B5",
"Cd c #95A0DA",
"Dd c #EEEFF8",
"Ed c #A0AADD",
"Fd c #CFD3ED",
"Gd c #3C4EB8",
"Hd c #3F51B9",
"Id c #D2D6EE",
"Jd c #97A1D8",
"Kd c #BAC0E5",
"Ld c #3245B2",
"Md c #2F43B1",
"Nd c #8490D1",
"Od c #081E99",
"Pd c #5F8662",
"Qd c #438049",
"Rd c #5666C4",
"Sd c #7E8AD2",
"Td c #A4ACDF",
"Ud c #DBDEF2",
"Vd c #5263C1",
"Wd c #3245B6",
"Xd c #FDFDFE",
"Yd c #5464C1",
"Zd c #5565C1",
"`d c #2438AE",
" e c #3447B3",
".e c #3448B3",
"+e c #CDD1EC",
"@e c #071E99",
"#e c #3A4FC2",
"$e c #4052BE",
"%e c #D4D8F0",
"&e c #2D40B3",
"*e c #2A3FB2",
"=e c #2A3EB2",
"-e c #F0F2F9",
";e c #11269F",
">e c #08209A",
",e c #4A814D",
"'e c #B9C0E7",
")e c #9FA8DD",
"!e c #7A87D0",
"~e c #4D5EC1",
"{e c #273BAF",
"]e c #868C86",
"^e c #7E8C80",
"/e c #788B7A",
"(e c #3C4FBC",
"_e c #4D5EC0",
":e c #5262C1",
"<e c #5262BF",
"[e c #2F41B2",
"}e c #4D5EBC",
"|e c #E1E3F3",
"1e c #081E9A",
"2e c #71050B",
"3e c #3348BD",
"4e c #7885CF",
"5e c #3045B7",
"6e c #5363C3",
"7e c #D7DBF1",
"8e c #A0A9DC",
"9e c #CBD0EC",
"0e c #3A4CB8",
"ae c #3B4DB8",
"be c #CCD0EC",
"ce c #8590D2",
"de c #293EB1",
"ee c #4657BA",
"fe c #D0D5ED",
"ge c #A1AADC",
"he c #3347B2",
"ie c #263AAD",
"je c #8893D2",
"ke c #071F99",
"le c #071E98",
"me c #6475E2",
"ne c #B2B9E4",
"oe c #3C4EB9",
"pe c #A5ADDE",
"qe c #3549B3",
"re c #ECEEF8",
"se c #FCFCFD",
"te c #5566BE",
"ue c #707FEC",
"ve c #5969DA",
"we c #485BCC",
"xe c #394DC2",
"ye c #384BB9",
"ze c #B6BDE5",
"Ae c #F8F8FC",
"Be c #D1D6EF",
"Ce c #717FCD",
"De c #5262C0",
"Ee c #CED3ED",
"Fe c #7C89CF",
"Ge c #2A3FB1",
"He c #A4ACDD",
"Ie c #EEF0F8",
"Je c #A2ABDC",
"Ke c #2539AE",
"Le c #3D4FB6",
"Me c #B6BDE3",
"Ne c #CED2EC",
"Oe c #5B6AC0",
"Pe c #182FA6",
"Qe c #0A219A",
"Re c #061E98",
"Se c #6D7EEB",
"Te c #6B7AE9",
"Ue c #2D43B7",
"Ve c #3749B6",
"We c #071D98",
"Xe c #4C8251",
"Ye c #337C3A",
"Ze c #687AE7",
"`e c #727FCC",
" f c #2A3EB1",
".f c #394BB6",
"+f c #B3BBE3",
"@f c #B7BEE4",
"#f c #081E98",
"$f c #071D99",
"%f c #384ABF",
"&f c #2A3DB5",
"*f c #AEB6E1",
"=f c #4D5EBD",
"-f c #0B209C",
";f c #0A1F9B",
">f c #061D98",
",f c #6676E5",
"'f c #5F70E0",
")f c #969FD8",
"!f c #FBFBFD",
"~f c #BEC4E7",
"{f c #4E5EBD",
"]f c #061D99",
"^f c #878D86",
"/f c #448047",
"(f c #327C39",
"_f c #5A835D",
":f c #578359",
"<f c #47814C",
"[f c #7786F1",
"}f c #6A79E8",
"|f c #2F43B7",
"1f c #061C97",
"2f c #878E86",
"3f c #6476E3",
"4f c #5A6CDC",
"5f c #5868D8",
"6f c #4657CB",
"7f c #818D83",
"8f c #4E8151",
"9f c #697AE8",
"0f c #3B50C3",
"af c #061D97",
"bf c #5C855E",
"cf c #6F7FEB",
"df c #4C5FCF",
"ef c #051C97",
"ff c #5E6FDF",
"gf c #061C98",
"hf c #898D88",
"if c #2F7C34",
"jf c #09219A",
"kf c #051B97",
"lf c #589B2A",
"mf c #A2C639",
"nf c #D3E344",
"of c #FCF950",
"pf c #DFE07C",
"qf c #B3BBBC",
"rf c #7D8BF6",
"sf c #5B6DDB",
"tf c #5567D6",
"uf c #364BBE",
"vf c #2035AE",
"wf c #3F7F45",
"xf c #54992A",
"yf c #95BF37",
"zf c #AECE3B",
"Af c #C6DB40",
"Bf c #D8DA86",
"Cf c #C9CE9C",
"Df c #ADB7C6",
"Ef c #A4ADD5",
"Ff c #9FA9DD",
"Gf c #3547BC",
"Hf c #051B96",
"If c #3E8E24",
"Jf c #D0D591",
"Kf c #B7BDB9",
"Lf c #A2ACD6",
"Mf c #9AA7E2",
"Nf c #8392FB",
"Of c #1B7823",
"Pf c #83B633",
"Qf c #93BE36",
"Rf c #C4DB40",
"Sf c #DDE846",
"Tf c #F5F64B",
"Uf c #CACF9B",
"Vf c #C1C8A7",
"Wf c #8290FA",
"Xf c #7A8BF5",
"Yf c #6171E0",
"Zf c #3448BE",
"`f c #051C96",
" g c #418E25",
".g c #B7D33E",
"+g c #D2D690",
"@g c #1E33AC",
"#g c #041C96",
"$g c #45804B",
"%g c #72AA2F",
"&g c #CBD09A",
"*g c #BBC2B3",
"=g c #B0B8C1",
"-g c #4758CB",
";g c #2E44B8",
">g c #3C7D42",
",g c #377D3B",
"'g c #1B781D",
")g c #9EC439",
"!g c #E7EE47",
"~g c #FEFC4D",
"{g c #F0EF62",
"]g c #D2D78E",
"^g c #C3CAA5",
"/g c #BBC3B1",
"(g c #7383EE",
"_g c #5164D4",
":g c #3F53C7",
"<g c #3F51C6",
"[g c #061E99",
"}g c #558258",
"|g c #528254",
"1g c #F2F54A",
"2g c #F8F557",
"3g c #DBDD83",
"4g c #CCD098",
"5g c #B5BEBA",
"6g c #B1B8C1",
"7g c #A8B3CD",
"8g c #384AC0",
"9g c #192DA7",
"0g c #1328A3",
"ag c #0A209C",
"bg c #CDDF42",
"cg c #FEFB4C",
"dg c #F1F062",
"eg c #E2E477",
"fg c #C0C7A8",
"gg c #495ACD",
"hg c #3448BB",
"ig c #172BA5",
"jg c #051C98",
". . . + @ # $ % & * = - ; > , ' ) ! ~ { ] ^ / ( _ : < [ } | 1 2 3 4 5 6 7 8 9 0 a b c d e f g h i j k l m n o p q r s t u v w x y z A B C D E F G H I J K L M N O P Q R S T U V W X Y Z `  ...+.@.#.$.%.&.*.=.-.;.>.,.'.).!.~.{.].^./.(._.:.<.[.}.|.1.2.3.4.5.6.7.8.9.0.a.b.c.d.e.f.g.h.i.j.k.l.m.n.o.p.q.r.s.t.u.v.w.x.y.z.A.B.C.D.E.F.G.H.I.J.K.L.M.N.O.P.Q.R.S.T.U.V.W.X.Y.Z.`. +.+++@+#+$+%+&+*+=+-+;+>+,+'+)+!+~+{+]+^+/+(+_+:+<+[+}+|+1+2+3+4+5+5+6+7+8+9+0+0+a+b+c+d+e+e+e+f+g+h+i+j+j+k+l+m+n+o+o+p+q+r+s+s+t+t+u+u+v+w+w+x+y+y+z+A+B+A+C+D+E+E+E+F+F+G+G+H+H+I+J+J+K+L+M+N+O+P+Q+R+R+S+T+U+V+W+X+Y+Z+`+ @`+.@+@@@+@+@#@$@%@&@*@=@-@;@>@,@,@,@,@'@'@)@)@!@~@{@]@]@^@/@^@/@(@_@:@<@[@}@|@1@2@3@4@",
". . . 5@6@7@8@9@0@a@b@c@d@e@f@g@h@i@j@k@l@m@n@o@p@q@r@s@t@u@v@w@x@y@z@A@B@C@D@E@F@G@H@I@J@K@L@M@N@O@P@Q@R@S@T@U@V@W@s X@Y@Z@`@ #.#+#@#B ##$#E %#&#*#=#-#;#>#,#'#)#!#~#{#]#^#/#(#_#:#<#[#}#|#1#2#3#4#5#6#7#8#9#0#a#b#c#d#e#f#{.g#h#i#j#k#l#m#n#o#p#|.q#r#s#t#u#v#w#x#y#z#A#B#C#D#E#F#G#H#I#J#K#L#M#N#O#P#Q#R#S#T#u.U#V#W#X#Y#Z#`# $.$+$@$#$$$%$&$*$=$-$;$>$,$'$)$!$~${$]$^$/$($_$:$<$[$}$|$1$2$3$4$5$6$7$8$9$0$a$b$c$d$e$f$g$h$i$j$<+<+k$2+l$2+l$l$m$4+n$7+7+o$0+a+p$q$q$c+r$s$s$e+h+g+h+j+t$u$t$l+m+v$o+o+w$q+r+x$y$u+u+v+w+w+z$x+A$y+B$z+B+B+C+C$D$D$D$E+E$F+G+F$H+J+G$I+L+H$I$J$J$J$Q+R+K$S+S+V+V+V+V+X+X+Z+L$M$N$.@O$@@@@P$P$#@%@Q$Q$-@;@R$S$>@,@T$U$'@V$)@!@W$X$]@]@]@Y$^@/@Z$(@`$[@<@[@1@1@1@ %.%+%",
". . @%@ #%$%%%&%* *%=%; -%, ' ) ;%~ >%,%'%)%!%~%{%]%^%/%(%_%2 :%<%5 [%7 8 }%|%1%b 2%d 3%f 4%5%6%N@k P@m n 7%8%9%r 0%a%u b%w c%y d%A e%f%g%h%i%G j%k%l%m%n%o%N p%q%r%s%t%u%v%w%x%y%z%Z A% .B%+.C%#.$.D%&.*.=.E%;.>.F%G%H%!.I%J%K%L%M%N%O%P%Q%R%S%T%U%V%3.W%5.6.7.X%Y%Z%`% &.&d.e.f.g.+&@&#&$&%&&&*&=&-&;&>&s.,&'&v.)&x.!&z.~&{&]&^&/&(&_&:&<&J.[&}&|&N.1&P.2&3&4&T.5&6&7&8&9&Z.0&a&b&++c&d&$+e&&+*+f&g&h&>+i&j&)+k&l&{+m&n&/+o&_+p&<+}+}+|+}+2+l$5+5+q&7+r&s&9+0+0+b+c+t&u&s$s$g+f+g+h+v&j+j+t$l+v$l+o+o+w&r+r+s+s+x$u+x&y&z&z$x+A$y+y+B$A+A+A+B+C$E+D$E$A&G+B&G+B&H+H+K+K+H$H$M+C&C&D&O+R+R+S+S+V+E&F&V+X+G&Z+ @`+N$@@H&I&J&P$J&$@&@-@-@K&;@R$R$>@L&M&N&'@'@!@W${@O&]@^@P&P&/@Q&(@_@_@_@[@|@1@1@1@R&4@R&",
". . S&T&7@U&V&W&X&b@- Y&Z&f@`&h@i@ *.*+*@*#*$*p@%*&***=*-*v@w@;*y@>*,*'*)*9 !*~*{*]*^*/*(*_*h i O@:*Q@<*n T@U@9%[*}*X@|*Z@`@1*2*3*4*B 5*6*7*8*9*0*a*b*;#>#c*d*)#e*f*{#]#g*/#(#h*:#i*j*k*l*m*n*3#o*p*q*7#r*s*t*a#b#c#u*H%f#{.g#v*i#w*x*l#m#y*z*A*|.B*C*D*t#E*v#w#x#y#z#F*G*C#H*I*J*K*L*M*#&K#N*M#O*P*Q*R*R#s.S*u.T*U*V*X#W*X*Y*Z*`* =.=+=@=#=$=%=&=*=;$==-='$;=>=,='=)=!=/$($~={=]=^=/=(=_=:=<=[=5$6$}=8$|=0$1=b$2=3=e$4=5=6=i$7=<+[+[+}+}+2+2+4+4+5+n$5+s&8+s&0+0+q$c+c+c+e+g+e+g+h+g+i+j+8=t$t$v$9=o+o+p+0=s+y$x$t+u+z&z&w+z$a=z$y+y+A+A+B+D+D+b=E+D$E$c=G+d=e=f=H+g=K+K+I$L+M+C&O+Q+O+R+S+S+h=V+V+Y+X+X+ @Z+i=`+O$+@+@+@#@$@%@%@&@-@;@K&;@j=>@,@T$'@M&'@k=k=W$~@~@]@l=l=/@^@(@_@_@[@[@m=[@|@1@ % %R&n=",
". + T&#%7@o=p=q=r=s=t=> u=' v=! ~ w=x='%y=z=~%{%q@A=} B=_%C=D=4 5 E=7 F=}%0 G=~*2%H=e I=4%J=K=N@L=P@m M=7%p N=r s O=P=Q=R=S=2*d%A T=C U=V=W=X=Y=Z=J K L `= -.-q%Q +-@-#-$-%-x%y%z%&-A%*-..=---;->-,-'-)-!-~-{->.]-^-)./-(-_-:-h#<-(.[-:.}-[.|-T%1-2.2-W%3-4-7.X%5-6-a.b.7-8-e.9-0-+&@&a-b-l.c-d-o.p.;&Q#e-f-g-h-i-x.y.j-k-l-m-n-o-p-q-r-s-t-u-v-w-N.x-y-z-A-B-T.C-6&D-E-F-G-0&a&b&H-I-J-K-L-M-N-f&O-;+>+,+j&)+P-Q-R-S-T-U-V-_+p&<+k$}+2+l$2+4+W-5+5+n$n$s&s&0+0+X-q$c+r$u&e+e+e+h+h+h+j+j+j+l+l+l+9=o+0=r+r+r+y$Y-t+u+w+w+w+w+x+B$z+z+z+B+Z-C+C+D$b=E+F+G+G+f=d=H+`-H+J+K+N+N+M+J$J$O+R+S+h= ;U+V+F&Y+Z+X+ @`+ @.@.;@@+@+@P$+;$@%@Q$-@-@@;;@>@S$,@N&#;M&'@!@W$W$]@]@P&P&^@^@/@Z$(@:@`$[@|@}@|@1@ %4@R&R&",
". S&$;7@%;&;&%* b@- d@*;f@=;h@i@j@-;+*m@;;>;,;';);s@!;~;{;];:%y@z@^;'*/;9 E@F@(;]*_;:;f _*<;[;};|;Q@R@1;T@U@9%W@s X@2;Z@w c%2*3*3;4;5;$#6;7;9*8;9;b*0;a;b;c;d;e*e;{#f;g;h;i;j;k;i*l;m;n;m*n*o;p;q;6#r;8#s;t;a#u;v;u*w;x;y;z;A;i#M%N%O%B;C;o#}.D;B*C*E;t#F;G;H;x#I;z#A#G*J;H*I*K;K*L;M*M;N;N*M#O*P*Q*q.O;P;Q;u.R;U*S;T;U;V;W;X;Y;Z;`; >.>#=$=*$&=+>@>>$-=#>$>%>,=&>*>=>->($~=;>>>,>'>)>!>:=~>{>5$]>}=^>/>0$(>_>:><>e$[>}>6=|>1>2><+[+|+1+2+l$4+4+4+n$n$s&s&0+0+0+q$0+t&c+e+f+f+f+h+v&j+t$8=t$l+3>o+0=o+w$w$s+s+y$t+z&v+w+z$w+z$x+A$B$B$z+Z-A+C+D$D$E+4>c=G+B&B&5>H+H+J+K+L+L+M+N+C&O+S+Q+S+ ; ;V+Y+F&X+X+X+L$`+`+.@@@@@+@#@$@%@%@&@&@6>;@@;j=>@,@T$L&L&'@'@7>W$X$8>]@P&^@^@/@(@(@:@<@[@m=9>1@1@ % %.%+%+%",
"@%5@#%$%U&p=0>a>s=; *;b>' g@! c>d>e>l@m@f>>;g>q@A=h>i>j>k>w@4 l>z@7 F=}%D@E@~*m>n>e o>p>5%q>N@r>s>t>u>7%p U@r v>O=w>Y@w x> #d%y>z>C A>V=W=B>C>k%D>E>F>`=G>.-q%H>I>t%J>$-w%W y%:#&-K>L>M>N>C%;-$.D%&.O>!-9#{-P>,.Q>R>S>I%{.T>^.<-U>V>:.}-W>X>Y>Z>`> ,s#.,u#+,w#5-6-@,b.c.8-#,9-0-+&L*I#$,%,c-&,*,p.=,Q#-,;,>,,,)&x.!&j-',),!,~,{,],^,/,(,_,:,}&<,[,x-},|,R.1,2,3,6&7&E-4,5,6,7,8,H-I-d&9,0,M-a,b,c,h&d,e,j&f,g,h,i,j,T-/+k,l,m,2>k$|+}+1+2+l$W-5+5+7+7+7+8+0+0+n,c+q$t&o,e+e+p,h+q,h+v&t$t$l+v$9=n+o+0=r+r,s,. . . . . . . . . . 4 t,t,t,t,t,t,t,t,t,t,t,t,t,t,t,t,t,t,t,t,t,t,t,u,. . . s,s,s,s,s,s,s,s,s,s,s,. . . t,t,t,t,t,t,t,t,t,t,t,t,t,t,t,t,t,t,t,t,t,t,t,t,. . . . s,s,s,s,s,s,v,w,1@R&.%R&R&R&",
"x,T&7@$%&;p=a@= y,d@z,f@A,) i@B,.*+*@*C,$*p@: r@**D,E,F,G,:%H,I,^;'*J,9 0 1%{*c d J@f _*h K,O@L,Q@M,n o N,V@W@O,P,u Z@`@Q,2*z 3;R,S,$#T,U,9*8;a*-#0;a;b;c;)#V,W,X,f;g;Y,i;j;k;<#j*Z,l*`, '--.'q;+'r;@'9##'$'b#v;'.H%%'&'g#*'i#j#k#O%B;y*z*='|.-'C*D*t#F;;'>','I;'')' &!'~'{'f.G#L*M*J#K#]'M#^'=&Q*q.r.P;/'u.('i-W#T;_':'<'['}'|'1'2'3'4'5'6'7'8'@>9'0'a'b'c'~$'=d'^$e'($~={=f'^=g'h'_=i'~>[=j']>}=^>/>k'l'm'n'o'e$p'q'r's't'u'[+k$v'|+|+w'4+x'5+n$y'7+s&9+0+p$c+c+t&u&u&e+z'h+q,v&i+v&t$l+A'l+v$v$o+B'w$r,s,s,C'. . . . . . . . . . D't,t,t,t,t,t,t,t,t,t,t,t,t,t,t,t,t,t,t,t,t,u,. . . s,s,s,s,s,s,s,s,s,s,s,. . . t,t,t,t,t,t,t,t,t,t,t,t,t,t,t,t,t,t,t,t,t,t,u,. . . v,s,s,s,s,s,s,. . w,2@ %R&n=+%E'",
"5@#%F'G'H'* *%s=; d@b>I'g@h@c>.*x=J'K'f>~%L'q@M'h>| _%v@w@N'5 O'7 P'Q'R'E@~*m>S'e J@4%T'q>U'L=V'W'X'7%Y'U@Z'v>a%u `'w  ).)+)@)z>#)$)%)&)B>*)=)D>-)F>;)>)d*,)r%+-t%J>$-')))!)z%&-A%~){)=-]);-^)p*/)()!-_):)P><)[)})e#|){.:-h#1)2)V>l#}-3)|-T%1-4)3.s#5)6.7.8.6)7)`%b.8)8-9)9-J*0)L*I#a)%,b)n.c)p.;&d)-,;,e)f)g)x.!&h)i)j)k)l)m)n)o)p)q)r)s)t)=$[,x-y-u)v)B-w)x)y)7&8&4,G-z)A)8,H-B)C)D)E)M-a,F)G)H)I)J)j&f,K)h,i,j,L)M)N)O)m,[+<+|+|+P)2+l$W-4+4+5+y'7+8+0+0+X-n,c+o,r$e+e+f+g+h+v&j+u$t$l+l+m+o+Q)o+q+w$r,s,s,s,s,. . . . . . . . . . u,t,t,t,t,t,t,t,t,t,t,t,t,t,t,t,t,t,t,t,t,u,. . . s,s,s,s,s,s,s,s,s,s,s,. . . t,t,t,t,t,t,t,t,t,t,t,t,t,t,t,t,t,t,t,t,t,. . . R)s,s,s,s,s,s,C'. . . w,4@R&R&S)T)U)",
"T&V)W)&;W&X)= Y)Z)*;, g@`) !.!k@,%+!@!$*~%#!$!s@!;%!1 2 :%&!*!^;'*=!9 |%-!{*;!d >!f _*,!K,j L,Q@'!n T@p 9%W@O,X@u Z@)!!!2*d%3;B C $#h%~!{!8;]!^!/!(!_!c;:!e*<!X,[!}!/#|!j;X i*l;Z,|#1!n*2!.'3!+'4!5!s;6!7!8!9!0!H%f#&'{.A;L%M%x*l#B;a!b!c!|.d!C*D*e!f!g!+,h!I;0.A#i!j!H*#,K;G#k!l!m!N;n!o!d-*,p!q.r.s.Q;q!r!i-W#T;s!t!u!v!w!x!y!z!A!4'B!6'7'8'C!D!-=a'E!S.F!'=G!^$/$Y.~=;>H!I!g'J!K!L!M!N!O!]>P!^>Q!R!S!T!n'~+e$U!V!W!X!Y!Z!<+<+`!|+l$l$l$4+4+5+n$7+7+9+0+c+c+q$o,u&e+ ~e+h+q,h+j+j+l+l+t$m+v$o+o+p+r+r+r,s,s,s,s,s,v,. . . . . . . . . . t,t,t,t,t,t,t,t,t,t,t,t,t,t,t,t,t,t,t,u,. . . s,s,s,s,s,s,s,s,s,s,s,. . . t,t,t,t,t,t,t,t,t,t,t,t,t,t,t,t,t,t,t,D'. . . s,s,s,s,s,s,v,. . . . . w, %R&R&T)T).~",
"+~$ U&p=0@@~#~; > b>f@g@! $~%~x=&~m@f>~%g>q@*~} %!=~-~D=;~l>>~,~'~}%)~E@~*!~S'e ~~{~5%]~N@^~P@/~M=(~_~U@Z'0%a%:~<~[~x  #}~3*|~f%$)1~W=2~3~4~D>-)F>;)5~p%q%6~e;t%J>7~8~9~0~:#a~A%*-M>=-2#b~c~p*/)d~e~f~0#P>u;^-})e#|)g~:-^.i#2)_.h~}-3)|-i~U%B*3.4.3-6.j~w#6)6-k~l~8)m~D#9-J*0)n~I#a)o~L#p~*,O#P#d)O;;,q~f))&V#!&r~s~t~u~v~w~x~y~z~A~r)B~C~D~E~F~y-G~v)H~I~J~y)K~L~M~G-N~O~8,P~/=J-Q~0,3$R~b,c,H)I)i&j&S~b$T~U~j,L)V~W~O)m,<+X~[+2+}+l$l$l$W-5+4+y'7+0+0+0+X-0+c+r$c+r$e+Y~g+h+h+j+j+l+l+m+m+o+o+0=q+Z~s+r,s,s,s,s,s,s,s,. . . . . . . . . . 4 t,t,t,t,t,t,t,t,t,t,t,t,t,t,t,t,t,u,. . . s,s,s,s,s,s,s,s,s,s,s,. . . t,t,t,t,t,t,t,t,t,t,t,t,t,t,t,t,t,t,. . . v,s,s,s,s,s,s,. . . . . . . w,4@R&`~+%`~T)",
" {$%&;&%X&= - ; *;.{' +{@{~ .*#{^ @!$*,;: r@s@${E,1 %{:%<%*!^;&{F=Q'*{1%{*={-{3%f p>;{i >{k l M=n ,{p 9%'{s t ){Z@R=c%2*!{3;T=C $#h%~{X={{]{^{0;/{({c;d;_{<!:{[!T /#<{W X [{Z Z,}{|{1{. . 2{+'4!3{s;E%4{>.F%0!5{f#&'6{A;7{j#8{9{:.y*o#c!T%d!C*E;t#0{g!H;h!a{''b{i!J;d.I*c{d{h.l!#&N;n!c-d-=&e{f{r.s.Q;u.g{i-h{T;i{j{k{l{m{n{o{p{q{4'r{6's{t{u{9'0'v{E!c'w{'=x{y{z{Y.A{`.B{C{g'J!D{:=M!&+*+f&}=;+E{F{S!m'G{~+H{I{V!r'J{t'u'k$[+[+|+1+l$l$3+5+4+n$n$s&0+0+0+a+c+c+s$t&e+z'z'g+h+j+j+l+t$l+l+K{o+o+p+r+s+r+r,. R)s,s,s,s,s,s,C'. . . . . . . . . . u,t,t,t,t,t,t,t,t,t,t,t,t,t,t,t,u,. . . s,s,s,s,s,s,s,s,s,s,s,. . . t,t,t,t,t,t,t,t,t,t,t,t,t,t,t,t,4 . . . v,s,s,s,s,s,s,. . . . . . . . w,R&+%+%.~.~.~",
"7@U&H'L{M{b@t=> b>N{O{P{Q{R{x=S{m@f>T{{%q@*~h>=*u@2 w@U{V{z@A@8 }%)~E@W{m>S'e X{Y{Z{;{N@`{P@W' ].]+]U@@]W@#]w>Y@$]`@ #d%%]z>&]S,V=*]=]*)-];]>],]'] -)]!]~]e;t%J>7~{]9~]]z%^]A%*-M>m*/]. . (]_]7#e~f~0#:]u;^-<]e#[]}]g#v*1)|]k#h~}-C;|-p#1]q# ,2].,F;3]w#4]I;z#5]B#6]~'9-7]0)8]I#$,%,L#p~N#O#9]Q#R#S#e)f)T*U*0]h)a]b]c]d]e]f]g]h]i]j]k]C~=$[,x-l]u)m]n]o]J~y))=L~p]q]0&r]s]H-/=t]Q~0,u]v]b,c,w]I)x]y]S~z]A]d$j,f$5=B]C]D]2><+`!|+P)1+3+3+4+5+n$n$s&E]0+0+0+q$c+o,r$e+e+z'g+q,i+j+F]u$l+m+n+o+o+o+0=0=r+x$r,. . . v,s,s,s,s,s,s,R). . . . . . . . . . t,t,t,t,t,t,t,t,t,t,t,t,t,t,u,. . . s,s,s,s,s,s,s,s,s,s,s,. . . t,t,t,t,t,t,t,t,t,t,t,t,t,t,D'. . . C's,s,s,s,s,s,R). . . . . . . . . w,R&+%E'E'.~G]",
"8@&;H]* = - ; *;.{`&) I].!.*+*'%@!$*J]: r@**${E,F,2 K]L]5 E=M]F=Q'N]1%O]={P]Q]f g h i R]k s>m n S]p N=T]s t u U]V]c%W]d%@)T=S,$#X]Y]X=H ]!Z]K L `] ^.^V,+^:{S }!v%@^#^k;$^Z Z,%^{)1{--. . %.&.&^=.6!*^>.=^'.-^!.~.{.A;;^>^x*O%:.y*o#c!,^-'C*'^t#)^;'+,8.Y%Z%!^b.~^d.#,{^G#h.]^#&^^l.M#d-=&p.;&d)-,Q;u./^(^S;T;_^:^<^[^}^|^1^2^3^4'J.4^L.5^u{6^0'7^3&c',='=G!y{z{Y.8^`.B{^=9^J!#+0^a^&+*+f&g&b^/>c^S!d^:>~+e^]+V!f^(+g^:+[+k$}+}+}+l$3+4+4+5+7+7+7+s&0+X-b+q$o,d+e+s$f+z'g+v&h^j+u$t$l+l+l+n+o+0=r+s+s+y$r,t,u,. . . R)s,s,s,s,s,s,v,. . . . . . . . . . t,t,t,t,t,t,t,t,t,t,t,t,u,. . . s,s,s,s,s,s,s,s,s,s,s,. . . t,t,t,t,t,t,t,t,t,t,t,t,D'. . . s,s,s,s,s,s,v,. . . . . . . . . . . t,i^R&n=+%.~.~G]",
"U&j^W&@~k^c@d@l^' g@P{c>{ x=m^m@n@n^o^q@p^h>| _%v@q^U{y@z@A@B@}%0 E@r^{*S'd X{(*s^;{i O@|;W'M=.]_~U@r t^u^X@Y@v^`@ #w^3*x^B y^V=7*7;z^4~;]-#,]'],#'#)#A^B^t%]#^#8~C^_#D^E^[#F^M>=-2#3#. . _]G^8#H^t*I^u;c#u*J^K^L^M^N^O^P^k#h~. . Q^R^S^T^U^V^.,u#j~W^X^Y^Z^`^. . ~'E#. . H#j. /%,. . ^'P*9]./+/@/#/$/%/&/0]X#*/=/-/;/>/,/. . '/)/k]!/~/V)#%{/]/m]H~>=x)^/K~L~//(/N~_/8,://=t]Q~</3$[/}/6$|/I)x]y]1/z]c$d$2/[>M)3/|>D]X~2>k$|+2+l$l$3+4+n$q&7+7+9+9+0+0+q$c+c+u&s$e+z'h+h+i+4/t$t$l+l+o+n+o+o+B'r+r+y$5/r,t,t,t,4 . . . s,s,s,s,s,s,s,. . . . . . . . . . 4 t,t,t,t,t,t,t,t,t,t,u,. . . s,s,s,s,s,s,s,s,s,s,s,. . . t,t,t,t,t,t,t,t,t,t,t,. . . C's,s,s,s,s,s,. . . . . . . . . . . D't,t,i^6/+%7/T).~8/",
"&;H]* r=y,; *;u=' ) ! ~ .*x=9/)%( ~%: 0/A=${a/{;2 K]4 5 >~b/F=c/0 d/e/c f/Q]g/h/5%i N@k l R@n i/p j/k/s O=l/Z@)!c%y m/n/z>C o/V=p/X=H k%^!q/r/s/t/p%V,u/R v/T U @^#^X Y Z A%%^|{1{--w/. . 4!)-x/6!*^>.F%G%y/. . . . . . z/A/:.. . B/. . . . C/5.;'D/E/. . . . . . e.c{. . l!F/$&n!. . G/-&H/. . . . . . I/J/K/L/M/. . . . . . <&J.N/O/. . . . P/Q/S.R/S/T/y{E-9&U/`.a&^=V/J!W/X/a^&+*+f&Y/Z/`/i& (.(+(Q-@(p'#(/+k,$(:+%(}+}+P)1+3+3+4+m$4+y'7+8+0+0+X-n,p$c+c+o,e+g+g+q,g+i+v&t$u$l+m+K{o+q+0=q+r+s+y$t+r,t,t,t,t,t,. . . C's,s,s,s,s,s,C'. . . . . . . . . . D't,t,t,t,t,t,t,t,u,. . . s,s,s,s,s,s,s,s,s,s,s,. . . t,t,t,t,t,t,t,t,t,4 . . . s,s,s,s,s,s,s,. . . . . . . . . . 4 t,t,t,t,i^n=T)T)8/G]G]",
"p=W&@~= &(*(Z&f@g@`)=(R{-(+*m@;(>(p@,(r@s@D,_%v@%{x@'()(,~B@!(9 E@1%{*~(e J@4%_*;{U'`{P@m M=1;+]U@@]W@a%{(Y@Z@`@1*](3*^(/(y^((7*7;&#*#D>-#;#']5~_()#A^W,{#f;g;:(<(_#:#<#K>[(n;m*])3#}(. . G^8#9#t*a#u;v;u*|(. 1(2(3(4(. 5(h~m#. . 6(7(8(9(. 0(u#v#a(. b(c(d(e(. . I*J*. . M*m!%,L#. . O#Q*f(. g(h(i(j(. @/X#k(l(. m(n(o(p(. . #=q(r(. s(t(u(v(. w(>=x(&>y(L~//($N~z(s][$/=t]!>2$~>A(}/B(}=C(D(0$a$E(c$F(e$f$5=G(C]j$<+<+[+}+1+2+3+W-5+5+H(n$s&8+9+0+X-q$c+e+d+s$e+z'g+h+g+v&u$u$l+m+K{m+o+r+w&w$s+y$s+t+r,t,t,t,t,t,t,. . . . s,s,s,s,s,s,s,. . . . . . . . . . . t,t,t,t,t,t,t,u,. . . s,s,s,s,s,s,s,s,s,s,s,. . . t,t,t,t,t,t,t,D'. . . R)s,s,s,s,s,s,R). . . . . . . . . . t,t,t,t,t,t,i^T).~T).~G]8/",
"I(* r=y,; J(K(' ) L(~ d>x=^ @!f>~%: ]%A=${| {;2 K]L]5 M(7 F=N(0 d/b c d e f h/5%q>j k O(m P(Q(p R(r S(X@u U])!x>2*d%A T(C U(V=i%X=Y=V(J /!r/M N O q%+^s%v/T v%w%W y%z%Z W( .{)X(C%w/3!. . )-=.E%:)>.F%G%R>Y(&'Z(`(O^ _. ._:.Q%. . +_@_2.#_. S&g!7.$_. %_a. &&_. . *_0-. . a-=_n!c-. . p.-_r.s.;_>_,_'_. ._z.A.)_. !_~_F.{_. . ]_6'^_. /_6^0'(_. __R/S/T/:_8&M~G-`. +C{V/J!d&<_a^M-[_F)}_;+>+i&'+|_g,l&@(]+#(1_(+_+:+}+k$}+}+|+2+l$3+5+5+7+7+s&o$2_a+p$c+c+r$r$e+z'f+f+q,j+u$j+t$l+l+v$n+o+q+0=w$y$3_x$u+r,t,t,t,t,t,t,t,D'. . . R)s,s,s,s,s,s,v,. . . . . . . . . . D't,t,t,t,t,u,. . . s,s,s,s,s,s,s,s,s,s,s,. . . t,t,t,t,t,t,. . . . s,s,s,s,s,s,C'. . . . . . . . . . 4 t,t,t,t,t,t,t,i^T)T)T)G]G]G]",
"W&@~4_- *(e@f@g@+{i@R{x=m^+!f>$*,;,(r@s@| ~;v@G,U{y@5_,*B@J,6_E@1%{*={_;J@{~s^M@K,O@P@Q@M=(~T@7_V@W@}*X@Y@[~`@1*2*!{z>B ##((X]8*&#*#=#b*,]']c*c;)#A^W,{#f;8_:(<{9_0_i*l;[(n;1!n*3#p;p*. . 8#9#a_I^b#c#0!H%b_c_. . . . . . B;n#. . d_q#C*s#. . 3]e_f_. g_5]G*h_. . J*G#. . i_%,N*j_. . Q*q.k_l_. . . . . . m_n_o_. p_q_r_s_. . k]t_u_. . . . . . v_~$^/w_!=->x_~=y_]=[$'>t]z_2$3$[=}/A_|/8$D(R!a$m'2=B_2/[>5=C_D_1><+E_}+|+P)l$l$3+4+5+5+7+7+2_0+0+0+n,c+u&s$e+e+z'f+v&v&h+u$u$l+t$v$K{o+o+w$q+s+r+t+x$t+r,t,t,t,t,t,t,t,t,t,u,. . . v,s,s,s,s,s,s,R). . . . . . . . . . t,t,t,t,u,. . . s,s,s,s,s,s,s,s,s,s,s,. . . t,t,t,t,t,. . . v,s,s,s,s,s,v,. . . . . . . . . . . t,t,t,t,t,t,t,t,t,i^.~8/F_G_8/H_",
"q=M{=%; I_J_' ) K_~ w=x='%K'L_~%: r@A=M_%!_%N_O_4 5 6 '*8 P_0 a ~*c -{>!f Q_5%i N@^~R_m  ]S]Y'j/r s a%u <~S_x  #d%@)T(C g%V=F T_{{k%U_K n%`=N p%V_r%s%W_J>X_V W y%[{Y_Z_ .{)+.`_ :.:D%. . !-E%;.>.F%G%).!.+:. @:#:$:%:. . }-[.. . U%2.&:4.. . +,X%*:. =: &-:;:. . >:+&. . $&l.c-,:. . f{':):. !:~:{:]:. . ^:{&/:. (:_:::<:. . u-}&5@. . . . . . ._C-V.[:8&4,G-6,7,.+V/@+d&K-L-M-}:f&}_|:1:i&2:)+g,h,3:j,#(/+V-_+p&[+k$k$}+4:5:W-4+5+n$n$7+7+o$o$n,c+c+u&t&r$s$e+6:h+i+i+j+F]u$u$m+K{v$o+w&w$Z~r+7:t+u+u+r,t,t,t,t,t,t,t,t,t,t,t,t,. . . v,s,s,s,s,s,s,R). . . . . . . . . . D't,u,. . . s,s,s,s,s,s,s,s,s,s,s,. . . t,t,4 . . . s,s,s,s,s,s,v,. . . . . . . . . . 4 t,t,t,t,t,t,t,t,t,t,t,i^.~T)8/8/G]H_",
"X&= - 8:9:f@g@+{0:.!-;m^m@@!$*a:%*M's@${E,v@];N'&!z@A@B@!(b:E@-!{*H@^*J@c:_*M@i };:*Q@<*d:T@e:f:g:O,X@Y@$]`@h:2*i:|~B j:k:T,~!z^*#l:-#m:(!c*n:)#_{o:{#p:g;/#<(_#0_i*[#m;n;q:n*o;w/q;r:. . s;t;7!b#c#0!w;%'s:. t:u:M%v:. . n#o#. . B*C*E;w:. . +,x#x:. y:G*J;z:. . 0)H#._. A:N*B:C:. . D:r.E:. F:g{i-G:. . H:I:J:. K:L:+=M:. . N:&=H]. O:-=P:;=Q:~${$d'=>R:S:~={=T::/U:|$V:W:3$X:j'Y:}=Z:D(0$`:m'2= <2/[>5=6=D_t'<+<+}+}+P)|+l$W-3+m$5+n$7+o$0+0+p$q$c+c+r$s$g+g+f+h+q,i+F]u$t$t$m+m+o+o+0=q+s+x$x$u+z&u+r,t,t,t,t,t,t,t,t,t,t,t,t,t,D'. . . s,s,s,s,s,s,s,. . . . . . . . . . . u,. . . s,s,s,s,s,s,s,s,s,s,s,. . . D'. . . R)s,s,s,s,s,s,. . . . . . . . . . . t,t,t,t,t,t,t,t,t,t,t,t,t,i^.~.~G]G_H_.<",
"r=s=t=*;.{+<@< !~ w=x='%m@f>~%{%$!A=} B=_%2 D=4 l>E=#<$<9 0 a ~*!~n>e I=g %<&<*<k P@m u>7%=<-<r S(a%u Y@w  )W]+)3;z>C U=V=p/X=*)I D>K n%`=N .-q%Q ;<t%#-><%-x%,<[{&-K> .M>+.C%;-$.,-&.. . -.:):],.^-'<!.)<!<. ~<{<]<^<. . [.|-. . V%3./<5.. . 8.x#(<. _<:<<<[<. . h.}<|<. 1<2<3<4<. . r.s.5<. 6<7<8<9<. . 0<a<b<. c<d<e<f<. . }&w-g<. h<i<j<k<. l<V.W.m<M~5,6,a&n<o<I-d&K-L-p<q<b,}_r<s<,+t<)+g,Q-i,u<v</+V-_+p&%(k$}+2+2+l$3+l$5+4+n$7+8+7+o$X-X-q$c+c+s$e+f+g+g+g+v&j+t$k+l+l+l+o+o+p+q+r+r+t+x$t+v+z&r,t,t,t,t,t,t,t,t,t,t,t,t,t,t,t,. . . R)s,s,s,s,s,s,C'. . . . . . . . . . . . . s,s,s,s,s,s,s,s,s,s,s,. . . . . . v,s,s,s,s,s,C'. . . . . . . . . . 4 t,t,t,t,t,t,t,t,t,t,t,t,t,t,i^.~F_8/w<H_x<",
"= y,y<*;f@' z<i@A<B<+*^ @!$*p@C<r@s@t@D<v@G,;*H,5_E<b/}%9 E@F<G<;!^*J@Y{_*,!H<>{I<Q@M,1;Q(J<9%g:K<t L<Z@V]M<w^z x^N<$)k:E U,O<0*V(^!0;>#b;P<:!Q<W,X,f;g;/#@^j;k;<#[#m;l*`,n*o;.'(]q*r;. . . . . . . . %'y;R<. . . . . . . z*S<. . C*2-t#)^. . 4]I;T<U<. . . . . . L*M*V<. . . . W<. . r.s.X<. . . . . . . W;Y<Z<`<. . . . . . &=8' [8@. . . . .[+[*>=>/$x_@[{=T::/g'(=D{0^~>X:#[$[P!8$/>R!l'%[&[*[e$4=5=6=D_=[u'r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,s,s,s,s,s,. . . . C's,s,s,s,s,v,. . . . . . . . . . . t,t,t,t,t,t,t,t,t,t,t,t,t,t,t,t,i^.~G_H_H_.<.<",
"s=c@I_b>I'@<! -[{ x=l@;[L_~%: < A=>[| _%,['[4 V{[%7 )[}%D@d/~*c S'e f 4%5%i N@r>P@m M=7%_~-<r ![a%u `'w x> #}~%]z>/(U(~[p/G {[=)D>E>L `=G>][q%H>B^^[u%v%%-W !)[{^]A% .B%=-C% :/[D%/)O>. . . . . . . . ~.{.([_[:[S^<[[[. . X>}[. . 3.4.|[u#. . 5-1[@,2[3[*:4[5[. *:]^j.6[7[8[E:9[0[. . -,f-a[b[c[d[e[f[. . g[h[i[j[k[l[m[n[. o[w-p[x-q[r[ {5@s[t[6&7&E-u[(/0&v[8,w[x[d&$+L-M-N-F)G)y[s<J)j&f,P-h,z[j,T-M)A[_+p&%(r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,s,s,s,s,s,. . . C'C'C'C'C'C'. . . . . . . . . . . u,t,t,t,t,t,t,t,t,t,t,t,t,t,t,t,t,t,i^.~8/H_.<.<B[",
"- 8:*;J_`&+{K_~ B<+*C[C,$*,;%*r@D[${E,v@2 :%y@E[^;&{F=9 N]1%{*H@d :;f _*,!i *<:*Q@M=n ,{7_9%g:s F[){v^`@Q,2*3*3;B S,$#V=U,{!0*G[^!0;a;_!c;d;e*W,X,]#g;/#|!#^k;H[l;I[%^1!1{3#.'q;6#J[8#K[t;a#u;=^'.L[!.&'z;*'7{M%x*O%B;<.[.A*|.d!M[D*t#u#N[O[h!1[z#)'G*j!P[{'Q[. R[M* /K#N*M#O*P*p.S[r.s.f-u.('i-T[T;_':'U[V[}'W[X[Y[Z[4'`[. O/8'@>9' }#>.}c'+}&>d'^$->S:~=;>T:@}g'h'z_:=M!#}$}$[Y/%}Q!&}l'm'2=*}e^p'=}W!s't'u'<+r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,s,s,s,s,s,. . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . w,G]H_H_H_-}B[",
";}> b>>}) ! Q{{ x=J';[f>o@L'q@A=,}| j>-~w@4 '}M(7 $<}%D@E@~*!~S'e g/4%5%i N@)}P@t>!}7%p U@~}S(a%{}Y@w x  #+)]}z>&]$)V=W=B>3~=)D>m%F>`=5~d*q%H>I>@-J>^}/}x%0~(}^]A% .B%N>`_b~^)D%_}()!-9#0#:]:}<}'<e#I%J%g#[}1)N%V>}}}-[.|-Y>1]q# ,|}f!6.3]1}6)6-z#2}. 3}4}5}6}. 7}I#$&%,L#&,*,8};&d)9}0}e)v.g)x.0]X#a}j)b}l)m)c}. d}e}f}g}. h}E~i}y-j}v)B-I~J~y)W.L~F-5,0&y_b&++/=C)9,0,k}a,l}G)H)m}i&y]n}o}A]z[u<L)U-W~l,D]k$k$r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,s,s,s,s,s,. . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . w,G_H_H_p}.<q}",
"r}*;J_s})  !j@.*+*^ t}$*J]: r@^%u}E,{;2 :%v}5 ^;#<J,9 !*1%G<;!d J@f g 5%i j I<l <*n w}p 9%k/s F[|*Z@V]c%x}y}3;B 5*A>T,~{O<0*V(^!q/(!_!c;d;z}<!A}B}g;Y,i;j;X Y [#Z,%^..+.C}.'q;D}4!@'x/t;4{8!=^'.H%%'y;g#A;7{M%k#O%:.y*o#='|.@_C*2-t#E};'e_h!I;0.A#F}. . . . . G}H}#&k.N*o!d-=&-&q.I}s.Q;u.R;i-J}T;K}L}M}N}w!O}P}. . . . . u_Q}R}S}0'7^b'%>,=T}x{U}X.Y.A{;>T:^='>(=D{X/M!{>$}V}W}b^Q!R!S!d^n'B_H{p'g$1_s't'u'2>}+r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,s,s,s,s,s,. . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . w,G]H_.<B[-}X}",
"d@b>+<g@! =(R{x=Y}K'f>~%p@q@M's@| u@Z}w@;~'(z@7 )[}%b:E@~*2%S'e X{4%5%;{K,O@P@`}X'7%T@U@~}0%a%:~Y@[~`@ #.#3*z>f%o/~[&)=]Y=Z==#-) |.| -.-q%H>B^{#J>^#8~9~!)z%&-A%[(M>N>])b~>-p*_}O>+|@|0#:]]-^-'<e#I%}]T>h#i##|V>l#$|W>%|p#1-q#r#4.3-6.3]w#x#7)`%&|*|=|-|;|>|,|'|I# /%&b)*&)|O#Q*Q#-,;,e)f)g)J}y.X#!|~|{|]|^|/|(|_|:|x,<|[|}|E~||y-u)v)H~1|J~2|K~3|4|G-_$O~5|6|I-7|Q~8|9|a,l}c,H)I),+y]n}z]c$z[j,L)M)W~C]0|<+[+[+r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,a|H_H_.<X}-}X}",
"*;, s}) I]~ .*#{C[t}b|J]%*c|s@${E,d|2 :%<%I,^;&{C@}%0 1%O];!e|f|g|Q_5%i R]h|Q@i|n ,{p -<r s X@2;<~`@c%W]+#3;4;S,A>X]~{X=8;]!J 0;(!M c;.^j|f*:{S k|l|@^m|k;n|Z W(%^1!1{@.w/q;D}r;)-x/E%7!8!9!'.5{Y(y;6{A;7{j#k#O%:.a!b!c!|.d!2.2-W%f!;'H;o|I;Z%@, &j!H*I*f.K*p|l!#&^^q|o!r|s|p.q.R#s.f-t|R;i-J}T;i{u|v|l{w|x|y|z|A|B|r{C|L.M.@>D!0'7^D|S.F!'=x{y{z{S:E|;>F|I!g'J!D{0^M!#}O!G|Y/;+/>k'S!T!n'*}H{]+V!H|I|t'J|X~[+v'r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,a|H_H_.<q}q}X}",
"z,f@g@z<=(R{k@J'K|f>~%o^q@&*s@=*u@v@w@L|V{z@M|P'}%)~1%r^{*S'N|X{{~_*;{H<O@P@W'M=S@O|P|Z'W@K<P=Y@w S= #}~3*z>B $)$#*]=]3~4~D>-)F>;)>)d*Q|R|;<S|T|^#8~9~0~:#&-K>[(M>N>])3#}(p*_]O>8#@|0#:]]-^-U|e#V|{.:-*'1)U>V>l#W|n#X|p#1-B* ,4..,u#v#Y|x#1[z#b.8)J;D#9-J*G#H#I#$,Z|`|p~c)O#Q*Q# 10}S*f)g)V#y..1+1@1#1$1%1&1g]*1=1r)B~t)=$-1;$;1j}>1n],1'12|y(L~4|5,N~y_>>)1!17|Q~2$k}~1l}}_H)I)x]y]{1b$T~d$]1f$V~W~C]D]%(k$k$}+r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,a|.<.<X}X}^1/1",
"u=' ) i@B,.*] '%;[$*~%: < [ ${E,{;2 :%4 *!^;&{F=9 N](1{*c d 3%f _*5%i j k Q@m n 7%p 9%r s a%L<v S_c%2*z 3;T=C $#E ~{X=8;]!J K (!_!c;_1V,f*A}:1g;<1@^#^X H[Z Z,%^|{1{--[1q;+'4!)-}16!7!8!|1'.H%Y(y;J%1121M%x*31:.y*[.X>T%1.C*41W%5.N[+,h!5-''51b.J;6171K;81h.i.#&^^n!91r|=&p!;&':s.f-u.v.g)S;T;01a1b1c1d1e1f1g1h1s-r{6's{t{R}D!0'v{.}S.F!i1x{y{X.S:j1k1f'^=V/J!#+X/e&&+l1m1n1;+Q!i&S!o1p1~+@(]+^+r'(+Y!:+<+[+}+}+r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,a|.<-}q1q}/1^1",
"f@g@r1$~R{B<l@m@#*o@g>,(s1s@!;u@v@w@;~t1z@E<$<}%6_E@1%G@S'N|J@4%s^;{u1`{|;m u>v18%U@Z'W@K<:~Y@Z@w1Q,+)3*x^C $)6*7*=]&#*#G[>],]'],#'#)#~];<{#]#x1/}(#_#y1i*z1[(A1m*n*b~c~(]q*r;B19#0#C1u;c#'<w;D1}]g#h#i#U>k#l#E1n#%|p#1]q#C*s#.,4-v#8.6)1[z#b.8)C#~'F1G10)L*j.$,%,]'p~O*H1I1R*O;J1q~f)r!U*y.X#*/K1L1M1N1O1P1Q1'/R1B~t)|&E~F~S1j}v)H~,1J~{$K~T1p]($N~_/s][$/=t]U12$V1~1W1c,X1Y1x]y]`:b$2= <2/Z1`1 2|>D]2>}+}+}+|+r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,a|H_X}X}q}q}^1",
"' ) L(~ w=e>'%@!L_~%: 0/^%} (%1 2 O_<%5 M('*F=c/0 a {*c P]J@f _*5%i >{k .2i|n 7%p -<r s a%u U]+2c%2*d%n/e%C o/@2i%X=C>]!l%K #2M N p%V,+^A}S T v%V W y%[{Z W( .{)+.--#.2{+'4!&^$2%2*^8!F%^-&2*2)<{.T>;^<-(.9{:.Q%W>S%,^d!C*2-=20{6.7.h!Y%0.!^-2~^d.e.f.0-h.@&j.$&n!c-*&=&p!q.d)-,t.t|h-)&;2T;>2,2'2)2!2~2{2]2^2/2]_4^L.(2N.6^P.2&3&S.R/_2T/y{X.:2U/`.B{C{V/c&d&X/a^&+*+m1g&;+>+c^2:d^P-<2@(m&#(1_(+[2}2<+2>k$|+1+r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,a|-}X}q}^1^1|2",
"A,`)0:R{k@J'm@f>T{p@C<s1s@u}-*v@w@4 t1z@,~)[}%9 E@F@12S'22J@Y{5%;{N@O@I<32M=v1T@7_f:W@a%X@){v^S=M<](3*|~B j:((7*7;O<*#=#42m:;)>)'#Q|~]e;{#T|8_8~(#]]0_52[#I[n;m*/]3#.'(]6#r;r*9#a_:]62c#<]H%|)y;g#11i##|k#72}-n#82p#92q#C*D*.,F;3]w#h!I;z#5]B#j!H*I*J*G#L*02a)K#N*p~c)O#Q*Q#O;;,T#f)T*V#T[X#a2b2c2d2e2f2g2h2i2j2&$N:k2-$F~l2m2m];=>=x(^/y(T1p](/N~y_>>:/}$|$Q~2$3$~15$n27$I)x]0$`:E(2= <o2f$p2G(C]D]2>[+}+}+2+2+r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,a|.<-}X}q2^1r2",
"v=! ~ %~#{'%@!$*~%: q@A=${%!s22 w@<%'(E=#<F=t2|%u2e/c d >!f v25%w2x2y2R_m n i/p U@r S(z2u Y@A2c%B2d%3;T(/(U=h%C2X={{k%D2K /{M E2F2G2H2I2S T l|J2W X [{K2Z_%^..+.-- :$.D%4!*.}1E%;.>.F%'.5{!.~.6{L2M21)N%O%P%Q%[.N2T%d!2.&:4.f!N[+,X%O2Z%!^ &~^8-#,f.>:h.]^#&b-P2&&n.*,p!;&d) 1f-u.h-g)x.y.z.Q2R2S2T2U2V2W2H.X2_,4^}&w-N.x-Y22&R.S.R/C-V.[:8&Y.G-6,7,C{Z2c&#+$+`2M-[_f&-+r<>+i& 3)+k&Q-.3+3T-r'(+_+p&k$[+k$}+}+1+r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,a|B[q}^1/1r2@3",
"r1=(j@.*S{#3C,$*p@#!p^s@u}-*v@$3;~y@>*,~B@}%9 E@r^{*S'%3J@K@_*;{N@O@:*W'M=v1T@&39%W@O,X@|**3`@!!](z @#B ##$#7*7;O<0*G[=3m:>#,#_()#A^~#-3p:x1:(|!_#:#i*l;Z,A1m*/]3#p;(]_];38#K[0#P>u;v;>3e#f#{.g#11i##|k#9{B;y*z*A*92B*C*s#e!u#;'H;4],3'3A#)36]!3F1J*G#h.M*$,%,b)p~^'P*Q*Q#O;s.T#~3T*{3T[]3Y#^3`# $.$/3r_(3$$#=k]_3&=-$@>S1-=#>;=:3~${$]$!=->($N~_/T:I!!1|$!>L!<3[=}/Y:|/8$[30$}3|32=3=e$f$5=B]C]=[2>[+k$|+|+l$l$r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,a|B[q}q}13r223",
"I]~ 33,%'%K'z=~%{%]%43${i>_%C=O_4 53^;&{F=c/6373O]2%S'Q]I=h/5%K=N@k V'm u>7%p 83r s O=u v w x>93d%n/e%C o/V=W=G C>Z=D2E> |`=N p%q%r%s%[!u%v%%-x%03[{Z a3 .{)+.b3c3/[d3&.&^=.-.e3:]|1G%R>!.(-}]T>L%<-N%[-P%y*R%}.T%d!2.2-f33-g!7.8.g36-a. &-:d.h3E#g.h.@&j.$&n!c-p~*,p.;&d)-,t.e)h-g)J}y.r~i3j3k3l3m3n3o3p3<&J.6'q3r3N.x-},z-s31,R/_2t3D-E-u[u3v3 +C{w[c&d&w3L-p<}:F)-+;+>+i&j&n}P-h,{+]+v</+(+_+:+<+E_}+2+2+|+W-r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,a|X}X}q}^123@3",
"i@R{x3+*+!f>T{J]%*r@s@t@~;v@$3;*y@5 ^;B@F=9 !*F<{*S'd J@Y{_*;{[;j |;t>M=d:T@&39%[*K<X@2;*3`@M<w^3*|~B $)$#7*y3O<0*l:420;(!z3d*d;e*W,X,]#g*:(A39_k;i*[#m;l*1!B32!p;q;6#J[3{K[t*a#u;c#0!L[%'C3g#[}7{#|x*9{W|n#%|p#|.q#D3s#e!E};'e_x#I;0.)'E3J;~'F1f.0)H#M*J#=_N*F3c)P*Q*R*O;P;S*~3R;V#S;X#G3H3Y*I3J3K3L3M3@=#=N3%=&=*=@>O3-=P3)$>=~${$d'^$z{x_Q3_/>>R3!1t]z_2$<=[=5$6$|/S3T3&}`:U32= <e$[>}>6=|>j$2>[+}+}+P)1+w'4+r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,a|q}q}^1r2V323",
"$~.*x='%)%b|~%: q@A=s@i>_%k>O_4 5 z@7 )[Q'0 E@~*c -{e I=4%5%;{N@O@P@W3 ]7%p U@r v>a%P=b%)!c%B2.#3*T=f%$)V=p/G H =)D>K L `=E2p%G2H>I>v/#-l|%-x%y%:#&-a3 .M>N>X3;-/[,-/)O>!-E%0#>.,.^-})!.Y3J%T>^.1)2)V>72Q%[.|-T%d!2.3.W%5.6.7.8.g36-`%b.~^8-e.E#>:Z3]^j.^^%,c-`3*,p.;& 4.4t.t|f)g)+4@4X##4l-$4%4o-&4q-*4<&_,u-=4w--4x-y-u)A-;4w)5&y)[:>49&G-0&7,,4H-'4d&$+L-)4N-F)}_r<>+J)'+!4g,~4i,{4T-1_N)_+m,2>k$k$|+]4l$3+W-r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,s,s,s,s,s,. . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . w,q}q}r2@323^4",
".!-;+*m@t}$*/4';&*s@!;-*v@%{:%4 z@^;B@!(6_E@1%{*H@d :;-!q@' $%7@; A=*<v1Q(N,9%W@#]X@l/Z@`@M<2*3*3;B 5*$#X]~!O<(4G[-#0;(!_!c;_4Q<W,X,:1g;/#:4j;y1i*. . l*`,B32!.'q;+'4!r*x/t;4{8!=^0!L[*2&'g#[}7{#|x*O%m#n#z*A*|.q#C*'^t#5.;'e_h!1[''F* &j!~'I*<4G#n~M* /K#]'M#d-P*Q*Q#I}s.S*q!T*V#W#X#[4}4W;|4142434 >444'5'*$54-$@>9'm2P:.}!$~$'=*>^$e'S:~=;>T:64g'(=D{:=74{>#[]>W}8$/>841=m'n'3=H{U!=}W!D_942>}+}+|+|+2+3+3+4+r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,s,s,s,s,s,. . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . w,^1/1r2@3^423",
"3304J')%f>o@p@0/A=h>%!_%N_D=4 '}z@7 P'a49 (1e/2%f/%3z@T&. . . . . . * i p q Z'W@a%u Y@w  ) #.#A z>b4D V=W=B>C>I D2K n%;) -p%q%H>I>t%#-$-%-x%,<[{&-. . M>N>`_;-/[D%&.d~!-@|0#:],.^-R>c4|)}]:-L%/.N%31:.}-n#d4e41-`>&:4.5)g!v#X%x#6-@,b.7-8-e.E#g.0)]^j.$&o~`|p~o.O#;&Q#-,f-e)h-g)x.y.z.a}f4g4~,i[],h4i4q)j4B~t)|&[,x-l]|,v)1,,1J~6&7&L~9&k40&7,.+)1c&7|9,0,l4q<F)O-|:d,i&t<!4P-h,z[{4v<M)V-l,m,[+2>[+P)}+2+l$l$5+r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,s,s,s,s,s,. . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . w,q}@3@3m423n4",
"x3+*C[@!( a:: r@D[D,E,F,];:%y@5_^;&{F=9 631%{*={d f|s=. ! ~*N@H<E@d@. #3p 9%k/s X@2;Z@`@!!2*m/3;B j:$#7*U,9*8;V(-#0;>#b;c;d;o4W,{#[!g;/#i;j;k;n|Z . . m*1{--.'q;+'J[3{x/t;a#8!v;'.H%f#y;6{A;7{M%x*9{B;C;o#S%|.-'C*&:t#5.;'7.o|,30.A#G*J;P[I*f.81p4l!#&K#]'M#O*=&p!S[d)s.T#u.T*i-T[T;q4:'r4s4}'t41'2'u44'$=v4L.8'@>9' }7^)$!$,='=d'U}e'w4j1x4B{^=g')>D{i'M!X:j'Y:P!^>/>y4z4m':> <H{4==}6=s'1>2>X~k$}+}+]42+W-4+4+r,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,a|s,s,s,s,s,. . . . . . . . . C'C'C'C'C'C'C'. . . . . . . . . . . . . . . . . . . . . . w,q}r2@323V3A4",
"x=S{m@f>~%{%0/M'h>| _%,[D=x@V{E=7 $<P_R'E@~*12S'e g/5@. B4N@`{P@m Y{. $%U@r . . &3i@5@' k .#3*z>. . !}&;,%*)4~C4D4E4T&F4G4H4H>+-t%I4J4K4L4M4N4&-A%. . O4P4Q4R4S4T4O>!-f~U4V4W4!<X4Y4Z4g~g#L%i#N%V>72`4W>|-T%1-`>r#4.5)6.v#8.Y%6-z#b.~^8-D#9-G10)n~I#$,%,c-p~)|O#P#d)-,;,e)h-g){30]z. 5.5+5@5#5$5%5z~&5R1:,q3D~[,*5y-u)A-H~T.=5y)7&L~4,5,0&7,8,H-I-t]9,L-M-a,-5c,H)d,,+t<f,z];5i,>5v</+W~l,0|<+k$k$}+l$3+l$3+5+4+r,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,a|s,s,s,s,s,. . . . . . . . . . s,s,s,s,s,s,s,R). . . t,t,t,t,t,t,t,t,t,t,t,t,t,t,t,t,t,i^r2@32323n4,5",
"+*9/@!$*J]: ]%s@D,E,d|2 O_<%I,^;B@J,a4*{1%G<={d 3%(*d@. v@};L,Q@R@n T@P|9%g:. . m@. . . 7@@]3;R,. . g@._B=8;'5. . . . . . )5!5:{~5$ . . . . {5Z Z_. . ]5. . . . ^58#s;/5(5. . . . _5:5z;A;7{M%x*9{:.a!o#X>|.<5C*E;t#f!;'Y|h!Y%[5)' &J;H*{'K;G#h.}5 /b-n!o!d-=&-&S[d)s.f-u.g{i-;2T;|515M}2535455565q{s-5'6'L.t{75D!-=a'b'!$+}S/d'8595S:~=;>f'^=g'05z_:=M!N!j'V}P!b^/>k'S!m':>~+a5b5V!1_s't'2>[+}+}+|+P)l$w'5+4+y'r,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,a|s,s,s,s,s,. . . . . . . . . . . R)s,s,s,s,s,s,s,. . . u,t,t,t,t,t,t,t,t,t,t,t,t,t,t,t,i^r2@323V3V3,5",
"Y})%f>n^c5q@&*s@| u@C=w@U{y@z@7 8 }%0 (1~*m>f/I@~~4%u2U&. W&'%D=J@S@=<U@d5e5. . *;S@f:) . | 4*B . . r@f5*)=)g5. h5i5j5k5. l5B^S|m5. n5o5p5. u_q5[(. . r5s5t5u5. v5e~9#w5. x5y5z5A5. B5].h#1)C5k#D5}-E5|-A*1-F5r#s#5)u#7.8.6)1[k~b.B#m~~'F1J*0)n~I#m!%,G5n.H5I5J5Q#R#;,e),,T*+4y.K5s~L5{|M5N5O5y~P5Q5R1B~t)|&-$;$==u)v)B-I~J~R57&3|//S5N~_/8,)1/=T5Q~U5k}[/b,c,V5d,W50$n}b$T~z[]1X5U-W~C]D]X~<+}+}+l$w'2+5+5+4+7+r,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,a|s,s,s,s,s,. . . . . . . . . . . . . v,s,s,s,s,s,s,C'. . . t,t,t,t,t,t,t,t,t,t,t,t,t,t,i^r2@323n4n4,5",
"'%@!$*a:: $!^%${a/v@2 D=<%5 ^;b/F=c/0 1%G<c P]f|f _*M@d $*W&. . . @~7 R(T]s . . _*S_!!P@. ; T=C . . u^{!8;V(^!q/Y5Z5`5 6. ._:{B}.6. +6j;k;@6Z Z, .. . #6#.3!$6. 5@s;%6&6. *6'.H%=6. -6A;7{/.;6[->6,6R%c!|.d!2.'^W%5.;'>'h!Y%'6a. &c.d.h3f.g.h.l!#&b-n!c-O**,-&q.)6!6T#u.h-i-;2~6i{u|{6]6^6n{f1/6(64'5'C|s{5^_69'0'7^3&c'R/i1G!y{z{Y.8^k1 +^=g'J!#+0^M!&+O!m1g&^>Q!c^S!o1:>~+e^:6^+W!I|t'Z!<+k$}+P)2+2+3+4+4+5+5+r,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,a|s,s,s,s,s,. . . t,. . . . . . . . . . . s,s,s,s,s,s,s,R). . D't,t,t,t,t,t,t,t,t,t,t,t,i^@3^4V3n4,5<6",
"K'f>[6{%q@*~/%| _%v@G,x@l>z@7 P'!(}6E@~*!~S'^*X{(*_*;{N@O@P@a4m@+*I_. 5 0%u^. . w>`@ #c%. #%/($). . |6*)16=#2636. . . . . . {#]#$ . 46!):#&-K>[(n;. . 56c~p*q*. . 9#0#66. . . . . . 76h#i#2)V>D5}-W>%|p#1]`>3.2]866.j~8.9.6-'35]B#m~~'9-J*0)96M*^^K#b)M#H5I5=,Q#R#;,T#06g)V#T[]3a6b6c6d6%1e6f6g6=1R1B~C~&=E~h6==u)m]n]I~i6{$K~L~//S50&_/j6k6k6k6k6k6k6k6k6k6k6k6k6k6k6k6k6k6k6k6k6k6k6k6k6k6k6k6k6k6l6l6l6l6l6l6l6l6l6l6l6l6l6l6l6l6l6l6l6l6l6l6l6l6l6l6l6l6l6l6s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,r,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,a|s,s,s,s,s,. . . t,t,t,D'. . . . . . . . . . s,s,s,s,s,s,s,. . . . t,t,t,t,t,t,t,t,t,t,i^2323V3m6,5n6",
")%$*J]: r@**${E,s22 3 L]5 ^;b/F=P_|%1%{*c -{3%f Q_5%i N@k O(<*!}o )}. W&v>P,. . Y@M<2*o6. F'C A>. . p68;]!^{q6. r6s6t6u6. . [!}!K4. v6,<$^Y_W(%^... . #.$.,-4!. . 6!$'w6. . . . . . 5@u:j#;6V>B;}-[.}.T%d!x62-t#0{N[+,h!I;6-a. &~^P[#,E#g.h.}<#&k.n!o!d-=&p.f{r.-,f-t|R;(^x.~601y6z6[^A6|^B62^C64'J.4^}&D6N.E60'F6G6S.H6U.d'y{X.Y.I6`.B{j6k6k6k6k6k6k6k6k6k6k6k6k6k6k6k6k6k6k6k6k6k6k6k6k6k6k6k6k6k6l6l6l6l6l6l6l6l6l6l6l6l6l6l6l6l6l6l6l6l6l6l6l6l6l6l6l6l6l6l6s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,r,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,a|s,s,s,s,s,. . . t,t,t,t,t,4 . . . . . . . . . R)s,s,s,s,s,s,v,. . . u,t,t,t,t,t,t,t,t,i^V323V3,5,5,5",
"C,[6g>C<&*s@=*j>v@w@;~V{z@M|B@}%9 u2J6{*;!%3J@(*J=;{7@. d t>M=n O|7%. T&a%:~. . :*1*K6Q@. f@$)6*. . &#4~G[42L6. M6_()#N6. . O6P6Q6. R6y1^][#F^M>m*. . }(p*6#O>. . t*a#S6. y5e#I%}]g#v*i##|k#h~m#n#d4p#T6q#C*s#5)u#;'w#9.I;z#b.8)m~~'9-J*0)L*I#a)K#N*M#^'H1=,Q#O;;,e)~3T*V#T[]3*/U6L1V6W6O1X6Q1Y6r)Z6t_k2*=;$;1m2m];=I~x({$)==>->($N~_/]=j6k6k6k6k6k6k6k6k6k6k6k6k6k6k6k6k6k6k6k6k6k6k6k6k6k6k6k6k6k6l6l6l6l6l6l6l6l6l6l6l6l6l6l6l6l6l6l6l6l6l6l6l6l6l6l6l6l6l6l6s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,r,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,a|s,s,s,s,s,. . . t,t,t,t,t,t,u,. . . . . . . . . . v,s,s,s,s,s,s,R). . . t,t,t,t,t,t,t,i^23n4n4,5`6 7",
".7+7@7c|A=${| {;2 K]<%5 6 7 F=N(|%a b c e|:;f _*h i .*. s=F=h|n ;{t}. ! t u . . ! ![s ) . y@D V=. . {{]!J K L6. #7$7%7&7. . T l|*7. =7-7;7. . >71{. . $.%.4!)-. . ;.8!,7. '7)7!7~7. {7j#(.9{B;y*W>X>]7@_2.^7W%3-N[7.8.Y%0.!^b.-:8-h3f.d{+&}<#&=_l./7*&*,O#q.d)s.f-u.g{(7x.T;>2_7:7<7!2~2[7]2H.s-]_:,L.t{C!E6}7z-3&4&w{'=V.y{z{9&U/`.a&n<j6k6k6k6k6k6k6k6k6k6k6k6k6k6k6k6k6k6k6k6k6k6k6k6k6k6k6k6k6k6l6l6l6l6l6l6l6l6l6l6l6l6l6l6l6l6l6l6l6l6l6l6l6l6l6l6l6l6l6l6s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,r,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,a|s,s,s,s,s,. . . t,t,t,t,t,t,t,t,. . . . . . . . . . . s,s,s,s,s,s,s,. . . D't,t,t,t,t,i^^4,5A4,5 7 7",
"n^p@C<&*s@|7D<v@2 L|y@z@,*P'}%)~E@~*{*S'd J@4%_*17u1f L{. . . . . . 7@i {(L<. . f@. . . W& )$#7*. . *#=#-#F>27. . . . . . . 8_:(3747. . . . 571!/]. . 5#6#7#e~. . a#]-6777. . . . u_87U>97h~m#07z*p#T6q#r#2]t#E}v#w#x#6-'3F*8)J;D#I*G10)L*M*m!K#]'M#*,H19]q.a7P;T#f)T*U*T[]3k(b2b7d2c7d7e7f7g7%$k]N:&=-$h7S1m2'$;=,1~$^/K~L~->($N~_/i7:/j6k6k6k6k6k6k6k6k6k6k6k6k6k6k6k6k6k6k6k6k6k6k6k6k6k6k6k6k6k6l6l6l6l6l6l6l6l6l6l6l6l6l6l6l6l6l6l6l6l6l6l6l6l6l6l6l6l6l6l6s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,r,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,a|s,s,s,s,s,. . . t,t,t,t,t,t,t,t,t,D'. . . . . . . . . . R)s,s,s,s,s,s,v,. . . t,t,t,t,i^V3,5n4,5j7k7",
"~%L'c|[ ,}%!_%2 D=l75 [%&{8 N(0 73~*c H=e f 4%5%w2N@y2i p^- #%5@* ~%L,a%u Z@. . N=f@T&'%a%g%V=m7. . n7o7K #2p7q7L6V)r7s7. . l|t7W u7v7K4w7x7y7+.C%. . %.4!)-!-. . >.|1G%z7A7W4B7C7D7j#N%_.:.y*[.E7,^@_`>'^W%f!6.7.8.Y%0.!^ &c.8-719-0-h.]^#&$&n!c-p~o.F7;&d)-,,&t|f))&x.!&r~G7H7S2I7U2V2J7K7s-J.:,L7w--4O.}7z-3&S.T.C-V.7&E-9&Z.`.M7.+V/j6k6k6k6k6k6k6k6k6k6k6k6k6k6k6k6k6k6k6k6k6k6k6k6k6k6k6k6k6k6l6l6l6l6l6l6l6l6l6l6l6l6l6l6l6l6l6l6l6l6l6l6l6l6l6l6l6l6l6l6s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,r,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,a|s,s,s,s,s,. . . t,t,t,t,t,t,t,t,t,t,t,u,. . . . . . . . . R)s,s,s,s,s,s,v,. . . 4 t,t,i^n4,5,5 7k7k7",
"p@C<r@s@t@E,v@G,x@y@)(^;B@)*b:E@F<12~(d :;4%L@M@i O@P@Q@N7S@_~7_f:W@O7{(L<v^. . 2*!{^(B j:%)T,y3O<0*G[>]0;>#c*'#)#A^W,X,P7g;8~(#h*k;i*l;[(n;1!/]3#Q7(]+'r;e~9#t;4{u;<}u*R7f#{.:-11i##|x*D5m#,6S7='|.q#r#41w:)^;'H;x#I;'3l~8)J;H*I*J*0)H#I#$,%,b)M#O*O#9]q.R#0}T#u.R;V#W#X#T7Z#U7Z*V7/3r_+=$$R1$=N:&=-$;$O3m2#>;=!$W7^/)=^$p]x_N~_/<$[$}$j6k6k6k6k6k6k6k6k6k6k6k6k6k6k6k6k6k6k6k6k6k6k6k6k6k6k6k6k6k6l6l6l6l6l6l6l6l6l6l6l6l6l6l6l6l6l6l6l6l6l6l6l6l6l6l6l6l6l6l6s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,r,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,a|s,s,s,s,s,. . . t,t,t,t,t,t,t,t,t,t,t,t,t,. . . . . . . . . . v,s,s,s,s,s,s,R). . . D'i^V3,5`6`6 7X7",
"o^q@A=,}i>_%,[w@4 5 z@7 )[N(0 (1~*c P]e o>4%J=q>N@k s>m Y7S]p U@r ![z2Z7v w . . d%n/z>C A>6;m7T_C>k%`7 8L `= -_1,)+^s%@-#-l|%-))y%.8K2W(L>{)N>`_;-$.,-&.()!-E%+8@8,.^-).!.Y3g~L2L%<-(.O%:.<.[.X>,^d!4)3.4.f!N[7.o|g3''@,b.!'8-D#E#g.+&@&j.$&%&&&d-o.p!;&d)-,f-u.f)g)J}@4r~~&#8k3l3/&$8::p3%8j4u-=4w-&8x-P.2&*81,2,C-=8W.E-4,Z.6,7,,4w[c&j6k6k6k6k6k6k6k6k6k6k6k6k6k6k6k6k6k6k6k6k6k6k6k6k6k6k6k6k6k6l6l6l6l6l6l6l6l6l6l6l6l6l6l6l6l6l6l6l6l6l6l6l6l6l6l6l6l6l6l6s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,r,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,a|s,s,s,s,s,. . . t,t,t,t,t,t,t,t,t,t,t,t,t,t,t,. . . . . . . . . . . s,s,s,s,s,s,v,. . w,n4,5`6k7k7-8",
"q@r@s@u}E,d|G,U{y@E[M|B@C@6_E@F@{*={_;f|f _*;{H<O@:*Q@N71;T@N,9%k/O,X@;8*3+2. . 3*@#B 5;$#T,8*9*0*G[-#0;>#c*c;_4Q<W,>8]#g;/#|!0~,8i*[#m;%^m*n*3#p;(]6#r;8#x/t*'8)8c#d#H%f#{.z;v*7{|]k#9{B;n#z*S<D;q#C*s#t#u#;'e_4]Y%z#A#!8J;d.E#F#K*p|~8a)N;N*o!^'P*Q*Q#O;P;{8q!R;i-S;X#]8V;^8/8J3K3(8M3_8R1&$v47'8';$9'-='$;=!$~$&>d'^$->w4~=;>T:64'>:8j6k6k6k6k6k6k6k6k6k6k6k6k6k6k6k6k6k6k6k6k6k6k6k6k6k6k6k6k6k6l6l6l6l6l6l6l6l6l6l6l6l6l6l6l6l6l6l6l6l6l6l6l6l6l6l6l6l6l6l6s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,r,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,a|s,s,s,s,s,. . . t,t,t,t,t,t,t,t,t,t,t,t,t,t,t,t,D'. . . . . . . . . . C's,s,s,s,s,s,C'w,,5n6,5k7k7<8",
"0/A=${%!_%C=O_4 5 O'7 P't20 u2~*c P]e f 4%s^&<N@L=O(W3X'7%8%U@~}v>[8P=Y@w c%. . n/z>C $)V=p/B>3~I J E>L `= -p%q%r%+-t%#-l|%-x%,<z%&-A%*-B%}8`_;-$.|8/)O>!--.;.>.:}G%).!.I%{.T>[}>^(.V>D5}-W>d4T%d!`>&:4.f!6.v#8.x#6-z#b.~^8-~'E#0-0)@&I#$&%,&&r|H5O#;&d).4t.t|h-g)x.!&r~#418!,28o-3848r-%8r)u-C~w-N.x-==z->11,2,i16&7&3|4|5,0&7,.+o<B)d&j6k6k6k6k6k6k6k6k6k6k6k6k6k6k6k6k6k6k6k6k6k6k6k6k6k6k6k6k6k6l6l6l6l6l6l6l6l6l6l6l6l6l6l6l6l6l6l6l6l6l6l6l6l6l6l6l6l6l6l6s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,r,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,a|s,s,s,s,s,. . . t,t,t,t,t,t,t,t,t,t,t,t,t,t,t,t,t,t,4 . . . . . . . . . R)s,s,s,s,s,s,a|,55858 7k7k7",
"p^s@${E,s2q^L|&!E[,*B@}%9 !*1%e/H@_;>!K@_*68i O@P@W'M=v1T@p f:78O7X@Y@Z@V]h:2*3*88B 5*$#X]98O<8;]{-#0;>#c*_(:!A^f*X,f;g;Y,<{_#y1n|j*I[n;1#n*o;w/q;D}r;8#08t;a#b#v;d#L[a8&'6{b8i#j#x*9{m#<.z*c!|.q#C*&:t#E*;'+,h!y#0.5]E3J;d.I*f.G#k!M*#&K#N*M#O*P*9]q.O;s.T#q!g{i-S;T;[4}4c8Y<142434d844#=5'v4&=8'@>e8f8#>D|!$~$T})=^$/$S:j1{=g8R3'>|$z_j6k6k6k6k6k6k6k6k6k6k6k6k6k6k6k6k6k6k6k6k6k6k6k6k6k6k6k6k6k6l6l6l6l6l6l6l6l6l6l6l6l6l6l6l6l6l6l6l6l6l6l6l6l6l6l6l6l6l6l6s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,r,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,a|s,s,s,s,s,. . . t,t,t,t,t,t,t,t,t,t,t,t,t,t,t,t,t,t,t,t,. . . . . . . . . . v,s,s,s,s,a|,5 7 7k7k7h8",
"A=${| _%k>i84 l>z@A@j8}%}6E@~*m>f/e o>4%5%;{N@k R_m  ]7%p R(r 0%[8u Y@w  )W]d%%]z>C $)V=W=G Y=Z=D>k8l8;)5~m8q%H>I>t%#-l|%-9~n8.8&-A%~)M>}8C%;-$.|8'-O>!--.0#:]<)o8R>e#I%{.T>h#<-U>V>p8}-n#|-T%1-F5q8s#5)4-3]w#x#7)!^b.-:6]71E#0-+&]^r8$&%,&&&,O*F7;&d)-,t.e)h-(7s8y.X#t8u8v8w8m)],x8y8q)]_u-}&w-[,x-l]u)R.1,I~J~y)z8L~4|A80&O~.+H-B)d&w3j6k6k6k6k6k6k6k6k6k6k6k6k6k6k6k6k6k6k6k6k6k6k6k6k6k6k6k6k6k6l6l6l6l6l6l6l6l6l6l6l6l6l6l6l6l6l6l6l6l6l6l6l6l6l6l6l6l6l6l6s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,r,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,a|s,s,s,s,s,. . . t,t,t,t,t,t,t,t,t,t,t,t,t,t,t,t,t,t,t,t,t,4 . . . . . . . . . . s,s,s,a|`6 7k7k7-8<8",
"A=${E,v@B8:%y@5 ^;&{C@P_!*1%O]={d J@f _*M@i };I<Q@M=n T@p 9%78K<X@u Z@A2c%W]z 3;B C $#V=Y]O<0*G[C80;(!z3c;:!_{f*X,f;}!/#@^j;k;i*[#k*%^`,+.o;w/q;6#r;&^s;t;7!8!D8'.H%x;y;g#A;M2M%x*h~B;y*o#}.D;B*C*'^t#0{N[Y|h!5-''A# &c.d.71f.E8L;M*#&=_n!o!d-P*p.q.d)s.F8q!T*i-W#T;s!G8H8s4}'t4I8J8K8L8B!%=54t{@>9'f8P:)$!$,='=M8U}z{x_~=;>f'64g':8K!:=j6k6k6k6k6k6k6k6k6k6k6k6k6k6k6k6k6k6k6k6k6k6k6k6k6k6k6k6k6k6l6l6l6l6l6l6l6l6l6l6l6l6l6l6l6l6l6l6l6l6l6l6l6l6l6l6l6l6l6l6s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,r,N8N8N8N8N8N8N8N8N8N8N8N8N8N8N8N8N8N8N8N8N8N8N8N8N8N8N8N8N8N8N8N8N8N8N8O8s,s,s,s,s,. . . t,t,t,t,t,t,t,t,t,t,t,t,t,t,t,t,t,t,t,t,t,t,t,. . . . . . . . . . R)s,a|,5k7h8-8P8<8",
"/%(%=~,[w@4 '}O',~B@}%0 d/~*m>n>22J@4%5%&<N@O@P@`}M=7%+]83r e5a%Z7Y@Q8`@ #d%%]z>&]U($#W=B>&#4~D>-)R8`=E2.-!]H>B^@-S8^#{]x%y%[{&-A%*-A1=-]);->-D%_]O>!-9#0#:]]-^-R>S>|)g~:-T8>^N%V>}}}-E5|-i~1-q#q84.3-4-3]w#9.6-U8V88)8-71F1G10)L*I#^^%&c-p~o.O#Q*Q# 1f-e)f)(7W8y.j-i).5+5X8m)$5Y8z~Z8r)s)q3|&E~x-l]G~v)1,I~'1`8K~>4M~(/0&7,8,)1/=T5Q~L-j6k6k6k6k6k6k6k6k6k6k6k6k6k6k6k6k6k6k6k6k6k6k6k6k6k6k6k6k6k6l6l6l6l6l6l6l6l6l6l6l6l6l6l6l6l6l6l6l6l6l6l6l6l6l6l6l6l6l6l6s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,r, 9 9 9 9 9 9 9 9 9 9 9 9 9 9 9 9 9 9 9 9 9 9 9 9 9 9 9 9 9 9 9 9 9 9 9.9a|a|a|a|a|w,w,w,i^i^i^i^i^i^i^i^i^i^i^i^i^i^i^i^i^i^i^i^i^i^i^i^w,w,w,w,w,w,w,w,w,w,w,+9 7 7k7-8<8<8",
"${(%{;2 :%<%I,[%B@C@9 63-!{*;!d >!f Q_<;i };L,V'N71;,{p 9%[*s P,u Z@)!c%2*!{3;T=C $#6;y3{!8;G[^{0;#2`]c;.^V,<!:{S k|/#V m|X n|j*W(%^1!1{@9#.3!D}4!&^x/E%7!8!=^'.L[!.{.{.A;i#M%k##9B;C;o#c!D;d!2.D*t#E*;'H;h!I;''a.G*j!d.$9f.81H#i.i_K#n!&&r|*,p!S[O;s.S*u.g{i-T[T;%9L}v|N}&9O}*9=9-94'5'v4L.M.u{6^0'7^G6c',='=x{y{X.S:~=`.H!^=;9)>>9:=M!j6k6k6k6k6k6k6k6k6k6k6k6k6k6k6k6k6k6k6k6k6k6k6k6k6k6k6k6k6k6l6l6l6l6l6l6l6l6l6l6l6l6l6l6l6l6l6l6l6l6l6l6l6l6l6l6l6l6l6l6s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,r, 9 9 9 9 9 9 9 9 9 9 9 9 9 9 9 9 9 9 9 9 9 9 9 9 9 9 9 9 9 9 9 9 9 9 9.97>V$W$W$O&]@]@^@^@^@(@Z$_@:@[@}@}@|@1@1@R&R&R&S)T)T).~.~G]8/.<X}X}X}q2^1r2r2V3^4V3,5,5n6 7 7P8-8h8,9",
"| u@2 w@x@t1z@7 B@}%9 E@r^G@S'd J@4%J=;{N@r>P@m M=(~8%U@d5W@a%:~Y@[~`@ #d%y>z>b4$)V=*]7;3~Z=D>>]R8'9>)m8Q|~]o:t%O6^#8~C^]]z%&-K>[()9=-/]!9c~(]~9O>e~f~{-:]u;^-{9e#I%g~:-v*1)U>k#72}-n#z*,^1]2.3.s#5)u#3]w#x#6-z#b.8)j!~'I*J*+&L*M*^^%,`|p~H5O#9]d)R#;,]9f)T*U*y.j-^9L5/9(9_9:9<9[9Q5r)B~=4<,-4x-==j}v)n],1x(y)y(L~//}90&y_8,[$B)|9Q~0,u]j6k6k6k6k6k6k6k6k6k6k6k6k6k6k6k6k6k6k6k6k6k6k6k6k6k6k6k6k6k6l6l6l6l6l6l6l6l6l6l6l6l6l6l6l6l6l6l6l6l6l6l6l6l6l6l6l6l6l6l6s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,r, 9 9 9 9 9 9 9 9 9 9 9 9 9 9 9 9 9 9 9 9 9 9 9 9 9 9 9 9 9 9 9 9 9 9 9.9!@W$W$~@X$]@^@]@^@Z$Q&:@(@[@[@}@m=1@1@ %.%R&`~T)T)8/.~F_H_.<.<.<q1X}r2r2@3@3V3V3n4,5,51958k729h8<8,9",
"E,_%2 3 &!5 ^;'*F=9 0 1%e/]*d e f g 68w2N@k Q@m n w}p 9%78s [8u Z@)!c%x}+#3;e%5*$#@2~{X=8;V(^!K a;_!t/.^V,f*X,[!T 39V j;,8Y Z W(%^`,+.--w/2{,-4!)-49t;7!>.9!'.&2Y(596{A;;^j#N%O%:.<.o#c!|.1.2.41t#5.;'+,8.5-''!^E3J;8-71K;g.h.l!#&K#N*&&d-P*p!q.I}-,{8u.('i-J}T;i{69<^c1^679f1/63^/2J.6'L.M.R}D!f87^E!S.F!i1x{y{X.Y.Z.`.f'^=V/J!890^`2&+j6k6k6k6k6k6k6k6k6k6k6k6k6k6k6k6k6k6k6k6k6k6k6k6k6k6k6k6k6k6l6l6l6l6l6l6l6l6l6l6l6l6l6l6l6l6l6l6l6l6l6l6l6l6l6l6l6l6l6l6s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,r, 9 9 9 9 9 9 9 9 9 9 9 9 9 9 9 9 9 9 9 9 9 9 9 9 9 9 9 9 9 9 9 9 9 9 9.9W$W$W$]@{@]@]@^@99Z$(@(@:@<@}@09091@4@4@R&R&S)E'E'.~G]H_H_.<.<B[X}q2r2@3@3@323a9`6,5`6 7k7-8-8<8b9,9",
"E,v@w@4 y@z@7 $<}%D@E@~*12S'%3J@{~Z{;{K,)}P@W3M=7%+]U@~}W@a%X@Y@[~`@ #w^3*^(/($)%)7*=]9**#=#>]F>'],#'#)#R|e;S|p:^#8~C^c9:#a~d9F^)9=-e93#}(p*_]O>r*@|0#P>u;^-u*e#I%{.g#[}i#U>V>l#}-3)|-p#T64)q8s#f96.v#w#6)g9z#)'B#8-~'9-F#G#L*j.a)%,b)p~N#O#Q*q.9};,e)f)g)V#y.]3a6h9i9j9k9l9g]m9n9r)k]t)k2-$x-;1,$m];=I~o9^/K~=>4|q]p9z(8,)1I-t]!></q9a,j6k6k6k6k6k6k6k6k6k6k6k6k6k6k6k6k6k6k6k6k6k6k6k6k6k6k6k6k6k6l6l6l6l6l6l6l6l6l6l6l6l6l6l6l6l6l6l6l6l6l6l6l6l6l6l6l6l6l6l6s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,r, 9 9 9 9 9 9 9 9 9 9 9 9 9 9 9 9 9 9 9 9 9 9 9 9 9 9 9 9 9 9 9 9 9 9 9.9W$W$X$8>]@]@^@Q&/@(@(@(@:@[@m=}@1@r94@4@+%R&E'T)T).~G]H_-}.<X}X}q}^1r2r2m423a9n4,5`6j7k7<8P8-8<8<8s9",
"1 2 O_4 5 E=&{F=N(|%73e/c d Q]f p>h w2O@k V''!n T@J<9%r s O=u Z@+2c%y d%3;R,C $#6;i%X=8;V(J m%#2M N d;V,f*s%S T v%w%W X [{Z m;%^`,+.--c3.:,-&.5!x/-.4{8!,.G%5{!.&'{.11;^t9N%O%:.y*[.X>T%d!C*E;4.5.6.H;h!I;0.!^G*c.d.71f.0-p|}<#&$&u9c-d-*,p!q.r.-,{8u.h-i-J}!&01v9w9c1x9y9z9]2A9B|J.6'L.t{75D!B9C93&4&T.C-D9y{z{S:Z.k1 +^=w[J!#+0^M!&+*+j6k6k6k6k6k6k6k6k6k6k6k6k6k6k6k6k6k6k6k6k6k6k6k6k6k6k6k6k6k6l6l6l6l6l6l6l6l6l6l6l6l6l6l6l6l6l6l6l6l6l6l6l6l6l6l6l6l6l6l6s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,r, 9 9 9 9 9 9 9 9 9 9 9 9 9 9 9 9 9 9 9 9 9 9 9 9 9 9 9 9 9 9 9 9 9 9 9.9W$W$~@{@]@Y$^@Q&Z$_@_@[@[@}@E9|@1@1@R&R&n=E'T).~.~8/G]H_.<X}B[q}/1q}^1@3^4@3A4n4,5j7k7k7-8h8h8<8<8,9",
"k>q^N'y@z@,~)[}%D@E@~*{*S'e J@4%s^;{U'O@I<`}M=7%T@P|d5W@u^Z7Y@v^`@o6d%3*4*B $)$#F9G9*)4~H9-);#;)5~'#I9R|e;-3p:^#:(<(]]:#52[#[(A1=-`_J9}(p*_]d~e~f~t*'8b#c#u*e#%'{.g#111)K9V>l#}-n#|-p#D;F5M[2]t#)^L9w#4]y#0.)'8)j!D#I*K;G#n~M*$,K#N*p~^'O#P#Q#R#;,q~q!M9M9M9M9M9M9M9M9M9M9M9M9M9M9M9M9M9M9M9M9M9M9M9M9M9M9M9M9M9M9w,w,w,w,w,w,w,w,w,w,w,w,w,w,w,w,w,w,w,w,w,w,w,w,w,w,w,w,w,w,a|a|a|a|a|a|a|a|a|a|a|a|a|a|a|a|a|a|a|a|a|a|a|a|a|a|a|a|a|w,l6l6l6l6l6l6l6l6l6l6l6s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,r, 9 9 9 9 9 9 9 9 9 9 9 9 9 9 9 9 9 9 9 9 9 9 9 9 9 9 9 9 9 9 9 9 9 9 9.9X$8>]@]@P&P&^@/@Q&(@_@`$[@|@m=|@2@2@4@R&`~E'.~.~G]8/H_.<B[-}B[X}/1r2r2@3@3n4,5,5,5j7k7-82929<8<8b9N9",
"2 3 v}5 >~b/F=P_0 1%b c P]e f h/5%6%R]k s>m n ,{p N=78s O=u Z@S_c%B2+#]}e%C D V=W=G H ]!J K (!M O9O V,+^:{S T v%J2W X (}P9A%%^|{+.C%w/$.,-4!&^!-E%;.Q9F%'.-^!.&'J%T>L%R9N%[-:.a![.S%T%@_4)&:t#f!g!7.o|O26-a. &~^d.71f.0-Z3]^j.$&n!&&r|=&p.;&': 1Q;u.h-S9S9S9S9S9S9S9S9S9S9S9S9S9S9S9S9S9S9S9S9S9S9S9S9S9S9S9S9S9S9. . . . . . . . . . . . . . . . . . . . . . . . . . . . . . s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,w,l6l6l6l6l6l6l6l6l6l6l6s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,r, 9 9 9 9 9 9 9 9 9 9 9 9 9 9 9 9 9 9 9 9 9 9 9 9 9 9 9 9 9 9 9 9 9 9 9.9T9X$]@P&^@U9/@(@(@(@[@[@[@9>|@1@ %R&4@+%+%`~.~T)8/8/V9.<B[-}X}q}q}1323V3n4V3,5`6,5`6k7-8X7<8<8W9,9X9",
"w@U{y@z@^;B@)*6_E@-!{*~(^*J@{~J=;{i O@|;/~M=.]T@e:r W@}*{(2;Z@`@o6d%z 3;B y^((7*7;&#*#G[-#F>>#c*c;)#Q<o:{#p:^#:((#Y9:#&-[#[(n;=-/]3#}(p*6#r;8#Z9t;I^]-v;u*`9Z4{.g#b8i##|x*h~$|n#%|p#Z><5D341t#)^v#H;h!,3z#5]G*J;!39-F#G#n~~8a)%,L#p~O*P* 0Q#R#0}/'f)R;S9S9S9S9S9S9S9S9S9S9S9S9S9S9S9S9S9S9S9S9S9S9S9S9S9S9S9S9S9S9. . . . . . . . . . . . . . . . . . . . . . . . . . . . . . s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,w,l6l6l6l6l6l6l6l6l6l6l6s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,r, 9 9 9 9 9 9 9 9 9 9 9 9 9 9 9 9 9 9 9 9 9 9 9 9 9 9 9 9 9 9 9 9 9 9 9.9W${@]@]@U9^@^@Z$(@(@_@<@[@|@1@2@ %4@.%R&T)E'7/.0G_G].<B[B[B[X}q}|2m4232323V3,5,5`6k7X7-8X7<8,9s9W9+0",
"K]4 5 O'7 F=a40 1%O]!~P]e X{g 5%w2N@L=P@m n Q(p j/r ![[8Z7b%V]c%x}d%%]e%C $)V=F B>Y=I J K L M N O q%r%s%@-T l|V W y%z%P9Z_ .B%+.b3;-$.%.@0*.$2E%*^8!F%^-R>#0&'{.T>L%<-N%9{P%<.[.|-T%-'2.&:4.5.g!7.X%5-6-!^ &c.8-h3f.>:+&}<I#^^l.&&*&*,p!;&I}!6f-$0v.(7S9S9S9S9S9S9S9S9S9S9S9S9S9S9S9S9S9S9S9S9S9S9S9S9S9S9S9S9S9S9. . . . . . . . . . . . . . . . . . . . . . . . . . . . . . s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,w,l6l6l6l6l6l6l6l6l6l6l6s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,r, 9 9 9 9 9 9 9 9 9 9 9 9 9 9 9 9 9 9 9 9 9 9 9 9 9 9 9 9 9 9 9 9 9 9 9.9~@O&^@^@/@/@(@_@_@_@<@[@m=E91@1@.%R&R&R&T)T).~G]G]G].<.<-}X}q}^113@323V323n4,5,5k7k7k7X729<8s9%0W9&0",
";*y@z@^;B@C@R'E@~*{*={I@J@g|_*5%H<O@I<Q@M=S@O|P|V@W@}*X@Y@w +2 #K63*@#B 5;~[7*y3O<0*G[=3;#.|,#c;)#Q<e;{#]#g;8~|!_#k;i*[#F^A1m*B32!p;q;_]7#8#9#t*'8b#c#>3`9%'{.g#*'i#j#x*O%}-n#o#A*D;B*C*2]5)u#;'w#x#I;z#)'B#j!D#{'J*G#L;M* /N;N*M#d-P*9]S[O;0}S*~3g)V#S9S9S9S9S9S9S9S9S9S9S9S9S9S9S9S9S9S9S9S9S9S9S9S9S9S9S9S9S9S9. . . . . . . . . . . . . . . . . . . . . . . . . . . . . . s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,w,l6l6l6l6l6l6l6l6l6l6l6s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,r, 9 9 9 9 9 9 9 9 9 9 9 9 9 9 9 9 9 9 9 9 9 9 9 9 9 9 9 9 9 9 9 9 9 9 9.9X$]@P&^@^@Q&Z$_@_@`$[@}@}@1@1@1@R&+%+%E'`~.~8/8/G]H_.<X}q}q}^1^1r2r2V3a9n4,5,5 7k7k7X7<8<8W9b9N9N9*0",
"4 '}E==0)[9 0 73e/2%H=e f B45%i x2y2P@m Y7w}Y'-<r 0%a%u `'w c%W]d%y>e%f%D V=W=X=H =)J K L -0N p%q%;0I>S S8$-t7W !)[{&-A%L>{)+.>0;-.:,-&.*.!-E%;.Q9F%^-R>c4(-_-:-^.<-N%,0:.}-[.X>,^U%`> ,W%5)6.3]8.6)''!^b.!'d.71E#0-0)i.a-^^%&c-*&o.p!=,r.'0S#u.,,g)+4S9S9S9S9S9S9S9S9S9S9S9S9S9S9S9S9S9S9S9S9S9S9S9S9S9S9S9S9S9S9. . . . . . . . . . . . . . . . . . . . . . . . . . . . . . s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,w,l6l6l6l6l6l6l6l6l6l6l6s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,r, 9 9 9 9 9 9 9 9 9 9 9 9 9 9 9 9 9 9 9 9 9 9 9 9 9 9 9 9 9 9 9 9 9 9 9.9{@]@^@^@^@Z$Q&(@`$<@[@}@m=1@.%1@.%R&+%E'U))0.~G]G].<H_X}q}^1q}r2r2@323V3,5,5n6,5k7-82929<8,9s9W9N9*0",
"l7I,E<B@/;9 *{J6{*S'd f|K@_*68u1O@:*Q@'!v1T@J<9%g:}*X@;8$]V]Q,2*i:@#B y^((X]98O<*#l:-#;#>#`]c;)#Q<f*X,B}g;Y,@^j;!0i*j*m;|#1!B33#p;(]D}r;3{K[a_'8b#=^0!H%f#&'g#*'i##|k#h~B;,6o#}.|.q#C*2-t#)^j~+,h!1[0.A#E3c.d.I*J*G#L;~8#&%,L#M#O*=&p!S[R#s.S*u.R;+4V*S9S9S9S9S9S9S9S9S9S9S9S9S9S9S9S9S9S9S9S9S9S9S9S9S9S9S9S9S9S9. . . . . . . . . . . . . . . . . . . . . . . . . . . . . . s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,w,l6l6l6l6l6l6l6l6l6l6l6s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,r, 9 9 9 9 9 9 9 9 9 9 9 9 9 9 9 9 9 9 9 9 9 9 9 9 9 9 9 9 9 9 9 9 9 9 9.9]@]@P&/@Q&Z$_@(@[@[@}@}@|@ % % %.%6/E'E'.~.~F_G_H_X}-}q1q}/1^1^1V3@3n4n4,5 7 7`6k7P8h8<8,9,9%0N9*0~0",
"5 >~7 8 }%0 1%~*. . %3f B45%&<N@`{V'. . 7%+]. . ![[8u Z@w w1W].#3*z>C $)V=W=B>*)k%D>-)L `=N .-q%H>s%t%#-></}9~,<[{&-a3 .{)+.`_;-{0|8/)O>$2_)+8@8,.<}R>#0I%}]T>h#1)2)V>:.a![.d4,^]02. ,4.5)g!v#8.x#^0'3b.-:/071E#G10)]^a-$&%,c-d-*,O#;&Q#.4f-q~h-)&x.(0S9S9S9S9S9S9S9S9S9S9S9S9S9S9S9S9S9S9S9S9S9S9S9S9S9S9S9S9S9S9. . . . . . . . . . . . . . . . . . . . . . . . . . . . . . s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,w,l6l6l6l6l6l6l6l6l6l6l6s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,r, 9 9 9 9 9 9 9 9 9 9 9 9 9 9 9 9 9 9 9 9 9 9 9 9 9 9 9 9 9 9 9 9 9 9 9.9]@P&U9^@Q&Z$_@<@<@<@0909|@1@2@R&+%n=E'.~T)G]8/_0H_-}.<X}X}q}r213@323A4,5:0,5k7k7<029h8<8s9W9N9N9*0[0",
"z@E<'*F=9 }0~*{*. . /*{~B45%i O@L,Q@. . i/p . . s t l/v^`@c%2*!{^(R,##$#7*7;O<8;G[-#0;a;b;c;.^_{f*X,]#g;/#<{_#k;n|l;k*l*`,B32!p;q;6#r;@'x/t;4{8!9!'.H%%'{.g#b8i#U>k#l#B;,6o#}.|.1.C*E;t#)^;'O[,'a{''a.i!j!d.I*<4G#L;}5 /K#P2o!d-|0p!q.O;;,T#u.h-i-W#T;S9S9S9S9S9S9S9S9S9S9S9S9S9S9S9S9S9S9S9S9S9S9S9S9S9S9S9S9S9S9. . . . . . . . . . . . . . . . . . . . . . . . . . . . . . s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,w,l6l6l6l6l6l6l6l6l6l6l6s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,r, 9 9 9 9 9 9 9 9 9 9 9 9 9 9 9 9 9 9 9 9 9 9 9 9 9 9 9 9 9 9 9 9 9 9 9.9l=l=/@/@(@10`$_@`$[@09|@r91@r9R&R&+%E'8/.~8/w<H_-}.<20X}X}r2^1@3@3a9n4n4,5 7 7k7-8h8<8%0W9N9N9*0[030",
"z@7 $<}%)~a e/12. . X{4%5%q>N@L=R_W3. . p j/Z'W@a%Z7Y@w `@ #w^3;z>b4$)V=*]G C>40D>E> |;)5~)]q%6~I>t%#-^}/}9~y%z%^]a3~){)}8]);-$.p*_]d~!-@|+8:]]-^-R>e#I%}]:-L%R9(.V>D5}-[.X>,^1-2.2-4.5)6.7.w#O26-U8b.~^8-h39-0-+&@&j.^^%&&&*&c)F7;&>&9}f->,q!g)U*0]]3S9S9S9S9S9S9S9S9S9S9S9S9S9S9S9S9S9S9S9S9S9S9S9S9S9S9S9S9S9S9. . . . . . . . . . . . . . . . . . . . . . . . . . . . . . s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,w,l6l6l6l6l6l6l6l6l6l6l6s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,r, 9 9 9 9 9 9 9 9 9 9 9 9 9 9 9 9 9 9 9 9 9 9 9 9 9 9 9 9 9 9 9 9 9 9 9.9]@^@/@/@Z$(@<@[@[@m=091@1@R&R&R&R&n=.~50.0G]H_H_.<.<X}^1q}r2r2V3^4V3V3,5n6 7k7k7-829<8<8,9X9N9&0[060",
"^;B@F=9 !*F@{*c . . f v2179 *;5@b>68. . N,R(. . X@L<70.]9/7@$%@!K<5*g%T,. . 80906@00a0b0c0K4d0e0:{[!k|f0g0l5K4h0i0j0l*k0l0--Q73!%.r;)-08#'a#8!m00!H%%'{.J%11;^M%(.9{>6<.o#}.D;B*C*2]t#u#;'e_h!y#0.A#B#J;d.{'c{81h.M*m!K#P2o!r|=&9]q.r.P;t.u.g{V#T[T;n0S9S9S9S9S9S9S9S9S9S9S9S9S9S9S9S9S9S9S9S9S9S9S9S9S9S9S9S9S9S9. . . . . . . . . . . . . . . . . . . . . . . . . . . . . . s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,w,l6l6l6l6l6l6l6l6l6l6l6s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,r, 9 9 9 9 9 9 9 9 9 9 9 9 9 9 9 9 9 9 9 9 9 9 9 9 9 9 9 9 9 9 9 9 9 9 9.9^@^@Z$/@10_@[@[@[@091@1@R&R&R&+%R&T)T)8/8/H_H_.<-}X}q}q}r2@3@3^4n4n4,5,5 7 7k7h8<8<8,9,9W9N9&0[0[060",
"7 )[}%)~G=W{!~S'. . 4%Z{o0#%. . . g@. . U@r . . {(`'U@p=. . . . * `@%)&). . p0. . . q0r0. . . s0t%J>t0. . . . . . u0n;v0`_J9{0p*_]d~!-9#0#P><)^-<]e#I%g~:-h#1)N%V>h~m#3)%|i~Z>B*3.2].,4-7.w#Y%1['3l~B#6]D#9-g.+&n~I#$&%,b)p~c)O#=,Q#.4;,t|f)T*U*y.z.i)S9S9S9S9S9S9S9S9S9S9S9S9S9S9S9S9S9S9S9S9S9S9S9S9S9S9S9S9S9S9. . . . . . . . . . . . . . . . . . . . . . . . . . . . . . s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,w,l6l6l6l6l6l6l6l6l6l6l6s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,^@w0Z$(@:@(@<@[@[@1@1@1@ %R&R&+%E'T).~8/.~H_H_B[B[X}q}r2|2@3@323V3n4,519 7k7k729<8<8,9N9N9+0~0[0[0x0",
"#<F=9 *{1%G<H@d . . _*5%m@. b>5%Z{*;. . 9%g:. . u Z@s@. ! a%X@z<. v@X]U,. . y0z0A0. #%B0C0D0. j^]#E0F0. G0H0I0J0. K0`, '--w/3!,-r;5!x/t;;.>.9!L0H%%'&'g#A;;^M%;69{B;<.[.p#|.q#C*'^M05.;'H;h!Y%''!^ &J;d.#,f.G#h.}<#&k.n!/7*&N09]D:d)s.{8u.r!i-W#~6i{O0S9S9S9S9S9S9S9S9S9S9S9S9S9S9S9S9S9S9S9S9S9S9S9S9S9S9S9S9S9S9. . . . . . . . . . . . . . . . . . . . . . . . . . . . . . s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,w,l6l6l6l6l6l6l6l6l6l6l6s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,r,F&X+X+Y+X+L$i=N$N$.@+@+@#@P0J&%@%@-@-@6>;@R$,@,@,@U$'@7>'@!@W$X$~@]@l=]@/@/@Z$(@(@<@<@[@[@1@1@1@r94@+%E'`~T)T)F_H_G]-}X}X}q}X}r2@3r223V3n4n4,5,5j7k7k729<8<8%0N9N9N9*060[0Q0",
"B@}%)~G=-!m>S'I@. . J=;{@~. ~*t>u>{*. . Z'e5. . b%w - . W'y>|~n . ; &)=]. . R0S0T0. . U0q%V0. . P7^#/}x%W0X0Y0Z0. ._=-`_;-c~p*_]d~!-9#0#:]u;^-u*e#%'{.:-L%i#2)V>p8$|C;|-p#D;V%3.W%3-u#v#w#x#,3'3b.B#6]~'E#`0+&@&I#$,%,N*p~H5O#=,Q#9};,S*q!g)V#0]r~ at~S9S9S9S9S9S9S9S9S9S9S9S9S9S9S9S9S9S9S9S9S9S9S9S9S9S9S9S9S9S9. . . . . . . . . . . . . . . . . . . . . . . . . . . . . . s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,w,l6l6l6l6l6l6l6l6l6l6l6s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,r,W+W+Y+X+.aL$`++a@@.@+@P$P$#@$@@a&@-@K&K&>@R$,@>@,@'@'@'@7>7>W$]@]@]@P&/@/@/@(@_@`$`$[@E9m=E94@2@R&R&6/`~T).~8/8/G]G].<-}q}X}^1r2@3@3#an4n4,5`6j7 7k72929<8s9b9W9N9&0[0Q060Q0",
"F=c/!*1%~*c P]f|. . M@i T&. L=R@n m . . T]s . . Z@+2T&. .)3;T=z>. T&Y]{!. . $aq/r/. . p%V,f*. . }!Y,%a&a. . . . . . l0@.*a$.,-r;3{x/=a$'b#F%'.L[Y(&'6{A;;^/.N%O%P%y*o#}.|.d!2.2-4.f!;'+,h!5-0.a.b.!'H*#,f.81p4~8i_$&P2o!d-=&p!q.d)s.F8u.R;i-W#~6_^u|b1S9S9S9S9S9S9S9S9S9S9S9S9S9S9S9S9S9S9S9S9S9S9S9S9S9S9S9S9S9S9. . . . . . . . . . . . . . . . . . . . . . . . . . . . . . s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,w,l6l6l6l6l6l6l6l6l6l6l6s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,r,-a;aX+X+Z+L$`+>aN$+@@@P$P0J&%@&@&@&@K&;@>@,@,@L&'@L&M&,aW$k=O&]@]@]@U9^@Q&Q&Z$_@[@[@}@m=m=1@ %R&R&+%R&`~.~.~8/G]H_p}.<B[q}q}r2^1@3@3V3,5n4,5,5 7k7X7k7<8<8,9N9N9+0*0[030Q0'a",
"}%D@E@W{o0S'_;J@. . ]~K,#%. P@ ].].]. . W@u^. . w x>T&. 2*88&]z>. T&=]*). . -) |']. . !]R|B^. . g*/})a. !a~a{a]a. . e9J9c~p*^ad~e~9#0#P><)c#<]e#I%{.:-[}R9#|V>l#}-W>|-A*1-B*r#4.5)/av#w#6)y#'65]B#m~~'(ag.+&L*I# /K#N*p~c)O#Q*Q# 1;,S*q!g)V#T[X#_aU6i9S9S9S9S9S9S9S9S9S9S9S9S9S9S9S9S9S9S9S9S9S9S9S9S9S9S9S9S9S9S9. . . . . . . . . . . . . . . . . . . . . . . . . . . . . . s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,w,l6l6l6l6l6l6l6l6l6l6l6s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,r,X+X+X+ @L$ @N$N$:a@@+@#@$@$@%@%@-@K&K&j=S$,@,@M&'@M&)@)@k=W$T9{@{@^@<a^@/@Q&(@`$[@<@}@1@|@1@1@3@+%R&+%E'T)8/8/H_H_H_-}X}q}/1/1@323^4V3n4,5,5k758k7h8<8<8<8,9N9N9*0*030Q0Q0[a",
"9 0 1%e/c -{f|f . . 6%R]= . ~*n ,{o>. . s t . . A2c%- . M=R,C S]. ;}X=H . . K n%M . . V_+^s%. . l|V }a. |aZ Z_1a. . C%*a3!,-&.)-x/-.7!8!F%'.&2!.I%g#K%^.t9N%9{B;y*o#S%|.d!2.2-t#5.N[7.8.Y%Z%!^G*c.8-e.f.>:+&]^a-N;l.M#d-*,p!q.)6.4Q;>,h-i-h{~62a:^z63aS9S9S9S9S9S9S9S9S9S9S9S9S9S9S9S9S9S9S9S9S9S9S9S9S9S9S9S9S9S9. . . . . . . . . . . . . . . . . . . . . . . . . . . . . . s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,w,l6l6l6l6l6l6l6l6l6l6l6s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,r,F&X+X+ @Z+N$N$+@+@.@P$P$$@%@%@Q$-@-@;@j=S$S$M&L&M&7>'@W$!@~@~@{@{@U9^@^@Q&Q&(@<@`$}@[@[@1@r9r94a+%E'T)T)T).~G]G]-}-}X}X}X}q}@323@3V3n4A4`6,5k7k7k7X7h8,9W9W9N9+0*0*0*0605aQ0",
"b:E@~*{*S'22J@c:. . i O@p@. *;w2`{g@. . u^{}. . `@ #| . @{Y@$]! . d|z^4~. . F>>#5~. . Q<e;>8. . 8~<(6a. 7a8a9a0a. . b~c~aa_}7#8#9#a_P>u;c#U|e#|){.g#v*i#U>V>h~m#r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,r,. . . . . . . . . . . . . s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,w,l6l6l6l6l6l6l6l6l6l6l6s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,r,X+X+ @L$L$N$@@.@ba+@P$#@$@&@&@-@K&-@R$R$>@,@,@'@'@'@W$7>W$~@X${@P&U9^@/@(@(@<@<@[@[@m=1@r9.%.%R&E'E'T)T)F_H_G]H_H_-}X}q}^1|2r223V323,5,5`6 7k7k729h8<8<8W9+0&0*0*0ca[0Q0da'a",
"0 (1(;c e|e f _*. . *<k 17&;. . . R{. . a%u . . x>y a%p=. . . . W&eaY=I . . r/M N . . r%:{S . . V W =7. . . . . . . #.3!,-&.)-=.=a;.>.:}^-L[!.&'6{A;L%j#N%O%:.`4fagagagagagagagagagagagagagagagagagagagagagagagagagagagagagagagagagagagagagagagagahahahahahahahahahahahahahahahahahahahahahahahahahahahahahahahahahahahahahahahahahahahahahahahahar,. . . . . . . . . . . . . s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,w,l6l6l6l6l6l6l6l6l6l6l6s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,r,X+L$ @ @`+N$.@@@+@+@$@$@$@-@-@-@;@K&>@>@>@L&,@N&'@'@,aW$X$8>O&P&<a^@/@(@Q&_@<@<@[@[@1@1@1@.%R&R&E'T)T).~.~8/G].<.<-}B[q}r2|223232323,5n6k758k7h8X7h8<8,9N9&0ia*0*0*0x0Q0[aja",
"E@r^G@]*%3J@4%_*. . O@|;t>J@' 5@f@l . . X@2;. . M<2*3*k/@!$%7@$*ka&#*#;]. . .|c*'#. . W,-3la. . 9~0~mana}aB7oapa. . }(q;q*G^r*9#t*'8u;c#<]w;%'{.:-v*7{2)k#l#}-C;fagagagagagagagagagaqagagagagagagaqagagagagagagagagagagagagagagagagagagagaqagagagahahahahahahahahahahahahahahahahahahahahahahahahahahahahahahahahahahahahahahahahahahahahahahahahar,. . . . . . . . . . . . . s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,w,l6l6l6l6l6l6l6l6l6l6l6s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,r,Z+ @.a`+N$N$.@+@P$P$J&$@Q$-@&@-@K&R$R$ra>@M&'@'@V$'@W$X$X$]@P&l=Y$/@Z$Q&_@(@<@[@[@E9|@1@ %R&R&`~E'T)T).~8/G]H_.<X}X}^1q}r2@3@3V3V3n4,5,5n6 7k7P8h8,9W9W9,9N9*0[0[060x0sa5asa",
"G=G<o0S'3%f p>5%6%x2k s>m n Q(p 9%'{W@a%u `'w tay d%A z>C g%V=p/G H ]!D2K #2uaN p%P +^s%S #-v%%-W ,<[{&-a3L>)9+.>0[1$.D%4!va}1E%e3>.,.^-).!.&'6{T>^.t9N%O%:.`4[.fagawaxawaqagagagawa. wagagagagawa. wagagagawawaxawagagagaqaxawaqagagagawa. wagagahahahahahahahahahahahahahahahahahahahahahahahahahahahahahahahahahahahahahahahahahahahahahahahahar,. . . . . . . . . . . . . s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,w,l6l6l6l6l6l6l6l6l6l6l6s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,r,X+Z+`+`+N$N$@@P$P$J&J&$@&@-@K&;@K&>@>@,@,@M&M&'@)@!@W$~@X$~@]@/@Y$^@Z$(@_@_@`$m=|@1@1@1@R&.%+%+%E'T)T)8/G]H_H_X}X}X}q}^1r2232323n4,5`6 7n6 7-8k7<8<8,9s9N9+0ia[0[0x0Q0sa5ada",
"1%{*H@d J@(*_*M@yaO@|;Q@N7n T@U@V@W@s :~L<Z@`@1*2*3*88B j:$#7*7;&#*#G[=3;#>#,#'#_4A^W,{#f;x1:(<(_#:#i*[#I[l*=-B33#}((]D}7#8#9#t;a#u;c#u*e#%'{.g#A;i##|k#D5W|n#o#fagaga. wagagagagaga. gagagagagaga. gagagagagawa. gagagagaga. wagagagagaga. gagagahahahahahahahahahahahahahahahahahahahahahahahahahahahahahahahahahahahahahahahahahahahahahahahahar,. . . . . . . . . . . . . s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,w,l6l6l6l6l6l6l6l6l6l6l6s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,r,G&`+`++a.@:a+@+@+@$@$@za&@-@;@K&;@R$,@,@L&,@'@'@V$W$X$W${@]@^@P&^@Q&(@(@_@[@[@m=091@ % %R&R&R&T)E'8/)0G]G]H_p}X}X}X}/1r2^12323A4A4n4,5`6 7k729h829,9N9N9+0*0[030Q0305a[adaAa",
"b c S'>!o>v25%K=>{k O(m n 7%p q r v>[8P=Q=R=S=B2d%y>z>C U=V=W=G 3~V(D2K  |M E2.-q%r%+-v/u%l|%-x%y%z%K2A% .|{+.])#./[D%/)*.Ba9#:)@8,.G%R>#0(-{.:-[}<-N%[-}}}-[.|-fagagagaqagagagagagagaqagagagagaqagagagagagagaqagagagagagagagaqagagaqagagagaqagaga. . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . r,. . . . . . . . . . . . . s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,w,l6l6l6l6l6l6l6l6l6l6l6s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,r,Z+L$ @N$N$H&+@P0P$#@%@&@&@K&;@K&;@j=,@,@L&'@'@7>!@W$W$X$O&]@^@Y$/@Q&Z$_@`$`$Ca}@|@|@4@ %R&+%E'E'.~.~G]G]G]H_B[.<X}Da^1r2@3^4a9V3n4,5 7k7k7X729h8,9<8N9+0N9+0Ea30605a'adadaFa",
"{*Ga_;J@g|_*;{H<O@I<Q@M=d:T@e:9%W@s X@){Z@`@!!2*i:^(R,y^$#7*7;Ha*#G[-#0;a;b;c;.^Q<W,{#B}8_/#<(m|k;<#[#k*l*m*B3o;p;(]6#J[3{x/t;'8b#c#u*H%f#(-g#11i#U>k#l#m#n#z*p#fagagagagagawawaqagagagaqawaxagagagagawawawagagagagawaxawagagagagawa. wagagagagaga. . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . r,. . . . . . . . . . . . . s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,w,l6l6l6l6l6l6l6l6l6l6l6s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,r, @`+.@N$@@H&P$P$$@P$%@Q$&@K&K&K&;@,@,@,@,@'@)@V$W$W$W${@{@l=/@^@^@_@Q&[@<@`$}@m=09 %1@.%R&R&+%`~T)G]8/8/H_.<X}X}q}^1^1^1@3@3V3n4,5`6`6k7X7k7<8<8<8N9N9W9+0*0[0[0605aQ0dadaIa",
"m>S'e Ja4%5%;{N@y2P@m n 7%8%U@r t^[8{}`'w ta.)d%y>z>C U(V=W=T_Y=Z=D2-)L `= -.-,)H>;<t%J>><%-W !)[{&-A%L>B%N>]);-$.d3/)Ka!-E%*^@8,.o8U|!.Y3}]:-^.1)N%V>:.$|LaX>T%fagagagagagagaxagagagagagawawagagagagaga. xagagagagagaxaxagagagagaqawaqagagagagaga. . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . r,. . . . . . . . . . . . . s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,w,l6l6l6l6l6l6l6l6l6l6l6s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,r, @N$N$.@@@P$#@#@$@%@%@Q$Ma-@K&R$R$,@,@M&L&'@'@)@)@W$~@{@{@^@l=^@/@(@_@(@<@}@[@|@1@1@4@R&R&+%`~.~)0.~8/H_H_-}B[X}q}r2@3@3m4^4V3n4 7`6j7 7X729<8<8,9b9+0&0&0*060Q0Q05aNadadaIa",
"]*d e g|_*,!i O@I<Q@M,n Q(e:9%[*O,X@L<Z@`@o62*+#3;T(5;$#V=~!Oa(4]{-#0;a;b;c;_4o4W,>8f;g;:(i;_#y1i*j*Z,%^m*B3Pa4#q;q*4!Qas;t;a#b#c#'.`9*2C36{A;;^U>N%O%B;C;o#c!|.fagagagagagagagagagawagagagagagagaxagagagagagagaqagagagagagaqagagagagagagaxagagaga. . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . r,. . . . . . . . . . . . . s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,w,l6l6l6l6l6l6l6l6l6l6l6s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,r,N$ @N$N$+@+@P$$@$@%@%@&@-@K&K&R$R$,@,@T$U$7>)@!@W$W${@]@]@<a/@Z$Q&Z$:@`$[@[@1@1@1@.% %R&+%T)T)T).~8/G]H_-}X}X}X}/1^1@3r223a923,5`619n6-8h8<8<8<8W9N9N9&0~060305aQ0'adaRaSaTa",
"S'e Ja4%J=K=u1^~P@m n (~p 83r e5a%u b%w w1 #+)@)z>C o/~[W==]Y=4~D>-) |`=5~p%!]UaB^^[#-7~%-x%!)Va&-A%~))9+.`_J9/[aa/)d~!-@|:)@8:}^-})c4)<{.T>h#<-WaV>:.}-W>d4,^1-fagaga. . gagagagaqa. . gagagagaxa. xagagagaga. . qagagagaga. . gagagagaga. xagagahahahahahahahahahahahahahahahahahahahahahahahahahahahahahahahahahahahahahahahahahahahahahahahahar,. . . . . . . . . . . . . s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,w,l6l6l6l6l6l6l6l6l6l6l6s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,r,N$N$.@.@@@P$P$$@$@$@Q$&@-@;@R$j=,@,@M&#;'@)@!@!@X$~@]@]@P&/@/@Q&(@(@_@<@[@}@1@1@ %R&R&R&E'`~E'.~8/G_H_H_p}X}q}X}^1r2@3@323n4A4,51958k7X7h8<8<8,9<8N9&0[0*060Q0Q0Q0dadaSaSaIa",
"d :;Y{_*h i O@k Q@m n ,{p 9%k/s X@Y@Z@`@!!y +#3;T(y^$#@2~{O<8;G[^!/!(!`]c;d;_{f*X,f;g;Y,<{j;k;<#l;m;l*1!1{@.p;$.,-4!)-s*t;'88!=^0!H%*2y;C3A;L%#|XaO%B;y*[.X>|.-'fagagaxa. gagagagagawawagagagagaqawagagagagagaxaxagagagagagaxa. gagagagagawaqagagahahahahahahahahahahahahahahahahahahahahahahahahahahahahahahahahahahahahahahahahahahahahahahahahar,. . . . . . . . . . . . . s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,w,l6l6l6l6l6l6l6l6l6l6l6s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,r,N$.@N$.@@@P$P$%@$@za%@&@;@@;>@j=,@L&L&L&'@!@!@k=X$~@]@P&^@P&Q&(@_@(@<@[@[@09091@ % %R&+%E'E'T)8/8/G_G_p}.<X}q}q}Yar2r2V3n4V3,5`61958k7-8h8<8<8W9W9N9&0[0[0[05aQ0sadaRaIaSaIa",
"N|X{4%T';{N@y2P@W' ](~_~U@r v>#]P=v $]w1 #.#@)z>B $)%)*]8*3~40D>ZaL ;) -.-Q|H>+-t%O6X_/}<(`a:#^]A%[(B%N>])!9c~p*'-d~8#~-:)I^<)<}).e#D1}]:-v*1)U>V>l#m#C;|-,^1-2.fagagagagagagagagagagagagagawagagagagagagagagagagagagaqagagagagagagawagagagagagagahahahahahahahahahahahahahahahahahahahahahahahahahahahahahahahahahahahahahahahahahahahahahahahahar,. . . . . . . . . . . . . s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,w,l6l6l6l6l6l6l6l6l6l6l6s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,r,N$N$@@@@P$#@#@%@%@%@-@6>;@;@>@,@,@,@M&M&'@'@!@W$~@{@P&^@^@/@99(@_@:@`$[@}@|@1@ %R&R&R&`~E'.~.~8/8/8/.<.<-}B[/1q}@313@3@3V3A4,5`6 7k7k7k7<8<8,9b9+0&0+0[0[0Q0Q0Q0sa bRaRada.b",
"Q]Y{p>5%i R]k Q@<*n 7%p R(T]s F[u Z@S_c%933*3;R,C g%7*~{{!8;V(-#0;#2b;c;.^V,+^+b:1k|Y,@^#^,8Y Z m;%^.. '--.'3!%.r;)-s;=a;.b#|1'.5{!.y;6{A;^.M%N%O%@b,6[.}.|.-'C*fagagagagagaxa. gagagagaga. . gagagagaga. . gagagagaqa. . gagagagaxa. xagagagagagahahahahahahahahahahahahahahahahahahahahahahahahahahahahahahahahahahahahahahahahahahahahahahahahar,. . . . . . . . . . . . . s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,w,l6l6l6l6l6l6l6l6l6l6l6s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,r,O$@@+@ba+@P$J&$@%@Q$K&;@;@;@>@,@T$,@M&!@W$W$W$O&{@{@P&P&l=^@(@(@`$_@<@[@9>091@.%4@R&+%n=`~T)8/F_#bH_.<X}X}q}/1r2^1m423n423n4,5,5k7-8<8<0<8b9,9N9N9&0*0*0605a5aQ0sadaSaAaIa$b",
"Ja{~L@;{U'^~%bW'!}7%Y'U@Z'v>K<u Y@[~ta #d%3*x^&]$)%)*]=]*)4~D>-),];) -)]Q|!#B^-3O67~8~9~]]z%^]&b*-n;N>`_J9c~p*/)O>e~@|0#I^62c#<]e#I%}]:-h#1)#|k#72}-3)|-p#1-2.3.fagagagagagagaxagagagagagawawagagagagaga. xagagagagagaxaxagagagagaqawaqagagagagaga*b*b*b*b*b*b*b*b*b*b*b*b*b*b*b*b*b*b*b*b*b*b*b*b*b*b*b*b*b*b*b*b*b*b*b*b*b*b*b*b*b*b*b*b*b*b*b*br,. . . . . . . . . . . . . s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,w,l6l6l6l6l6l6l6l6l6l6l6s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,r,O$+@P$P0P$#@%@&@&@&@;@;@;@R$R$T$,@U$'@W$7>!@~@{@{@]@P&^@/@Z$(@=b<@<@[@}@09}@ %3@R&R&S)`~.~.~8/G]H_H_H_X}20q}q}/1@3@3V3m6A4`6`6`6k7k7<0<8,9s9s9N9&0[0[0[0[0Q0'asa-b bFaIa;b$b",
"f p>17q>N@k .2R@n w}p 9%78s X@;8<~V]c%93!{3;R,5;U=6;~{X=8;V(J /!a;_!c;d;j|f*A}:1}!39@^W >bY Z m;%^1!1{@.c3,b%.&.)-x/t;7!8!|1'.L[!.&'J%11;^j#N%[-:.$|o#}.T%d!C*&:fagagaqagagagagagagaxagagagagagaga. gagagagagagawagagagagagawagagagagagaga. gagaga. . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . r,. . . . . . . . . . . . . s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,w,l6l6l6l6l6l6l6l6l6l6l6s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,r,@@@@+@+@J&$@%@&@-@*@;@K&R$,@,@T$L&'@'@)@)@k=X$W${@P&/@^@/@/@Q&_@'b[@}@[@9>|@.%.%R&R&S)T)T).~F_H_G].<.<q}q}X}q}@3r2@323n4n4,5 7 7 7h8-829<8W9W9N9*0~0)b60!b[a5adadaRaTaIa~b.b",
"(*_*;{N@)}P@`}M=S@=<U@f:W@K<:~Y@w S=Q,2*3*@#B $)6*7*8*z^4~=#>]F>;)>))])#r,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,a|. . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . r,. . . . . . . . . . . . . s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,w,l6l6l6l6l6l6l6l6l6l6l6s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,r,@@@@+@P$J&%@%@Q$*@-@-@;@R$,@,@M&'@'@'@k=W$W$W$]@]@P&l=99Q&/@(@_@<@[@1@09}@1@1@4@R&`~+%T).~T)F__0G].<X}q}q2q}q}1323V3V3,5,5`6 7k7-8k7<8<8%0b9W9N9N9[0[0[0Q0Q0dasadaIaFaIa{b]b",
"_*5%q>*<k O(R@n 7%p R('{s O=u `'+2c%2*d%A z>C U=7*~{p6H ]!^!m%a;s/^b.-V,r,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,a|. . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . r,. . . . . . . . . . . . . s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,w,l6l6l6l6l6l6l6l6l6l6l6s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,r,@@+@P$/b%@%@-@Q$-@K&K&;@R$,@. . M&M&,ak=W$X$T9]@. . /@/@/@Z$(@_@`$}@}@1@1@4@.%R&E'+%. . .~8/G]G]p}-}X}X}q}r2r2@3^4V3n4,5n4,558k7h8<8<8,9,9W9N9*0&0[0)bQ0Q05a5ada bIaIa{b]b~b",
"_*;{yaO@P@/~M=n =<P|r e5K<X@Y@v^`@ #2*3*z>&]S,~[7*=]z^*#=#-#,]']>)'#)#Q<r,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,a|hahahahahahahahahahahahahahahahahahahahahahahahahahahahahahahahahahahahahahahahahahahar,. . . . . . . . . . . . . s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,w,.9.9.9.9.9.9.9.9.9.9.9a|a|a|a|a|a|a|a|a|a|a|a|a|a|a|a|a|a|a|a|a|a|a|a|a|a|a|a|a|r,.@+@$@$@J&%@%@%@;@-@R$,@,@L&. . '@'@k=W$W$T9{@]@. . /@/@(@_@_@[@<@m=|@|@1@.%R&R&R&E'. . 8/G]H_G]x<.<q}^1q}13r2r2V3n4n4n419 7k7k7<0h8<8%0N9%0N9*0[060Q0Q05a'adadaIaIaIa(b]b(b",
"5%i >{k P@m  ]S]p 83r v>F[u Z@R=c%W]m/3;B C $#X]~{G _bZ=J /!#2M t/F2j|+^r,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,a|hahahahahahahahahahahahahahahahahahahahahahahahahahahahahahahahahahahahahahahahahahahar,. . . . . . . . . . . . . s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,w,B$A+B+C+C+D$D+E+E+4>G+B&G+d=H+H+J+K+K+N+N+:bC&O+Q+R+R+S+h=U+V+W+W+X+X+Z+`+`+`+.;@@P$P0$@J&$@%@&@-@K&K&>@,@,@<b. . '@7>'@W$X$T9{@]@^@^@/@Q&Q&:@<@<@[@}@m=1@r92@4@+%E'T). . G]G]H_.<-}-}X}/1^1r2@3r223A4n4:0`6j7k7-8<0<8<8W9W9N9[b*0[0305a5a5a'ada bTaIaIa$b]b]b",
";{ya)}%b/~i|7%O|7_V@W@#]{(Y@w `@!!+)3*^(B C ((7*8*9**#=#-);#.|c*P<)#Q<e;r,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,a|hahahahahahahahahahahahahahahahahahahahahahahahahahahahahahahahahahahahahahahahahahahar,. . . . . . . . . . . . . s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,w,}bB+A+|bD+b=E+1bE+4>G+G+B&H+H+H+J+L+N+M+N+M+O+O+K$S+S+h= ;V+V+V+F&X+Z+L$`+`+@@@@+@+@P$P$$@$@&@-@-@;@;@>@S$,@L&. . '@k=W$W$]@O&]@l=. . /@(@. . 2b3b4b5b6b7b8b4b9b0b+%.~. . abbbcbdbeb-}q}fb^1gbhbibjbkblbmb,5 7k7h829<8<8N9N9N9&0*0)b60[0jasadaRadaAaIaIa$b]b]b",
"K=N@)}s>m  ]7%O|q r s a%u Z@w c%x}d%A N<C g%V=p/X=H =)J K L M t/O G2Q s%r,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,nbs,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,a|hahahahahahahahahahahahahahahahahahahahahahahahahahahahahahahahahahahahahahahahahahahar,. . . . . . . . . . . . . s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,w,A+A+B+D+D+obE+E+A&G+B&e=f=H+J+K+K+L+N+N+M+M+C&Q+S+R+h=V+V+V+V+X+X+Z+Z+`+N$`+@@@@@@P$P0J&%@%@K&-@-@;@R$>@>@,@#;. . '@W$!@W$W$]@]@/@. . (@Z$. . pb. . . qbrb. . . sbE'T). . tb. . . ubvb^1q}wb. . . . . . xb 7 7-8k7<8<8b9,9N9[0[b[0Q030Q0Q0'adaTa bIa.b]b~b]byb",
"K,O@%bQ@M=n T@7_~}g:u^X@){v^`@c%w^y}^(B y^((7*8*O<*#G[-#F>.|c*_(_4_{e;X,r,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s, 9nb 9N8s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,a|. . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . r,. . . . . . . . . . . . . s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,w,z+A+D+D+D$E+E$A&E$F+G+d=d=H+I+zbK+H$N+N+M+O+Q+Q+R+AbBbBbV+V+F&;a;aX+G& @N$@@@@+@P$P$J&#@%@&@&@K&K&K&>@>@,@,@L&. . )@W$W$T9]@Cb]@^@. . (@_@. . Db2bEb. FbGbHbIb. ibT)8/. . Jb0bKbLb. Mb^1/1Nb. ObPbQbRb. Sbk7X7k729<8W9W9N9&0*0[0)b305a5a5adadaAaIaIaIa]b]b]bTb",
">{L=P@`}n w}8%U@r s z2w>Z@w x>B2d%n/T(&]U(1~W=B>Y=I D2k8L `=N .-,)H>s%t%r,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,l6l6l6l6s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,a|. . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . r,. . . . . . . . . . . . . s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,w,A+B+C+C$D+D$E$F+F+G+G+f=d=`-`-J+K+H$N+M+C&J$O+O+S+S+h=V+V+Y+F&X+X+`+`+`+`+@@@@+@+@#@$@$@&@&@&@;@;@R$j=S$T$T$'@. . !@W$W$]@8>l=]@^@. . Q&_@. . Ub}@Vb. . WbR&Xb. . T))0. . YbH_-}Zb. `b^1r2@323 c.c+c@c. ._k7k729<8<8<8N9N9N9*0*030Q05a'ada#cAaIaAaIa.b(byb]b$c",
"O@k Q@M=n T@7_9%[*#]X@l/Z@+2c%2*3*88B $)$#T,U,{!0*G[-#0;'],#c;_4Q<!5X,B}r,s,s,s,s,s,s,s,s,s,s,s,s,N8s,s,s,s,s,s,s,s,s,s,s,l6N8l6s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,a|. . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . r,. . . . . . . . . . . . . s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,w,B+A+D+D$obD$G+F+G+5>G+f=H+H+J+K+H$M+J$M+C&Q+S+%cS+h=V+ ;F&;aY+;aL$Z+i=.@N$O$@@baP$P$P$%@&cK&K&6>;@R$>@,@L&,@M&. . ,aW$O&X$]@P&^@^@. . (@_@. . *c1@1@. . 1@R&R&. . )0.~. . =c.<-}-c. ;c^1@3>c,c. . . . . . -8X7<8<8W9b9W9+0*0*0[0Q05a5a'adadaRadaIaIa]b]b$c$c'c",
"k R_t>X'7%Y'-<r W@a%u Y@w S= #.#3*z>f%$)V=W=G *)I D>E>,]`= -)]q%H>;<@-J>r,s,s,s,s,s,s,s,s,s,s,s,s,l6N8s,s,s,s,s,s,s,s,s,s,s,s,nbs,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,a|. . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . r,. . . . . . . . . . . . . s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,w,B+B+D+D$E+E$c=c=G+f=5>H+I+J+J+H$H$N+M+M+M+O+R+S+S+ ;h=V+Y+F&Y+X+Z+ @N$N$@@+@+@+@P$$@%@$@&@K&-@;@;@j=,@,@L&'@)@. . W$W${@{@l=]@^@/@. . (@`$. . }@|@1@. . R&R&+%. . 8/.~. . )c-}X}!c. ~cr223{c. `b]c^c/c. . h8<8-8<8%0%0N9+0*0*060Q0Q0'asada bIaAa.b(b]b]bybyb'c",
"I<Q@m n T@e:V@78s X@){70A2o62*z x^4;y^$#E Y]O<(cV(b*0;(!b;c;_co4f*:c:1g;r,s,s,s,s,s,s,s,s,s,s,s,s,l6l6s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,a|. . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . r,. . . . . . . . . . . . . s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,w,C+C+C$D$E+E+<cG+G+H+f=H+H+zbK+K+N+M+J$M+O+R+R+S+h=U+V+W+W+X+X+[cL$ @+a@@N$+@+@P$$@$@$@$@*@K&K&;@R$,@>@T$U$T$)@. . W$W$8>]@]@P&/@/@. . (@[@. . |@091@. . .%R&E'. . 8/G]. . }c-}B[|c. 1c13@32c. 3cn4n64c. . X7X7h8%0%0W9+0*0*0*0[0Q0[a'ada bRaIaIa~b.b]b5c]b'c'c",
"V'W3n 7%_~q Z'v>O=u Y@w `@ #d%]}z>&]o/V=&)%#C>=)D>-)F>`=G>'#Q|~]s%t%#-><r,s,s,s,s,s,s,s,s,s,s,s,N8l6l6s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,nbs, 9s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,a|hahahahahahahahahahahahahahahahahahahahahahahahahahahahahahahahahahahahahahahahahahahar,. . . . . . . . . . . . . s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,w,B+D+D+E+E$A&F+F+B&f=H+J+g=K+J+M+N+N+J$O+Q+S+6cS+h=T+V+7cY+X+Z+ @L$N$`+.@@@+@P$P$#@%@%@Q$K&K&K&R$R$,@L&,@'@'@7>. . W$T9]@]@]@P&^@(@. . [@_@. . |@1@1@. . R&n=`~. . 8/8/. . bb8c9c0c. acr2@3ub. bcccdcec. . <8<0<8<8W9N9N9*0[0*0Q0Q0[adadada bIa.bIaIa]b5cyb$cfc",
"Q@M=n T@U@9%78O7z2;8Z@`@c%2*m/88B C $#T,Y]O<8;]!-#0;a;b;c;_4V,+^:{B}gc/#r,s,s,s,s,s,s,s,s,s,s,s,l6l6l6s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,l6l6s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,a|hahahahahahahahahahahahahahahahahahahahahahahahahahahahahahahahahahahahahahahahahahahar,. . . . . . . . . . . . . s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,w,D+D$E+E+E$F+G+G+d=F$H+`-zbK+K+M+M+J$M+Q+Q+Q+S+S+h=U+V+V+X+X+Z+ @ @N$O$H&@@+@#@$@$@$@$@-@-@;@K&;@S$L&T$U$#;'@'@. . . . . . . . /@Q&. . _@`$. . 1@1@1@. . 6/+%T). . G]H_. . hc. . . icjcr2V3kc. . . . . . . 2929W9s9N9&0N9+06060305a5a'adaRaSaIaIa(b~byb]byblc'c",
"m u>7%p U@Z'W@a%{}Y@w x> #}~3*z>#)$)~[*]7;3~Z=D>>]F>`=mc)]Q|6~;<-3J>7~/}r,s,s,s,s,s,s,l6l6l6l6l6l6l6l6l6l6l6l6l6l6s,s,s,s,s,s,s,s,s,s,s,l6l6 9s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,a|hahahahahahahahahahahahahahahahahahahahahahahahahahahahahahahahahahahahahahahahahahahar,. . . . . . . . . . . . . s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,w,D$D$D$E+F+F+5>e=f=d=H+H+J+K+K+N+M+O+O+Q+S+Q+S+T+BbV+-aW+X+Z+ @L$N$+a.@.@ncP$P$#@$@Q$-@Q$K&6>;@S$,@,@L&L&'@V$)@. . . . . . . . Z$Q&. . (@}@. . 1@ %r9. . +%E'T). . G]H_. . ocpcFbtb4cr22323qcrcsctcucvc. . <8<8b9W9W9+0*0[0ca30Q05a'a bSaFaIa.b;b]b]b]bwc'c'cfc",
"R@n T@p j/k/s X@l/Z@S_c%x}y}3;e%5*U=h%Y]O<xcV(C8/!(!`]c;_1V,+^s%:1}!39@^r,s,s,s,s,s,s,nbl6l6l6l6l6l6l6l6l6l6l6N8s,s,s,s,s,s,s,s,s,s,s,s,l6s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,a|*b*b*b*b*b*b*b*b*b*b*b*b*b*b*b*b*b*b*b*b*b*b*b*b*b*b*b*b*b*b*b*b*b*b*b*b*b*b*b*b*b*b*br,. . . . . . . . . . . . . s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,w,C+D$E+G+E$c=G+f=F$H+I+I+K+K+I$N+M+C&O+Q+R+S+S+h=V+W+W+F&X+Z+Z+ @N$.@.@+@@@P$$@%@$@%@*@K&K&;@>@R$>@,@L&M&)@)@!@W$W${@X$]@^@^@^@Z$Z$(@_@[@m=1@091@1@.%R&R&`~E'T).~.~8/H_.<-}q}q}/1/1r2232323V3n4n6`6`6-8P8P8<8<8s9ycN9~0~0[0Q060Q0dasadaRaFaIaIa(b]bTbTb$c'cfczc",
"M=7%+]U@d50%K<:~`'70`@ #+)3*4*Ac$)~[*]B>&#4~D>>]F>']>)d*q%H>e;S|J>7~/}9~r,s,s,s,s,s,s,s,s,l6l6l6l6l6l6l6l6l6s,s,s,s,s,s,s,s,s,s,s,s,s,s,nbs,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,a|. . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . r,. . . . . . . . . . . . . s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,w,C+E+A&A&c=G+G+5>5>H+J+J+K+L+BcN+M+O+O+O+S+S+h= ;V+V+X+;aZ+Z+ @`+N$.@+@@@+@P$%@CcQ$&@%@-@6>;@S$>@,@L&'@M&'@!@7>X$~@]@{@l=^@/@(@Z$(@:@`$[@m=m=1@4@.%4@+%n=T)T)8/.~G]H_G]p}X}X}q}q}r2r223@3n4,5,5n619k7-8<8<8<8<8ycN9N9*0[0[0[0605adada bSaIaIa~b]b]b]bTb'cfcfcDc",
"Y7i/N,83r s z2){Z@`@c%2*!{%]z>C $#@2~{X=8;V(^!m%#2M  ^d;V,+^:{v/T Y,t7W r,s,s,s,s,s,s,s,s,s, 9l6l6l6l6l6N8s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,a|. . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . r,. . . . . . . . . . . . . s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,w,E+E$E+F+G+G+G+5>H+H+J+K+K+L+N+C&J$O+R+6cS+S+EcV+Y+W+W+X+X+ @L$N$N$@@H&+@+@J&J&%@%@&@-@6>@;j=R$,@,@'@M&)@!@7>W${@]@]@]@U9l=/@/@(@_@(@[@[@[@|@1@ %.%4@n=E'+%.~.~.~H_G].<.<-}X}^1r2@3232323n4,5`6n6`6k7<8-8<8<8b9,9N9+0*0[0Ea30Q0sa'ada bAaIa$bIa]b]byb'c$c'cfcFc",
"(~Y'U@V@W@u^P=Y@[~`@ #](3*z>B ##k:7*G9O<4~G[S0F>']c*'#Q|A^B^-3T|^#/}(#]]r,s,s,s,s,s,s,s,s,s, 9l6l6l6l6l6 9s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,a|. . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . r,. . . . . . . . . . . . . s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,w,D$E+F+G+G+d=H+5>I+J+J+K+N+N+M+M+O+R+Q+S+S+V+V+V+V+F&X+Z+X+ @`+`+N$.@@@P$P0#@%@$@&@&@6>K&R$R$,@,@M&N&'@'@)@W$W$X${@]@]@Y$^@/@/@_@_@'b[@[@m=1@r91@2@+%+%E'T))08/F_G_H_-}.<X}q}q}^1@3@32323V3,5 7 7k7k7h8h8,9s9,9N9&0*0&0[0Q05a'a5a b bRaIaIa]b]bybGc$cwc'cHczcIc",
"i/p 9%78s z2u v )!c%2*d%3;z>C U(T,~{X=C>I J K r/s/t/.-q%r%s%B}}!<1i;W Jcr,s,s,s,s,s,s,s,s,s,l6l6l6l6l6l6l6s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,a|. . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . r,. . . . . . . . . . . . . s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,w,D$4>E+c=G+H+5>H+K+I+K+H$L+N+C&J$Q+O+R+h=U+EcU+F&7cF&X+ @Z+ @N$@@.@+@+@#@P$#@$@za&@6>6>R$R$;@>@,@U$T$7>)@W$W$X$X$O&P&P&/@Z$/@Z$(@_@[@[@|@1@|@4@.%R&+%`~E'.~)08/G]H_H_-}B[q}X}^1@3r223n4n4,5,5`6k7 7X7k7<8<8%0W9+0*0*0[0Q0Q05asa'a bAaTaIaIa~b]b]b]b'c$cfczczcIc",
"T@U@9%W@#]X@Y@Z@`@ #](3*z>B $)$#7*=]O<0*G[=3;#>#c*'#)#A^e;{#P7^#8~(#]]y1r,s,s,s,s,s,s,s,s,s,l6l6l6s,nbl6l6s,s,s,s,s,s,s,s,s,s,s,s,s,s,s, 9s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,a|hahahahahahahahahahahahahahahahahahahahahahahahahahahahahahahahahahahahahahahahahahahar,. . . . . . . . . . . . . s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,w,E$A&E+G+B&d=H+H+J+J+L+K+N+M+O+O+O+R+S+S+h= ;V+V+W+X+X+ @Z+N$`+`+.@+@P$+@P$J&%@Q$-@-@6>;@R$>@,@T$'@M&'@!@!@W$X$~@]@^@^@/@Z$(@(@<@`$}@}@}@1@r9.%1@R&R&T)T).~F_F_G]H_-}.<20q2^1r2r2@32323V3,5,51958k7P8h8<8%0,9+0N9*0[0[0Q0Q05a'adadaSaSaIa.b~b.b]bTb'c'cfcDcIcIc",
"p N=78v>z2u Q=R=x W]d%]}z>C A>6;m7B>H =)`7/!L M t/d;V,r%+-@-T <1w%W X [{r,s,s,s,s,s,s,s,s,l6l6s,s,s,s,s,l6l6s,s,s,s,s,s,s,s,s,s,s,s,nbl6l6l6l6s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,a|hahahahahahahahahahahahahahahahahahahahahahahahahahahahahahahahahahahahahahahahahahahar,. . . . . . . . . . . . . s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,w,A&E$c=G+e=d=H+J+J+J+K+L+N+M+Q+O+R+6cS+h=S+ ;V+V+W+Y+Z+ @`+`+.@@@H&P$/b$@#@%@za&@-@6>;@;@,@>@L&U$'@'@,ak=W${@X$8>]@l=^@/@Q&(@(@<@[@[@m=1@1@1@ % %+%`~T).~.~.~G_H_.<-}X}q}q}q}r2r2@3V3m6,5`6 758 7h8<0<8<8W9N9N9~0+0*03030Q0sadadaFaIaAa.b~b]b]bwc'c'cKczczcFcLc",
"U@V@W@O7X@|*Z@`@Q,2*z 4*&]j:((T,7;9*0*G[-#0;']b;'#)#!#W,-3]#7~:(<{]]!0<#r,s,s,s,s,s,s,s,s, 9s,s,s,s,s,s,s,N8s,s,s,s,s,s,s,s,s,s,s,s,s,s,l6l6s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,a|hahahahahahahahahahahahahahahahahahahahahahahahahahahahahahahahahahahahahahahahahahahar,. . . . . . . . . . . . . s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,w,A&G+G+G+5>d=G$I+K+H$N+M+N+M+J$K$Q+S+S+S+V+T+W+F&Y+X+L$.a @`+N$@@@@+@#@#@#@$@%@Q$-@;@R$;@R$L&L&M&'@)@V$k=X${@{@]@]@/@/@(@Q&(@'b<@[@[@|@|@1@ %R&R&6/`~.~T)G]G]G_.<.<X}X}q2^1q}r2@3a9V3a9,5n6`6`6k7k7-8<8<8ycN9N9*0~0[030Q0Q05ada bRaTa.b]b(b]bTbyb'cfczczcDcLcIc",
"j/r v>[8u v )!x>2*d%n/T(/(U=V=W=T_H k%D2K n%M N _1V,H>R t%S8l|%-#^,<Y Mcr,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,N8nb 9s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,a|hahahahahahahahahahahahahahahahahahahahahahahahahahahahahahahahahahahahahahahahahahahar,w,w,w,w,w,w,w,w,w,w,w,w,w,w,w,w,w,w,w,w,w,w,w,w,w,w,w,w,w,w,w,w,w,w,w,w,w,w,w,w,w,w,4 A&<cG+G+B&H+H+J+K+NcL+H$M+C&O+O+Oc6c ;U+EcV+F&;aX+G&`+`+`+N$.@@@+@P$J&P$%@Q$Q$K&;@;@R$R$,@T$L&M&'@!@!@W$W${@{@l=l=^@/@Q&/@`$:@[@[@E9E91@.%R&.%R&+%E'T).~8/Pcw<.<.<.<q}q}q}^1r2@323V3A4 758`6k7-8-829,9ycN9+0N9ia*0Q0Q0Q0[ada b bdaSaIa]b.b]b]b'c'czcDcIcIcQcLc",
"9%k/s X@Y@Z@`@M<2*i:|~B 5*$#T,8*&#8;]{42F>Rc,#_(_4Q<Sc>8f;gc8~<{j;k;i*[#r,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,a|. . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . r,c+c+o,s$e+e+f+h+g+h+j+u$Tct$m+m+m+0=o+r+q+r+x$x$t+v+v+y&w+w+z$y+B$B$z+A+Z-B+D+b=E+D$E+F+G+f=5>5>H+`-g=H$K+N+N+M+O+P+Q+Q+h=h=V+V+V+Y+Y+X+X+`+N$N$Uc@@ba+@P$P$$@$@%@*@&@K&;@;@R$,@T$#;'@!@'@W$W$X${@]@P&l=/@/@Q&(@(@`$<@m=[@E91@r92@R&R&T)T)T).~G]H_H_.<-}X}q}q}r2r2@3@3a9n4,5`619k7X729h8<8<8s9N9N9*0*0[0Q0Q0Q0sadadaFaIaIaIaIa]b]bwc'cVcfczczcLcIcWc",
"d5W@z2P=Y@w  ) #.#y>z>/(o/V=F B>C>k%D>m%L `=N .-V_H>I>@-#-X_%-Xc,<[{K2A%r,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,a|. . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . r,c+q$t&c+e+z'z'g+h+i+j+F]F]l+m+m+o+o+w&r+q+y$3_x$u+u+u+v+w+w+A$YcZcB$A+`cZ-C+D+D+E+A&F+c=G+f=B&H+H+J+K+K+H$N+ dJ$O+Q+R+Q+S+h=T+V+;aF&Z+Z+Z+N$`+N$.@+@+@+@J&#@%@%@&@*@K&@;R$j=,@,@T$'@'@!@,ak=W$X${@]@P&/@^@/@10(@(@[@[@m=1@1@1@4@R&R&S)T)E'.~8/8/G]H_-}.<-}X}^1^1r2232323m6`6n6k7k7-829h8,9<8N9N9N9*0*030[05a5adadaSaFaSaIa~b$b]b$c'c'cfc.dzcQcIcLcLc",
"W@O,P,l/Z@R=!!2*!{3;B j:$#T,7;{!0*G[-#0;>#b;c;:!Q<W,X,]#g;:(<{j;k;<#[#I[r,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,nb 9l6s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,a|. . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . r,c+c+t&e+s$z'g+h+v&u$j+j+8=l+K{v$o+0=r+w$r+s+x$y$u+u++dw+z$A$z$x+B$B$z+A+@dC+b=D$E+E$G+G+G+H+d=H+`-J+K+L+BcM+O+J$Q+Q+R+S+ ;BbV+V+Y+;aZ+L$L$L$.@N$.@H&+@P$$@J&%@&@-@;@6>j=R$R$,@,@L&M&'@)@!@X$T9W$]@P&/@/@Q&_@(@_@[@[@}@1@1@ %4@4@R&6/E'.~T).~8/8/H_H_.<q}q}q}/1@3@3V323n4,5`6k7k7k7-8<8<8s9ycN9N9&0[030[0605ajasadadaSaIa~b{b]byb'cwcfcDcIcDcDcIcLc#d",
"![a%u `'w  )x}+)A z>C $)V=p/G *)=)D>K F>`= -p%q%H>I>^[#-X_%-Xc03[{&-A%~)r,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,l6l6l6N8s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,a|. . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . r,c+t&s$e+f+g+g+g+h+j+j+l+l+l+m+v$0=q+0=r+r+s+x$t+v+w+y&z$a=z$x+y+B$}bA+A+C+D+D$E+E+F+c=G+H+B&H+H+J+K+K+K+N+M+J$P+Q+K$R+S+ ;V+U+7cF&$d[cX+ @N$.@N$N$P$P$P$P$%@%@&@K&K&K&R$,@,@>@L&N&'@)@,aW$W$T9]@]@^@P&/@/@Q&(@`$<@[@9>1@1@2@r9R&6/R&E'%d.~G]F_G]-}.<.<X}^1q}|2@32323A4,5`6,5j7k7k7h8<8<8s9N9N9+0*0*060605a5a'a-bdaSaSa.b]b~b]b5cTbwc'czcDcDcIcLcLc&d",
"O7X@|*Z@`@c%2*m/88B C $#X]~!{!(4a*-#0;(!b;_()#Q<W,X,:1g;/#@^m|y1H[l;k*l*r,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,l6N8l6s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,a|hahahahahahahahahahahahahahahahahahahahahahahahahahahahahahahahahahahahahahahahahahahar,t&s$s$e+z'g+v&v&i+j+F]l+l+l+n+o+o+q+0=s+x$x$x$u+u+w+z&z$z$z$Yc*dz+B+B+Z-C+D+b=E+4>G+G+G+e=H+H+I+K+=dK+BcN+:bM+O+R+R+S+ ;h=U+V+F&Y+Z+X+`+`+`+.@@@+@ba/b#@$@%@&@%@-@;@;@;@>@,@T$T$'@'@,a,aW$8>8>]@]@P&^@99/@(@:@_@[@[@1@1@ % %R&4@R&`~`~T).~G]G_H_.<H_B[q}^1/1@3r223V3V3,5,5n6k7-8X7P8<8<8,9N9&0+0[030305a5asadadadaSaIa;b~b]b'cwc$cfcfczcDcIcLcLc-d;d",
"a%P=Y@w c% #}~3;z>&]U(k:W=B>3~Z=D>k8F>`= -.-)#H>B^t%J>></}Xc!).8&-A%[({)r,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,a|hahahahahahahahahahahahahahahahahahahahahahahahahahahahahahahahahahahahahahahahahahahar,u&s$s$z'g+z'h+j+u$j+j+l+K{3>o+v$0=w$s+s+s+y$t+u+v+w+w+a=y+x+B$z+}bB+B+C+C$C+b=A&F+G+G+G+H+d=g=H+K+J+I$N+J$J$O+O+O+S+S+BbEcV+V+-aX+Z+Z+L$`+Uc.@@@+@+@#@J&$@Q$Q$*@K&;@;@R$,@,@U$L&'@'@k=W$W$O&X$l=]@P&/@/@(@_@'b[@[@}@|@1@1@ %R&+%E'`~.~)08/.~H_G]-}-}X}^1^1@3@3@3^4a9n4,5`6j7k7X7k7<8<8b9,9N9+0[0[0ca305a[a5adadaFaSa.b.b~b]bTb$c>dfcfcfcIcIcWcWc,d-d",
"X@u Z@V]M<2*3*3;B 5*$#@2~{{!0*]{-#0;#2M c;d;Q<f*A}:1k|Y,@^#^,8n|j*m;}{1!r,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,a|hahahahahahahahahahahahahahahahahahahahahahahahahahahahahahahahahahahahahahahahahahahar,r$r$e+Y~Y~g+v&j+v&u$k+m+l+o+o+o+q+0=s+'dy$u+t+u+z&z&w+z$x+y+z+B$z+A+B+B+E+D$E+E+F+G+G+B&5>H+zb. . H$N+M+M+J$O+R+Q+S+h=S+V+V+X+Y+X+X+Z+N$.@Uc@@+@+@P$P$$@$@%@&@K&-@K&R$>@,@,@L&'@7>!@k=W$W$]@]@l=l=P&Z$Z$10_@:@[@m=}@|@1@1@.%R&`~E'T).~.~F_G]G_H_-}20X}q}q}^123V3V323n4n6 7k7k7-8<0<8,9N9N9N9+0[0*03060Q05asadaSaSaIa$b;b]b5c$c$c'c.dzcfcIcIcLc,d,d-d",
"{}Y@w w1 #.#3*z>C U(V=W=%#)d4~H9>]F>;) -'#q%H>e;-3O6^#%-9~y%Va&-z1[(M>=-r,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,a|hahahahahahahahahahahahahahahahahahahahahahahahahahahahahahahahahahahahahahahahahahahar,e+e+e+e+h+!dj+4/j+t$l+l+v$v$o+w&q+r+r+s+Y-t+u+w+z&z&z$A$A$y+B$A+z+B+C+C+b=D$D$E$G+G+G+H+d=I+`-. . N+I$M+O+O+O+O+S+S+h=U+V+V+X+X+Z+Z+ @`+N$N$@@+@P$P0#@%@@a-@K&-@;@R$R$R$<b#;'@'@7>7>W$W${@O&]@l=^@/@/@Z$(@`$[@[@|@[@1@.%.%4@R&+%`~.~T)G]G]G_G].<X}-}^1^1r2r2r2V3V3,5n4`6j7k7k7k7<8,9N9ycN9+0~0[0EaQ05aQ0sadadaIaTaIaIa]b]b]b$c'cfcDcfcFcDcLcLc,d-d,d",
"l/Z@V]!!2*y}3;4;5;$#7*~d9*8;]!^!0;(!_!t/d;V,f*X,[!}!39t7j;Jc[{l;m;}{..l0r,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,a|. . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . r,d+e+e+g+h+i+j+j+t$u$m+l+v$o+o+0=B'r+7:s+t+t+v+w+w+w+w+x+A$B$z+B$A+B+C+D+D$D$A&F+G+e=f=d=H+`-J+. . H$N+{dO+O+O+Q+S+S+EcT+V+Y+W+;aZ+`+ @N$N$O$.@+@J&#@$@%@%@&@-@K&>@R$,@,@T$T$#;'@k=)@W$W$X$]@P&]@Y$/@/@(@:@(@<@[@[@E91@ %R&4@n=6/T))08/8/G_H_.<B[-}X}/1/1r2m4V3a9A4,5 7 7k7]dk7<8h8<8,9N9N9[0*0[030Q05a5ada b bSaIa;b]b]byb]bwc'cfcDcFcIcLcLc,d,d^d/d",
"Y@v^ ) #d%3*|~C $)k:&)G9&#16G[-) |`=>)'#)#Q<B^-3O6^#/}C^]]z%^][#F^M>=-])r,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,a|. . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . r,s$e+z'g+h+j+j+j+k+t$m+K{v$o+o+r+s+3_s+x$t+u+u+z&w+a=w+x+y+y+B$A+B+C+C+obD$E+E$F+F+B&d=H+G$I+I+. . BcM+C&O+Q+OcR+S+ ;(d_d:d<d[d}d|d @ @. . 1d2dtc3d4d5dza&@K&6d7d<d8d9d. . L&'@. . !@W$X$]@. . U9^@Z$0dpbadub5bbd|@1@1@.%R&R&E'E'T).~.~G]G].<p}X}X}q}^1r2cd23n4V3n4,5`6n6k7k7<8h8<8<8N9N9&0+0[0[0Q0Q0'a'ada bFaIa;b;b$b]b]b]b'cKcddddDcLcLcLc;d-dedfd",
"Z@+2c%B2i:3;e%C U=h%~{{!8;]!l%q/a;M N _1V,+^:{[!}!Y,i;#^k;$^Z m;%^..l0@.r,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,a|. . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . r,s$f+z'h+h+j+j+j+t$l+v$o+v$o+w$r+r+s+y$x$u+v+u+z&w+w+y+YcB$gdA+A+C+D+D+D$E+E+c=G+d=B&H+H+I+J+K+. . N+C&M+O+%c6cS+S+hd. . . . . . id`+`+. . sc. . . . jd&@-@kdld. . . . . . #;7>. . W$W$O&]@. . ^@/@mdnd. . . . odpd1@ %2@R&+%`~T)T).~.~H_H_.<.<X}q}X}q}^1@32323n4,5,5,5k7k7k7<8<8s9,9b9+0*0*0*0[05aQ05a5adaRaTaIa$b~b(b]byb$cfc'cDcDcDcIcLcWc,d^d-dfd",
"v^`@Q,](3*@#f%$)V=7*7;&#4~=#>];#;),#'#Q|Q<qd{#p:^#8~<(]]:#52[#[(M>N>])3#r,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,a|. . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . r,e+f+g+g+i+i+j+t$l+l+K{n+o+0=q+q+r+s+x$t+t+rdw+z&z$z$sdy+}bB$}bA+D+D+D+b=E+E$E$G+G+G+d=H+H+K+K+. . M+M+J$Q+OcS+S+U+td. udvdwdxd. yd`+N$. . zdAdBdCd. Dd&@K&Ed. FdGdHdId. . M&'@. . W$X$X$]@. . /@^@Jd. KdLdMdpb. Nd1@.%4@R&+%E'T).~508/G]p}.<B[X}q}q}@3r2232323,5,5n6n6k7k7X7<8,9<8W9N9&0&0[0[060Q0[aQ0dadaTaSaIa(b]b]b]b$c'cfczcDcIcIcLcLc#d,dededOd",
"w c%2*d%A R,C U=V=m7X=8;I J K #2M ^bF2P +^:{v/Pdv%i;W X [{Z m;%^Qd+.X3;-r,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,a|hahahahahahahahahahahahahahahahahahahahahahahahahahahahahahahahahahahahahahahahahahahar,e+e+h+j+i+u$t$l+l+v$o+o+o+q+q+s+x$y$y$u+z&z&z&w+w+z$A$y+A+A+Z-Z-C+C+D$E+F+c=<cf=d=F$H+H+I+K+H$. . J$M+O+Q+R+R+S+ ;h=V+RdSdTdUd. ._N$N$. . Vd#@P$Wd. Xd*@-@Ud. YdS$,@Zd. . `d!@. . ~@]@{@]@. . /@Q&Nb.  e[@[@.e. +e.%R&.%R&R&.~T).~.~G]G].<H_X}q}r2/1r2@3V3V3n4,5,5`6k7X7X729<8<8b9W9N9+0+0[060Q0Q0'asadadaRaIaIa{b~b]bGcwcfczcDcDcFcIcIcWcWc,dfdfd@e",
"w11*.#3*4*Ac$)%)7*7;&#*#=#>];#>#,#'#)#~]W,-3P77~8~9~]]:#<#K>F^M>m*2#3#4#r,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,a|hahahahahahahahahahahahahahahahahahahahahahahahahahahahahahahahahahahahahahahahahahahar,e+h+g+h+j+u$t$t$l+K{v$#eq+o+r+s+s+s+u+u+u+z&w+w+z$z$B$}bA+A+A+Z-C$C$E+E+E+E+G+G+H+F$I+`-K+K+N+. . M+J$O+S+S+h=S+Ec$e%e. . . . . . `+O$. . &eP$J&$@. . K&K&cb. *eraT$=e. . '@W$. . X$]@P&P&. . 99Q&tc. . . . . . -e.%R&R&R&T)T).~.~8/G]H_.<-}B[X}q}/1r223n423V3n4,5 7 7k7k7-8<8<8W9N9N9*0+0[0;e60'adada b bIaIa.b(b]bybwc$cfczczcIcIcLcLc#d,d>eedOd@e",
"x>x}d%3;e%C o/V=W=T_8;]!`7K n%M t/.-q%+^A}@-#-v%t7x%X $^K2,e ...+.--;-$.r,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,a|hahahahahahahahahahahahahahahahahahahahahahahahahahahahahahahahahahahahahahahahahahahar,z'h+i+h+4/j+t$l+m+m+v$0=B'r+r+s+s+x$u+u+v+z&w+z$z$A$B$}bB$A+B+D+C+C+E$E+E$F+G+F$d=H+H+J+K+K+H$. . O+O+6cO+R+h=T+V+'e. 8d)e!e~e. . N$N$. . P$#@P$J&. . -@-@4b. *e,@L&*e. . !@!@. . W$]@]@{e. . (@(@4b. . . . . . Xd %R&R&E'T).~.~G]G]w<p}B[-}20/1q}@3@3^4V3V3,5,558n6k7k7h8<8<8%0N9N9+0*0*060Q0Q05a'aRaFaAaIaIa(bIa]b]bwc'cfcfcIcIcLcWc#d,ded/dedOd@e",
"Q,}~3*3;B ##((7*=]&#]el:^eF>/eb;c;)#Q<e;{#T|x1:(<(_#y1i*[#k*n;=-n*3#Q7q;r,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,a|hahahahahahahahahahahahahahahahahahahahahahahahahahahahahahahahahahahahahahahahahahahar,e+h+v&u$j+F]l+l+v$l+o+p+0=w$r+r+x$t+u+z&+dw+z$x+A$B$B$z+B$B+B+C$D$D$D$E$G+G+d=H+H+J+I+K+K+H$N+. . C&O+6cS+S+S+V+V+~c. (e;aZ+_e. . @@@@. . #@P$%@%@. . 6>K&td. :e<bT$<e. . W$W$._. [e]@^@}e. . (@(@|e.  eE91@1@1@.%3@R&`~S).~.~)0.~H_H_H_.<X}X}^1r2^1@3^423,5,5,5`658k7P8<8<8<8s9W9N9[b*0606060Q0Q0sadaRaSa$b;b]b]bTb$cVc'cfcfczcLcLc#d#d-d,ded1eOdOd",
" #d%3*z>Aco/V=W=B>C>=)J K r/`=N .-P r%R @-#-l|%-#^y%[{K2Z_ .{)=--- :$.%.r,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,a|2e2e2e2e2e2e2e2e2e2e2e2e2e2e2e2e2e2e2e2e2e2e2e2e2e2e2e2e2e2e2e2e2e2e2e2e2e2e2e2e2e2e2er,g+h+v&j+t$k+l+v$l+o+o+o+w&s+s+'dt+u+u+z&w+z$z$z$x+y+z+A+A+C+|b3eD$D$E$E$<cG+d=d=H+I+G$K+K+H$M+. . O+Q+S+S+S+T+T+V+sc. 4e5e6e7e. . O$@@. . P$P$$@&@. . K&;@8e. 9e0eaebe. . k=k=ic. cedeeefe. . Q&(@ge. Dbheieje. 2dR&R&S)T)E'G].~H_G]H_.<X}X}q2^1r2r2m4a923,5,5n6 7 7P8X7<8<8,9W9X9[b~0[0[0[05a5a5adadaRaIa;b~b]b]b'c'c$cKc'czcDcLcWc#d-d^d/dfdOdkele",
"2*i:z>B $)6*7*U,O<0*l:b*0;']z3_(:!Q<e;X,f;8_/#<(9_y1<#l;I[l*1#n*3#c~5#q*r,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,a|L!3$~15$Y:}=^>/>&}1=men'*[2/4=5=h$|>1>X~E_}+}+}+|+l$3+4+q&q&y'7+7+8+0+X-a+c+u&c+r$e+z'f+h+g+v&u$t$t$m+m+9=o+w&w$w$r+'dy$t+v+u+rd+dA$a=A$B$y+z+A+B+Z-D+C+E+E+F+G+F+B&f=H+H+I+J+NcH$N+N+. . . . . . . . V+V+ne. . . . . . . .@.@. . $@P$$@&@. . K&;@oeyd. . . . . . !@W$pe. . . . 8e. . (@'bqere. . . . seteR&+%E'T).~T)G]G]H_.<X}X}q}/1^1^12323V3m6,5,558 7k7-8<8h8%0,9W9+0~0*0[060Q0Q05asaRaFaRaIa(b(bybybyb$c'cKczcDcDcIc,d-d-d,d1eOdOdlele",
"+)n/T=C $)~[W=G H Z=J K L M E2)]q%;0s%@-T X_%-x%,<z%&-A% .{)+.@.;-c~p*'-r,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,a|L-M-}:f&-+|:uei& (n}g,h,i,vev</+k,l,we2>}+}+|+l$l$3+3+4+4+n$7+o$E]8+0+0+q$c+u&r$e+e+f+g+j+h+v&u$F]t$l+m+v$o+p+0=xer+x$t+u+v+u+w+z$w+x+y+y+z+B+A+B+D+C+E+D$A&F+<cG+e=H+H+H+H+K+K+N+M+M+. . . . . . . . V+W+yeze~cAeBeCe. . .@+@. . +;%@&@-@. . ;@;@raDeEeFbkbFe. FbW$W$GeHeIe~cJeKe. . (@(@[@LeMe:d4bNeOe4@R&+%`~T))08/8/.<H_PeX}X}X}/1r2@323@3,5n4,5k7 7k7-829h8<8,9%0N9&0[0[0*0Q0Q05adadaTa bIaIa~b]b]b'cGc'c'cddFcDcLcQeWc-d>e-d1efdle@eRe",
"!{3;N<y^$#E 7;9*0*l:-#;#/ez3c;d;o4W,{#:1g;/#@^m|k;<#[#k*l*`,n*2!}(q;+'r;r,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,a|M!X:j']>}=^>SeTel'm'&[ <e$b55=6=s't'}2<+[+|+|+l$l$4+W-4+n$7+7+9+0+0+q$q$c+c+s$s$e+g+g+v&v&i+j+t$t$m+v$9=o+0=0=q+r+y$x$u+u+z&w+w+z$z$z$A$y+B$A+A+B+C+b=b=E$E+E$F+G+f=H+H+J+K+J+K+N+N+ dO+Ue6cR+h=S+ ;U+V+7cF&Y+G&L$`+`+N$H&.@P$P$J&#@%@%@&@*@K&>@R$ra>@M&#;M&Ve. ndX$W$O&{@]@P&Y$Q&_@(@'b<@<@}@1@1@1@1@R&4@n=T).~.~G]8/G]H_H_-}X}X}/1/1@3@3@3V3V3,5`6 7 7X7k7<0h8<8,9W9N9[b+060Q0!bQ0dadadaRaIaIaIaIa.b]b$cyb'cfczcFcQcLcLc#d,d-dfdOdOd@eWele",
"n/z>C D V=W=B>C>Z=D>k8R8`=N .-q%H>+-t%#-v%%-x%03.8Xe[#*-{)N>>0 :$.p*Yed~r,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,a|u]}:b,}_H)s<,+Zen}g,h,i,j,v<U-(+l,p&2>[+}+}+2+2+l$m$4+4+H(s&s&8+0+a+p$c+c+c+o,s$e+g+g+!dj+j+F]k+l+l+v$o+o+q+0=s+y$s+t+u+v+u+z&w+x+A$y+y+B$z+`cZ-B+C+D$D$A&E$G+G+B&H+5>H+g=J+K+N+N+N+O+M+Q+S+R+S+U+U+V+F&V+Y+X+Z+ @i=`+@@+@@@+@P0$@%@Q$-@*@-@@;;@R$~c. `e f.f+f. @f~@X${@P&^@/@/@/@(@_@(@<@Ca|@|@E9.% %4@R&+%E'T)T)8/G]G_H_B[X}-}q}r213@323@3V3n4,5 7 758X7P8<8<8<8N9N9*0&0*0*0305aja5ada bTaIa(b(b(b]b]b$c'cfczcDcDcLcLcWc-d,d-dfdOd#fleWe$f",
"@#B $)$#7*Y]O<0*]{-#/!>#`]c;.^e*W,X,[!g;Y,|!m|k;<#Z I[l*m*1{@9.'q;+'r;3{r,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,a|[=#[]>P!8$/>R!l'm'n'B_a5U!5=r'X!j$u'2>}+}+|+l$l$3+W-5+4+5+7+E]o$0+X-a+c+t&d+u&e+p,g+g+j+j+j+t$j+l+m+v$o+0=p+w$s+s+y$u+x&rd+dw+%fz$A$y+B$B$A+Z-D+C$D$E+E+E+<cG+G+G+H+H+`-I+L+K+M+M+M+C&O+O+S+S+S+ ;EcY+;aY+$dZ+ @ @&fN$H&+@P$+@P$$@%@%@-@*@;@;@j=>@*f. . . . . Ae=f{@O&]@]@]@/@Q&(@Q&'b[@[@[@|@1@1@1@R&R&R&T)E'T).~G]H_H_H_.<20X}^1^1@3m4@3n4V3,5`619 7k7P8<8<8,9%0W9+0+0[0*030305a5adadaFaIaSa;b$b]bybyb'c'cfcddDc-fLcWc;f&d-dededOdleWeWe>f",
"z>b4o/6*W=B>Y=Z=D>E>F>;)G>.-q%6~B^@-S87~8~x%0~z%&-[#*-{)+.]);->-p*_]d~!-r,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,a|a,f&G)H)d,W5t<,fz]'fi,j,v<`1W~O)p&<+[+}+}+|+2+w'l$4+6+n$7+7+s&s&a+c+n,c+c+o,e+e+g+6:h+h+j+j+l+t$l+K{m+o+0=q+q+r+y$x$u+u+u+w+z&z$x+x+B$B$A+A+B+C+D$D+D$A&A&c=G+f=e=f=I+J+g=K+L+N+J$C&P+K$6cR+S+S+V+U+V+Y+X+X+X+ @`++a.@.@@@P$P$$@$@&@&@-@;@K&;@R$,@*e)f8d!f:d~f{fW$X${@P&P&^@(@Z$(@(@_@`$[@}@[@1@r9 %R&R&R&T)T)8/)0G]H_.<H_X}q}q}q}r2@3^4V3,5n4`6 7`6k7X7P8<8<8W9N9W9+0*0*0[0305asada bdadaIa.b$b]b]byb$cfczcfczcFcDc,d#d,d,d/dfdfdOd@e@e]fWe",
"4;C $#@2~{{!^fV(l%0;(!_!c;d;o4f*:{B}g;/#i;m|X n|l;Z,%^/f+.@9.'$.+'(f)-x/r,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,a|O!V}P!^>Q!R!l'd^n'~+e^b5}>W!X!t'u'<+[+}+|+2+l$3+3+4+5+5+7+E]8+0+0+p$c+c+o,e+s$e+g+g+i+v&u$u$l+v$9=v$o+0=w$q+r+y$x$t+u+u+z&w+z$w+y+y+B$B$`cB+B+C+D$b=E$E$E$F+G+B&H+H+I+J+K+K+H$M+J$O+Q+Q+6cR+h= ;EcW+W+F&Y+X+.aN$N$N$O$H&+@P0J&%@&@za%@K&K&R$;@R$>@,@M&'@'@7>)@W$O&{@]@^@l=/@/@Q&(@_@[@<@}@[@|@1@2@1@R&+%`~`~.~.~G]G]H_.<.<B[q}q}r2@3@3@323V3,5`6k7j7k7<8X7<8s9b9N9N9*0*03030Q0Q05asadadaIaIa;b;b~byb$c$cVcKcddddIcLcWcWc-d-dededOd@e$fWeRe>f",
"&]$)~[*]B>z^4~;]-)F>'95~][Q|H>e;-3J>l|_f:f!):#^]z1<fn;=-`_;-c~(]_}7#8#-.r,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,a|}/[fw]I)x]}ff,z]h,d$j,X5U-W~C]D]k$}+}+P)2+2+l$4+4+q&n$7+7+8+0+0+p$c+c+d+e+e+g+h+h+h+h+j+t$F]l+m+K{n+o+p+r+r+s+s+t+t+t+v+w+z&z$z$x+B$B$A+A+B+Z-D+3eD$A&E+c=G+f=F$f=I+H+K+H$H$N+M+J$|fR+S+R+S+U+V+V+V+F&X+X+.a`+N$N$N$:a+@P0P0$@$@%@%@-@;@;@R$R$>@,@'@N&'@'@)@W$~@~@]@]@^@^@/@Q&/@_@_@:@[@[@1@|@ %3@.%R&n=T).~8/8/8/G_.<H_.<X}^1/1^1@3232323n4,5`6,5k7k7-8-8,9,9N9N9*0*0[0[0Q0Q0[a'adadaTaIaIa.b;b]bTbwcfcfcKczcDcLcQeWc,d,dfdfdOdOd#fWe>f>f1f",
"C g%h%~{X=2f]{J q/a;z3c;.^j|+^+b:1k|Y,V #^k;i*Z Z,%^|{+.--.'3!+'4!3{x/t;r,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,a|V}n1;+/>k'S!3fp1~+4f5fV!H|s't'Z!X~[+6f|+l$l$3+3+4+5+7+s&2_8+9+0+c+c+c+u&d+e+Y~g+h+g+i+v&j+l+m+9=n+v$o+w&w$s+s+s+t+u+u+z&+dw+z$y+y+B$y+B+A+|bB+b=D+E+E+E$F+d=f=H+H+`-J+K+H$L+BcM+O+O+Q+R+S+ ;EcV+F&Y+Y+Z+X+L$L$N$.@.@+@P$P$J&%@za%@&@K&K&K&>@R$,@,@L&'@)@k=W$W$~@~@O&]@]@^@^@Q&_@`$<@[@[@091@1@.%r94@R&+%E'.~T)F_G]G]p}.<X}q}^1r21323@323m6,5`6k7k7k7k7-8<8,9s9N9+0&0[0[0[0[0saQ0'adaRa bIaIa.b]bTbGcyb'c'czcDcIcQc#d#d,d^d-d-dOd@elele>fWe>f",
"j:((*]8*3~*#7f-) |.|5~][)#~]B^t%J>^#8~C^]]:#8fA%F^n;v0`_3#c~p*_]d~8#f~t*r,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,a|c,w]d,x]9f1/b$A]F(j,L)`1h$O)D]<+}+k$}+1+|+l$4+l$4+y'y'7+2_9+0+a+b+c+c+e+e+f+z'z'h+j+j+F]k+l+0fv$K{o+0=0=q+x$x$x$5/v+v+w+w+z$x+y+y+z+z+A+Z-B+D+C+E+E+G+c=G+B&f=H+H+`-`-K+wdN+J$J$P+Q+K$R+S+U+U+V+V+F&;aZ+ @ @ @N$O$O$+@+@P$$@$@$@&@&@K&K&;@R$,@,@M&M&'@V$)@,aW$~@{@]@l=/@/@Q&(@_@_@`$[@m=[@E91@.% %R&+%`~.~.~F_8/G]H_PeB[B[^1^1q}r2r2@3a9,5`6,5`6k7X7k7-8<8<8<8N9N9*0*0[0Q0Q0sasa'adaTaAa$b$b{bybyb$c$c'cddDcDcIcLcWc-d-dedfd1eOd#f$fWeaf>f1f",
"D E Y]X=H ]!-#K /{_!t/.^V,+^:{v/}!bf@^W ,8Y Z Z,l*B%+.--*a$.%.&.3{x/=a;.r,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,a|P!;+cfc^2:d^:>~+@(]+^+r'X!Y!u'<+E_}+1+|+l$3+3+n$4+y'n$7+0+0+0+b+q$c+s$r$s$e+g+h+v&h+j+u$k+l+v$K{o+o+p+q+r+s+s+t+u+u+u+z&w+z$y+x+ZcB$A+A+B+D$D$D+E+A&F+G+G+d=5>H+I+J+K+K+K+N+M+O+O+O+6cS+S+BbV+V+F&F&X+ @ @`+`+N$.@@@baP0J&$@$@za-@-@6>@;R$>@,@L&'@'@'@)@W$!@W$]@]@]@/@^@w0(@(@_@_@[@[@9>E91@1@.%R&R&E'T)T)T)F_8/H_-}B[-}q}/1q}@3m4@3V323n4,5n6`6k7-8h8h8W9%0,9N9[0&0*0Q0Q0Q05ada#cSaTaIaIa.b(bTbTbyb'cfcDcDcLcLcQe,d&ded-dfdfdOd$fleWe>f>f1f",
"%)*]7;&#4~D>-)F>;)5~d*)#~]~#-3J>^#8~<(]]y1^]A%F^n;=-/]3#}(5#6#7#8#f~a_P>r,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,a|}=d,x]0$`:U3;5d$o2[>5=3/df0|2>[+[+|+|+l$l$3+4+5+7+n$s&2_E]0+0+c+c+o,t&e+e+p,h+v&j+v&u$Tct$m+l+v$o+0=B's+7:y$t+t+rdu++dz$w+w+y+y+B$z+A+A+C+D+D+b=E+c=G+B&5>f=H+H+H+zbL+K+N+J$M+C&O+OcS+S+ ; ;V+;a-aX+X+L$Z+N$O$.@@@P$+@P$$@%@%@&@K&K&K&;@j=S$,@L&M&M&'@'@,a~@W$T9P&l=l=/@/@Z$_@`$_@<@[@}@1@1@r9.%R&+%`~T).~T)G]8/H_X}-}X}q}/1^1@32323n4n4,5,5`6 7X7k7<8<8,9W9+0+0N9[0)bQ05a'aNa'ada bRaIa(b.b]b$c$c'c'cfcfcIcIcLc#d,d,d-dededOdleleRe>f>fef1f",
"h%Y]p6H V(D2K /{M ^bd;V,+^R @-T l|i;W y%Y McA% .`,+.--[13!%.&.()=.E%*^8!r,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,a|;+cfc^2:3f+(ff{+p'#(r'(+Y!}2<+}+[+}+}+2+4+m$4+n$5+7+7+0+0+0+p$c+u&c+s$s$e+h+g+v&j+u$u$u$l+K{n+o+o+q+w$q+s+y$x$t+u+v+z&w+z$x+y+y+B$A+`cB+D+E+D+D$E+E$G+f=5>B&I+I+H+K+K+I$M+M+M+O+Q+Q+S+S+ ;V+V+Y+Y+X+X+ @`+N$N$@@@@baP$P$#@%@%@&@K&K&R$R$R$,@,@L&M&'@7>W$W$~@{@]@]@P&^@/@Z$(@(@`$[@}@[@1@r91@.%4@R&E'`~T)8/8/H_H_H_H_B[X}q}q}13r2@3n4n4,5n6k7k7k7k7k7<8<8,9W9N9N9[0*0Q060Q0sadadaRaIaIaIa.b]b]byb5cVcfcfcDcDcLcQeWcWc-dedfdOd@ele@eWe>f>fgfef",
"7*7;hf*#G[b*;#']c*_()#~]e;{#la^#:(<(]]y1a~[#k*n;v0n*b~c~p*6#r;if08a_a#<)r,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,a|S3x]y]`:E(2= <]1[>`1C_|>D][+<+|+}+2+2+l$4+W-n$4+7+7+8+0+0+b+n,n,c+u&e+e+g+f+h+v&u$j+k+k+l+l+o+o+0=o+r+s+'dx$t+t+v+w+w+z$a=y+y+y+A+z+C+B+|bC+D$E+E+G+F+B&H+H+H+I+J+K+K+N+M+ dM+Q+Q+S+S+U+V+V+;aX+Y+Z+X+Z+`+`+@@N$.@P$#@P$$@%@Q$Q$-@;@R$R$S$,@L&'@'@7>W$!@W${@{@]@^@Y$^@w0Z$10_@[@[@|@1@m=1@2@.%R&R&T)T)T)F_8/.<G].<X}q}q}q}r2r223@3V3n4n4,5j7 7k7X729<8,9%0N9+0[b*0[0Q060jadadaAa bSa.b{b(b]b]b'c'cfczcDcDcIcLcjf,d,d-d/dOdOd@eWeWe>faf1f1fkf",
"~{G C>k%D2K n%M t/p%P r%A}^[T l|V #^,<[{Z W( .B%+.>0*a$.%.&.)-x/E%;.:]F%G%-^!.&'J%T>^.t9N%31:.y*[.X>T%d!2.2-W%f!6.7.8.O26-!^b.!'d.e.lf0-+&]^i_$&n!c-`3=&p.f{I}-,f-t|h-(^J}~6r~mfB.nfT2ofV2pfK7<&J.:,}&(2R}qf0'F63&1,R/C-T/7&8&9&Z.v37,n<w[x[89$+L-M-rff&-+r<>+i&'+T!!+ffsfm&tf1_(+[2p&<+}+|+}+]4l$W-l$5+5+y'n$0+0+0+X-0+q$c+t&r$e+z'f+h+v&i+j+t$u$l+l+K{o+w&q+q+s+s+3_t+u+v+rdw+w+ufx+y+z+z+z+A+A+D+D+D$E+E+F+F+G+G+d=H+H+J+K+K+N+N+C&C&O+R+O+h= ; ;V+V+Y+Y+X+Z+Z+L$ @O$@@+@+@#@$@%@$@Q$Q$*@K&;@;@,@>@L&'@'@'@V$,aW$O&X$]@vfY$^@^@w0Q&(@`$`$}@}@1@|@ %R&+%+%+%+%7/T)8/8/H_.<.<X}X}q}r2^1r2@323V3n4,5 7 7k7k7h829,9s9,9N9*0*06030;eQ0Nasada bAaIaIa{b(b]b$cGc$cfczczcIcLcLcWcLc-d/dedfd@e@eWeWe>f>fafefkf",
"7;z^*#G[S0m:>#,#P<)#Q<W,>8]#^#:(<(]]:#8fl;[(n;=-wfo;.'q;q*G^8#9#a_'8b#<}0!H%%'{.g#h#i#2)k#l#m#y*|-p#D;q#D3s#.,F;;'w#x#1[0.)'8)m~xfF1G1K*h.M* /K#b)M#O*P*Q*S[O;0}T#~3T*V#V*X#yfzfAf $V7/3r_BfCfj]k]v4&=-$@>>$-=Df)$,1~$Efw_Ff->($Q3{=T:[$'>|$!>L!<=[=5$A_7$C(9$&}1=_>2= <2/[>}>C_C]=[<+[+}+|+|+2+l$l$5+5+4+7+E]7+8+0+a+c+c+c+t&t&e+g+z'h+i+v&j+u$t$l+m+K{o+o+B'q+r+s+x$u+u+u++dw+A$a=A$y+B$A+A+Z-C+GfD$E+E+c=F+F+G+5>5>H+zbJ+=dL+N+N+J$J$O+Q+R+S+S+h=U+W+X+X+X+Z+Z+N$N$N$.@@@P$$@#@$@%@%@-@-@K&@;j=,@,@,@'@'@7>'@)@W$W${@]@^@l=^@Q&(@(@:@`$[@}@|@1@1@3@4@+%+%`~T)7/G]F_G]H_H_-}X}q}Da^123@3@3V3a9,5,5k7k7k7k7h8<8,9s9W9N9*0*0*0[0Q0sa'ada bTaTa.b]b~b(b$c$cfc'cfczczcLcIc,d-d-d/dfdOdOd@eleWeWe>f1f1fefHf",
"G Y=k%D>>]L -0N .-P r%R @-J>$-%-Xc,<z%McA%*-{)N>`_[1$.,-/)va!-E%e3:],.'.R>!.)<6{K%^.<-N%V>:.<.W>}.T%1-2.2-=2f!If3]8.x#6-!^ &!'8-h39-g.+&i.#&$&l.c-*&=&p.;&Q#-,,&e)v.i-U*y.h)i3#8k3l3m3$8o3Jfs-J.:,=4|&KfE6P.z-R.;4T._2Lf:_E-MfG-0&7,.+H-B)d&K-NfM-N-f&-+r<uec^ (T!g,Q-{+]+T-/+k,_+:+<+E_}+2+2+2+3+3+4+5+7+7+7+0+0+X-n,c+c+c+o,e+z'f+h+v&v&v&F]u$m+K{o+o+o+r+r+w$r+t+t+u+rdv+w+w+z$x+B$y+*dz+B+B+D+D+D+D$G+F+G+B&d=5>H+H+g=J+K+L+M+M+J$O+K$S+R+S+ ;h=U+V+X+Z+X+`+L$i=O$+@@@+@+@#@#@$@-@Q$-@-@R$;@>@>@,@T$T$'@7>!@!@{@~@T9]@Y$^@^@/@Z$_@(@[@[@}@|@1@ %4@4@R&+%`~.~8/8/8/G].<.<B[X}q}q}13@3^4V3n4n4,5n6 7 7k729<8<8s9ycN9&0[0[0*0Q05aQ05ada bIaAaIa.b{b]b'cwc$c'czcDcFcLcLc#d#d>eedOdOdOd$fWeWe1fef1fefkfef",
"O<0*G[-#0;.|,#P<)#A^f*{#f;g;/#<{j;D^8fl;k*%^1#n*3#p;q;q*r;8#9#t;7!629!'.Of%'&'g#11i#j#x*O%m#C;o#A*1-q# ,E;3-)^v#e_h!I;0.F* &J;~'I*c{K*H#l!i_N;n!p~d-N09]q.O;P;Q;~3T*PfS;X#QfH3RfSfTfK3.=M3UfVfq(*$&=+>;$O3-=Df;=>=~$T}*>=>/$x_Q3{=f'64!1|$z_2$Wf[=Xf]>}=8$/>0$1=meYfo'e$[>5=6=D_t'<+}+}+|+1+l$2+3+m$4+y'7+s&8+0+0+0+b+c+u&u&s$e+f+h+g+i+v&j+t$l+l+9=o+v$0=0=q+r+t+y$t+rdv+w+z&a=A$A$x+y+B$z+ZfC+GfC$b=D$A&A&F+G+H+H+H+`-g=K+H$BcM+C&J$Q+R+Och=h=T+V+F&X+F&Z+X+L$N$N$N$.@+@+@J&P$$@@a&@-@-@;@K&>@>@,@,@M&'@'@7>W$W$W$]@]@l=^@/@/@(@Z$_@<@[@}@}@m=1@r91@R&6/+%U).~.~G]G]H_B[-}B[X}q}/1^1@3@3V3n4,5`6`6j7-8-8X7<8%0b9N9N9*0[0[060;e5ajadadaIaIaIaIa.b~b$c$c'cfc'czcDcIcWc#d#d#d,dfd/d@eleleWeWe1f1f1fefef`f",
"C>I `7K F>`= -.-q%Q I>v/J>^}%-x%!)(}&-A%*-M>N>`_;-$.%.&.*.!--.e3:]<)^-).!.|){.T>h#1)N%V>72}-[.d4p#1-`> ,4.5.g! g8.Y%6-'3b.~^d.~'E#>:h.@&j.$&%&c-p~H5O#;&d) 1;,e)f)(7J}y..1',.ga<28o-38q-+g<&]_:,=4r3[,x-y-z-R.1,T.J~y):_E-M~Z.0&7,.+o<c&d&K-L-M-[_f&O-|:>+J)j&)+P-~4i,u<v<1_k,l,p&2>%(}+|+l$2+3+3+4+7+y'7+8+2_0+X-n,n,c+u&u&e+e+g+g+j+j+v&u$t$l+l+K{n+o+0=r+r+'dy$t+u+t+v+z&z$z$ufx+y+}bA+A+B+D+C+D$E+E+E+G+G+e=d=H+H+H+K+H$H$BcC&M+O+Q+Q+R+S+U+U+F&V+X+Y+Z+L$`+i=N$.@+@+@P$$@$@$@%@&@-@K&K&;@R$,@L&T$'@'@)@)@k=T9~@]@l=<a^@/@(@(@(@@g`$[@}@091@1@ %4@+%R&+%T)T)8/G]H_.<X}B[-}q}/1^1@3@3a9n4V3,5n6 7k7k7P8-8,9ycN9N9+0[0[030!bQ0Q05a'aFaSaIaIa]b~b]b'c$c'cfcfczcQcLcQe,d-d,d-dedOdOd@eWeWe>fgfefef`fkf#g",
"0*l:C80;>#c*c;:!e*W,:{]#g;/#i;j;,8<#j*k*$g1! '3#Q7q;+'r;8#x/t;'8b#=^'.H%x;&'g#A;7{w*;6O%>6C;z*p#D;<5C*2-t#5.N[w#h!1[0.5] &J;xfI*K;81k!~8a)K#N*p~r|=&%gS[I}s.T#~3T*i-;2T;_'}4W;X;142434 >&g%$&$C|*g8'@>D!=g'$)$!$+}'=d'U}/$w4~=;>T:^='>|$D{L!<3[=j']>}=^>/>&}l'_>&[*}e$4=q'W!D_t'-g2>[+|+|+2+l$l$3+5+4+5+7+7+9+0+a+q$c+c+u&r$e+g+h+g+i+j+j+F]k+l+n+m+o+w&o+r+r+s+x$t+u+v+rdw+z$z$A$x+*dA+z+B+A+C+D+D$E+E+E$G+f=F$5>I+`-J+K+K+H$;gC&D&Q+O+S+S+Bb ;h=V+V+;aZ+ @ @N$`+N$@@+@+@J&J&$@$@&@K&K&;@K&R$R$,@,@'@'@'@!@!@X$W$X$O&l=^@^@Z$(@(@_@`$[@[@1@|@1@ %R&R&+%S)T)8/T)8/G]H_.<-}X}X}^1r2@32323n423n4,519k7k7-829<8s9<8N9&0ia*0[0Q0Q0Q0sadaSa bAa.bIa~b]bybyb'cKczcDcIcIcIcLcLc,d,ded1eOdOdWe>f>f>f>f1f1fefefkf",
"Z=D>m%L ;)E2)]q%Q R t%J>l|%-9~!)z%K2K> .{)+.])>g>-,g_]d~!-~-0#:],.Q>R>S>|)g~:-'g1)U>,0P%$|C;X>p#@_q#2-4.3-6.+,8.6)7)`%b.-:8-719-G10)n~j.^^%&G5d-N#O#P#d) 1;,>,f)g)U*(0X#)gf4k)!g~g{gh4]g^gJ.u-/gr3[,x-P.u)R.B-2,C-y)7&m<4,u30&7,8,)1B)7|9,0,q9q<F)O-(gs<J)j&f,K)h,i,+3v<_gW~_+m,[+k$}+}+}+l$3+3+4+q&n$s&7+9+0+a+a+X-:gs$t&e+<ge+f+h+h+u$F]t$t$l+m+o+o+w&r+r+s+7:y$u+t++dz&z&z$ufy+y+z+z+A+Z-D+D$C+E+F+A&G+B&e=F$H+H+zbJ+K+K+M+M+M+C&R+R+S+h=EcV+V+W+7cY+G& @Z+`+.@O$.@+@+@P$#@%@@a-@-@K&;@;@R$>@,@,@L&'@!@k=,a8>{@]@]@l=P&/@Q&(@:@'b[@[@}@m=|@.% % %R&`~E'.~T)8/.~G_.<-}X}-}X}/1^1m4r2@3V3A4,5n6k7k7-8h8X7<8<8N9N9&0ia[0[0Q05asa5ada bFaIaIa]b{b]b$c$c'c'cfcIcIcDcIcLcLc-d-dOdfd@elele[gWe>f1fefefefHfef",
"l:l%q/>#b;_(d;_{W,X,B}k|/#@^}g|g<#j*Z,l*..1{o;w/3!6#r;8#08#'*^8!=^0!H%*2C3g#A;;^M%k#O%:.,6o#X>|.d!C*s#t#E};'e_,'1['')'i!!'d.#,f.K*H#M*#&K#N*o!O*=&Q*q.O;P;{8u.T*V#S;T;n0G8<'s41g2gI83g4g4'$=6'7't{5g9'6g#>)$7g,='=d'U}e'Y.~=;>T:I!g'|$D{i'<=[=l1]>Y/^>/>k'1=_>:>*}e$4=g$6=X!t'Z!}+k$}+2+2+l$W-3+n$q&7+s&7+7+8+a+0+b+c+o,d+e+g+Y~g+h+v&u$t$u$l+m+m+o+o+q+q+r+s+t+u+t+u+z&8gz$x+y+B$B$z+A+Z-B+D$D+b=E$E+F+G+G+B&B&`-I+H+K+K+H$M+J$M+O+6cR+R+ ;EcU+V+F&Y+;aL$ @`+`+O$O$@@+@P0J&$@%@%@-@K&K&K&;@,@>@,@M&'@)@'@!@X$W${@]@]@]@/@Z$(@Q&<@:@_@[@|@1@1@ %.%R&R&S)T).~8/8/G_H_p}.<9gq}q2^1@3@3V323,5`6<6k7 7k7X7h80g<8s9W9N9*0+0[030x0Q0dadada bIaSa.b$b]b]bybfc'czcfcDcagIc#d,d-d-dedOded@e@eleWe>f>fefefHfkfHfef",
"=#m% |;)G>'#q%6~B^t%O6^#8~9~,<:#&-K>*-M>=-C%J9{0p*_]*.+|E%0#:]:}^-).S>|)g~:-[}1)WaV>P%}-[.|-i~1-V%3.4.f!6.v#8.6)6-'3l~8)6]e.F1g.+&L*j.$&%,&&*&H5p.Q*Q# 1f-T#f)U#U*T[X#i)j)bgX8cgdgegz~&5fgu-v-=$-4x-y-j}v)n]o]'16&7&8&4|5,0&O~8,H-x[d&w30,q9a,b,[fH)ueJ)t<n}b$T~i,j,v<M)W~_+gg2><+}+2+1+l$3+3+3+4+H(n$8+9+0+n,X-q$c+t&s$s$e+Y~g+h+h+j+u$t$l+l+K{n+o+0=w$r+s+t+y$u+v+v+w+z$z$z$A$YcB$A+B+A+D+C+D+hgA&E$G+G+B&F$H+H+J+K+J+H$M+M+O+P+R+Q+S+S+S+U+V+V+F&X+X+ @`+N$+a@@@@+@+@$@$@$@%@%@-@K&;@R$,@,@M&,@M&'@'@)@W$W$]@]@]@^@Y$Z$/@(@(@_@[@}@}@1@1@ % %4@R&+%+%T)T)8/H_H_H_-}-}X}X}q}^1r223igV3n4,5,5`6k7-8X729<8,9ycW9~0*0ca[0Q05a5asadada bIaIaIa{b]b]b5c'czcddDcagLcWc,dWced-dfdfdOd$fleWeWeafjgefefefef#gkf"};

#endif
