/***************************************************************************
 *   Copyright (C) 2008 by Joerg Zopes   *
 *   joerg.zopes@linux-specialist.com   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#ifndef WIFISETUP_H
#define WIFISETUP_H

#include <qmultilinedit.h>
#include <qbuttongroup.h>
#include <qradiobutton.h>
#include <qinputdialog.h>
#include <qprogressbar.h>
#include <qpushbutton.h>
#include <qmessagebox.h>
#include <qtextstream.h>
#include <wifistartup.h>
#include <qcombobox.h>
#include <qlineedit.h>
#include <qtooltip.h>
#include <qprocess.h>
#include <qdialog.h>
#include <qlabel.h>
#include <qframe.h>
#include <qlabel.h>
#include <qtimer.h>
#include <qfile.h>
#include <qfont.h>
#include <cstdlib>
#include <cstring>
#include <qdir.h>

/**
    @author Joerg Zopes <joerg.zopes@linux-specialist.com>
 */
class wifiSetup : public QDialog
{
    Q_OBJECT
    public:
        wifiSetup(QWidget*,const char *, const char *);
        virtual ~wifiSetup();
    private:
        QString             interface;
        QFrame            * commentFrame;
        QFrame            * mainFrame;
        QFrame            * ipSetupFrame;
        QFrame            * profileFrame;
        QFrame            * wifiFrame;
        QLabel            * essidLabel;
        QLabel            * cryptLabel;
        QLabel            * modeLabel;
        QLabel            * deviceLabel;
        QLabel            * keyLengthLabel;
        QLabel            * ipAddrLabel;
        QLabel            * netMaskLabel;
        QLabel            * defaultRouteLabel;
        QLabel            * DNSLabel;
        QLabel            * secondaryDNSLabel;
        QLabel            * confLabel;
        QLabel            * preConfScriptLabel;
        QLabel            * postConfScriptLabel;
        QLabel            * signalLevelLabel;
        QLabel            * nicknameLabel;
        QLabel            * channelLabel;
        QLabel            * bitRateLabel;
        QLabel            * bitRateValueLabel;
        QLabel            * signalQualityLabel;
        QLineEdit         * keyEdit;
        QLineEdit         * ipAddrEdit;
        QLineEdit         * netMaskEdit;
        QLineEdit         * defaultRouteEdit;
        QLineEdit         * DNSEdit;
        QLineEdit         * secondaryDNSEdit;
        QLineEdit         * preConfScriptEdit;
        QLineEdit         * postConfScriptEdit;
        QLineEdit         * nicknameEdit;
        QComboBox         * cryptComboBox;
        QComboBox         * essidComboBox;
        QComboBox         * modeComboBox;
        QComboBox         * confComboBox;
        QComboBox         * channelComboBox;
        QComboBox         * bitRateComboBox;
        QRadioButton      * hexButton;
        QRadioButton      * asciiButton;
        QRadioButton      * passphraseButton;
        QRadioButton      * ipConfig;
        QRadioButton      * dhcpConfig;
        QRadioButton      * disableInterfaces;
        QButtonGroup      * buttonGroup;
        QButtonGroup      * configGroup;
        QMultiLineEdit    * commentEdit;
        QPushButton       * scanButton;
        QPushButton       * editButton;
        QPushButton       * submitButton;
        QPushButton       * closeButton;
        QPushButton       * saveButton;
        QPushButton       * delButton;
        QPushButton       * preConfButton;
        QPushButton       * postConfButton;
        QProcess          * scanProcess;
        QProcess          * find_wpa_supplicantProcess;
        QProcess          * find_iwlistProcess;
        QProcess          * find_iwconfigProcess;
        QProcess          * find_dhclientProcess;
        QProcess          * get_hostname;
        QProcess          * getSignalLevelProcess;
        QProgressBar      * signalLevel;
        QTimer            * getLevelTimer;
        QString             wpa_supplicantPath;
        QString             iwlistPath;
        QString             iwconfigPath;
        QString             dhclientPath;
        QString             findResult;
        QString             hostname;
        QString             basePath;
        QString             filePath;

        void enableControls(bool);
        void initWidget();
        void loadConfig();
        bool checkValidHex(QString);
        bool checkIP(QString);
        bool checkNetMask();
    private slots:
        void slot_find_wpa_supplicantProcessExited();
        void slot_keyTextChanged(const QString &);
        void slot_getSignalLevelProcessExited();
        void slot_find_iwconfigProcessExited();
        void slot_find_dhclientProcessExited();
        void slot_cryptComboBoxActivated(int);
        void slot_modeComboBoxActivated(int);
        void slot_find_iwlistProcessExited();
        void slot_getHostnameProcessExited();
        void slot_configGroupClicked(int);
        void slot_postConfButtonClicked();
        void slot_getLevelTimerTimeout();
        void slot_preConfButtonClicked();
        void slot_submitButtonClicked();
        void slot_closeButtonClicked();
        void slot_scanButtonClicked();
        void slot_scanProcessExited();
        void slot_editButtonClicked();
        void slot_saveButtonClicked();
        void slot_delButtonClicked();
        void loadStage2(int);
};

#endif
