/***************************************************************************
 *   Copyright (C) 2005 by SUZUKI Tasuku                                   *
 *   tasuku@linux-life.net                                                 *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#include "kkagroup.h"
#include "kkaperson.h"
#include "kkacontactdata.h"
#include "kkahomeaddress.h"
#include "kkaofficeaddress.h"

#include <kdebug.h>
#include <kiconloader.h>

using namespace KKAddressBook;

KKAGroup::KKAGroup( QListView* parent )
	: KListViewItem( parent )
{
	setPixmap( 0, SmallIcon( "folder" ) );
	setRenameEnabled( 0, true );
}

KKAGroup::KKAGroup( QListView* parent, QDomNode& node )
	: KListViewItem( parent )
{
	setPixmap( 0, SmallIcon( "folder" ) );
	setRenameEnabled( 0, true );
	readData( node );
}

KKAGroup::KKAGroup( QListViewItem* parent )
	: KListViewItem( parent )
{
	setPixmap( 0, SmallIcon( "folder" ) );
	setRenameEnabled( 0, true );
}

KKAGroup::KKAGroup( QListViewItem* parent, QDomNode& node )
	: KListViewItem( parent )
{
	setPixmap( 0, SmallIcon( "folder" ) );
	setRenameEnabled( 0, true );
	readData( node );
}

KKAGroup::~KKAGroup()
{
// 	m_list.setAutoDelete( true );
}

void KKAGroup::readData( QDomNode& node )
{
	QDomElement elem = node.toElement();
	setText( 0, elem.attribute( "title" ) );
	setOpen( elem.hasAttribute( "isopen" ) );
	listView()->setSelected( this, elem.hasAttribute( "isselected" ) );

	for( QDomNode child = node.lastChild(); !child.isNull(); child = child.previousSibling() )
	{
		QDomElement e = child.toElement();
		if( e.tagName() == tagName() )
		{
			new KKAGroup( this, child );
		}
		else if( e.tagName() == KKAContactData::tagName() )
		{
			m_list.append( new KKAContactData( child.toElement(), listView() ) );
		}
	}
}

QDomElement KKAGroup::toElement( QDomDocument& doc )
{
	QDomElement elem = doc.createElement( tagName() );
	elem.setAttribute( "title", text( 0 ) );
	if( isOpen() )
	{
		elem.setAttribute( "isopen", "1" );
	}
	if( isSelected() )
	{
		elem.setAttribute( "isselected", "1" );
	}
	QListViewItem* child = firstChild();
	while( child )
	{
		elem.appendChild( ((KKAGroup*)child)->toElement( doc ) );
		child = child->nextSibling();
	}

	for( KKAContactData* person = m_list.first(); person; person = m_list.next() )
	{
		elem.appendChild( person->toElement( doc ) );
	}
	return elem;
}

void KKAGroup::plug( QListView* lvw )
{
	for( KKAContactData* person = m_list.first(); person; person = m_list.next() )
	{
		new KKAPerson( lvw, person );
	}
}

void KKAGroup::unplug( QListView* lvw )
{
	QListViewItem* child = lvw->firstChild();
	m_list.clear();
	while( child )
	{
		m_list.append( ((KKAPerson*)child)->data() );
		lvw->takeItem( child );
		child = lvw->firstChild();
	}
}

void KKAGroup::cache( QListView* lvw )
{
	QListViewItem* child = lvw->firstChild();
	m_list.clear();
	while( child )
	{
		m_list.append( ((KKAPerson*)child)->data() );
		child = child->nextSibling();
	}
}

void KKAGroup::addPrintData( QPtrList<KKAContactData>& data )
{
	QListViewItem* parent = firstChild();
	while( parent )
	{
		((KKAGroup*)parent)->addPrintData( data );
		parent = parent->nextSibling();
	}
	for( KKAContactData* person = m_list.first(); person; person = m_list.next() )
	{
		if( person->home()->printStatus() == KKAAddressData::Print )
		{
			data.append( person );
		}
		else if( person->office()->printStatus() == KKAAddressData::Print )
		{
			data.append( person );
		}
	}
}

void KKAGroup::addImportData( KKAContactData* data )
{
	m_list.append( data );
}
