/***************************************************************************
 *   Copyright (C) 2005 by SUZUKI Tasuku                                   *
 *   tasuku@linux-life.net                                                 *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#ifndef _KKDIMAGEITEM_H_
#define _KKDIMAGEITEM_H_

#include "kkditembase.h"
#include <qimage.h>

namespace KKDesigner
{
	class KKDImageItem : public KKDItemBase
	{
		Q_OBJECT
		Q_PROPERTY( QImage image READ image WRITE setImage )
	public:
		KKDImageItem( const QPoint& l, const QSize& s, QObject* parent = 0 );
		KKDImageItem( const QPoint& l, const QImage& i, QObject* parent = 0 );
		KKDImageItem( QDomElement e, QObject* parent = 0 );
		KKDImageItem( const KKDImageItem* item, QObject* parent = 0 );
		virtual ~KKDImageItem();

		static const QString tagName(){ return QString( "Image" ); }
		QDomElement toElement( QDomDocument& doc, const QString& t = QString::null );

		//BEGIN PROPERTIES
		virtual ItemType type() const { return ImageItem; }

		const QImage& image() const { return m_image; }
		virtual bool imagePrint() const { return true; }
		//END   PROPERTIES

	public slots:
		//BEGIN PROPERTIES
		void setImage( const QImage& i );
		//END   PROPERTIES

	signals:
		//BEGIN Properties
		void imageChanged();
		//END   Properties

	protected:
		virtual void drawItemBefore( QRect& r, QPainter& p, DrawMode m, const KKAddressBook::KKAContactData* d );
		virtual void drawItemAfter( QRect& r, QPainter& p, DrawMode m, const KKAddressBook::KKAContactData* d );

	private slots:
		void resizeImage();

	private:
		QImage m_image;
		QImage m_resizedImage;
	};
}
#endif /* _KKDIMAGEITEM_H_ */
