/***************************************************************************
 *   Copyright (C) 2005 by SUZUKI Tasuku                                   *
 *   tasuku@linux-life.net                                                 *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#include "kkswidget.h"
#include "../kkaddressbook/kkacontactdata.h"
#include "../kkaddressbook/kkadetailview.h"
#include "../kkdesigner/kkddoc.h"
#include "../kkdesigner/kkdview.h"

#include <qfile.h>
#include <qdom.h>

#include <kconfig.h>
#include <kaction.h>
#include <klocale.h>
#include <kdebug.h>
#include <kstandarddirs.h>
#include <kmessagebox.h>

using namespace KKSender;

KKSWidget::KKSWidget( KCommandHistory* cmdHistory, QWidget* parent, const char* name )
	: KKWidgetBase( cmdHistory, parent, name )
{
	m_doc = NULL;
	m_dvw = new KKAddressBook::KKADetailView( false, this );
	m_pvw = NULL;
	
	new KToggleAction( i18n( "&Preview" ), "", KShortcut(), this, SLOT( togglePreview() ), actionCollection(), "sender_preview" );

	QString datafile = locateLocal( "data", KGlobal::instance()->instanceName() + "/sender.xml" );
	QDomDocument doc( "kkaddress" );
	QFile file( datafile );
	if( file.open( IO_ReadOnly ) )
	{
		if( !doc.setContent( &file ) )
		{
			createData( doc );
		}
		file.close();
	}
	else
	{
		createData( doc );
	}
	m_sender = new KKAddressBook::KKAContactData( doc.documentElement().firstChild().toElement(), this );
	
	m_dvw->setData( m_sender );
}

KKSWidget::~KKSWidget()
{
	QString datafile = locateLocal( "data", KGlobal::instance()->instanceName() + "/sender.xml" );
	QDomDocument doc( "kkaddress" );
	doc.appendChild( doc.createProcessingInstruction( "xml", "version=\"1.0\" encoding=\"UTF-8\"" ) );
	QDomElement root = doc.createElement( "kkaddress" );
	root.setAttribute( "version", "0.1" );
	root.appendChild( m_sender->toElement( doc ) );
	doc.appendChild( root );
	QFile file( datafile );
	if ( !file.open( IO_WriteOnly ) ){
		KMessageBox::sorry( this, i18n("Can not open file") );
		return;
	}
	QTextStream str( &file );
	str << doc;
	file.close();
}

void KKSWidget::createData( QDomDocument& doc )
{
	doc.appendChild( doc.createProcessingInstruction( "xml", "version=\"1.0\" encoding=\"UTF-8\"" ) );
	QDomElement root = doc.createElement( "kkaddress" );
	root.setAttribute( "version", "0.1" );

	QDomElement sernder = doc.createElement( "personaldata" );
	sernder.setAttribute( "prefix", "" );
	sernder.setAttribute( "name", i18n( "Your name" ) );
	sernder.setAttribute( "suffix", "" );
	root.appendChild( sernder );
	doc.appendChild( root );
}

bool KKSWidget::closable()
{
	return true;
}

void KKSWidget::tabChanged( bool /*enabled*/ )
{
}

void KKSWidget::readConfig( KConfig* conf )
{
	conf->setGroup("Sender");

	if( conf->hasKey( "HSplit" ) )
	{
		setSizes( conf->readIntListEntry( "HSplit" ) );
	}

	if( conf->readBoolEntry( "Preview" ) )
	{
		((KToggleAction*)action( "sender_preview" ))->setChecked( true );
		togglePreview();
	}
}

void KKSWidget::saveConfig( KConfig* conf )
{
	conf->setGroup("Sender");
	conf->writeEntry( "HSplit", sizes() );
	conf->writeEntry( "Preview", ((KToggleAction*)action( "sender_preview" ))->isChecked() );
}

void KKSWidget::togglePreview()
{
	if( ((KToggleAction*)action( "sender_preview" ))->isChecked() )
	{
		if( !m_pvw )
		{
			m_pvw = new KKDesigner::KKDView( KKDesigner::KKDItemBase::AddressMode, m_doc, this );
			m_pvw->documentChanged();
			m_pvw->setSender( m_sender );
		}
		m_pvw->show();
	}
	else
	{
		m_pvw->hide();
	}
}
