/***************************************************************************
 *   Copyright (C) 2005 by SUZUKI Tasuku                                   *
 *   tasuku@linux-life.net                                                 *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#include "kktcategoryitem.h"
#include "kktitem.h"

#include <qfile.h>
#include <qdom.h>
#include <qdir.h>
#include <qregexp.h>

#include <kglobal.h>
#include <klocale.h>
#include <kdebug.h>
#include <kiconloader.h>
#include <kmessagebox.h>

using namespace KKTemplate;

KKTCategoryItem::KKTCategoryItem( KListView* parent, QString path )
	: KListViewItem( parent )
	, m_strPath( path )
{
	readMetaData();
	readChildren();
	setOpen( true );
}

KKTCategoryItem::KKTCategoryItem( KListViewItem* parent, QString path )
	: KListViewItem( parent )
	, m_strPath( path )
{
	readMetaData();
	readChildren();
}

void KKTCategoryItem::readMetaData()
{
	setPixmap( 0, SmallIcon( "folder" ) );

	QFile file( m_strPath + "metadata.xml" );
	if( !file.open( IO_ReadOnly ) )
	{
		KMessageBox::error( (QWidget*)parent(), i18n( "File open error\n%1" ).arg( m_strPath ) );
		return;
	}

	QDomDocument doc( "kktemplate" );
	if( !doc.setContent( &file ) )
	{
		KMessageBox::error( (QWidget*)parent(), i18n( "File is not kreetingkard template format" ) );
		file.close();
		return;
	}
	file.close();

	QString lang = KGlobal::locale()->language();

	for( QDomNode n = doc.documentElement().firstChild(); !n.isNull(); n = n.nextSibling() )
	{
		QDomElement elem = n.toElement();
		if( elem.tagName() == "category" )
		{
			if( ( elem.attribute( "lang" ) == "C" && text( 0 ).isEmpty() ) || elem.attribute( "lang" ) == lang )
			{
				setText( 0, elem.text().remove( '\t' ).remove( '\n' ) );
			}
		}
	}
}

void KKTCategoryItem::readChildren()
{
	QRegExp rx( "^([0-9]+)_(.*)$" );
	QDir dir( m_strPath );
	QStringList list = dir.entryList( QDir::Dirs|QDir::Readable, QDir::Name );

	for( QStringList::iterator it = list.begin(); it != list.end(); ++it )
	{
		if( (*it)[0] != '.' )
		{
			if( rx.search( *it ) > -1 )
			{
				KKTCategoryItem* item = new KKTCategoryItem( this, m_strPath + *it + "/" );
				item->setText( 1, QString( "%1" ).arg( rx.cap( 1 ).toInt(), QString::number( list.size() ).length() ) );
			}
			else
			{
				m_list.append( new KKTItem( m_strPath + *it + "/" ) );
			}
		}
	}
	m_list.setAutoDelete( true );
}
