/**
 * @file libgalago-gtk/galago-gtk-contact-chooser-widget.h
 *       Contact chooser widget
 *
 * @Copyright (C) 2005-2006 Christian Hammond.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA  02111-1307, USA.
 */
#ifndef _GALAGO_GTK_CONTACT_CHOOSER_WIDGET_H_
#define _GALAGO_GTK_CONTACT_CHOOSER_WIDGET_H_

typedef struct _GalagoGtkContactChooserWidget      GalagoGtkContactChooserWidget;
typedef struct _GalagoGtkContactChooserWidgetClass GalagoGtkContactChooserWidgetClass;
typedef struct _GalagoGtkContactChooserWidgetPriv  GalagoGtkContactChooserWidgetPriv;

#include <libgalago-gtk/galago-gtk-contact-chooser.h>
#include <gtk/gtkvbox.h>

#define GALAGO_GTK_TYPE_CONTACT_CHOOSER_WIDGET (galago_gtk_contact_chooser_widget_get_type())
#define GALAGO_GTK_CONTACT_CHOOSER_WIDGET(obj) \
		(G_TYPE_CHECK_INSTANCE_CAST((obj), GALAGO_GTK_TYPE_CONTACT_CHOOSER_WIDGET, GalagoGtkContactChooserWidget))
#define GALAGO_GTK_CONTACT_CHOOSER_WIDGET_CLASS(klass) \
		(G_TYPE_CHECK_CLASS_CAST((klass), GALAGO_GTK_TYPE_CONTACT_CHOOSER_WIDGET, GalagoGtkContactChooserWidgetClass))
#define GALAGO_GTK_IS_CONTACT_CHOOSER_WIDGET(obj) \
		(G_TYPE_CHECK_INSTANCE_TYPE((obj), GALAGO_GTK_TYPE_CONTACT_CHOOSER_WIDGET))
#define GALAGO_GTK_IS_CONTACT_CHOOSER_WIDGET_CLASS(klass) \
		(G_TYPE_CHECK_CLASS_TYPE((klass), GALAGO_GTK_TYPE_CONTACT_CHOOSER_WIDGET))
#define GALAGO_GTK_CONTACT_CHOOSER_WIDGET_GET_CLASS(obj) \
		(G_TYPE_INSTANCE_GET_CLASS ((obj), GALAGO_GTK_TYPE_CONTACT_CHOOSER_WIDGET, GalagoGtkContactChooserWidgetClass))

struct _GalagoGtkContactChooserWidget
{
	GtkVBox parent_object;

	GalagoGtkContactChooserWidgetPriv *priv;

	void (*gtk_reserved1)(void);
	void (*gtk_reserved2)(void);
	void (*gtk_reserved3)(void);
	void (*gtk_reserved4)(void);
};

struct _GalagoGtkContactChooserWidgetClass
{
	GtkVBoxClass parent_class;

	void (*gtk_reserved1)(void);
	void (*gtk_reserved2)(void);
	void (*gtk_reserved3)(void);
	void (*gtk_reserved4)(void);
};

G_BEGIN_DECLS

GType galago_gtk_contact_chooser_widget_get_type(void);

GtkWidget *galago_gtk_contact_chooser_widget_new(void);

G_END_DECLS

#endif /* _GALAGO_GTK_CONTACT_CHOOSER_WIDGET_H */
