/*
 * libopensync - A synchronization framework
 * Copyright (C) 2004-2005  Armin Bauer <armin.bauer@opensync.org>
 * Copyright (C) 2008       Daniel Gollub <dgollub@suse.de>
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307  USA
 * 
 */

#ifndef _OPENSYNC_HASHTABLE_INTERNALS_H_
#define _OPENSYNC_HASHTABLE_INTERNALS_H_

#define OSYNC_HASHTABLE_DB_PREFIX "tbl_hash_"

/*! @brief Represent a hashtable which can be used to check if changes have been modifed or deleted */
struct OSyncHashTable {
	int ref_count;
	OSyncDB *dbhandle;

	GHashTable *reported_entries;

	GHashTable *db_entries;

	char *name;

	/* Only to build transaction queries */
	GString *query;
};

#endif /*_OPENSYNC_HASHTABLE_INTERNALS_H_*/
