# vim: ts=4
###
#
# Listen is the legal property of mehdi abaakouk <theli48@gmail.com>
# Copyright (c) 2006 Mehdi Abaakouk
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2 as
# published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#
###


import gtk
import gobject
import stock

from song import Song

from library import Library,Playlist,library_wrapper
from  _source import Source,SourceItem,PlaylistSourceItem
from widget.song_view import SortableSongView,SongView,PlaylistSongView
from widget.browser import Browser
from widget.song_menu import SongMenu

from helper import helper 

from daap import DAAPClient
from service_discover import service_discover

class DaapSource(Source):
    #load_priority = 0
    display_index = 150
    def __init__(self,player):
        Source.__init__(self,player)
        self.services = {}
        
    def load(self,player):
        service_discover.connect_service("_daap._tcp",self.connect,self.disconnect)    
        
    def connect(self,*args):
        add,port,name = service_discover.resolve(*args)
        print args
        print args[:-1]
        gobject.idle_add(self.add_service,args[:-1],add,port,name)
        
    def add_service(self,args,address, port,name):
        l =  DaapLibrary(address, port)
        l.load()
        self.services[args] = l 
        self.paned_browser = DaapBrowser(l.get_pl_master())
        paned_browser_item = DaapLibrarySourceItem(self.player,stock.SRC_DAAP,name,self.paned_browser,"daaplibrary")
        self.items.append(paned_browser_item)
        
        self.paned_browser.populate()
        helper.update_source()
        
    def disconnect (self,*args):
        self.services[args].save()
        del self.services[args]
        
    def save(self):
        for info,l in self.services.iteritems():
            l.save()

class DaapLibrarySourceItem(SourceItem):
    has_top_separateur = True
    
class DaapBrowser(Browser):
    def __init__(self,pl):
        super(DaapBrowser,self).__init__(pl,pl.library.codeName,True)
        self.set_song_treeview(DaapSongView(pl,pl.library.codeName))
        self.treeviews["songs"].set_sort_by(None,"album", gtk.SORT_ASCENDING, False)

        self.set_menu(SongMenu(pl,True,True,False,False,True,False,False))
         
class DaapSongView(SortableSongView):
    def __init__(self,pl,conf_prefix):
        super(DaapSongView,self).__init__(pl,conf_prefix)
        self.set_menu(SongMenu(pl,True,True,False,False,True,False,False))
          
class DaapLibrary(Library):
    def __init__(self,address, port):   
        Library.__init__(self,"daap")
        self.address = address
        self.port = port
        self.client = DAAPClient()
        self.client.connect( address, port )
        self.session = None
        
    def load(self):
        Library.load(self)
        self.session  = self.client.login()
        library =  self.session.library()
        tracks = library.tracks()
        songs =[self.daap_track_to_song(t) for t in tracks]
        self.get_pl_master().append(songs)
        print "Daap:",len(self.get_pl_master().get_songs())
            
        
    def save(self):
        Library.save(self)    
        if self.session:
            try:
                self.session.logout()
            except:pass
        
        
       
    def daap_track_to_song(self,track): 
        s = Song()
        s["daap_track"] = track
        if isinstance(track.id,int):
            s["uri"] = "daap://%s:%d/%d"%(self.address,self.port,track.id)
        else:
            s["uri"] = "daap://%s:%d/%s"%(self.address,self.port,track.id)
            
        s["title"] = track.name.encode("utf8")
        s["artist"] = track.artist.encode("utf8")
        s["album"] = track.album.encode("utf8")
        s["#duration"] = track.time
        #s["#size"] = track.size
        #s["genre"] = track.genre
        return s
    
