// generated by Fast Light User Interface Designer (fluid) version 1.0300

#include "PartUI.h"
//Copyright (c) 2002-2005 Nasca Octavian Paul
//License: GNU GPL version 2 or later

void PartSysEffSend::cb_01_i(WidgetPDial* o, void*) {
  master->setPsysefxvol(npart,neff,(int) o->value());
}
void PartSysEffSend::cb_01(WidgetPDial* o, void* v) {
  ((PartSysEffSend*)(o->parent()->user_data()))->cb_01_i(o,v);
}

Fl_Group* PartSysEffSend::make_window() {
  { syseffsend = new Fl_Group(0, 0, 90, 35);
    syseffsend->box(FL_FLAT_BOX);
    syseffsend->color(FL_BACKGROUND_COLOR);
    syseffsend->selection_color(FL_BACKGROUND_COLOR);
    syseffsend->labeltype(FL_NO_LABEL);
    syseffsend->labelfont(0);
    syseffsend->labelsize(14);
    syseffsend->labelcolor(FL_FOREGROUND_COLOR);
    syseffsend->user_data((void*)(this));
    syseffsend->align(Fl_Align(FL_ALIGN_TOP));
    syseffsend->when(FL_WHEN_RELEASE);
    { WidgetPDial* o = new WidgetPDial(0, 0, 25, 25, "01");
      o->box(FL_ROUND_UP_BOX);
      o->color(FL_BACKGROUND_COLOR);
      o->selection_color(FL_INACTIVE_COLOR);
      o->labeltype(FL_NORMAL_LABEL);
      o->labelfont(1);
      o->labelsize(10);
      o->labelcolor(FL_FOREGROUND_COLOR);
      o->maximum(127);
      o->step(1);
      o->callback((Fl_Callback*)cb_01);
      o->align(Fl_Align(130));
      o->when(FL_WHEN_CHANGED);
      o->size(25,25);
      o->value(master->Psysefxvol[neff][npart]);
      char tmp[10];snprintf(tmp,10,"%d",neff+1);o->label(strdup(tmp));
    } // WidgetPDial* o
    syseffsend->end();
  } // Fl_Group* syseffsend
  return syseffsend;
}

PartSysEffSend::PartSysEffSend(int x,int y, int w, int h, const char *label):Fl_Group(x,y,w,h,label) {
  master=NULL;
neff=0;
npart=0;
}

void PartSysEffSend::init(Master *master_,int npart_,int neff_) {
  npart=npart_;
neff=neff_;
master=master_;
make_window();
syseffsend->show();
end();
}

PartSysEffSend::~PartSysEffSend() {
  syseffsend->hide();
//delete(syseffsend);
}

void PartUI_::showparameters(int kititem,int engine) {
}

void PartKitItem::cb_minkcounter_i(Fl_Counter* o, void*) {
  part->kit[n].Pminkey=(int)o->value();
}
void PartKitItem::cb_minkcounter(Fl_Counter* o, void* v) {
  ((PartKitItem*)(o->parent()->parent()->user_data()))->cb_minkcounter_i(o,v);
}

void PartKitItem::cb_m_i(Fl_Button*, void*) {
  if (part->lastnote>=0) minkcounter->value(part->lastnote);
minkcounter->do_callback();
maxkcounter->do_callback();
}
void PartKitItem::cb_m(Fl_Button* o, void* v) {
  ((PartKitItem*)(o->parent()->parent()->user_data()))->cb_m_i(o,v);
}

void PartKitItem::cb_M_i(Fl_Button*, void*) {
  if (part->lastnote>=0) maxkcounter->value(part->lastnote);
maxkcounter->do_callback();
minkcounter->do_callback();
}
void PartKitItem::cb_M(Fl_Button* o, void* v) {
  ((PartKitItem*)(o->parent()->parent()->user_data()))->cb_M_i(o,v);
}

void PartKitItem::cb_R_i(Fl_Button*, void*) {
  minkcounter->value(0);
minkcounter->do_callback();
maxkcounter->value(127);
maxkcounter->do_callback();
}
void PartKitItem::cb_R(Fl_Button* o, void* v) {
  ((PartKitItem*)(o->parent()->parent()->user_data()))->cb_R_i(o,v);
}

void PartKitItem::cb_adeditbutton_i(Fl_Button*, void*) {
  partui->showparameters(n,0);
}
void PartKitItem::cb_adeditbutton(Fl_Button* o, void* v) {
  ((PartKitItem*)(o->parent()->parent()->user_data()))->cb_adeditbutton_i(o,v);
}

void PartKitItem::cb_subeditbutton_i(Fl_Button*, void*) {
  partui->showparameters(n,1);
}
void PartKitItem::cb_subeditbutton(Fl_Button* o, void* v) {
  ((PartKitItem*)(o->parent()->parent()->user_data()))->cb_subeditbutton_i(o,v);
}

void PartKitItem::cb_mutedcheck_i(Fl_Check_Button* o, void*) {
  part->kit[n].Pmuted=(int)o->value();
}
void PartKitItem::cb_mutedcheck(Fl_Check_Button* o, void* v) {
  ((PartKitItem*)(o->parent()->parent()->user_data()))->cb_mutedcheck_i(o,v);
}

void PartKitItem::cb_maxkcounter_i(Fl_Counter* o, void*) {
  part->kit[n].Pmaxkey=(int)o->value();
}
void PartKitItem::cb_maxkcounter(Fl_Counter* o, void* v) {
  ((PartKitItem*)(o->parent()->parent()->user_data()))->cb_maxkcounter_i(o,v);
}

void PartKitItem::cb_labelbutton_i(Fl_Button*, void*) {
  const char *tmp=fl_input("Kit item name:",(const char *)part->kit[n].Pname);
if (tmp!=NULL) snprintf((char *)part->kit[n].Pname,PART_MAX_NAME_LEN,"%s",tmp);
}
void PartKitItem::cb_labelbutton(Fl_Button* o, void* v) {
  ((PartKitItem*)(o->parent()->parent()->user_data()))->cb_labelbutton_i(o,v);
}

void PartKitItem::cb_adcheck_i(Fl_Check_Button* o, void*) {
  part->kit[n].Padenabled=(int)o->value();
if (part->kit[n].Padenabled!=0) adeditbutton->activate();
       else  adeditbutton->deactivate();
}
void PartKitItem::cb_adcheck(Fl_Check_Button* o, void* v) {
  ((PartKitItem*)(o->parent()->parent()->user_data()))->cb_adcheck_i(o,v);
}

void PartKitItem::cb_subcheck_i(Fl_Check_Button* o, void*) {
  part->kit[n].Psubenabled=(int)o->value();
if (part->kit[n].Psubenabled!=0) subeditbutton->activate();
       else  subeditbutton->deactivate();
}
void PartKitItem::cb_subcheck(Fl_Check_Button* o, void* v) {
  ((PartKitItem*)(o->parent()->parent()->user_data()))->cb_subcheck_i(o,v);
}

void PartKitItem::cb_sendtoeffect_i(Fl_Choice* o, void*) {
  if (o->value()!=0) part->kit[n].Psendtoparteffect=(int)o->value()-1;
    else part->kit[n].Psendtoparteffect=127;
}
void PartKitItem::cb_sendtoeffect(Fl_Choice* o, void* v) {
  ((PartKitItem*)(o->parent()->parent()->user_data()))->cb_sendtoeffect_i(o,v);
}

void PartKitItem::cb_padeditbutton_i(Fl_Button*, void*) {
  partui->showparameters(n,2);
}
void PartKitItem::cb_padeditbutton(Fl_Button* o, void* v) {
  ((PartKitItem*)(o->parent()->parent()->user_data()))->cb_padeditbutton_i(o,v);
}

void PartKitItem::cb_padcheck_i(Fl_Check_Button* o, void*) {
  part->kit[n].Ppadenabled=(int)o->value();
if (part->kit[n].Ppadenabled!=0) padeditbutton->activate();
       else padeditbutton->deactivate();
}
void PartKitItem::cb_padcheck(Fl_Check_Button* o, void* v) {
  ((PartKitItem*)(o->parent()->parent()->user_data()))->cb_padcheck_i(o,v);
}

void PartKitItem::cb_enabledcheck_i(Fl_Check_Button* o, void*) {
  int answer=1;
if (o->value()==0) answer=fl_choice("Delete the item?","No","Yes",NULL);
if (answer!=0){
pthread_mutex_lock(&master->mutex);
 part->setkititemstatus(n,(int) o->value());
pthread_mutex_unlock(&master->mutex);

if (o->value()==0) partkititemgroup->deactivate();
else partkititemgroup->activate();
o->redraw();
partui->showparameters(n,-1);//use to delete the ui, if it is not to item 0
} else o->value(1);
}
void PartKitItem::cb_enabledcheck(Fl_Check_Button* o, void* v) {
  ((PartKitItem*)(o->parent()->user_data()))->cb_enabledcheck_i(o,v);
}

Fl_Group* PartKitItem::make_window() {
  { partkititem = new Fl_Group(0, 0, 670, 30);
    partkititem->box(FL_FLAT_BOX);
    partkititem->color(FL_BACKGROUND_COLOR);
    partkititem->selection_color(FL_BACKGROUND_COLOR);
    partkititem->labeltype(FL_NO_LABEL);
    partkititem->labelfont(0);
    partkititem->labelsize(14);
    partkititem->labelcolor(FL_FOREGROUND_COLOR);
    partkititem->user_data((void*)(this));
    partkititem->align(Fl_Align(FL_ALIGN_TOP));
    partkititem->when(FL_WHEN_RELEASE);
    { Fl_Group* o = partkititemgroup = new Fl_Group(55, 0, 605, 20);
      partkititemgroup->box(FL_FLAT_BOX);
      { Fl_Counter* o = minkcounter = new Fl_Counter(225, 0, 55, 15);
        minkcounter->type(1);
        minkcounter->minimum(0);
        minkcounter->maximum(128);
        minkcounter->step(1);
        minkcounter->callback((Fl_Callback*)cb_minkcounter);
        o->value(part->kit[n].Pminkey);
      } // Fl_Counter* minkcounter
      { Fl_Button* o = new Fl_Button(285, 3, 15, 12, "m");
        o->tooltip("set the minimum key to the last pressed key");
        o->box(FL_THIN_UP_BOX);
        o->labelsize(10);
        o->callback((Fl_Callback*)cb_m);
      } // Fl_Button* o
      { Fl_Button* o = new Fl_Button(315, 3, 15, 12, "M");
        o->tooltip("set the maximum key to the last pressed key");
        o->box(FL_THIN_UP_BOX);
        o->labelsize(10);
        o->callback((Fl_Callback*)cb_M);
      } // Fl_Button* o
      { Fl_Button* o = new Fl_Button(300, 3, 15, 12, "R");
        o->tooltip("reset the minimum key to 0 and maximum key to 127");
        o->box(FL_THIN_UP_BOX);
        o->labelfont(1);
        o->labelsize(10);
        o->callback((Fl_Callback*)cb_R);
      } // Fl_Button* o
      { Fl_Button* o = adeditbutton = new Fl_Button(420, 0, 40, 15, "edit");
        adeditbutton->box(FL_THIN_UP_BOX);
        adeditbutton->labelsize(11);
        adeditbutton->callback((Fl_Callback*)cb_adeditbutton);
        if (part->kit[n].Padenabled==0) o->deactivate();
        if (n==0) o->hide();
      } // Fl_Button* adeditbutton
      { Fl_Button* o = subeditbutton = new Fl_Button(490, 0, 40, 15, "edit");
        subeditbutton->box(FL_THIN_UP_BOX);
        subeditbutton->labelsize(11);
        subeditbutton->callback((Fl_Callback*)cb_subeditbutton);
        if (part->kit[n].Psubenabled==0) o->deactivate();
        if (n==0) o->hide();
      } // Fl_Button* subeditbutton
      { Fl_Check_Button* o = mutedcheck = new Fl_Check_Button(60, 0, 20, 15);
        mutedcheck->down_box(FL_DOWN_BOX);
        mutedcheck->labelfont(1);
        mutedcheck->labelsize(11);
        mutedcheck->callback((Fl_Callback*)cb_mutedcheck);
        mutedcheck->align(Fl_Align(FL_ALIGN_LEFT));
        o->value(part->kit[n].Pmuted);
      } // Fl_Check_Button* mutedcheck
      { Fl_Counter* o = maxkcounter = new Fl_Counter(335, 0, 55, 15);
        maxkcounter->type(1);
        maxkcounter->minimum(0);
        maxkcounter->maximum(128);
        maxkcounter->step(1);
        maxkcounter->callback((Fl_Callback*)cb_maxkcounter);
        o->value(part->kit[n].Pmaxkey);
      } // Fl_Counter* maxkcounter
      { Fl_Button* o = labelbutton = new Fl_Button(90, 0, 130, 15, "Bass Drum");
        labelbutton->box(FL_THIN_DOWN_BOX);
        labelbutton->down_box(FL_FLAT_BOX);
        labelbutton->labelfont(1);
        labelbutton->labelsize(10);
        labelbutton->callback((Fl_Callback*)cb_labelbutton);
        labelbutton->align(Fl_Align(FL_ALIGN_LEFT|FL_ALIGN_INSIDE));
        o->label((char *)part->kit[n].Pname);
      } // Fl_Button* labelbutton
      { Fl_Check_Button* o = adcheck = new Fl_Check_Button(400, 0, 20, 15);
        adcheck->down_box(FL_DOWN_BOX);
        adcheck->labelfont(1);
        adcheck->labelsize(11);
        adcheck->callback((Fl_Callback*)cb_adcheck);
        adcheck->align(Fl_Align(FL_ALIGN_LEFT));
        o->value(part->kit[n].Padenabled);
        if (n==0) o->hide();
      } // Fl_Check_Button* adcheck
      { Fl_Check_Button* o = subcheck = new Fl_Check_Button(470, 0, 20, 15);
        subcheck->down_box(FL_DOWN_BOX);
        subcheck->labelfont(1);
        subcheck->labelsize(11);
        subcheck->callback((Fl_Callback*)cb_subcheck);
        subcheck->align(Fl_Align(FL_ALIGN_LEFT));
        o->value(part->kit[n].Psubenabled);
        if (n==0) o->hide();
      } // Fl_Check_Button* subcheck
      { Fl_Choice* o = sendtoeffect = new Fl_Choice(615, 0, 45, 15);
        sendtoeffect->down_box(FL_BORDER_BOX);
        sendtoeffect->labelsize(10);
        sendtoeffect->textfont(1);
        sendtoeffect->textsize(10);
        sendtoeffect->callback((Fl_Callback*)cb_sendtoeffect);
        sendtoeffect->align(Fl_Align(FL_ALIGN_TOP_LEFT));
        o->add("OFF");char nrstr[10]; for(int i=0;i<NUM_PART_EFX;i++){sprintf(nrstr,"FX%d",i+1);o->add(nrstr);};
        o->value(part->kit[n].Psendtoparteffect+1);if (part->kit[n].Psendtoparteffect==127) o->value(0);
      } // Fl_Choice* sendtoeffect
      { Fl_Button* o = padeditbutton = new Fl_Button(560, 0, 40, 15, "edit");
        padeditbutton->box(FL_THIN_UP_BOX);
        padeditbutton->labelsize(11);
        padeditbutton->callback((Fl_Callback*)cb_padeditbutton);
        if (part->kit[n].Ppadenabled==0) o->deactivate();
        if (n==0) o->hide();
      } // Fl_Button* padeditbutton
      { Fl_Check_Button* o = padcheck = new Fl_Check_Button(540, 0, 20, 15);
        padcheck->down_box(FL_DOWN_BOX);
        padcheck->labelfont(1);
        padcheck->labelsize(11);
        padcheck->callback((Fl_Callback*)cb_padcheck);
        padcheck->align(Fl_Align(FL_ALIGN_LEFT));
        o->value(part->kit[n].Ppadenabled);
        if (n==0) o->hide();
      } // Fl_Check_Button* padcheck
      if (part->kit[n].Penabled==0) o->deactivate();
      partkititemgroup->end();
    } // Fl_Group* partkititemgroup
    { Fl_Check_Button* o = enabledcheck = new Fl_Check_Button(30, 0, 20, 15, "01");
      enabledcheck->down_box(FL_DOWN_BOX);
      enabledcheck->labeltype(FL_EMBOSSED_LABEL);
      enabledcheck->labelfont(1);
      enabledcheck->labelsize(13);
      enabledcheck->callback((Fl_Callback*)cb_enabledcheck);
      enabledcheck->align(Fl_Align(FL_ALIGN_LEFT));
      snprintf(label,10,"%d",n+1);o->label(strdup(label));
      o->value(part->kit[n].Penabled);
      if (n==0) o->deactivate();
    } // Fl_Check_Button* enabledcheck
    partkititem->end();
  } // Fl_Group* partkititem
  return partkititem;
}

PartKitItem::PartKitItem(int x,int y, int w, int h, const char *label):Fl_Group(x,y,w,h,label) {
  n=0;
part=NULL;
}

void PartKitItem::refresh() {
  enabledcheck->value(part->kit[n].Penabled);
if (part->kit[n].Penabled==0) partkititemgroup->deactivate();
else partkititemgroup->activate();

mutedcheck->value(part->kit[n].Pmuted);
labelbutton->label((char *)part->kit[n].Pname);
minkcounter->value(part->kit[n].Pminkey);
maxkcounter->value(part->kit[n].Pmaxkey);
adcheck->value(part->kit[n].Padenabled);
adcheck->do_callback();
subcheck->value(part->kit[n].Psubenabled);
subcheck->do_callback();

sendtoeffect->value(part->kit[n].Psendtoparteffect+1);
if (part->kit[n].Psendtoparteffect==127) sendtoeffect->value(0);

this->redraw();
}

void PartKitItem::init(Part *part_,int n_,Master *master_,PartUI_ *partui_) {
  part=part_;
n=n_;
partui=partui_;
master=master_;
make_window();
//partkititem->show();
end();
}

PartKitItem::~PartKitItem() {
  partkititem->hide();
//delete(partkititem);
}

void PartUI::cb_Pan_i(WidgetPDial* o, void*) {
  part->setPpanning((int) o->value());
}
void PartUI::cb_Pan(WidgetPDial* o, void* v) {
  ((PartUI*)(o->parent()->parent()->user_data()))->cb_Pan_i(o,v);
}

void PartUI::cb_KeyShift_i(Fl_Counter* o, void*) {
  part->Pkeyshift=(int) o->value()+64;
}
void PartUI::cb_KeyShift(Fl_Counter* o, void* v) {
  ((PartUI*)(o->parent()->parent()->user_data()))->cb_KeyShift_i(o,v);
}

void PartUI::cb_Grand_i(Fl_Button*, void*) {
  int event=Fl::event_button();
if (event==FL_RIGHT_MOUSE){
   const char *tmp=fl_input("Instrument name:",(const char *)part->Pname);
   if (tmp!=NULL) snprintf((char *)part->Pname,PART_MAX_NAME_LEN,"%s",tmp);
} else {
  if (event==FL_LEFT_MOUSE) bankui->show();
       else instrumenteditwindow->show();
};
}
void PartUI::cb_Grand(Fl_Button* o, void* v) {
  ((PartUI*)(o->parent()->parent()->user_data()))->cb_Grand_i(o,v);
}

void PartUI::cb_NoteOn_i(Fl_Check_Button* o, void*) {
  part->Pnoteon=(int) o->value();
}
void PartUI::cb_NoteOn(Fl_Check_Button* o, void* v) {
  ((PartUI*)(o->parent()->parent()->user_data()))->cb_NoteOn_i(o,v);
}

void PartUI::cb_minkcounter1_i(Fl_Counter* o, void*) {
  part->Pminkey=(int) o->value();
if (part->Pminkey>part->Pmaxkey) o->textcolor(FL_RED);
 else o->textcolor(FL_BLACK);
}
void PartUI::cb_minkcounter1(Fl_Counter* o, void* v) {
  ((PartUI*)(o->parent()->parent()->user_data()))->cb_minkcounter1_i(o,v);
}

void PartUI::cb_maxkcounter1_i(Fl_Counter* o, void*) {
  part->Pmaxkey=(int) o->value();

if (part->Pminkey>part->Pmaxkey) o->textcolor(FL_RED);
 else o->textcolor(FL_BLACK);
}
void PartUI::cb_maxkcounter1(Fl_Counter* o, void* v) {
  ((PartUI*)(o->parent()->parent()->user_data()))->cb_maxkcounter1_i(o,v);
}

void PartUI::cb_Volume_i(WidgetPDial* o, void*) {
  part->setPvolume((int) o->value());
}
void PartUI::cb_Volume(WidgetPDial* o, void* v) {
  ((PartUI*)(o->parent()->parent()->user_data()))->cb_Volume_i(o,v);
}

void PartUI::cb_Vel_i(WidgetPDial* o, void*) {
  part->Pveloffs=(int) o->value();
}
void PartUI::cb_Vel(WidgetPDial* o, void* v) {
  ((PartUI*)(o->parent()->parent()->user_data()))->cb_Vel_i(o,v);
}

void PartUI::cb_Vel1_i(WidgetPDial* o, void*) {
  part->Pvelsns=(int) o->value();
}
void PartUI::cb_Vel1(WidgetPDial* o, void* v) {
  ((PartUI*)(o->parent()->parent()->user_data()))->cb_Vel1_i(o,v);
}

void PartUI::cb_Controllers_i(Fl_Button*, void*) {
  ctlwindow->show();
}
void PartUI::cb_Controllers(Fl_Button* o, void* v) {
  ((PartUI*)(o->parent()->parent()->user_data()))->cb_Controllers_i(o,v);
}

void PartUI::cb_Portamento_i(Fl_Check_Button* o, void*) {
  part->ctl.portamento.portamento=(int) o->value();
}
void PartUI::cb_Portamento(Fl_Check_Button* o, void* v) {
  ((PartUI*)(o->parent()->parent()->user_data()))->cb_Portamento_i(o,v);
}

void PartUI::cb_Edit_i(Fl_Button*, void*) {
  instrumenteditwindow->show();
}
void PartUI::cb_Edit(Fl_Button* o, void* v) {
  ((PartUI*)(o->parent()->parent()->user_data()))->cb_Edit_i(o,v);
}

void PartUI::cb_m1_i(Fl_Button*, void*) {
  if (part->lastnote>=0) minkcounter->value(part->lastnote);
minkcounter->do_callback();
maxkcounter->do_callback();
}
void PartUI::cb_m1(Fl_Button* o, void* v) {
  ((PartUI*)(o->parent()->parent()->user_data()))->cb_m1_i(o,v);
}

void PartUI::cb_M1_i(Fl_Button*, void*) {
  if (part->lastnote>=0) maxkcounter->value(part->lastnote);
maxkcounter->do_callback();
minkcounter->do_callback();
}
void PartUI::cb_M1(Fl_Button* o, void* v) {
  ((PartUI*)(o->parent()->parent()->user_data()))->cb_M1_i(o,v);
}

void PartUI::cb_R1_i(Fl_Button*, void*) {
  minkcounter->value(0);
minkcounter->do_callback();
maxkcounter->value(127);
maxkcounter->do_callback();
}
void PartUI::cb_R1(Fl_Button* o, void* v) {
  ((PartUI*)(o->parent()->parent()->user_data()))->cb_R1_i(o,v);
}

void PartUI::cb_MIDI_i(Fl_Choice* o, void*) {
  part->Prcvchn=(int) o->value();
}
void PartUI::cb_MIDI(Fl_Choice* o, void* v) {
  ((PartUI*)(o->parent()->parent()->user_data()))->cb_MIDI_i(o,v);
}

void PartUI::cb_keylimitlist_i(Fl_Choice* o, void*) {
  int val=0;
val=atoi(o->text());
part->setkeylimit(val);
}
void PartUI::cb_keylimitlist(Fl_Choice* o, void* v) {
  ((PartUI*)(o->parent()->parent()->user_data()))->cb_keylimitlist_i(o,v);
}

void PartUI::cb_Mode_i(Fl_Choice* o, void*) {
  if ((int) o->value()==0){ /* Poly (implies no legato) */
  part->Ppolymode=1;
  part->Plegatomode=0;
} else {
  if ((int) o->value()==1){ /* Mono (implies no legato) */
    part->Ppolymode=0;
    part->Plegatomode=0;
  } else {
    if ((int) o->value()==2){ /* Legato (implies mono) */
      part->Ppolymode=0;
      part->Plegatomode=1;
    };
  };
};
}
void PartUI::cb_Mode(Fl_Choice* o, void* v) {
  ((PartUI*)(o->parent()->parent()->user_data()))->cb_Mode_i(o,v);
}

void PartUI::cb_Enabled_i(Fl_Check_Button* o, void*) {
  pthread_mutex_lock(&master->mutex);
master->partonoff(npart,(int) o->value());
pthread_mutex_unlock(&master->mutex);
if (part->Penabled==0) partgroupui->deactivate();
    else partgroupui->activate();
}
void PartUI::cb_Enabled(Fl_Check_Button* o, void* v) {
  ((PartUI*)(o->parent()->user_data()))->cb_Enabled_i(o,v);
}

void PartUI::cb_Expr_i(Fl_Check_Button* o, void*) {
  part->ctl.expression.receive=(int) o->value();
}
void PartUI::cb_Expr(Fl_Check_Button* o, void* v) {
  ((PartUI*)(o->parent()->user_data()))->cb_Expr_i(o,v);
}

void PartUI::cb_PanDpth_i(WidgetPDial* o, void*) {
  part->ctl.panning.depth=(int) o->value();
}
void PartUI::cb_PanDpth(WidgetPDial* o, void* v) {
  ((PartUI*)(o->parent()->user_data()))->cb_PanDpth_i(o,v);
}

void PartUI::cb_FltCut_i(WidgetPDial* o, void*) {
  part->ctl.filtercutoff.depth=(int) o->value();
}
void PartUI::cb_FltCut(WidgetPDial* o, void* v) {
  ((PartUI*)(o->parent()->user_data()))->cb_FltCut_i(o,v);
}

void PartUI::cb_FltQ_i(WidgetPDial* o, void*) {
  part->ctl.filterq.depth=(int) o->value();
}
void PartUI::cb_FltQ(WidgetPDial* o, void* v) {
  ((PartUI*)(o->parent()->user_data()))->cb_FltQ_i(o,v);
}

void PartUI::cb_BwDpth_i(WidgetPDial* o, void*) {
  part->ctl.bandwidth.depth=(int) o->value();
}
void PartUI::cb_BwDpth(WidgetPDial* o, void* v) {
  ((PartUI*)(o->parent()->user_data()))->cb_BwDpth_i(o,v);
}

void PartUI::cb_ModWh_i(WidgetPDial* o, void*) {
  part->ctl.modwheel.depth=(int) o->value();
}
void PartUI::cb_ModWh(WidgetPDial* o, void* v) {
  ((PartUI*)(o->parent()->user_data()))->cb_ModWh_i(o,v);
}

void PartUI::cb_PWheelB_i(Fl_Counter* o, void*) {
  part->ctl.pitchwheel.bendrange=(int) o->value();
}
void PartUI::cb_PWheelB(Fl_Counter* o, void* v) {
  ((PartUI*)(o->parent()->user_data()))->cb_PWheelB_i(o,v);
}

void PartUI::cb_FMamp_i(Fl_Check_Button* o, void*) {
  part->ctl.fmamp.receive=(int) o->value();
}
void PartUI::cb_FMamp(Fl_Check_Button* o, void* v) {
  ((PartUI*)(o->parent()->user_data()))->cb_FMamp_i(o,v);
}

void PartUI::cb_Vol_i(Fl_Check_Button* o, void*) {
  part->ctl.volume.receive=(int) o->value();
}
void PartUI::cb_Vol(Fl_Check_Button* o, void* v) {
  ((PartUI*)(o->parent()->user_data()))->cb_Vol_i(o,v);
}

void PartUI::cb_Sustain_i(Fl_Check_Button* o, void*) {
  part->ctl.sustain.receive=(int) o->value();
if (part->ctl.sustain.receive==0) {
  part->RelaseSustainedKeys();
  part->ctl.setsustain(0);
};
}
void PartUI::cb_Sustain(Fl_Check_Button* o, void* v) {
  ((PartUI*)(o->parent()->user_data()))->cb_Sustain_i(o,v);
}

void PartUI::cb_Close_i(Fl_Button*, void*) {
  ctlwindow->hide();
}
void PartUI::cb_Close(Fl_Button* o, void* v) {
  ((PartUI*)(o->parent()->user_data()))->cb_Close_i(o,v);
}

void PartUI::cb_Reset_i(Fl_Button*, void*) {
  part->SetController(C_resetallcontrollers,0);
}
void PartUI::cb_Reset(Fl_Button* o, void* v) {
  ((PartUI*)(o->parent()->user_data()))->cb_Reset_i(o,v);
}

void PartUI::cb_Rcv_i(Fl_Check_Button* o, void*) {
  part->ctl.portamento.receive=(int) o->value();
}
void PartUI::cb_Rcv(Fl_Check_Button* o, void* v) {
  ((PartUI*)(o->parent()->parent()->user_data()))->cb_Rcv_i(o,v);
}

void PartUI::cb_time_i(WidgetPDial* o, void*) {
  part->ctl.portamento.time=(int) o->value();
}
void PartUI::cb_time(WidgetPDial* o, void* v) {
  ((PartUI*)(o->parent()->parent()->user_data()))->cb_time_i(o,v);
}

void PartUI::cb_thresh_i(Fl_Counter* o, void*) {
  part->ctl.portamento.pitchthresh=(int) o->value();
}
void PartUI::cb_thresh(Fl_Counter* o, void* v) {
  ((PartUI*)(o->parent()->parent()->user_data()))->cb_thresh_i(o,v);
}

void PartUI::cb_th_i(Fl_Check_Button* o, void*) {
  part->ctl.portamento.pitchthreshtype=(int) o->value();
}
void PartUI::cb_th(Fl_Check_Button* o, void* v) {
  ((PartUI*)(o->parent()->parent()->user_data()))->cb_th_i(o,v);
}

void PartUI::cb_t_i(WidgetPDial* o, void*) {
  int x=(int) o->value();

part->ctl.portamento.updowntimestretch=x;
}
void PartUI::cb_t(WidgetPDial* o, void* v) {
  ((PartUI*)(o->parent()->parent()->user_data()))->cb_t_i(o,v);
}

void PartUI::cb_BWdpth_i(WidgetPDial* o, void*) {
  part->ctl.resonancebandwidth.depth=(int) o->value();
}
void PartUI::cb_BWdpth(WidgetPDial* o, void* v) {
  ((PartUI*)(o->parent()->parent()->user_data()))->cb_BWdpth_i(o,v);
}

void PartUI::cb_CFdpth_i(WidgetPDial* o, void*) {
  part->ctl.resonancecenter.depth=(int) o->value();
}
void PartUI::cb_CFdpth(WidgetPDial* o, void* v) {
  ((PartUI*)(o->parent()->parent()->user_data()))->cb_CFdpth_i(o,v);
}

void PartUI::cb_Exp_i(Fl_Check_Button* o, void*) {
  part->ctl.modwheel.exponential=(int) o->value();
}
void PartUI::cb_Exp(Fl_Check_Button* o, void* v) {
  ((PartUI*)(o->parent()->user_data()))->cb_Exp_i(o,v);
}

void PartUI::cb_Exp1_i(Fl_Check_Button* o, void*) {
  part->ctl.bandwidth.exponential=(int) o->value();
}
void PartUI::cb_Exp1(Fl_Check_Button* o, void* v) {
  ((PartUI*)(o->parent()->user_data()))->cb_Exp1_i(o,v);
}

void PartUI::cb_inseffnocounter_i(Fl_Counter* o, void*) {
  ninseff=(int) o->value()-1;
insefftype->value(part->partefx[ninseff]->geteffect());
//insefftype->do_callback();
inseffectui->refresh(part->partefx[ninseff]);
int x=part->Pefxroute[ninseff];
if (x==127) x=1;
bypasseff->value(part->Pefxbypass[ninseff]);

sendtochoice->value(x);
}
void PartUI::cb_inseffnocounter(Fl_Counter* o, void* v) {
  ((PartUI*)(o->parent()->user_data()))->cb_inseffnocounter_i(o,v);
}

void PartUI::cb_insefftype_i(Fl_Choice* o, void*) {
  pthread_mutex_lock(part->mutex);
part->partefx[ninseff]->changeeffect((int) o->value());
pthread_mutex_unlock(part->mutex);
inseffectui->refresh(part->partefx[ninseff]);
}
void PartUI::cb_insefftype(Fl_Choice* o, void* v) {
  ((PartUI*)(o->parent()->user_data()))->cb_insefftype_i(o,v);
}

Fl_Menu_Item PartUI::menu_insefftype[] = {
 {"No Effect", 0,  0, 0, 0, FL_NORMAL_LABEL, 1, 10, 0},
 {"Reverb", 0,  0, 0, 0, FL_NORMAL_LABEL, 1, 10, 0},
 {"Echo", 0,  0, 0, 0, FL_NORMAL_LABEL, 1, 10, 0},
 {"Chorus", 0,  0, 0, 0, FL_NORMAL_LABEL, 1, 10, 0},
 {"Phaser", 0,  0, 0, 0, FL_NORMAL_LABEL, 1, 10, 0},
 {"AlienWah", 0,  0, 0, 0, FL_NORMAL_LABEL, 1, 10, 0},
 {"Distortion", 0,  0, 0, 0, FL_NORMAL_LABEL, 1, 10, 0},
 {"EQ", 0,  0, 0, 0, FL_NORMAL_LABEL, 1, 10, 0},
 {"DynFilter", 0,  0, 0, 0, FL_NORMAL_LABEL, 1, 10, 0},
 {0,0,0,0,0,0,0,0,0}
};

void PartUI::cb_Close1_i(Fl_Button*, void*) {
  partfx->hide();
}
void PartUI::cb_Close1(Fl_Button* o, void* v) {
  ((PartUI*)(o->parent()->user_data()))->cb_Close1_i(o,v);
}

void PartUI::cb_sendtochoice_i(Fl_Choice* o, void*) {
  int x=(int) o->value();
part->Pefxroute[ninseff]=x;
if (x==2) part->partefx[ninseff]->setdryonly(true);
	else part->partefx[ninseff]->setdryonly(false);
}
void PartUI::cb_sendtochoice(Fl_Choice* o, void* v) {
  ((PartUI*)(o->parent()->user_data()))->cb_sendtochoice_i(o,v);
}

Fl_Menu_Item PartUI::menu_sendtochoice[] = {
 {"Next Effect", 0,  0, 0, 0, FL_NORMAL_LABEL, 1, 10, 0},
 {"Part Out", 0,  0, 0, 0, FL_NORMAL_LABEL, 1, 10, 0},
 {"Dry Out", 0,  0, 0, 0, FL_NORMAL_LABEL, 1, 10, 0},
 {0,0,0,0,0,0,0,0,0}
};

void PartUI::cb_bypasseff_i(Fl_Check_Button* o, void*) {
  part->Pefxbypass[ninseff]=(((int)o->value())!=0);
}
void PartUI::cb_bypasseff(Fl_Check_Button* o, void* v) {
  ((PartUI*)(o->parent()->user_data()))->cb_bypasseff_i(o,v);
}

void PartUI::cb_C_i(Fl_Button*, void*) {
  presetsui->copy(part->partefx[ninseff]);
}
void PartUI::cb_C(Fl_Button* o, void* v) {
  ((PartUI*)(o->parent()->user_data()))->cb_C_i(o,v);
}

void PartUI::cb_P_i(Fl_Button*, void*) {
  pthread_mutex_lock(&master->mutex);
presetsui->paste(part->partefx[ninseff],inseffectui);
pthread_mutex_unlock(&master->mutex);
}
void PartUI::cb_P(Fl_Button* o, void* v) {
  ((PartUI*)(o->parent()->user_data()))->cb_P_i(o,v);
}

void PartUI::cb_Close2_i(Fl_Button*, void*) {
  instrumentkitlist->hide();
}
void PartUI::cb_Close2(Fl_Button* o, void* v) {
  ((PartUI*)(o->parent()->user_data()))->cb_Close2_i(o,v);
}

void PartUI::cb_Mode1_i(Fl_Choice* o, void*) {
  part->Pkitmode=(int) o->value();
if (part->Pkitmode==0) {
     kitlist->deactivate();
 } else {
 kitlist->activate();
};
}
void PartUI::cb_Mode1(Fl_Choice* o, void* v) {
  ((PartUI*)(o->parent()->user_data()))->cb_Mode1_i(o,v);
}

Fl_Menu_Item PartUI::menu_Mode[] = {
 {"OFF", 0,  0, 0, 0, FL_NORMAL_LABEL, 1, 11, 0},
 {"MULTI", 0,  0, 0, 0, FL_NORMAL_LABEL, 1, 11, 0},
 {"SINGLE", 0,  0, 0, 0, FL_NORMAL_LABEL, 1, 11, 0},
 {0,0,0,0,0,0,0,0,0}
};

void PartUI::cb_Drum_i(Fl_Check_Button* o, void*) {
  part->Pdrummode=(int) o->value();
}
void PartUI::cb_Drum(Fl_Check_Button* o, void* v) {
  ((PartUI*)(o->parent()->user_data()))->cb_Drum_i(o,v);
}

void PartUI::cb_padeditbutton1_i(Fl_Button*, void*) {
  showparameters(0,2);
}
void PartUI::cb_padeditbutton1(Fl_Button* o, void* v) {
  ((PartUI*)(o->parent()->parent()->parent()->user_data()))->cb_padeditbutton1_i(o,v);
}

void PartUI::cb_padsynenabledcheck_i(Fl_Check_Button* o, void*) {
  int x=(int) o->value();
part->kit[0].Ppadenabled=x;
if (x==0) padeditbutton->deactivate();
     else padeditbutton->activate();
}
void PartUI::cb_padsynenabledcheck(Fl_Check_Button* o, void* v) {
  ((PartUI*)(o->parent()->parent()->parent()->user_data()))->cb_padsynenabledcheck_i(o,v);
}

void PartUI::cb_adsynenabledcheck_i(Fl_Check_Button* o, void*) {
  int x=(int) o->value();
part->kit[0].Padenabled=x;
if (x==0) adeditbutton->deactivate();
     else adeditbutton->activate();
}
void PartUI::cb_adsynenabledcheck(Fl_Check_Button* o, void* v) {
  ((PartUI*)(o->parent()->parent()->parent()->user_data()))->cb_adsynenabledcheck_i(o,v);
}

void PartUI::cb_adeditbutton1_i(Fl_Button*, void*) {
  showparameters(0,0);
}
void PartUI::cb_adeditbutton1(Fl_Button* o, void* v) {
  ((PartUI*)(o->parent()->parent()->parent()->user_data()))->cb_adeditbutton1_i(o,v);
}

void PartUI::cb_subsynenabledcheck_i(Fl_Check_Button* o, void*) {
  int x=(int) o->value();
part->kit[0].Psubenabled=x;
if (x==0) subeditbutton->deactivate();
     else subeditbutton->activate();
}
void PartUI::cb_subsynenabledcheck(Fl_Check_Button* o, void* v) {
  ((PartUI*)(o->parent()->parent()->parent()->user_data()))->cb_subsynenabledcheck_i(o,v);
}

void PartUI::cb_subeditbutton1_i(Fl_Button*, void*) {
  showparameters(0,1);
}
void PartUI::cb_subeditbutton1(Fl_Button* o, void* v) {
  ((PartUI*)(o->parent()->parent()->parent()->user_data()))->cb_subeditbutton1_i(o,v);
}

void PartUI::cb_Kit_i(Fl_Button*, void*) {
  instrumentkitlist->show();
}
void PartUI::cb_Kit(Fl_Button* o, void* v) {
  ((PartUI*)(o->parent()->parent()->user_data()))->cb_Kit_i(o,v);
}

void PartUI::cb_Effects_i(Fl_Button*, void*) {
  partfx->show();
}
void PartUI::cb_Effects(Fl_Button* o, void* v) {
  ((PartUI*)(o->parent()->parent()->user_data()))->cb_Effects_i(o,v);
}

void PartUI::cb_Author_i(Fl_Input* o, void*) {
  snprintf((char *)part->info.Pauthor,MAX_INFO_TEXT_SIZE,"%s",o->value());
}
void PartUI::cb_Author(Fl_Input* o, void* v) {
  ((PartUI*)(o->parent()->parent()->user_data()))->cb_Author_i(o,v);
}

void PartUI::cb_Comments_i(Fl_Input* o, void*) {
  snprintf((char *)part->info.Pcomments,MAX_INFO_TEXT_SIZE,"%s",o->value());
}
void PartUI::cb_Comments(Fl_Input* o, void* v) {
  ((PartUI*)(o->parent()->parent()->user_data()))->cb_Comments_i(o,v);
}

void PartUI::cb_Type_i(Fl_Choice* o, void*) {
  part->info.Ptype=o->value();
}
void PartUI::cb_Type(Fl_Choice* o, void* v) {
  ((PartUI*)(o->parent()->parent()->user_data()))->cb_Type_i(o,v);
}

Fl_Menu_Item PartUI::menu_Type[] = {
 {"--------------------------", 0,  0, 0, 0, FL_NORMAL_LABEL, 1, 11, 0},
 {"Piano", 0,  0, 0, 0, FL_NORMAL_LABEL, 1, 11, 0},
 {"Chromatic Percussion", 0,  0, 0, 0, FL_NORMAL_LABEL, 1, 11, 0},
 {"Organ", 0,  0, 0, 0, FL_NORMAL_LABEL, 1, 11, 0},
 {"Guitar", 0,  0, 0, 0, FL_NORMAL_LABEL, 1, 11, 0},
 {"Bass", 0,  0, 0, 0, FL_NORMAL_LABEL, 1, 11, 0},
 {"Solo Strings", 0,  0, 0, 0, FL_NORMAL_LABEL, 1, 11, 0},
 {"Ensemble", 0,  0, 0, 0, FL_NORMAL_LABEL, 1, 11, 0},
 {"Brass", 0,  0, 0, 0, FL_NORMAL_LABEL, 1, 11, 0},
 {"Reed", 0,  0, 0, 0, FL_NORMAL_LABEL, 1, 11, 0},
 {"Pipe", 0,  0, 0, 0, FL_NORMAL_LABEL, 1, 11, 0},
 {"Synth Lead", 0,  0, 0, 0, FL_NORMAL_LABEL, 1, 11, 0},
 {"Synth Pad", 0,  0, 0, 0, FL_NORMAL_LABEL, 1, 11, 0},
 {"Synth Effects", 0,  0, 0, 0, FL_NORMAL_LABEL, 1, 11, 0},
 {"Ethnic", 0,  0, 0, 0, FL_NORMAL_LABEL, 1, 11, 0},
 {"Percussive", 0,  0, 0, 0, FL_NORMAL_LABEL, 1, 11, 0},
 {"Sound Effects", 0,  0, 0, 0, FL_NORMAL_LABEL, 1, 11, 0},
 {0,0,0,0,0,0,0,0,0}
};

void PartUI::cb_Close3_i(Fl_Button*, void*) {
  instrumenteditwindow->hide();
}
void PartUI::cb_Close3(Fl_Button* o, void* v) {
  ((PartUI*)(o->parent()->user_data()))->cb_Close3_i(o,v);
}

Fl_Group* PartUI::make_window() {
  { partgroup = new Fl_Group(0, 0, 385, 180);
    partgroup->box(FL_FLAT_BOX);
    partgroup->color(FL_BACKGROUND_COLOR);
    partgroup->selection_color(FL_BACKGROUND_COLOR);
    partgroup->labeltype(FL_NO_LABEL);
    partgroup->labelfont(0);
    partgroup->labelsize(14);
    partgroup->labelcolor(FL_FOREGROUND_COLOR);
    partgroup->user_data((void*)(this));
    partgroup->align(Fl_Align(FL_ALIGN_TOP));
    partgroup->when(FL_WHEN_RELEASE);
    { Fl_Group* o = partgroupui = new Fl_Group(0, 0, 385, 180);
      { WidgetPDial* o = new WidgetPDial(50, 40, 25, 25, "Pan");
        o->box(FL_ROUND_UP_BOX);
        o->color(FL_BACKGROUND_COLOR);
        o->selection_color(FL_INACTIVE_COLOR);
        o->labeltype(FL_NORMAL_LABEL);
        o->labelfont(0);
        o->labelsize(11);
        o->labelcolor(FL_FOREGROUND_COLOR);
        o->maximum(127);
        o->step(1);
        o->callback((Fl_Callback*)cb_Pan);
        o->align(Fl_Align(FL_ALIGN_BOTTOM));
        o->when(FL_WHEN_CHANGED);
        o->value(part->Ppanning);
      } // WidgetPDial* o
      { Fl_Counter* o = new Fl_Counter(195, 45, 90, 20, "KeyShift");
        o->labelsize(11);
        o->minimum(-64);
        o->maximum(64);
        o->step(1);
        o->callback((Fl_Callback*)cb_KeyShift);
        o->align(Fl_Align(FL_ALIGN_TOP));
        o->lstep(12);
        o->value(part->Pkeyshift-64);
      } // Fl_Counter* o
      { Fl_Scroll* o = new Fl_Scroll(166, 91, 125, 60);
        o->box(FL_ENGRAVED_FRAME);
        o->labelfont(1);
        o->labelsize(10);
        o->align(Fl_Align(FL_ALIGN_TOP_LEFT|FL_ALIGN_INSIDE));
        { Fl_Pack* o = new Fl_Pack(171, 96, 115, 35);
          o->type(1);
          o->spacing(5);
          for (int i=0;i<NUM_SYS_EFX;i++){psyef[i]=new PartSysEffSend(0,0,25,35,"");psyef[i]->init(master,npart,i);}
          o->end();
        } // Fl_Pack* o
        o->end();
      } // Fl_Scroll* o
      { Fl_Button* o = new Fl_Button(195, 5, 185, 20, "Grand Piano");
        o->tooltip("left mousebutton - to choose/save/.. from/to bank or right mousebutton to cha\
nge the name or middle button to change the instrument information");
        o->box(FL_THIN_DOWN_BOX);
        o->down_box(FL_FLAT_BOX);
        o->labelfont(1);
        o->labelsize(11);
        o->callback((Fl_Callback*)cb_Grand);
        o->align(Fl_Align(68|FL_ALIGN_INSIDE));
        o->label((char *)part->Pname);
      } // Fl_Button* o
      { Fl_Box* o = new Fl_Box(166, 81, 95, 10, "To Sys.Efx.");
        o->labelfont(1);
        o->labelsize(10);
      } // Fl_Box* o
      { Fl_Check_Button* o = new Fl_Check_Button(10, 155, 65, 20, "NoteOn");
        o->tooltip("set if the part receives NoteOn messages");
        o->down_box(FL_DOWN_BOX);
        o->labelfont(1);
        o->labelsize(11);
        o->callback((Fl_Callback*)cb_NoteOn);
        o->value(part->Pnoteon);
      } // Fl_Check_Button* o
      { Fl_Counter* o = minkcounter = new Fl_Counter(295, 125, 40, 15, "Min.k");
        minkcounter->tooltip("Minimum key (that the part receives NoteOn messages)");
        minkcounter->type(1);
        minkcounter->labelfont(1);
        minkcounter->labelsize(10);
        minkcounter->minimum(0);
        minkcounter->maximum(127);
        minkcounter->step(1);
        minkcounter->textsize(10);
        minkcounter->callback((Fl_Callback*)cb_minkcounter1);
        o->value(part->Pminkey);
      } // Fl_Counter* minkcounter
      { Fl_Counter* o = maxkcounter = new Fl_Counter(340, 125, 40, 15, "Max.k");
        maxkcounter->tooltip("Maximum key (that the part receives NoteOn messages)");
        maxkcounter->type(1);
        maxkcounter->labelfont(1);
        maxkcounter->labelsize(10);
        maxkcounter->minimum(0);
        maxkcounter->maximum(127);
        maxkcounter->step(1);
        maxkcounter->textsize(10);
        maxkcounter->callback((Fl_Callback*)cb_maxkcounter1);
        o->value(part->Pmaxkey);
      } // Fl_Counter* maxkcounter
      { WidgetPDial* o = new WidgetPDial(10, 35, 30, 30, "Volume");
        o->tooltip("Part Volume");
        o->box(FL_ROUND_UP_BOX);
        o->color(FL_BACKGROUND_COLOR);
        o->selection_color(FL_INACTIVE_COLOR);
        o->labeltype(FL_NORMAL_LABEL);
        o->labelfont(0);
        o->labelsize(11);
        o->labelcolor(FL_FOREGROUND_COLOR);
        o->maximum(127);
        o->step(1);
        o->callback((Fl_Callback*)cb_Volume);
        o->align(Fl_Align(FL_ALIGN_BOTTOM));
        o->when(FL_WHEN_CHANGED);
        o->value(part->Pvolume);
      } // WidgetPDial* o
      { WidgetPDial* o = new WidgetPDial(135, 40, 25, 25, "Vel.Ofs.");
        o->tooltip("Velocity Offset");
        o->box(FL_ROUND_UP_BOX);
        o->color(FL_BACKGROUND_COLOR);
        o->selection_color(FL_INACTIVE_COLOR);
        o->labeltype(FL_NORMAL_LABEL);
        o->labelfont(0);
        o->labelsize(10);
        o->labelcolor(FL_FOREGROUND_COLOR);
        o->maximum(127);
        o->step(1);
        o->callback((Fl_Callback*)cb_Vel);
        o->align(Fl_Align(FL_ALIGN_BOTTOM));
        o->when(FL_WHEN_CHANGED);
        o->value(part->Pveloffs);
      } // WidgetPDial* o
      { WidgetPDial* o = new WidgetPDial(95, 40, 25, 25, "Vel.Sns.");
        o->tooltip("Velocity Sensing Function");
        o->box(FL_ROUND_UP_BOX);
        o->color(FL_BACKGROUND_COLOR);
        o->selection_color(FL_INACTIVE_COLOR);
        o->labeltype(FL_NORMAL_LABEL);
        o->labelfont(0);
        o->labelsize(10);
        o->labelcolor(FL_FOREGROUND_COLOR);
        o->maximum(127);
        o->step(1);
        o->callback((Fl_Callback*)cb_Vel1);
        o->align(Fl_Align(FL_ALIGN_BOTTOM));
        o->when(FL_WHEN_CHANGED);
        o->value(part->Pvelsns);
      } // WidgetPDial* o
      { Fl_Button* o = new Fl_Button(295, 90, 85, 30, "Controllers");
        o->box(FL_PLASTIC_UP_BOX);
        o->labelfont(1);
        o->labelsize(11);
        o->callback((Fl_Callback*)cb_Controllers);
      } // Fl_Button* o
      { Fl_Check_Button* o = new Fl_Check_Button(95, 155, 88, 20, "Portamento");
        o->tooltip("Enable/Disable the portamento");
        o->down_box(FL_DOWN_BOX);
        o->labelfont(1);
        o->labelsize(11);
        o->callback((Fl_Callback*)cb_Portamento);
        o->value(part->ctl.portamento.portamento);
      } // Fl_Check_Button* o
      { Fl_Button* o = new Fl_Button(15, 90, 130, 30, "Edit instrument");
        o->box(FL_PLASTIC_UP_BOX);
        o->color((Fl_Color)230);
        o->labelfont(1);
        o->labelsize(13);
        o->callback((Fl_Callback*)cb_Edit);
      } // Fl_Button* o
      { Fl_Button* o = new Fl_Button(315, 155, 15, 12, "m");
        o->tooltip("set the minimum key to the last pressed key");
        o->box(FL_THIN_UP_BOX);
        o->labelsize(10);
        o->callback((Fl_Callback*)cb_m1);
      } // Fl_Button* o
      { Fl_Button* o = new Fl_Button(345, 155, 15, 12, "M");
        o->tooltip("set the maximum key to the last pressed key");
        o->box(FL_THIN_UP_BOX);
        o->labelsize(10);
        o->callback((Fl_Callback*)cb_M1);
      } // Fl_Button* o
      { Fl_Button* o = new Fl_Button(330, 155, 15, 12, "R");
        o->tooltip("reset the minimum key to 0 and maximum key to 127");
        o->box(FL_THIN_UP_BOX);
        o->labelfont(1);
        o->labelsize(10);
        o->callback((Fl_Callback*)cb_R1);
      } // Fl_Button* o
      { Fl_Choice* o = new Fl_Choice(310, 45, 70, 20, "MIDI Chn.Rcv.");
        o->tooltip("receive from Midi channel");
        o->down_box(FL_BORDER_BOX);
        o->labelsize(10);
        o->textfont(1);
        o->textsize(10);
        o->callback((Fl_Callback*)cb_MIDI);
        o->align(Fl_Align(FL_ALIGN_TOP_LEFT));
        char nrstr[10]; for(int i=0;i<NUM_MIDI_CHANNELS;i++){sprintf(nrstr,"Chn%d",i+1);if (i!=9) o->add(nrstr); else o->add("Drms10");};
        o->value(part->Prcvchn);
      } // Fl_Choice* o
      { keylimitlist = new Fl_Choice(215, 155, 50, 20, "KLmt");
        keylimitlist->tooltip("Key Limit");
        keylimitlist->down_box(FL_BORDER_BOX);
        keylimitlist->labelsize(10);
        keylimitlist->textfont(1);
        keylimitlist->textsize(10);
        keylimitlist->callback((Fl_Callback*)cb_keylimitlist);
        keylimitlist->align(Fl_Align(FL_ALIGN_RIGHT));
      } // Fl_Choice* keylimitlist
      { Fl_Choice* o = new Fl_Choice(80, 130, 64, 18, "Mode :");
        o->tooltip("Poly, Mono or Legato mode");
        o->down_box(FL_BORDER_BOX);
        o->labelfont(1);
        o->labelsize(11);
        o->textfont(1);
        o->textsize(10);
        o->callback((Fl_Callback*)cb_Mode);
        o->add("Poly"); o->add("Mono"); o->add("Legato");
        if (part->Ppolymode!=0) o->value(0); else o->value(1);
        if (part->Ppolymode==0 && part->Plegatomode!=0) o->value(2);
      } // Fl_Choice* o
      if (part->Penabled==0) o->deactivate();
      partgroupui->end();
    } // Fl_Group* partgroupui
    { Fl_Check_Button* o = new Fl_Check_Button(90, 5, 75, 20, "Enabled");
      o->down_box(FL_DOWN_BOX);
      o->labelfont(1);
      o->labelsize(11);
      o->callback((Fl_Callback*)cb_Enabled);
      o->value(part->Penabled);
    } // Fl_Check_Button* o
    partgroup->end();
  } // Fl_Group* partgroup
  { ctlwindow = new Fl_Double_Window(460, 130, "Controllers");
    ctlwindow->user_data((void*)(this));
    { Fl_Check_Button* o = new Fl_Check_Button(155, 55, 45, 20, "Expr");
      o->tooltip("Expression enable");
      o->box(FL_THIN_UP_BOX);
      o->down_box(FL_DOWN_BOX);
      o->labelsize(10);
      o->callback((Fl_Callback*)cb_Expr);
      o->value(part->ctl.expression.receive);
    } // Fl_Check_Button* o
    { WidgetPDial* o = new WidgetPDial(10, 55, 30, 30, "PanDpth");
      o->tooltip("Panning Depth");
      o->box(FL_OVAL_BOX);
      o->color(FL_BACKGROUND_COLOR);
      o->selection_color(FL_INACTIVE_COLOR);
      o->labeltype(FL_NORMAL_LABEL);
      o->labelfont(0);
      o->labelsize(10);
      o->labelcolor(FL_FOREGROUND_COLOR);
      o->maximum(127);
      o->step(1);
      o->callback((Fl_Callback*)cb_PanDpth);
      o->align(Fl_Align(FL_ALIGN_BOTTOM));
      o->when(FL_WHEN_CHANGED);
      o->value(part->ctl.panning.depth);
    } // WidgetPDial* o
    { WidgetPDial* o = new WidgetPDial(90, 55, 30, 30, "FltCut");
      o->tooltip("Filter Cutoff depth");
      o->box(FL_OVAL_BOX);
      o->color(FL_BACKGROUND_COLOR);
      o->selection_color(FL_INACTIVE_COLOR);
      o->labeltype(FL_NORMAL_LABEL);
      o->labelfont(0);
      o->labelsize(10);
      o->labelcolor(FL_FOREGROUND_COLOR);
      o->maximum(127);
      o->step(1);
      o->callback((Fl_Callback*)cb_FltCut);
      o->align(Fl_Align(FL_ALIGN_BOTTOM));
      o->when(FL_WHEN_CHANGED);
      o->value(part->ctl.filtercutoff.depth);
    } // WidgetPDial* o
    { WidgetPDial* o = new WidgetPDial(50, 55, 30, 30, "FltQ");
      o->tooltip("Filter Q depth");
      o->box(FL_OVAL_BOX);
      o->color(FL_BACKGROUND_COLOR);
      o->selection_color(FL_INACTIVE_COLOR);
      o->labeltype(FL_NORMAL_LABEL);
      o->labelfont(0);
      o->labelsize(10);
      o->labelcolor(FL_FOREGROUND_COLOR);
      o->maximum(127);
      o->step(1);
      o->callback((Fl_Callback*)cb_FltQ);
      o->align(Fl_Align(FL_ALIGN_BOTTOM));
      o->when(FL_WHEN_CHANGED);
      o->value(part->ctl.filterq.depth);
    } // WidgetPDial* o
    { WidgetPDial* o = new WidgetPDial(125, 10, 30, 30, "BwDpth");
      o->tooltip("BandWidth depth");
      o->box(FL_OVAL_BOX);
      o->color(FL_BACKGROUND_COLOR);
      o->selection_color(FL_INACTIVE_COLOR);
      o->labeltype(FL_NORMAL_LABEL);
      o->labelfont(0);
      o->labelsize(10);
      o->labelcolor(FL_FOREGROUND_COLOR);
      o->maximum(127);
      o->step(1);
      o->callback((Fl_Callback*)cb_BwDpth);
      o->align(Fl_Align(FL_ALIGN_BOTTOM));
      o->when(FL_WHEN_CHANGED);
      o->value(part->ctl.bandwidth.depth);
    } // WidgetPDial* o
    { WidgetPDial* o = new WidgetPDial(50, 10, 30, 30, "ModWh");
      o->tooltip("Modulation Wheel depth");
      o->box(FL_OVAL_BOX);
      o->color(FL_BACKGROUND_COLOR);
      o->selection_color(FL_INACTIVE_COLOR);
      o->labeltype(FL_NORMAL_LABEL);
      o->labelfont(0);
      o->labelsize(10);
      o->labelcolor(FL_FOREGROUND_COLOR);
      o->maximum(127);
      o->step(1);
      o->callback((Fl_Callback*)cb_ModWh);
      o->align(Fl_Align(FL_ALIGN_BOTTOM));
      o->when(FL_WHEN_CHANGED);
      o->value(part->ctl.modwheel.depth);
    } // WidgetPDial* o
    { Fl_Counter* o = new Fl_Counter(165, 15, 110, 20, "PWheelB.Rng (cents)");
      o->tooltip("Pitch Wheel Bend Range (cents)");
      o->labelsize(10);
      o->minimum(-6400);
      o->maximum(6400);
      o->step(1);
      o->callback((Fl_Callback*)cb_PWheelB);
      o->align(Fl_Align(FL_ALIGN_TOP));
      o->value(part->ctl.pitchwheel.bendrange);
      o->lstep(100);
    } // Fl_Counter* o
    { Fl_Check_Button* o = new Fl_Check_Button(205, 55, 60, 20, "FMamp");
      o->tooltip("FM amplitude enable");
      o->box(FL_THIN_UP_BOX);
      o->down_box(FL_DOWN_BOX);
      o->labelsize(10);
      o->callback((Fl_Callback*)cb_FMamp);
      o->value(part->ctl.fmamp.receive);
    } // Fl_Check_Button* o
    { Fl_Check_Button* o = new Fl_Check_Button(155, 80, 45, 20, "Vol");
      o->tooltip("Volume enable");
      o->box(FL_THIN_UP_BOX);
      o->down_box(FL_DOWN_BOX);
      o->labelsize(10);
      o->callback((Fl_Callback*)cb_Vol);
      o->value(part->ctl.volume.receive);
    } // Fl_Check_Button* o
    { Fl_Check_Button* o = new Fl_Check_Button(205, 80, 60, 20, "Sustain");
      o->tooltip("Sustain pedal enable");
      o->box(FL_THIN_UP_BOX);
      o->down_box(FL_DOWN_BOX);
      o->labelsize(10);
      o->callback((Fl_Callback*)cb_Sustain);
      o->value(part->ctl.sustain.receive);
    } // Fl_Check_Button* o
    { Fl_Button* o = new Fl_Button(330, 105, 95, 20, "Close");
      o->box(FL_THIN_UP_BOX);
      o->callback((Fl_Callback*)cb_Close);
    } // Fl_Button* o
    { Fl_Button* o = new Fl_Button(5, 105, 210, 20, "Reset all controllers");
      o->box(FL_THIN_UP_BOX);
      o->callback((Fl_Callback*)cb_Reset);
    } // Fl_Button* o
    { Fl_Group* o = new Fl_Group(280, 15, 120, 85, "Portamento");
      o->box(FL_ENGRAVED_FRAME);
      o->labelfont(1);
      o->labelsize(10);
      { Fl_Check_Button* o = new Fl_Check_Button(285, 20, 40, 20, "Rcv");
        o->tooltip("Receive Portamento Controllers");
        o->box(FL_THIN_UP_BOX);
        o->down_box(FL_DOWN_BOX);
        o->labelsize(10);
        o->callback((Fl_Callback*)cb_Rcv);
        o->value(part->ctl.portamento.receive);
      } // Fl_Check_Button* o
      { WidgetPDial* o = new WidgetPDial(285, 60, 25, 25, "time");
        o->tooltip("Portamento time");
        o->box(FL_OVAL_BOX);
        o->color(FL_BACKGROUND_COLOR);
        o->selection_color(FL_INACTIVE_COLOR);
        o->labeltype(FL_NORMAL_LABEL);
        o->labelfont(0);
        o->labelsize(10);
        o->labelcolor(FL_FOREGROUND_COLOR);
        o->maximum(127);
        o->step(1);
        o->callback((Fl_Callback*)cb_time);
        o->align(Fl_Align(FL_ALIGN_BOTTOM));
        o->when(FL_WHEN_CHANGED);
        o->value(part->ctl.portamento.time);
      } // WidgetPDial* o
      { Fl_Counter* o = new Fl_Counter(340, 20, 50, 20, "thresh");
        o->tooltip("Minimum or max. difference of the notes in order to do the portamento (x 100 \
cents)");
        o->type(1);
        o->labelsize(10);
        o->minimum(0);
        o->maximum(127);
        o->step(1);
        o->callback((Fl_Callback*)cb_thresh);
        o->value(part->ctl.portamento.pitchthresh);
      } // Fl_Counter* o
      { Fl_Check_Button* o = new Fl_Check_Button(370, 70, 15, 15, "th.type");
        o->tooltip("Threshold type (min/max)");
        o->down_box(FL_DOWN_BOX);
        o->labelsize(10);
        o->callback((Fl_Callback*)cb_th);
        o->align(Fl_Align(FL_ALIGN_BOTTOM));
        o->value(part->ctl.portamento.pitchthreshtype);
      } // Fl_Check_Button* o
      { Fl_Box* o = new Fl_Box(340, 50, 55, 15, "x100 cnt.");
        o->labelsize(10);
        o->align(Fl_Align(FL_ALIGN_CENTER|FL_ALIGN_INSIDE));
      } // Fl_Box* o
      { WidgetPDial* o = new WidgetPDial(315, 60, 25, 25, "t.dn/up");
        o->tooltip("Portamento time stretch (up/down)");
        o->box(FL_OVAL_BOX);
        o->color(FL_BACKGROUND_COLOR);
        o->selection_color(FL_INACTIVE_COLOR);
        o->labeltype(FL_NORMAL_LABEL);
        o->labelfont(0);
        o->labelsize(10);
        o->labelcolor(FL_FOREGROUND_COLOR);
        o->maximum(127);
        o->step(1);
        o->callback((Fl_Callback*)cb_t);
        o->align(Fl_Align(FL_ALIGN_BOTTOM));
        o->when(FL_WHEN_CHANGED);
        o->value(part->ctl.portamento.updowntimestretch);
      } // WidgetPDial* o
      o->end();
    } // Fl_Group* o
    { Fl_Group* o = new Fl_Group(400, 15, 45, 85, "Resonance");
      o->box(FL_ENGRAVED_BOX);
      o->labelfont(1);
      o->labelsize(10);
      { WidgetPDial* o = new WidgetPDial(410, 60, 25, 25, "BWdpth");
        o->tooltip("BandWidth controller depth");
        o->box(FL_OVAL_BOX);
        o->color(FL_BACKGROUND_COLOR);
        o->selection_color(FL_INACTIVE_COLOR);
        o->labeltype(FL_NORMAL_LABEL);
        o->labelfont(0);
        o->labelsize(10);
        o->labelcolor(FL_FOREGROUND_COLOR);
        o->maximum(127);
        o->step(1);
        o->callback((Fl_Callback*)cb_BWdpth);
        o->align(Fl_Align(FL_ALIGN_BOTTOM));
        o->when(FL_WHEN_CHANGED);
        o->value(part->ctl.resonancebandwidth.depth);
      } // WidgetPDial* o
      { WidgetPDial* o = new WidgetPDial(410, 20, 25, 25, "CFdpth");
        o->tooltip("Center Frequency controller Depth");
        o->box(FL_OVAL_BOX);
        o->color(FL_BACKGROUND_COLOR);
        o->selection_color(FL_INACTIVE_COLOR);
        o->labeltype(FL_NORMAL_LABEL);
        o->labelfont(0);
        o->labelsize(10);
        o->labelcolor(FL_FOREGROUND_COLOR);
        o->maximum(127);
        o->step(1);
        o->callback((Fl_Callback*)cb_CFdpth);
        o->align(Fl_Align(FL_ALIGN_BOTTOM));
        o->when(FL_WHEN_CHANGED);
        o->value(part->ctl.resonancecenter.depth);
      } // WidgetPDial* o
      o->end();
    } // Fl_Group* o
    { Fl_Check_Button* o = new Fl_Check_Button(10, 15, 40, 25, "Exp MWh");
      o->tooltip("Exponential modulation wheel");
      o->down_box(FL_DOWN_BOX);
      o->labelsize(10);
      o->callback((Fl_Callback*)cb_Exp);
      o->align(Fl_Align(132|FL_ALIGN_INSIDE));
      o->value(part->ctl.modwheel.exponential);
    } // Fl_Check_Button* o
    { Fl_Check_Button* o = new Fl_Check_Button(85, 15, 35, 25, "Exp BW");
      o->tooltip("Exponential BandWidth Controller");
      o->down_box(FL_DOWN_BOX);
      o->labelsize(10);
      o->callback((Fl_Callback*)cb_Exp1);
      o->align(Fl_Align(132|FL_ALIGN_INSIDE));
      o->value(part->ctl.bandwidth.exponential);
    } // Fl_Check_Button* o
    ctlwindow->end();
  } // Fl_Double_Window* ctlwindow
  { partfx = new Fl_Double_Window(390, 145, "Part\'s Insert Effects");
    partfx->user_data((void*)(this));
    { Fl_Counter* o = inseffnocounter = new Fl_Counter(5, 110, 80, 20, "FX No.");
      inseffnocounter->type(1);
      inseffnocounter->labelfont(1);
      inseffnocounter->minimum(1);
      inseffnocounter->maximum(127);
      inseffnocounter->step(1);
      inseffnocounter->textfont(1);
      inseffnocounter->callback((Fl_Callback*)cb_inseffnocounter);
      inseffnocounter->align(Fl_Align(FL_ALIGN_BOTTOM_LEFT));
      o->bounds(1,NUM_PART_EFX);
      o->value(ninseff+1);
    } // Fl_Counter* inseffnocounter
    { Fl_Choice* o = insefftype = new Fl_Choice(155, 110, 70, 15, "EffType");
      insefftype->down_box(FL_BORDER_BOX);
      insefftype->labelsize(10);
      insefftype->callback((Fl_Callback*)cb_insefftype);
      insefftype->align(Fl_Align(FL_ALIGN_BOTTOM_LEFT));
      insefftype->menu(menu_insefftype);
      o->value(part->partefx[ninseff]->geteffect());
    } // Fl_Choice* insefftype
    { inseffectuigroup = new Fl_Group(5, 5, 380, 100);
      inseffectuigroup->box(FL_FLAT_BOX);
      inseffectuigroup->color((Fl_Color)48);
      { EffUI* o = inseffectui = new EffUI(5, 5, 380, 95);
        inseffectui->box(FL_NO_BOX);
        inseffectui->color(FL_BACKGROUND_COLOR);
        inseffectui->selection_color(FL_BACKGROUND_COLOR);
        inseffectui->labeltype(FL_NORMAL_LABEL);
        inseffectui->labelfont(0);
        inseffectui->labelsize(14);
        inseffectui->labelcolor(FL_FOREGROUND_COLOR);
        inseffectui->align(Fl_Align(FL_ALIGN_TOP));
        inseffectui->when(FL_WHEN_RELEASE);
        o->init(part->partefx[ninseff]);
        inseffectui->end();
      } // EffUI* inseffectui
      inseffectuigroup->end();
    } // Fl_Group* inseffectuigroup
    { Fl_Button* o = new Fl_Button(325, 115, 60, 20, "Close");
      o->box(FL_THIN_UP_BOX);
      o->callback((Fl_Callback*)cb_Close1);
    } // Fl_Button* o
    { Fl_Choice* o = sendtochoice = new Fl_Choice(235, 110, 80, 15, "Send To.");
      sendtochoice->down_box(FL_BORDER_BOX);
      sendtochoice->labelsize(10);
      sendtochoice->callback((Fl_Callback*)cb_sendtochoice);
      sendtochoice->align(Fl_Align(FL_ALIGN_BOTTOM_LEFT));
      sendtochoice->menu(menu_sendtochoice);
      int x=part->Pefxroute[ninseff]; if (x==127) x=1;
      o->value(x);
    } // Fl_Choice* sendtochoice
    { Fl_Check_Button* o = bypasseff = new Fl_Check_Button(90, 110, 60, 15, "bypass");
      bypasseff->tooltip("if the effect is not used (is bypassed)");
      bypasseff->down_box(FL_DOWN_BOX);
      bypasseff->labelsize(11);
      bypasseff->callback((Fl_Callback*)cb_bypasseff);
      int x=part->Pefxbypass[ninseff];o->value(x);
    } // Fl_Check_Button* bypasseff
    { Fl_Button* o = new Fl_Button(90, 127, 25, 15, "C");
      o->box(FL_THIN_UP_BOX);
      o->color((Fl_Color)179);
      o->labelfont(1);
      o->labelsize(11);
      o->labelcolor(FL_BACKGROUND2_COLOR);
      o->callback((Fl_Callback*)cb_C);
    } // Fl_Button* o
    { Fl_Button* o = new Fl_Button(120, 127, 25, 15, "P");
      o->box(FL_THIN_UP_BOX);
      o->color((Fl_Color)179);
      o->labelfont(1);
      o->labelsize(11);
      o->labelcolor(FL_BACKGROUND2_COLOR);
      o->callback((Fl_Callback*)cb_P);
    } // Fl_Button* o
    partfx->end();
  } // Fl_Double_Window* partfx
  { instrumentkitlist = new Fl_Double_Window(670, 370, "Instrument Kit");
    instrumentkitlist->user_data((void*)(this));
    { Fl_Button* o = new Fl_Button(375, 350, 160, 20, "Close Window");
      o->box(FL_THIN_UP_BOX);
      o->callback((Fl_Callback*)cb_Close2);
    } // Fl_Button* o
    { Fl_Scroll* o = kitlist = new Fl_Scroll(0, 15, 670, 330);
      kitlist->type(2);
      kitlist->box(FL_THIN_UP_BOX);
      { Fl_Pack* o = new Fl_Pack(0, 20, 670, 320);
        for (int i=0;i<NUM_KIT_ITEMS;i++){partkititem[i]=new PartKitItem(0,0,670,20,"");partkititem[i]->init(part,i,master,this);}
        o->end();
      } // Fl_Pack* o
      if (part->Pkitmode==0) o->deactivate();
      kitlist->end();
    } // Fl_Scroll* kitlist
    { Fl_Box* o = new Fl_Box(5, 0, 25, 15, "No.");
      o->labelfont(1);
      o->labelsize(11);
      o->align(Fl_Align(FL_ALIGN_BOTTOM|FL_ALIGN_INSIDE));
    } // Fl_Box* o
    { Fl_Box* o = new Fl_Box(55, 0, 25, 15, "M.");
      o->labelfont(1);
      o->labelsize(11);
      o->align(Fl_Align(FL_ALIGN_BOTTOM|FL_ALIGN_INSIDE));
    } // Fl_Box* o
    { Fl_Box* o = new Fl_Box(235, 0, 40, 15, "Min.k");
      o->labelfont(1);
      o->labelsize(11);
      o->align(Fl_Align(FL_ALIGN_BOTTOM|FL_ALIGN_INSIDE));
    } // Fl_Box* o
    { Fl_Box* o = new Fl_Box(345, 0, 40, 15, "Max.k");
      o->labelfont(1);
      o->labelsize(11);
      o->align(Fl_Align(FL_ALIGN_BOTTOM|FL_ALIGN_INSIDE));
    } // Fl_Box* o
    { Fl_Box* o = new Fl_Box(405, 0, 50, 15, "ADsynth");
      o->labelfont(1);
      o->labelsize(11);
      o->align(Fl_Align(FL_ALIGN_BOTTOM|FL_ALIGN_INSIDE));
    } // Fl_Box* o
    { Fl_Box* o = new Fl_Box(470, 0, 60, 15, "SUBsynth");
      o->labelfont(1);
      o->labelsize(11);
      o->align(Fl_Align(FL_ALIGN_BOTTOM|FL_ALIGN_INSIDE));
    } // Fl_Box* o
    { Fl_Choice* o = new Fl_Choice(35, 350, 70, 15, "Mode");
      o->down_box(FL_BORDER_BOX);
      o->labelsize(11);
      o->textfont(1);
      o->textsize(11);
      o->callback((Fl_Callback*)cb_Mode1);
      o->menu(menu_Mode);
      o->value(part->Pkitmode);
    } // Fl_Choice* o
    { Fl_Check_Button* o = new Fl_Check_Button(285, 350, 70, 15, "Drum mode");
      o->down_box(FL_DOWN_BOX);
      o->labelsize(10);
      o->callback((Fl_Callback*)cb_Drum);
      o->value(part->Pdrummode);
    } // Fl_Check_Button* o
    { Fl_Box* o = new Fl_Box(620, 0, 30, 15, "FX.r.");
      o->labelfont(1);
      o->labelsize(11);
      o->align(Fl_Align(FL_ALIGN_BOTTOM|FL_ALIGN_INSIDE));
    } // Fl_Box* o
    { Fl_Box* o = new Fl_Box(540, 0, 60, 15, "PADsynth");
      o->labelfont(1);
      o->labelsize(11);
      o->align(Fl_Align(FL_ALIGN_BOTTOM|FL_ALIGN_INSIDE));
    } // Fl_Box* o
    instrumentkitlist->end();
  } // Fl_Double_Window* instrumentkitlist
  { instrumenteditwindow = new Fl_Double_Window(395, 360, "Instrument Edit");
    instrumenteditwindow->user_data((void*)(this));
    { Fl_Group* o = new Fl_Group(0, 220, 395, 110);
      o->box(FL_ENGRAVED_FRAME);
      { Fl_Group* o = new Fl_Group(205, 245, 100, 80, "PADsynth");
        o->box(FL_ENGRAVED_FRAME);
        o->labelfont(1);
        { Fl_Button* o = padeditbutton = new Fl_Button(215, 280, 80, 35, "Edit");
          padeditbutton->box(FL_PLASTIC_UP_BOX);
          padeditbutton->color((Fl_Color)222);
          padeditbutton->selection_color((Fl_Color)220);
          padeditbutton->labelfont(1);
          padeditbutton->labelsize(13);
          padeditbutton->callback((Fl_Callback*)cb_padeditbutton1);
          padeditbutton->align(Fl_Align(FL_ALIGN_WRAP));
          if (part->kit[0].Ppadenabled==0) o->deactivate();
        } // Fl_Button* padeditbutton
        { Fl_Check_Button* o = padsynenabledcheck = new Fl_Check_Button(215, 255, 80, 20, "Enabled");
          padsynenabledcheck->tooltip("enable/disable PADsynth");
          padsynenabledcheck->box(FL_PLASTIC_UP_BOX);
          padsynenabledcheck->down_box(FL_DOWN_BOX);
          padsynenabledcheck->color((Fl_Color)222);
          padsynenabledcheck->selection_color((Fl_Color)218);
          padsynenabledcheck->labelfont(1);
          padsynenabledcheck->labelsize(11);
          padsynenabledcheck->callback((Fl_Callback*)cb_padsynenabledcheck);
          o->value(part->kit[0].Ppadenabled);
        } // Fl_Check_Button* padsynenabledcheck
        o->end();
      } // Fl_Group* o
      { Fl_Group* o = new Fl_Group(5, 245, 100, 80, "ADDsynth");
        o->box(FL_ENGRAVED_FRAME);
        o->labelfont(1);
        { Fl_Check_Button* o = adsynenabledcheck = new Fl_Check_Button(15, 255, 80, 20, "Enabled");
          adsynenabledcheck->tooltip("enable/disable ADsynth");
          adsynenabledcheck->box(FL_PLASTIC_UP_BOX);
          adsynenabledcheck->down_box(FL_DOWN_BOX);
          adsynenabledcheck->color((Fl_Color)222);
          adsynenabledcheck->selection_color((Fl_Color)218);
          adsynenabledcheck->labelfont(1);
          adsynenabledcheck->labelsize(11);
          adsynenabledcheck->callback((Fl_Callback*)cb_adsynenabledcheck);
          o->value(part->kit[0].Padenabled);
        } // Fl_Check_Button* adsynenabledcheck
        { Fl_Button* o = adeditbutton = new Fl_Button(15, 281, 80, 34, "Edit");
          adeditbutton->box(FL_PLASTIC_UP_BOX);
          adeditbutton->color((Fl_Color)222);
          adeditbutton->selection_color((Fl_Color)220);
          adeditbutton->labelfont(1);
          adeditbutton->labelsize(13);
          adeditbutton->callback((Fl_Callback*)cb_adeditbutton1);
          adeditbutton->align(Fl_Align(FL_ALIGN_WRAP));
          if (part->kit[0].Padenabled==0) o->deactivate();
        } // Fl_Button* adeditbutton
        o->end();
      } // Fl_Group* o
      { Fl_Group* o = new Fl_Group(105, 245, 100, 80, "SUBsynth");
        o->box(FL_ENGRAVED_FRAME);
        o->labelfont(1);
        { Fl_Check_Button* o = subsynenabledcheck = new Fl_Check_Button(115, 255, 80, 20, "Enabled");
          subsynenabledcheck->tooltip("enable/disable SUBsynth");
          subsynenabledcheck->box(FL_PLASTIC_UP_BOX);
          subsynenabledcheck->down_box(FL_DOWN_BOX);
          subsynenabledcheck->color((Fl_Color)222);
          subsynenabledcheck->selection_color((Fl_Color)218);
          subsynenabledcheck->labelfont(1);
          subsynenabledcheck->labelsize(11);
          subsynenabledcheck->callback((Fl_Callback*)cb_subsynenabledcheck);
          o->value(part->kit[0].Psubenabled);
        } // Fl_Check_Button* subsynenabledcheck
        { Fl_Button* o = subeditbutton = new Fl_Button(115, 280, 80, 35, "Edit");
          subeditbutton->box(FL_PLASTIC_UP_BOX);
          subeditbutton->color((Fl_Color)222);
          subeditbutton->selection_color((Fl_Color)220);
          subeditbutton->labelfont(1);
          subeditbutton->labelsize(13);
          subeditbutton->callback((Fl_Callback*)cb_subeditbutton1);
          subeditbutton->align(Fl_Align(FL_ALIGN_WRAP));
          if (part->kit[0].Psubenabled==0) o->deactivate();
        } // Fl_Button* subeditbutton
        o->end();
      } // Fl_Group* o
      { Fl_Button* o = new Fl_Button(310, 245, 80, 35, "Kit Edit");
        o->box(FL_PLASTIC_UP_BOX);
        o->color((Fl_Color)238);
        o->selection_color((Fl_Color)220);
        o->labelfont(1);
        o->callback((Fl_Callback*)cb_Kit);
        o->align(Fl_Align(FL_ALIGN_WRAP));
      } // Fl_Button* o
      { Fl_Button* o = new Fl_Button(310, 290, 80, 35, "Effects");
        o->box(FL_PLASTIC_UP_BOX);
        o->color((Fl_Color)230);
        o->labelfont(1);
        o->labelsize(13);
        o->callback((Fl_Callback*)cb_Effects);
      } // Fl_Button* o
      o->end();
    } // Fl_Group* o
    { Fl_Group* o = new Fl_Group(0, 5, 395, 215);
      o->box(FL_ENGRAVED_FRAME);
      { Fl_Input* o = new Fl_Input(5, 60, 385, 50, "Author and Copyright");
        o->type(4);
        o->color((Fl_Color)26);
        o->labelsize(10);
        o->callback((Fl_Callback*)cb_Author);
        o->align(Fl_Align(FL_ALIGN_TOP_LEFT));
        o->maximum_size(MAX_INFO_TEXT_SIZE);
        o->value((char *) &part->info.Pauthor);
      } // Fl_Input* o
      { Fl_Input* o = new Fl_Input(5, 125, 385, 90, "Comments");
        o->type(4);
        o->color((Fl_Color)26);
        o->labelsize(11);
        o->callback((Fl_Callback*)cb_Comments);
        o->align(Fl_Align(FL_ALIGN_TOP_LEFT));
        o->maximum_size(MAX_INFO_TEXT_SIZE);
        o->value((char *) &part->info.Pcomments);
      } // Fl_Input* o
      { Fl_Choice* o = new Fl_Choice(5, 25, 155, 20, "Type:");
        o->down_box(FL_BORDER_BOX);
        o->labelfont(1);
        o->labelsize(11);
        o->textsize(10);
        o->callback((Fl_Callback*)cb_Type);
        o->align(Fl_Align(FL_ALIGN_TOP_LEFT));
        o->menu(menu_Type);
        o->value(part->info.Ptype);
      } // Fl_Choice* o
      o->end();
    } // Fl_Group* o
    { Fl_Button* o = new Fl_Button(150, 335, 95, 25, "Close");
      o->box(FL_THIN_UP_BOX);
      o->callback((Fl_Callback*)cb_Close3);
    } // Fl_Button* o
    instrumenteditwindow->end();
  } // Fl_Double_Window* instrumenteditwindow
  return instrumenteditwindow;
}

PartUI::PartUI(int x,int y, int w, int h, const char *label):Fl_Group(x,y,w,h,label) {
  part=NULL;
adnoteui=NULL;
subnoteui=NULL;
padnoteui=NULL;
lastkititem=-1;
}

void PartUI::init(Part *part_,Master *master_,int npart_,BankUI *bankui_) {
  bankui=bankui_;
part=part_;
npart=npart_;
master=master_;
ninseff=0;

make_window();
partgroup->position(this->parent()->x()+2,this->parent()->y()+2);
partgroup->show();
end();


//if (config.ui.showinstrumentinfo!=0) instrumenteditwindow->show();

int klimits[]={1,2,3,4,5,6,7,8,9,10,15,20,30,50,100,0};

keylimitlist->add("OFF");
int k=0;
int val=-1;
char tmp[10];
while (klimits[k]!=0){
	sprintf(tmp,"%d",klimits[k]);
	keylimitlist->add(tmp);
	if ((val==-1)){
		if (klimits[k]>part->Pkeylimit) val=k;
	};
	k++;
};

if (val==-1) val=k;
keylimitlist->value(val);
}

void PartUI::showparameters(int kititem,int engine) {
  if (engine==-1){//this is used if I want to clear the engine from the part
   if (kititem==lastkititem) kititem=-1;
         else kititem=lastkititem;
};

if (kititem!=lastkititem){
    if (adnoteui!=NULL) delete (adnoteui);
    if (subnoteui!=NULL) delete (subnoteui);   
    if (padnoteui!=NULL) delete (padnoteui);
    adnoteui=NULL;subnoteui=NULL;padnoteui=NULL;
    lastkititem=kititem;

    if (kititem>=NUM_KIT_ITEMS) return;//bad kit item
    if (kititem<0) return;

    if (part->kit[kititem].adpars!=NULL) 
      adnoteui=new ADnoteUI(part->kit[kititem].adpars,master);

    if (part->kit[kititem].subpars!=NULL) 
       subnoteui=new SUBnoteUI(part->kit[kititem].subpars);

    if (part->kit[kititem].padpars!=NULL) 
      padnoteui=new PADnoteUI(part->kit[kititem].padpars,master);

};



if ((engine==0)&&(adnoteui!=NULL)) adnoteui->ADnoteGlobalParameters->show();
if ((engine==1)&&(subnoteui!=NULL)) subnoteui->SUBparameters->show();
if ((engine==2)&&(adnoteui!=NULL)) padnoteui->padnotewindow->show();
}

PartUI::~PartUI() {
  if (adnoteui!=NULL) delete (adnoteui);
if (subnoteui!=NULL) delete (subnoteui);
if (padnoteui!=NULL) delete (padnoteui);

partgroup->hide();
//delete(partgroup);

ctlwindow->hide();
delete(ctlwindow);

partfx->hide();
delete(partfx);

instrumentkitlist->hide();
delete(instrumentkitlist);

instrumenteditwindow->hide();
delete(instrumenteditwindow);
}
