#include "common.h"

extern "C"
{
#include <dirent.h>
#include <libgen.h>
#include <termios.h>
#include <time.h>
#include <sys/ioctl.h>
}

bool cDirWnd::gRemainMarks = true;                  // }[NR}hscǂ

char* cDirWnd::kSortName[cDirWnd::kSortMax] = {
    "name", "name_rev", "extension", "extension_rev", "size", "size_rev",
    "time", "time_rev", "user", "user_rev", "group", "group_rev", "permission", "permission_rev", "random", "none"
};

vector_obj* gDirStack;                   // fBNgX^bN sDirInfo̔z
int gDirScrollTop = 0;                   // fBNgX^bNIʂ̃XN[ʒu
int gDirCursor = 0;                      // fBNgX^bNIʂ̃J[\ʒu
bool gSelectDir = false;                        // fBNgX^bNIʂǂ

///////////////////////////////////////////////////////////////////////////////
// EI
///////////////////////////////////////////////////////////////////////////////
void cDirWnd::Init()
{
    gDirStack = vector_new(10);
}

void cDirWnd::Final()
{
    for(int i=0; i<vector_size(gDirStack); i++) {
        FREE(vector_item(gDirStack, i));
    }
    vector_delete(gDirStack);
}

///////////////////////////////////////////////////////////////////////////////
// RXgN^EfXgN^
///////////////////////////////////////////////////////////////////////////////
cDirWnd::eViewOption cDirWnd::gViewOption = cDirWnd::kAll;      // ʕ\̎

cDirWnd::cDirWnd(char* path, bool active)
{
    mFiles = vector_new(30);
    mDirStack = list_new();
    mMarkFiles = hash_new(30);
    mFileNum = hash_new(30);
    mFileNum2 = list_new();
    mSortKind = cDirWnd::kName;
    mViewNameOnly = false;
    mViewFocusBack = false;
    mViewRemoveDir = false;

    char path3[PATH_MAX];
    if(!correct_path(NULL, path, path3)) {
        strcpy(path3, "/");
    }

    if(path3[strlen(path3)-1] != '/') {
        strcat(path3, "/");
    }
    
    strcpy(mPath, path3);
    
    strcpy(mMask, "{*,.*}");
    strcpy(mPathBefore, "");

    read();

    mActive = active;
    mScrollTop = 0; 
    if(vector_size(mFiles) <= 2)
        mCursor = 1;
    else
        mCursor = 2;
        
    Sort();
}

cDirWnd::~cDirWnd()
{
    hash_delete(mMarkFiles);
    hash_delete(mFileNum);
    for(list_it* i=list_begin(mFileNum2); i; i=list_next(i)) {
        FREE(list_item(i));
    }
    list_delete(mFileNum2);
    for(list_it* i=list_begin(mDirStack); i; i=list_next(i)) {
        FREE(list_item(i));
    }
    list_delete(mDirStack);
    for(int i=0; i<vector_size(mFiles); i++) {
        delete (sFile*)vector_item(mFiles, i);
    }
    vector_delete(mFiles);
}

///////////////////////////////////////////////////////////////////////////////
// vCx[g\bh
///////////////////////////////////////////////////////////////////////////////
void cDirWnd::clear_dir_stack()
{
    for(list_it* i=list_begin(mDirStack); i; i=list_next(i)) {
        FREE(list_item(i));
    }
    list_clear(mDirStack);
}

///////////////////////////////////////////////////////////////////////////////
// file yomikomi
///////////////////////////////////////////////////////////////////////////////
int convert_fname(char* src, char* des, int des_size) 
{
#if defined(HAVE_ICONV_H) || defined(HAVE_BICONV_H) 
    if(is_all_ascii(src)) {
        strcpy(des, src);
    }
    else {
        /// Ro[g ///
        if(kanji_convert(src, des, des_size, gKanjiCodeFileName, gKanjiCode) == -1) {
            return -1;
        }
    }
    return 0;
#else
    strcpy(des, src);
    return 0;
#endif
}

///////////////////////////////////////////////////////////////////////////////
// fBXNǂݍ
///////////////////////////////////////////////////////////////////////////////
void cDirWnd::read()
{
    if(access(Path(), F_OK) != 0) Move("/");

    if(strcmp(mPath, mPathBefore) != 0) {
        hash_clear(mMarkFiles);
    }
    
    for(int i= 0; i<vector_size(mFiles); i++) {
        delete (sFile*)vector_item(mFiles, i);
    }
    vector_clear(mFiles);

    /// fBXNǂݍ݃tbNH ///
    VALUE disk_read_ret;
    
    if(gLDir == this)
        disk_read_ret = rb_funcall(rb_cObject, rb_intern("disk_read_hook_ldir"), 0);
    else
        disk_read_ret = rb_funcall(rb_cObject, rb_intern("disk_read_hook_rdir"), 0);
    
    /// tbNȂftHg̃t@Cǂݍ ///
    if(disk_read_ret == Qnil) {
        DIR* dir = opendir(mPath);
        if(dir == NULL) {
            gErrMsgCancel = false; 
            err_msg("cDirWnd::read(): opendir err");
            Move("/");
        }
        
        struct dirent* entry;
        while(entry = readdir(dir)) {
            char fname[4089];
            if(convert_fname(entry->d_name, fname, 4089) == -1) {
                continue;
            }

            char path[PATH_MAX];
            strcpy(path, mPath);
            strcat(path, entry->d_name);
            
            struct stat lstat_;
            memset(&lstat_, 0, sizeof(struct stat));
            if(lstat(path, &lstat_) < 0) {
                continue;
            }

            struct stat stat_;
            memset(&stat_, 0, sizeof(struct stat));
            if(stat(path, &stat_) < 0) {
                if(S_ISLNK(lstat_.st_mode)) {
                    stat_ = lstat_;
                }
                else {
                    continue;
                }
            }
            
            char linkto[PATH_MAX];

            if(S_ISLNK(lstat_.st_mode)) {
                int bytes = readlink(path, linkto, PATH_MAX);
                if(bytes == -1) {
                    linkto[0] = 0;
                }
                else {
                    linkto[bytes] = 0;
                }
            }
            else {
                linkto[0] = 0;
            }

#if defined(HAVE_ICONV_H) || defined(HAVE_BICONV_H)
            char tmp[PATH_MAX + 1];
            if(kanji_convert(linkto, tmp, PATH_MAX, gKanjiCodeFileName, gKanjiCode) != -1) {
                strcpy(linkto, tmp);
            }
#endif
            char* user = mygetpwuid(&lstat_);
            char* group = mygetgrgid(&lstat_);

            if(strcmp(entry->d_name, ".") != 0) {
                /// mark ///
                bool mark = false;
                
                if(hash_item(mMarkFiles, entry->d_name) == (void*)1) mark = true;

                /// add ///
                vector_add(mFiles, new sFile(entry->d_name, fname, linkto, &stat_, &lstat_, mark, user, group, lstat_.st_uid, lstat_.st_gid));
            }
        }
        
        closedir(dir);
    }

    /// }XN ///
    VALUE ret;
    if(this == gLDir)
        ret = rb_funcall(rb_cObject, rb_intern("mask_hook_ldir"), 5, Qnil, INT2NUM(0), INT2NUM(0), INT2NUM(0), INT2NUM(0));
    else
        ret = rb_funcall(rb_cObject, rb_intern("mask_hook_rdir"), 5, Qnil, INT2NUM(0), INT2NUM(0), INT2NUM(0), INT2NUM(0));
    
    /// }XNtbNȂ߂lfalsẽt@C̓Xg폜 ///
    if(ret != Qnil) {
        for(int i=0; i<vector_size(mFiles); i++) {
            sFile* file = (sFile*)vector_item(mFiles, i);

            int kind = 0;
            if(S_ISDIR(file->mLStat.st_mode)) {
                kind = 1;
            }
            else if(S_ISLNK(file->mLStat.st_mode)) {
                if(S_ISDIR(file->mStat.st_mode)) {
                    kind = 3;
                }
                else {
                    kind = 2;
                }
            }

            if(this == gLDir)
                ret = rb_funcall(rb_cObject, rb_intern("mask_hook_ldir"), 5, rb_str_new2(file->mName), INT2NUM(kind), INT2NUM(file->mStat.st_uid), INT2NUM(file->mStat.st_gid), INT2NUM(file->mStat.st_mode & S_ALLPERM));
            else
                ret = rb_funcall(rb_cObject, rb_intern("mask_hook_rdir"), 5, rb_str_new2(file->mName), INT2NUM(kind), INT2NUM(file->mStat.st_uid), INT2NUM(file->mStat.st_gid), INT2NUM(file->mStat.st_mode & S_ALLPERM));
            
            if(ret == Qfalse) {
                vector_erase(mFiles, i);
                i--;
            }
        }
    }
    
    /// I ///
    strcpy(mPathBefore, mPath);
    
    hash_file_num_reset();
}

void cDirWnd::DeleteFileFromFileList(int num)
{
    if(num >= 0 && num < vector_size(mFiles)) {
        vector_erase(mFiles, num);
    }
}

void cDirWnd::AddFile(char* fname) 
{
    /// t@Cɑ݂ȂǉȂ ///
    for(int i=0; i<vector_size(mFiles); i++) {
        sFile* item = (sFile*)vector_item(mFiles, i);

        if(strcmp(item->mName, fname) == 0) {
            return;
        }
    }

    /// mark ///
    bool mark = false;
    
    if(hash_item(mMarkFiles, fname) == (void*)1)
        mark = true;

    /// fname_view ///
    char fname_view[PATH_MAX];

#if defined(HAVE_ICONV_H) || defined(HAVE_BICONV_H)
    if(kanji_convert(fname, fname_view, PATH_MAX, gKanjiCodeFileName, gKanjiCode)== -1) {
        strcpy(fname_view, fname);
    }
#else
    strcpy(fname_view, fname);
#endif

    /// stat ///
    char path[PATH_MAX];
    strcpy(path, mPath);
    strcat(path, fname);
    
    struct stat lstat_;
    memset(&lstat_, 0, sizeof(struct stat));
    if(lstat(path, &lstat_) < 0) {
        return;
    }

    struct stat stat_;
    memset(&stat_, 0, sizeof(struct stat));
    if(stat(path, &stat_) < 0) {
        if(S_ISLNK(lstat_.st_mode)) {
            stat_ = lstat_;
        }
        else {
            return;
        }
    }
    
    /// linkto ///
    char linkto[PATH_MAX];

    if(S_ISLNK(lstat_.st_mode)) {
        int bytes = readlink(path, linkto, PATH_MAX);
        if(bytes == -1) {
            linkto[0] = 0;
        }
        else {
            linkto[bytes] = 0;
        }
    }
    else {
        linkto[0] = 0;
    }

#if defined(HAVE_ICONV_H) || defined(HAVE_BICONV_H)
    char tmp[PATH_MAX + 1];
    if(kanji_convert(linkto, tmp, PATH_MAX, gKanjiCodeFileName, gKanjiCode)!= -1) {
        strcpy(linkto, tmp);
    }
#endif

    char* user = mygetpwuid(&lstat_);
    char* group = mygetgrgid(&lstat_);

    /// add ///
    vector_add(mFiles, new sFile(fname, fname_view, linkto, &stat_, &lstat_, mark, user, group, lstat_.st_uid, lstat_.st_gid));
}

void cDirWnd::AddFile2(char* fname, char* linkto, int kind, bool user_r, bool user_w, bool user_x, bool group_r, bool group_w, bool group_x, bool other_r, bool other_w, bool other_x, int size, time_t mtime, char* user, char* group)
{
    /// t@Cɑ݂ȂǉȂ ///
    for(int i=0; i<vector_size(mFiles); i++) {
        sFile* item = (sFile*)vector_item(mFiles, i);

        if(strcmp(item->mName, fname) == 0) {
            return;
        }
    }

    /// mark ///
    bool mark = false;
    
    if(hash_item(mMarkFiles, fname) == (void*)1)
        mark = true;

    /// fname_view ///
    char fname_view[PATH_MAX];

#if defined(HAVE_ICONV_H) || defined(HAVE_BICONV_H)
    if(kanji_convert(fname, fname_view, PATH_MAX, gKanjiCodeFileName, gKanjiCode)== -1) {
        strcpy(fname_view, fname);
    }
#else
    strcpy(fname_view, fname);
#endif

    /// stat ///
    char path[PATH_MAX];
    strcpy(path, mPath);
    strcat(path, fname);
    
    struct stat lstat_;
    memset(&lstat_, 0, sizeof(struct stat));

    lstat_.st_mode = (user_r?S_IRUSR:0)|(user_w?S_IWUSR:0)|(user_x?S_IXUSR:0)|(group_r?S_IRGRP:0)|(group_w?S_IWGRP:0)|(group_x?S_IXGRP:0)|(other_r?S_IROTH:0)|(other_w?S_IWOTH:0)|(other_x?S_IXOTH:0);
    if(kind == 0) {
        lstat_.st_mode |= S_IFREG;
    }
    else if(kind == 1) {
        lstat_.st_mode |= S_IFDIR;
    }
    else if(kind == 2) {
        lstat_.st_mode |= S_IFLNK;
    }
    lstat_.st_mtime = mtime;
    lstat_.st_size = size;

    struct stat stat_;
    stat_ = lstat_;
    

#if defined(HAVE_ICONV_H) || defined(HAVE_BICONV_H)
    char tmp[PATH_MAX + 1];
    if(kanji_convert(linkto, tmp, PATH_MAX, gKanjiCodeFileName, gKanjiCode) != -1) {
        strcpy(linkto, tmp);
    }
#endif

    /// add ///
    vector_add(mFiles, new sFile(fname, fname_view, linkto, &stat_, &lstat_, mark, user, group, 0,0));
}

void cDirWnd::hash_file_num_reset()
{
    hash_clear(mFileNum);
    for(list_it* i=list_begin(mFileNum2); i; i=list_next(i)) {
        delete (int*)list_item(i);
    }
    list_clear(mFileNum2);
    
    for(int i=0; i<vector_size(mFiles); i++) {
        sFile* file = (sFile*)vector_item(mFiles, i);
        int* n = new int(i);

        hash_put(mFileNum, file->mName, n);
        list_push_back(mFileNum2, n);
    }
}

void cDirWnd::Reread()
{
    read();
    MoveCursor(mCursor);
    Sort();
}


void cDirWnd::Activate(cDirWnd* current)
{
    current->mActive = false;
    mActive = true;

    if(!gIndividualCursor)
        MoveCursor(mScrollTop + current->mCursor - current->mScrollTop);

    chdir(mPath);
    setenv("PWD", mPath, 1);
   
    /// [̃^CgɖOt ///
    if(gChangeTerminalTitle) {
        char tmp2[PATH_MAX];
        char* home = getenv("HOME");
        if(home == NULL) {
           fprintf(stderr, "HOME is NULL");
           exit(1);
        }
        if(strstr(mPath, home) == mPath) {
           strcpy(tmp2, "~");
           sprintf(tmp2 + strlen(tmp2), mPath + strlen(home));
           printf("%c]2;mfiler2 %s%c", 033, tmp2, 007);
           fflush(stdout);
        }
        else {
           printf("%c]2;mfiler2 %s%c", 033, mPath, 007);
           fflush(stdout);
        }
    }
}

void cDirWnd::Mark()
{
    sFile* cursor = (sFile*)vector_item(mFiles, mCursor);
    cursor->mMark = !cursor->mMark;

    if(cursor->mMark)
        hash_put(mMarkFiles, cursor->mName, (void*)1);
    else
        hash_erase(mMarkFiles, cursor->mName);
}

void cDirWnd::Mark2(int index)
{
    if(index>=0 && index<vector_size(mFiles)) {
        sFile* cursor = (sFile*)vector_item(mFiles, index);
        cursor->mMark = !cursor->mMark;

        if(cursor->mMark)
            hash_put(mMarkFiles, cursor->mName, (void*)1);
        else
            hash_erase(mMarkFiles, cursor->mName);
    }
}

void cDirWnd::Mark3(int index)
{
    if(index>=0 && index<vector_size(mFiles)) {
        sFile* cursor = (sFile*)vector_item(mFiles, index);
        cursor->mMark = true;

        if(cursor->mMark)
            hash_put(mMarkFiles, cursor->mName, (void*)1);
        else
            hash_erase(mMarkFiles, cursor->mName);
    }
}

void cDirWnd::MarkOff(char* fname)
{
    int index = FileNum(fname);
    if(index != -1) {
        MarkOff(index);
    }
}

void cDirWnd::MarkOff(int index)
{
    if(index>=0 && index<vector_size(mFiles)) {
        sFile* cursor = (sFile*)vector_item(mFiles, index);
        cursor->mMark = false;

        if(cursor->mMark)
            hash_put(mMarkFiles, cursor->mName, (void*)1);
        else
            hash_erase(mMarkFiles, cursor->mName);
    }
}

void cDirWnd::MarkAll()
{
    for(int i=0; i<vector_size(mFiles); i++) {
        sFile* file = (sFile*)vector_item(mFiles, i);
        if(strcmp(file->mName, ".") != 0 && strcmp(file->mName, "..") != 0) {
            file->mMark = !file->mMark;

            if(file->mMark)
                hash_put(mMarkFiles, file->mName, (void*)1);
            else
                hash_erase(mMarkFiles, file->mName);
        }
    }
}

void cDirWnd::MarkAllFiles()
{


    for(int i=0; i<vector_size(mFiles); i++) {
        sFile* file = (sFile*)vector_item(mFiles, i);
        if(!S_ISDIR(file->mStat.st_mode)) {
             file->mMark = !file->mMark;

             if(file->mMark)
                 hash_put(mMarkFiles, file->mName, (void*)1);
             else
                 hash_erase(mMarkFiles, file->mName);
        }
    }

     
}

void cDirWnd::ResetMarks()
{


    for(int i=0; i<vector_size(mFiles); i++) {
        sFile* file = (sFile*)vector_item(mFiles, i);
        file-> mMark = false;

//        hash_erase(mMarkFiles, file->mName);
    }
    
    hash_clear(mMarkFiles);


}

bool cDirWnd::Move(char* path)
{
    char path2[PATH_MAX];
    if(!correct_path(Path(), path, path2)) {
        //strcpy(path2, "/");
        return false;
    }
    
    if(access(path2, F_OK) == 0 && strcmp(mPath, path2) != 0) {
         char path3[PATH_MAX];

         strcpy(path3, path2);
         if(path2[strlen(path2) -1] != '/') {
              strcat(path3, "/");
         }

        DIR* dir = opendir(path3);
         if(dir && access(path3, X_OK) == 0) {
             closedir(dir);

             /// ݂̃fBNgۑ ///
             sDirInfo* dinfo = (sDirInfo*)MALLOC(sizeof(sDirInfo));
             strcpy(dinfo->mPath, mPath);
             dinfo->mCursor = mCursor;
             dinfo->mScrollTop = mScrollTop;
             
             list_push_back(mDirStack, dinfo);
             if(list_size(mDirStack) > kDirStackSize) {
                 FREE(list_item(list_begin(mDirStack)));
                 list_pop_front(mDirStack);
             }

             /// fBNgƂ̃tbN ///
             rb_funcall(rb_cObject, rb_intern("path_change_hook"), 1, gLDir == this?Qtrue:Qfalse);

             /// ړ ///
             char* tmp = STRDUP(mPath);
             char* fname = STRDUP(basename(tmp));
             FREE(tmp);
    
             char* parentpath = parentname(mPath);

             strcpy(mPath, path3);
             
             read();
             Sort();
   
             /// [̃^CgɖOt ///
             if(gChangeTerminalTitle) {
                 char tmp2[PATH_MAX];
                 char* home = getenv("HOME");
                 if(home == NULL) {
                    fprintf(stderr, "HOME is NULL");
                    exit(1);
                 }
                 if(strstr(mPath, home) == mPath) {
                    strcpy(tmp2, "~");
                    sprintf(tmp2 + strlen(tmp2), mPath + strlen(home));
                    printf("%c]2;mfiler2 %s%c", 033, tmp2, 007);
                    fflush(stdout);
                 }
                 else {
                    printf("%c]2;mfiler2 %s%c", 033, mPath, 007);
                    fflush(stdout);
                 }
             }

             if(gRemainCursor) {
                 bool found = false;
                 for(list_it* i = list_last(mDirStack); i;
                             i = list_prev(i))
                     {
                     sDirInfo* dinfo = (sDirInfo*)list_item(i);

                     if(strcmp(mPath, dinfo->mPath) == 0) {
                         SetScrollTop(dinfo->mScrollTop);
                         MoveCursor(dinfo->mCursor);
                         found = true;
                         break;
                     }
                 }
    
                 if(!found) {
                     if(strcmp(mPath, parentpath) == 0) {

                         bool found2 = false;
                             
                         for(int i=0; i<vector_size(mFiles); i++) {
                             sFile* file = (sFile*)vector_item(mFiles, i);
                             if(strcmp(file->mName, fname) == 0) {
                                 mScrollTop = 0;
                                 MoveCursor(i);
                                 found2 = true;
                             }
                         }
                         
                         if(!found2) {
                             mScrollTop = 0;
                             MoveCursor(0);
                         }
                     }
                     else {
                        mScrollTop = 0;
                        MoveCursor(0);
                     }
                 }
            }
            else {
                if(strcmp(mPath, parentpath) == 0) {
                     bool found = false;
                         
                     for(int i=0; i<vector_size(mFiles); i++) {
                         sFile* file = (sFile*)vector_item(mFiles, i);
                         if(strcmp(file->mName, fname) == 0) {
                             mScrollTop = 0;
                             MoveCursor(i);
                             found = true;
                         }
                     }
                     
                    
                     if(!found) {
                         mScrollTop = 0;
                         MoveCursor(0);
                     }
                 }
                 else {
                    mScrollTop = 0;
                    MoveCursor(0);
                 }
             }
             
             FREE(parentpath);
             FREE(fname);
             
             if(this == ActiveDir()) {
                chdir(mPath);
                setenv("PWD", mPath, 1);
             }

             return true;
         }
    }

    return false;
}

///////////////////////////////////////////////////////////////////////////////
// ߂
///////////////////////////////////////////////////////////////////////////////
void cDirWnd::MoveBack()
{
    if(list_size(mDirStack) > 0) {
        sDirInfo* dinfo = (sDirInfo*)list_pop_back(mDirStack);

        if(access(dinfo->mPath, F_OK) == 0) {
             /// fBNgƂ̃tbN ///
             rb_funcall(rb_cObject, rb_intern("path_change_hook"), 1, gLDir == this?Qtrue:Qfalse);

             /// ߂ ///
             strcpy(mPath, dinfo->mPath);
             read();

             Sort();
    
             SetScrollTop(dinfo->mScrollTop);
             MoveCursor(dinfo->mCursor);
        }

        FREE(dinfo);
    }

    if(ActiveDir() == this) chdir(mPath);
}

///////////////////////////////////////////////////////////////////////////////
// ёւ
///////////////////////////////////////////////////////////////////////////////
void cDirWnd::ChangeSort()
{
    int n = 0;
    for(int i=0; i<vector_size(mFiles); i++) {
        sFile* file = (sFile*)vector_item(mFiles, i);
        if(file->mMark) {
            vector_erase(mFiles, i);
            if(i < mCursor+n) {
                vector_insert(mFiles, mCursor, file);
            }
            else {
                vector_insert(mFiles, mCursor+n, file);
            }
            n++;
            file->mMark = false;
            if(i <= mCursor+n) {
                i--;
            }
        }
    }
}

///////////////////////////////////////////////////////////////////////////////
// }XNύX
///////////////////////////////////////////////////////////////////////////////
bool cDirWnd::ChangeMask(char* mask)
{
    strcpy(mMask, mask);

    MoveCursor(mCursor);
    SetScrollTop(0);

    return true;
}

