
###############################################################################
# VKt@C쐬j[(N)
###############################################################################
def make_new_shell_script(fname)
    if !File.exist?(adir_path() + fname)
        begin 
            f = File.new(adir_path() + fname,File::CREAT|File::TRUNC|File::WRONLY)
            f.chmod(0755)
            f.print("#!/bin/sh\n\n")
            f.close
        rescue
            return false
        end
        reread(0)
        reread(1)
        cursor_move(adir(), file_num(adir(), fname))
    end
end

def make_new_html(fname)
    if !File.exist?(adir_path() + fname)
        begin 
            f = File.new(adir_path() + fname,File::CREAT|File::TRUNC|File::WRONLY)
            f.print <<EOS
<html>
<head>
<title></title>
<meta http-equiv="Content-Type" content="text/html; charset=utf-8">
</head>
<body>
</body>
</html>
EOS
            f.close
        rescue
            return false
        end
        reread(0)
        reread(1)
        cursor_move(adir(), file_num(adir(), fname))
    end
end

def make_new_perl_script(fname)
    if !File.exist?(adir_path() + fname)
        begin
            f = File.new(adir_path() + fname,File::CREAT|File::TRUNC|File::WRONLY)
            f.chmod(0755)
            f.print("#!/usr/bin/env perl\n\n")
            f.close
        rescue
            return false
        end
        reread(0)
        reread(1)
        cursor_move(adir(), file_num(adir(), fname))
    end
end

def make_new_python_script(fname)
    if !File.exist?(adir_path() + fname)
        begin
            f = File.new(adir_path() + fname,File::CREAT|File::TRUNC|File::WRONLY)
            f.chmod(0755)
            f.print("#!/usr/bin/env python\n\n")
            f.close
        rescue
            return false
        end
        reread(0)
        reread(1)
        cursor_move(adir(), file_num(adir(), fname))
    end
end

def make_new_ruby_script(fname)
    if !File.exist?(adir_path() + fname)
        begin
            f = File.new(adir_path() + fname,File::CREAT|File::TRUNC|File::WRONLY)
            f.chmod(0755)
            f.print("#!/usr/bin/env ruby\n\n")
            f.close
        rescue
            return false
        end
        reread(0)
        reread(1)
        cursor_move(adir(), file_num(adir(), fname))
    end
end

defmenu("new-file",
    "(s)h script", KEY_s, "cmdline_c('%r%Q make_new_shell_script \\'.sh\\'', -4, nil)",
    "(h)tml", KEY_h, "cmdline_c('%r%Q make_new_html \\'.html\\'', -6, nil)",
    "(p)erl script", KEY_p, "cmdline_c('%r%Q make_new_perl_script \\'.pl\\'', -4, nil)",
    "p(y)thon script", KEY_y, "cmdline_c('%r%Q make_new_python_script \\'.py\\'', -4, nil)",
    "(r)uby script", KEY_r, "cmdline_c('%r%Q make_new_ruby_script \\'.rb\\'', -4, nil)",
    "play (l)ist", KEY_l, "cmdline_c('%r%Q make_new_playlist \\'.list\\'', -6, nil)"
);

keycommand NOMETA, KEY_N,      "*",     "menu('new-file')"

