#include "common.h"

bool gViewHelp = false;

static int gScrollTop = 0;

const int kMaxMessage = 72;

void help_start()
{
    gViewHelp = true;
    gScrollTop = 0;
}

void help_view()
{
    const int maxx = mgetmaxx();
    const int maxy = mgetmaxy();
    
    mmove(0,0);

    char* buf[] = {
        "UP, CTRL-P                        move cursor up",
        "DOWN, CTRL-N                      move cursor down",
        "LEFT, CTRL-B                      move cursor left",
        "RIGHT, CTRL-F                     move cursor right",
        "CTRL-A                            move cursor top",
        "CTRL-E                            move cursor bottom",
        "PAGEUP, CTRL-U, Meta-v            move cursor up",
        "PAGEDOWN, CTRL-D, CTRL-V          move cursor down",
        "BACKSPACE, CTRL-H                 move to parent direcotry",
        "\\                                 move to root directory",
        "~                                 move to home directory" ,
        ".                                 toggle visible dot file" ,
        "CTRL + I (tab)                    change 2 directory mode or cursor move other directory",
        "ENTER                             run cursor file(insert directory)",
        "CTRL_C                            quit the Minnu's Filer2",
        "q                                 change 1 directory mode or quit the Minnu's Filer2",
        "Q                                 quit the Minnu's Filer2",
        "CTRL+L                            redraw the screen",
        "SPACE                             mark file under cursor" ,
        "HOME                              mark all files without directory",
        "END                               mark all files",
        "*                                 mark menu" ,
        "+                                 mask menu" ,
        "c,C                               copy mark file",
        "m,M                               move mark file",
        "d                                 move mark file to $HOME/mtrashbox",
        "D                                 delete mark file",
        "e                                 edit file(run $EDITOR)",
        "E                                 edit file(run $EDITOR)2",
        "l                                 make symbolic link",
        "L                                 make symbolic link2",
        "v                                 view file(run $PAGER)",
        "r,R                               rename",
        "a                                 open attribute menu",
        "n                                 make new file",
        "N                                 make new file menu",
        "k                                 make new direcotry",
        "p                                 compression",
        "P                                 compression2",
        "u                                 unpack",
        "U                                 unpack2",
        "b                                 backup",
        "i                                 info",
        "g                                 mgrep",
        "G                                 grep menu",
        "S                                 sed s///g",
        "K                                 mmake",
        "f,/                               incremental search",
        "F                                 super incremental search",
        "Meta + f, $ f                     find",
        "s                                 open sort menu",
        "V                                 open view menu",
        "o,O                               copy direcotry path",
        "w                                 exchange two directories",
        "j                                 change dircetory with menu",
        "J                                 jump menu",
        "#                                 sudo menu",
        "$                                 extra menu",
        "h                                 switch command line mode",
        "H                                 shell menu",
        "x                                 excute",
        ":                                 run shell($SHELL)",
        "[                                 mark range begin",
        "]                                 mark range end",
        "!                                 run file manager",
        "Meta+x                            switch ruby command line mode",
        "z                                 next command will be runned with xterminal",
        "Z                                 toggle xterminal mode",
        "CTRL + T                          new tab",
        "CTRL + W                          remove current tab",
        "Meta+0-9                          change current tab",
        "Meta + Left                       move to previous directory",
        "1-9                               forground job"
    };

    for(int i=gScrollTop; i<gScrollTop+maxy; i++) {
        if(i < kMaxMessage) {
            mmvprintw(i-gScrollTop, 0, buf[i]);
        }   
    }

    mmove(maxy-1, maxx-2);
}

void help_input(int meta, int key)
{
    const int maxy = mgetmaxy();

    // 'q' CTRL-C CTRL-G Escape
    if(key == 'q' || key == 3 || key == 7||key == 27) { 
        gViewHelp = false;
    }
    // space f CTRL-D PAGE DOWN
    else if(key == ' '|| key == 'f' || key == 4||key == KEY_NPAGE) {
        if(kMaxMessage >= maxy) {
            gScrollTop += 10;
            if(gScrollTop+maxy > kMaxMessage) {
                gScrollTop -= gScrollTop+maxy-kMaxMessage;
            }
        }
    }
    // b CTRL-U PAGE UP
    else if(key == 'b' || key ==21 || key == KEY_PPAGE) {
        gScrollTop -= 10;

        if(gScrollTop < 0) {
            gScrollTop = 0;
        }
    }
    // CTRL-N DOWN CTRL-M CTRL-J
    else if(key == 14 || key == 10 || key == 13 || key == KEY_DOWN) {
        if(kMaxMessage >= maxy) {
            gScrollTop ++;
            if(gScrollTop+maxy > kMaxMessage) {
                gScrollTop -= gScrollTop+maxy-kMaxMessage;
            }
        }
    }
    else if(key == 16 || key == KEY_UP) {    /// CTRL-P UP
        gScrollTop--;

        if(gScrollTop < 0) {
            gScrollTop = 0;
        }
    }
}
