/*
 * C[`
 */

#include "common.h"

extern "C"
{
#include <sys/types.h>
#include <sys/socket.h>
#include <sys/un.h>
#include <sys/ioctl.h>
#include <sys/types.h>
#include <sys/wait.h>
#include <signal.h>
#include <termios.h>
#include <stdarg.h>
#include <time.h>
#include <ctype.h>
#include <locale.h>
#include <sys/types.h>
#include <pwd.h>
#include <dirent.h>
#include <stdlib.h>

#ifdef __CYGWIN__
#include <ncurses/term.h>
#include <sys/time.h>
#else
#include <term.h>
#endif

}

#if defined(MYCYGWINCOMPILE)
char gProgramHome[PATH_MAX];
#endif

char gHomeDir[PATH_MAX];
char gTempDir[PATH_MAX];

///////////////////////////////////////////////////////////////////////////////
// Ŏgϐ
///////////////////////////////////////////////////////////////////////////////
const int kKeyMetaFirst = 128;      // MetaL[R[h̍ŏ
const int kKeyEsc = 27;             // EscL[R[h

static char gHostName[256];         // zXg
static char gUserName[256];         // [U[

///////////////////////////////////////////////////////////////////////////////
// Oɂ炷ϐ
///////////////////////////////////////////////////////////////////////////////
cDirWnd* gLDir;                         // ̃fBNgIuWFNg
cDirWnd* gRDir;                         // ẼfBNgIuWFNg
bool gMainLoop = false;                 // C[v
hash_obj* gKeyCommand[2][KEY_MAX];      // L[ƃR}h̃}bv[0][L[R[h] metaȂ [1][L[R[h] meta
char gTrashBoxPath[PATH_MAX];           // ݔ̃fBNgpX

bool gExtensionICase = true;            // }[Nt@C̊gqʎső啶ʂ邩ǂ
bool gColor = false;                    // ʂ̕`ʂɃJ[gǂ
bool gIndividualCursor = true;          // Ẽt@CʂŃJ[\ʒuƗĂ邩ǂ
bool gCheckDeleteFile = true;           // t@CɊmF邩ǂ
bool gCheckCopyFile = false;            // t@CɊmF邩ǂ
bool gCheckExit = true;                 // t@CI鎞ɊmFғ
bool gGnuScreen = false;                // GNU screenŋNĂ邩ǂ
bool gAutoRehash = false;               // R}hCI[gnbV
bool gUnixDomainSocket = true;          // UnixDomainSocketgǂ
bool gRemainCursor = false;             // J[\ʒuۑ邩ǂ
bool gExecutiveFileBold = true;
bool gReadDirHistory = true;
enum eKanjiCode gKanjiCodeFileName = kUnknown;     // t@C̊R[h kUnknown̏ꍇ͎

bool gBoldExe = true;
bool gBoldDir = true;
int gColorMark = kCAYellow;
int gColorDir = kCACyan;
int gColorExe = kCARed;
int gColorLink = kCAMagenta;

char* gVersion = "4.0.9b";
 
void (*gViewSystem)() = NULL;      // o^`ʊ֐
void (*gView)() = NULL;  // [U[po^`ʊ֐

bool gChangeTerminalTitle = false;

static void initialize_global_vars(char* init_path)
{
    char* home = getenv("HOME");
    if(home == NULL) {
        fprintf(stderr, "$HOME is NULL\n");
        exit(1);
    }

    strcpy(gTrashBoxPath, home);
    strcat(gTrashBoxPath, "/mtrashbox");
    
    for(int i=0; i<2; i++) {
        for(int j=0; j<KEY_MAX; j++) {
            gKeyCommand[i][j] = hash_new(10);
         }
    }

    gethostname(gHostName, 256);
    struct passwd* user = getpwuid(getuid());
    strcpy(gUserName, user->pw_name);

    if(strcmp(init_path, "") == 0) {  
        gLDir = new cDirWnd("", false);
        gRDir = new cDirWnd("", true);
    }
    else {
        struct stat _stat;
        if(stat(init_path, &_stat) < 0) {
            fprintf(stderr, "%s don't exist\n", init_path);
            exit(1);
        }
        if(!S_ISDIR(_stat.st_mode)) {
            fprintf(stderr, "%s is not directory\n", init_path);
            exit(1);
        }
    
        gLDir = new cDirWnd(init_path, false);
        gRDir = new cDirWnd(init_path, true);
    }
}

static void finalize_global_vars()
{
    delete gLDir;
    delete gRDir;

    for(int i=0; i<2; i++) {
        for(int j=0; j<KEY_MAX; j++) {
            for(hash_it* it = gKeyCommand[i][j]->mEntryIt;
                it;
                it = it->mNextIt)
            {
                FREE(it->mItem);
            }
            hash_delete(gKeyCommand[i][j]);
         }
    }
}

////////////////////////////////////////////////////////////////////////////////
// Ruby EI
////////////////////////////////////////////////////////////////////////////////
static void myruby_init()
{
    ruby_init();
    ruby_script("embedded");
    ruby_init_loadpath();
#if defined(MYCYGWINCOMPILE)
    char tmp[PATH_MAX];
    
    sprintf(tmp, "$:.clear(); $:.push('%s/lib_ruby'); $:.push('%s/lib_ruby/i386-cygwin'); $:.push('%s/etc')", gProgramHome, gProgramHome, gProgramHome);
    rb_eval_string(tmp);
    
    sprintf(tmp, "ENV['PATH']=\"%s/bin:#{ENV['PATH']}\"", gProgramHome);
    rb_eval_string(tmp);
    
    sprintf(tmp, "ENV['TERMINFO']='%s/terminfo'", gProgramHome);
    rb_eval_string(tmp);
    
    rb_eval_string("MYCYGWINCOMPILE=1");
    
    sprintf(tmp, "PROGRAM_HOME='%s'", gProgramHome);
    rb_eval_string(tmp);

    setenv("HOME", gProgramHome, 1);
#else
    char tmp[256];
    sprintf(tmp, "$:.push(\"%s\")", SYSCONFDIR);
    rb_eval_string(tmp);
#endif
    
    rb_eval_string("require 'nkf'; def kanji_convert_nkf(input, code); if code == \"eucjp\" then return NKF.nkf('-e', input); elsif code == \"sjis\" then return NKF.nkf('-s', input); elsif code == \"utf8\" then return NKF.nkf('-w', input); elsif code == \"utf8-mac\" then return input; elsif code == \"ascii\" then return input; else return input; end end");
    rb_eval_string("require 'kconv'; def kanji_guess_kconv(input); ret = Kconv.guess(input); if ret == Kconv::EUC then return 0; elsif ret == Kconv::SJIS then return 1; elsif ret == Kconv::UTF8 then return 2; else return -1; end end");
    rb_eval_string("def mfiler2_extend_glob(path, wc); cwd = Dir.pwd(); Dir.chdir(path); result = Dir::glob(wc); Dir.chdir(cwd); return result; end");

    rb_define_global_const("KEY_UP", INT2NUM(KEY_UP));
    rb_define_global_const("KEY_RIGHT", INT2NUM(KEY_RIGHT));
    rb_define_global_const("KEY_DOWN", INT2NUM(KEY_DOWN));
    rb_define_global_const("KEY_LEFT", INT2NUM(KEY_LEFT));
    rb_define_global_const("KEY_INSERT", INT2NUM(KEY_IC));
    rb_define_global_const("KEY_DELETE", INT2NUM(KEY_DC));
    rb_define_global_const("KEY_HOME", INT2NUM(KEY_HOME));
    rb_define_global_const("KEY_END", INT2NUM(KEY_END));
    rb_define_global_const("KEY_PAGEUP", INT2NUM(KEY_PPAGE));
    rb_define_global_const("KEY_PAGEDOWN", INT2NUM(KEY_NPAGE));
    rb_define_global_const("KEY_META_LEFT", INT2NUM(KEY_F(13)));
    rb_define_global_const("KEY_META_RIGHT", INT2NUM(KEY_F(14)));
    rb_define_global_const("KEY_META_UP", INT2NUM(KEY_F(15)));
    rb_define_global_const("KEY_META_DOWN", INT2NUM(KEY_F(16)));
    
    rb_define_global_const("KEY_ENTER", INT2NUM(10));
    rb_define_global_const("KEY_BACKSPACE", INT2NUM(KEY_BACKSPACE));
    rb_define_global_const("KEY_SPACE", INT2NUM(32));
    
    rb_define_global_const("KEY_F1", INT2NUM(KEY_F(1)));
    rb_define_global_const("KEY_F2", INT2NUM(KEY_F(2)));
    rb_define_global_const("KEY_F3", INT2NUM(KEY_F(3)));
    rb_define_global_const("KEY_F4", INT2NUM(KEY_F(4)));
    rb_define_global_const("KEY_F5", INT2NUM(KEY_F(5)));
    rb_define_global_const("KEY_F6", INT2NUM(KEY_F(6)));
    rb_define_global_const("KEY_F7", INT2NUM(KEY_F(7)));
    rb_define_global_const("KEY_F8", INT2NUM(KEY_F(8)));
    rb_define_global_const("KEY_F9", INT2NUM(KEY_F(9)));
    rb_define_global_const("KEY_F10", INT2NUM(KEY_F(10)));
    rb_define_global_const("KEY_F11", INT2NUM(KEY_F(11)));
    rb_define_global_const("KEY_F12", INT2NUM(KEY_F(12)));
    
    rb_define_global_const("KEY_a", INT2NUM('a'));
    rb_define_global_const("KEY_b", INT2NUM('b'));
    rb_define_global_const("KEY_c", INT2NUM('c'));
    rb_define_global_const("KEY_d", INT2NUM('d'));
    rb_define_global_const("KEY_e", INT2NUM('e'));
    rb_define_global_const("KEY_f", INT2NUM('f'));
    rb_define_global_const("KEY_g", INT2NUM('g'));
    rb_define_global_const("KEY_h", INT2NUM('h'));
    rb_define_global_const("KEY_i", INT2NUM('i'));
    rb_define_global_const("KEY_j", INT2NUM('j'));
    rb_define_global_const("KEY_k", INT2NUM('k'));
    rb_define_global_const("KEY_l", INT2NUM('l'));
    rb_define_global_const("KEY_m", INT2NUM('m'));
    rb_define_global_const("KEY_n", INT2NUM('n'));
    rb_define_global_const("KEY_o", INT2NUM('o'));
    rb_define_global_const("KEY_p", INT2NUM('p'));
    rb_define_global_const("KEY_q", INT2NUM('q'));
    rb_define_global_const("KEY_r", INT2NUM('r'));
    rb_define_global_const("KEY_s", INT2NUM('s'));
    rb_define_global_const("KEY_t", INT2NUM('t'));
    rb_define_global_const("KEY_u", INT2NUM('u'));
    rb_define_global_const("KEY_v", INT2NUM('v'));
    rb_define_global_const("KEY_w", INT2NUM('w'));
    rb_define_global_const("KEY_x", INT2NUM('x'));
    rb_define_global_const("KEY_y", INT2NUM('y'));
    rb_define_global_const("KEY_z", INT2NUM('z'));
    
    rb_define_global_const("KEY_CTRL_SPACE", INT2NUM(0));
    rb_define_global_const("KEY_CTRL_A", INT2NUM(1));
    rb_define_global_const("KEY_CTRL_B", INT2NUM(2));
    rb_define_global_const("KEY_CTRL_C", INT2NUM(3));
    rb_define_global_const("KEY_CTRL_D", INT2NUM(4));
    rb_define_global_const("KEY_CTRL_E", INT2NUM(5));
    rb_define_global_const("KEY_CTRL_F", INT2NUM(6));
    rb_define_global_const("KEY_CTRL_G", INT2NUM(7));
    rb_define_global_const("KEY_CTRL_H", INT2NUM(8));
    rb_define_global_const("KEY_CTRL_I", INT2NUM(9));
    rb_define_global_const("KEY_CTRL_J", INT2NUM(10));
    rb_define_global_const("KEY_CTRL_K", INT2NUM(11));
    rb_define_global_const("KEY_CTRL_L", INT2NUM(12));
    rb_define_global_const("KEY_CTRL_M", INT2NUM(13));
    rb_define_global_const("KEY_CTRL_N", INT2NUM(14));
    rb_define_global_const("KEY_CTRL_O", INT2NUM(15));
    rb_define_global_const("KEY_CTRL_P", INT2NUM(16));
    rb_define_global_const("KEY_CTRL_Q", INT2NUM(17));
    rb_define_global_const("KEY_CTRL_R", INT2NUM(18));
    rb_define_global_const("KEY_CTRL_S", INT2NUM(19));
    rb_define_global_const("KEY_CTRL_T", INT2NUM(20));
    rb_define_global_const("KEY_CTRL_U", INT2NUM(21));
    rb_define_global_const("KEY_CTRL_V", INT2NUM(22));
    rb_define_global_const("KEY_CTRL_W", INT2NUM(23));
    rb_define_global_const("KEY_CTRL_X", INT2NUM(24));
    rb_define_global_const("KEY_CTRL_Y", INT2NUM(25));
    rb_define_global_const("KEY_CTRL_Z", INT2NUM(26));
    rb_define_global_const("KEY_ESCAPE", INT2NUM(27));
    
    rb_define_global_const("KEY_A", INT2NUM('A'));
    rb_define_global_const("KEY_B", INT2NUM('B'));
    rb_define_global_const("KEY_C", INT2NUM('C'));
    rb_define_global_const("KEY_D", INT2NUM('D'));
    rb_define_global_const("KEY_E", INT2NUM('E'));
    rb_define_global_const("KEY_F", INT2NUM('F'));
    rb_define_global_const("KEY_G", INT2NUM('G'));
    rb_define_global_const("KEY_H", INT2NUM('H'));
    rb_define_global_const("KEY_I", INT2NUM('I'));
    rb_define_global_const("KEY_J", INT2NUM('J'));
    rb_define_global_const("KEY_K", INT2NUM('K'));
    rb_define_global_const("KEY_L", INT2NUM('L'));
    rb_define_global_const("KEY_M", INT2NUM('M'));
    rb_define_global_const("KEY_N", INT2NUM('N'));
    rb_define_global_const("KEY_O", INT2NUM('O'));
    rb_define_global_const("KEY_P", INT2NUM('P'));
    rb_define_global_const("KEY_Q", INT2NUM('Q'));
    rb_define_global_const("KEY_R", INT2NUM('R'));
    rb_define_global_const("KEY_S", INT2NUM('S'));
    rb_define_global_const("KEY_T", INT2NUM('T'));
    rb_define_global_const("KEY_U", INT2NUM('U'));
    rb_define_global_const("KEY_V", INT2NUM('V'));
    rb_define_global_const("KEY_W", INT2NUM('W'));
    rb_define_global_const("KEY_X", INT2NUM('X'));
    rb_define_global_const("KEY_Y", INT2NUM('Y'));
    rb_define_global_const("KEY_Z", INT2NUM('Z'));

    rb_define_global_const("KEY_0", INT2NUM('0'));
    rb_define_global_const("KEY_1", INT2NUM('1'));
    rb_define_global_const("KEY_2", INT2NUM('2'));
    rb_define_global_const("KEY_3", INT2NUM('3'));
    rb_define_global_const("KEY_4", INT2NUM('4'));
    rb_define_global_const("KEY_5", INT2NUM('5'));
    rb_define_global_const("KEY_6", INT2NUM('6'));
    rb_define_global_const("KEY_7", INT2NUM('7'));
    rb_define_global_const("KEY_8", INT2NUM('8'));
    rb_define_global_const("KEY_9", INT2NUM('9'));
        
    rb_define_global_const("KEY_EXCLAM", INT2NUM('!'));
    rb_define_global_const("KEY_DQUOTE", INT2NUM('"'));
    rb_define_global_const("KEY_SHARP", INT2NUM('#'));
    rb_define_global_const("KEY_DOLLAR", INT2NUM('$'));
    rb_define_global_const("KEY_PERCENT", INT2NUM('%'));
    rb_define_global_const("KEY_AND", INT2NUM('&'));
    rb_define_global_const("KEY_SQUOTE", INT2NUM('\''));
    rb_define_global_const("KEY_LPAREN", INT2NUM('('));
    rb_define_global_const("KEY_RPAREN", INT2NUM(')'));
    rb_define_global_const("KEY_TILDA", INT2NUM('~'));
    rb_define_global_const("KEY_EQUAL", INT2NUM('='));
    rb_define_global_const("KEY_MINUS", INT2NUM('-'));
    rb_define_global_const("KEY_CUP", INT2NUM('^'));
    rb_define_global_const("KEY_VBAR", INT2NUM('|'));
    rb_define_global_const("KEY_BACKSLASH", INT2NUM('\\'));
    rb_define_global_const("KEY_ATMARK", INT2NUM('@'));
    rb_define_global_const("KEY_BAPOSTROPHE", INT2NUM('`'));
    rb_define_global_const("KEY_LCURLY", INT2NUM('{'));
    rb_define_global_const("KEY_LBRACK", INT2NUM('['));
    rb_define_global_const("KEY_PLUS", INT2NUM('+'));
    rb_define_global_const("KEY_SEMICOLON", INT2NUM(';'));
    rb_define_global_const("KEY_STAR", INT2NUM('*'));
    rb_define_global_const("KEY_COLON", INT2NUM(':'));
    rb_define_global_const("KEY_RCURLY", INT2NUM('}'));
    rb_define_global_const("KEY_RBRACK", INT2NUM(']'));
    rb_define_global_const("KEY_LSS", INT2NUM('<'));
    rb_define_global_const("KEY_COMMA", INT2NUM(','));
    rb_define_global_const("KEY_GTR", INT2NUM('>'));
    rb_define_global_const("KEY_DOT", INT2NUM('.'));
    rb_define_global_const("KEY_SLASH", INT2NUM('/'));
    rb_define_global_const("KEY_QMARK", INT2NUM('?'));
    rb_define_global_const("KEY_UNDERBAR", INT2NUM('_'));
    
    rb_define_global_const("NOMETA", INT2NUM(0));
    rb_define_global_const("META", INT2NUM(1));

    rb_define_global_const("MA_REVERSE", INT2NUM(kCAReverse));
    rb_define_global_const("MA_BOLD", INT2NUM(kCABold));
    rb_define_global_const("MA_UNDERLINE", INT2NUM(kCAUnderline));
    
    rb_define_global_const("MA_WHITE", INT2NUM(kCAWhite));
    rb_define_global_const("MA_BLUE", INT2NUM(kCABlue));
    rb_define_global_const("MA_CYAN", INT2NUM(kCACyan));
    rb_define_global_const("MA_GREEN", INT2NUM(kCAGreen));
    rb_define_global_const("MA_YELLOW", INT2NUM(kCAYellow));
    rb_define_global_const("MA_MAGENTA", INT2NUM(kCAMagenta));
    rb_define_global_const("MA_RED", INT2NUM(kCARed));

    rb_eval_string("def cursor_move_hook(i) 0; end");
    rb_eval_string("def completion_hook(editing, editing_dir, editing_file, editing_before, earray, cmd, editing_position, squote, dquote, last_squote, last_dquote) return 0; end");
    rb_eval_string("def atexit_hook() 0; end");
    rb_eval_string("def mloop_hook() 0; end");
    rb_eval_string("def mask_hook_ldir(fname, kind, uid, gid, permission) nil; end");
    rb_eval_string("def mask_hook_rdir(fname, kind, uid, gid, permission) nil; end");
    rb_eval_string("def disk_read_hook_ldir() nil; end");
    rb_eval_string("def disk_read_hook_rdir() nil; end");
    rb_eval_string("def path_change_hook(is_ldir) nil; end");
    rb_eval_string("def view_hook() end");
    rb_eval_string("def view_hook_filer() 0 end");
/*
    char tmp[256];
    sprintf(tmp, "$:.push(\"%s\")", SYSCONFDIR);
    rb_eval_string(tmp);
*/
}

////////////////////////////////////////////////////////////////////////////////
// Ruby nkfɂ銿ϊ
////////////////////////////////////////////////////////////////////////////////
void ruby_nkf(char* input, char* output, enum eKanjiCode code)
{
    VALUE v = rb_funcall(rb_cObject, rb_intern("kanji_convert_nkf"), 2, rb_str_new2(input), rb_str_new2(gKanjiCodeString[gKanjiCode]));
    strcpy(output, RSTRING(v)->ptr);
}

////////////////////////////////////////////////////////////////////////////////
// Ruby nkfɂ銿
////////////////////////////////////////////////////////////////////////////////
enum eKanjiCode ruby_kconv_guess(char* input)
{
    int v = NUM2INT(rb_funcall(rb_cObject, rb_intern("kanji_guess_kconv"), 1, rb_str_new2(input)));
    if(v == 0)
        return kEucjp;
    else if(v == 1)
        return kSjis;
    else if(v == 2)
        return kUtf8;
    else
        return kUnknown;
}

///////////////////////////////////////////////////////////////////////////////
// ^CXNvgt@Cǂݍ
///////////////////////////////////////////////////////////////////////////////
static void read_rc_file()
{
#if defined(MYCYGWINCOMPILE)
    /// main.rbǂݍ ///
    char ms_fname[256];
    sprintf(ms_fname, "%s/etc/main.rb", gProgramHome);

    if(access(ms_fname, R_OK) == 0) {
        rb_load(rb_str_new2(ms_fname), 0);
    }
    else {
        fprintf(stderr, "can't find %s/etc/main.rb", gProgramHome);
        exit(1);
    }

    /* etc/.mfilerǂݍ */
    char rc_fname[PATH_MAX];
    sprintf(rc_fname,"%s/etc/.mfiler", gProgramHome);
    if(access(rc_fname, R_OK) == 0) {
        rb_load(rb_str_new2(rc_fname), 0);
    }
    else {
        fprintf(stderr, "can't find %s/etc/.mfiler file\n", gProgramHome);
        exit(1);
    }
#else
    char ms_fname[256];
    sprintf(ms_fname, "%s/main.rb", SYSCONFDIR);

    if(access(ms_fname, R_OK) == 0) {
        rb_load(rb_str_new2(ms_fname), 0);
    }
    else {
        fprintf(stderr, "can't find %s/main.rb", SYSCONFDIR);
        exit(1);
    }

    /* ~/.mfilerǂݍށB ~/.mfiler ȂȂ$PREFIX/etc/.mfilerǂݍ */
    char* home = getenv("HOME");
    if(home == NULL) {
        fprintf(stderr, "$HOME is NULL");
        exit(1);
    }

    char rc_fname[256];
    sprintf(rc_fname, "%s/.mfiler", home);
    
    if(access(rc_fname, R_OK) == 0) {
        rb_load(rb_str_new2(rc_fname), 0);
    }
    else {
        sprintf(rc_fname,"%s/.mfiler", SYSCONFDIR);
        if(access(rc_fname, R_OK) == 0) {
            rb_load(rb_str_new2(rc_fname), 0);
        }
        else {
            fprintf(stderr, "can't find $HOME/.mfiler or %s/.mfiler file\n", SYSCONFDIR);
            exit(1);
        }
    }
#endif
}

///////////////////////////////////////////////////////////////////////////////
// L[{[h͏
///////////////////////////////////////////////////////////////////////////////
static void input(int meta, int key)
{
    /// wv ///
    if(gViewHelp) {
        help_input(meta, key);
    }
    /// fBNgI ///
    else if(gSelectDir) {
        ActiveDir()->SelectDirInput(meta, key);
    }
    /// R}hC ///
    else if(gCmdLineActive) {
        /// qXg[I ///
        if(vector_size(gHCandidate) > 0)
            cmdline_history_input(meta, key);
        /// ⊮I ///
        else if(gCompletionMenu)
            cmdline_completion_menu_input(meta, key);
        /// ʂ̃R}hC ///
        else
            cmdline_input(meta, key);
    }
    /// j[I ///
    else if(gActiveMenu) {
        gActiveMenu->Input(meta, key);
    }
    /// CN^T[` ///
    else if(gISearch) {
        isearch_input(meta, key);
    }
    /// GLXv[[CN^T[` ///
    else if(gISearchExplore && IsISearchExploreChar(meta, key)) {
        isearch_explore_input(meta, key);
    }
    /// GLXv[[CN^T[` ㉺L[ƃXy[XL[ ///
    else if(gISearchExplore && !IsISearchNULL() 
        && (meta == 0 && key == ' '
            || meta == 1 && (key == 14 || key == 16)
            || meta == 1 && (key == KEY_UP || key == KEY_DOWN)
            || meta == 0 && (key == KEY_F(15) || key == KEY_F(16))
            ))
    {
        isearch_explore_input(meta, key);
    }
    /// X[p[CN^T[` ///
    else if(gSISearch) {
        sisearch_input(meta, key);
    }
    /// t@C ///
    else {
        sFile* cursor = ActiveDir()->CursorFile();

        /// t@C𓾂 ///
        const char* name = cursor->mName;
        char fname[1024];
        
        strcpy(fname, name);
        if(gExtensionICase && is_all_ascii((char*)name)) {
            strtolower(fname);
        }

        /// gq𓾂 ///
        char extension[256];

        char* tmp = extname(cursor->mName);
        if(gExtensionICase) {
            strtolower(tmp);
        }
        sprintf(extension, ".%s", tmp);
        free(tmp);
    
        /// }[NȂ炻̏Ԃ𒲂ׂ ///
        bool is_extension_marked = false;           // gq̃t@C}[N
        char marked_extension[1024];                // }[N̊gq
        bool is_directory_marked = false;           // fBNg}[N
        bool is_executive_file_marked = false;      // st@C}[N
        bool is_link_marked = false;                // N}[N

        if(ActiveDir()->Marking()) {
            char tmp[1024];
            is_extension_marked = ActiveDir()->IsSameExtensionMarked(tmp);
            if(is_extension_marked) {
                if(gExtensionICase) {   // 啶ʂȂꍇ
                    strtolower(tmp);
                }
                sprintf(marked_extension, ".mark-%s", tmp);
            }
            
            is_directory_marked = ActiveDir()->IsDirectoryMarked();
            is_executive_file_marked = ActiveDir()->IsExecutiveFileMarked();
            is_link_marked = ActiveDir()->IsLinkMarked();
        }

        /// gq̃t@C}[N ///
        if(is_extension_marked
                && key >= 0 && key < KEY_MAX
                && hash_item(gKeyCommand[meta][key], marked_extension))
        {
            int error;
            rb_eval_string_protect((char*)hash_item(gKeyCommand[meta][key],  marked_extension), &error);
            
            output_eval_error(error);

            ISearchClear();
        }

        /// N}[N ///
        else if(is_link_marked
                && key >= 0 && key < KEY_MAX
                && hash_item(gKeyCommand[meta][key], ".mark-link"))
        {
            int error;
            rb_eval_string_protect((char*)hash_item(gKeyCommand[meta][key],  ".mark-link"), &error);
            
            output_eval_error(error);

            ISearchClear();
        }

        /// fBNg}[N ///
        else if(is_directory_marked
                && key >= 0 && key < KEY_MAX
                && hash_item(gKeyCommand[meta][key], ".mark-dir"))
        {
            int error;
            rb_eval_string_protect((char*)hash_item(gKeyCommand[meta][key],  ".mark-dir"), &error);
            
            output_eval_error(error);

            ISearchClear();
        }

        /// st@C}[N ///
        else if(is_executive_file_marked
                && key >= 0 && key < KEY_MAX
                && hash_item(gKeyCommand[meta][key], ".mark-execute"))
        {
            int error;
            rb_eval_string_protect((char*)hash_item(gKeyCommand[meta][key],  ".mark-execute"), &error);
            
            output_eval_error(error);

            ISearchClear();
        }

        /// }[N ///
        else if(ActiveDir()->Marking()
            && key >= 0 && key < KEY_MAX 
            && hash_item(gKeyCommand[meta][key], ".mark"))
        {
            int error;
            rb_eval_string_protect((char*)hash_item(gKeyCommand[meta][key],".mark"), &error);
            
            output_eval_error(error);

            ISearchClear();
        }

        /// NI ///
        else if(S_ISLNK(cursor->mLStat.st_mode)
            && key >= 0 && key < KEY_MAX 
            && hash_item(gKeyCommand[meta][key], ".link"))
        {
            int error;
            rb_eval_string_protect((char*)hash_item(gKeyCommand[meta][key], ".link"), &error);
            
            output_eval_error(error);

            ISearchClear();
        }

        /// t@CŎw肳Ăꍇ ///
        else if(key >= 0 && key < KEY_MAX  
              && hash_item(gKeyCommand[meta][key], fname))
        {
            int error;
           rb_eval_string_protect(
               (char*)hash_item(gKeyCommand[meta][key], fname), &error);
            
            output_eval_error(error);

            ISearchClear();
        }

        /// gqŎw肳Ăꍇ ///
        else if(key >= 0 && key < KEY_MAX 
               && hash_item(gKeyCommand[meta][key], extension))
        {
            int error;
            rb_eval_string_protect(
                (char*)hash_item(gKeyCommand[meta][key], extension), &error);
            
            output_eval_error(error);

            ISearchClear();
        }

        /// fBNgI ///
        else if(S_ISDIR(cursor->mLStat.st_mode)
            && key >= 0 && key < KEY_MAX 
            && hash_item(gKeyCommand[meta][key], ".dir"))
        {
            int error;
            rb_eval_string_protect((char*)hash_item(gKeyCommand[meta][key], ".dir"), &error);
            
            output_eval_error(error);

            ISearchClear();
        }

        /// st@CI ///
        else if((cursor->mStat.st_mode&S_IXUSR
             || cursor->mStat.st_mode&S_IXGRP || cursor->mStat.st_mode&S_IXOTH)
            && key >= 0 && key < KEY_MAX 
            && hash_item(gKeyCommand[meta][key], ".execute"))
        {
            int error;
            rb_eval_string_protect((char*)hash_item(gKeyCommand[meta][key],".execute"), &error);
            
            output_eval_error(error);

            ISearchClear();
        }

        /// ̑̃t@C ///
        else if(key >= 0 && key < KEY_MAX 
            && hash_item(gKeyCommand[meta][key], "*")) 
        {
            int error;
            rb_eval_string_protect((char*)hash_item(gKeyCommand[meta][key], "*"), &error);
            
            output_eval_error(error);

            ISearchClear();
        }
        else {
            ISearchClear();
        }
    }

    
}

///////////////////////////////////////////////////////////////////////////////
// `
///////////////////////////////////////////////////////////////////////////////

/// t@Cʓ͎̃R}hC̕` ///
static void view_cmdline_filer()
{
    const int maxx = mgetmaxx();        // ʃTCY
    const int maxy = mgetmaxy();
    
    /// CN^T[`` ///
    if(gISearch) {
        isearch_view();
    }
    /// Ԃ` ///
    else {
        int error;
        VALUE cmdline_prompt = rb_eval_string_protect("cmdline_prompt()", &error);
        output_eval_error(error);

        if(TYPE(cmdline_prompt) == T_STRING)
            mmvprintw(maxy -2, 0, RSTRING(cmdline_prompt)->ptr);
        else 
            mmvprintw(maxy -2, 0, "the Minnu's Filer2 %s %s %s %s@%s ", gVersion, cDirWnd::kSortName[ActiveDir()->mSortKind], gKanjiCodeString[gKanjiCodeFileName], gUserName, gHostName);

        /// [s@\gĂꍇx` ///            
        if((gXterm && !(gXtermNext||gXterm2)) || (!gXterm && (gXtermNext||gXterm2))) mprintw("x ");

        if(gISearchExplore) isearch_explore_view();
    }


    /// J[\̃t@C̏` ///          
    char buf[1024];
    sFile* file = ActiveDir()->CursorFile();

    char permission[12];
    strcpy(permission, "----------");

    if(S_ISDIR(file->mLStat.st_mode)) permission[0] = 'd';  // t@C̎
    if(S_ISCHR(file->mLStat.st_mode)) permission[0] = 'c';
    if(S_ISBLK(file->mLStat.st_mode)) permission[0] = 'b';
    if(S_ISFIFO(file->mLStat.st_mode)) permission[0] = 'p';
    if(S_ISLNK(file->mLStat.st_mode)) permission[0] = 'l';
    if(S_ISSOCK(file->mLStat.st_mode)) permission[0] = 's';

    mode_t smode = file->mLStat.st_mode;        // p[~bV
    if(smode & S_IRUSR) permission[1] = 'r';
    if(smode & S_IWUSR) permission[2] = 'w';
    if(smode & S_IXUSR) permission[3] = 'x';
    if(smode & S_IRGRP) permission[4] = 'r';
    if(smode & S_IWGRP) permission[5] = 'w';
    if(smode & S_IXGRP) permission[6] = 'x';
    if(smode & S_IROTH) permission[7] = 'r';
    if(smode & S_IWOTH) permission[8] = 'w';
    if(smode & S_IXOTH) permission[9] = 'x';
    if(smode & S_ISUID) permission[3] = 's';
    if(smode & S_ISGID) permission[6] = 's';
#if defined(S_ISTXT)
    if(smode & S_ISTXT) permission[9] = 't';
#endif
#if defined(S_ISVTX)
    if(smode & S_ISVTX) permission[9] = 't';
#endif
    
    permission[10] = 0;

    time_t t = file->mLStat.st_mtime;                   // 
    struct tm* tm_ = (struct tm*)localtime(&t);
    
    char buf2[1024];

    char owner[256];
    char* tmp = file->mUser;
    if(tmp) {
        if(gKanjiCode == kUtf8)
            str_cut2(tmp, 8, owner, 256);
        else 
            cut(tmp, owner, 8);
    }
    else {
        sprintf(owner, "%d", file->mLStat.st_uid);
    }

    char group[256];
    tmp = file->mGroup;
    if(tmp) {
        if(gKanjiCode == kUtf8)
            str_cut2(tmp, 7, group, 256);
        else
            cut(tmp, group, 7);
    }
    else {
        sprintf(group, "%d", file->mLStat.st_gid);
    }

    if(!S_ISLNK(file->mLStat.st_mode)) {
        int year = tm_->tm_year-100;
        if(year < 0) year+=100;
        while(year > 100) year-=100;
        
        sprintf(buf2
            , "%s %3d %-8s %-7s%10lld %02d-%02d-%02d %02d:%02d %s"
            , permission, file->mLStat.st_nlink
            , owner, group
                                
            , file->mLStat.st_size
            
            , year, tm_->tm_mon+1, tm_->tm_mday
            , tm_->tm_hour, tm_->tm_min
            , file->mNameView);
            
        char buf3[1024];
        if(gKanjiCode == kUtf8) 
            str_cut2(buf2, maxx-1, buf3, 1024);
        else
            cut(buf2, buf3, maxx-1);
                            
        mmvprintw(maxy-1, 0, "%s", buf3);
    }
    else {
        sprintf(buf
           , "%s %3d %s%s%10lld %02d-%02d-%02d %02d:%02d %s -> %s"
           , permission, file->mLStat.st_nlink
           , owner, group
                                
           , file->mLStat.st_size

           , tm_->tm_year-100, tm_->tm_mon+1, tm_->tm_mday
           , tm_->tm_hour, tm_->tm_min
           , file->mNameView
           , file->mLinkTo);
           
        char buf2[1024];
        if(gKanjiCode == kUtf8)
            str_cut2(buf, maxx-1, buf2, 1024);
        else
            cut(buf, buf2, maxx-1);
                   
        mmvprintw(maxy-1, 0, "%s", buf2);
    }

    mmove(maxy-1, maxx-2);
}

void view(bool cmdline)
{
    /// wv ///
    if(gViewHelp) {
        help_view();
    }

    /// j[ ///
    else if(gActiveMenu) {
        /// t@C ///
        gLDir->View();
        gRDir->View();

        /// Wu` ///
        shell_view();

        /// R}hC` ///
        if(cmdline) {
            view_cmdline_filer();
        }

        /// j[` ///
        gActiveMenu->View();
    }

    /// fBNgI ///
    else if(gSelectDir) {
        ActiveDir()->SelectDirView();
    }

    /// X[p[CN^T[`` ///
    else if(gSISearch) {
        sisearch_view();
    }

    /// R}hC͎ ///
    else if(gCmdLineActive) {
        /// qXg[I ///
        if(vector_size(gHCandidate))
            cmdline_history_view();
        /// ⊮I ///
        else if(vector_size(gCCandidate))
            cmdline_completion_view();
        /// t@C ///
        else {
            gLDir->View();
            gRDir->View();

            /// Wu` ///
            shell_view();
        }

        /// R}hC̕` ///
        if(cmdline) {
            cmdline_view();
        }
    }

    /// t@C ///
    else {
        /// fBNg̕` ///
        gLDir->View();
        gRDir->View();

        /// Wu` ///
        shell_view();

        /// R}hC̕` ///
        if(cmdline) {
            view_cmdline_filer();
        }
    }

    /// o^`ʊ֐ ///
    if(gViewSystem) gViewSystem();
    if(gView) {
        gView();
    }
    else {
        rb_funcall(rb_cObject, rb_intern("view_hook"), 0);
    }
}

///////////////////////////////////////////////////////////////////////////////
// exitɎs֐
///////////////////////////////////////////////////////////////////////////////
void atexit_fun()
{
    if(mis_curses()) {
        mendwin();
    }
}

///////////////////////////////////////////////////////////////////////////////
// VOi
///////////////////////////////////////////////////////////////////////////////
static void sig_winch(int signal)
{
    if(gMainLoop) {
        mclear_immediately();       // ʂ̍ĕ`
        view(true);
        mrefresh();
    }
}

void set_signal_clear()
{
    signal(SIGABRT, SIG_DFL);
    signal(SIGALRM, SIG_DFL);
    signal(SIGBUS, SIG_DFL);
    signal(SIGCHLD, SIG_DFL);
    signal(SIGCONT, SIG_DFL);
    signal(SIGHUP, SIG_DFL);
    signal(SIGFPE, SIG_DFL);
    signal(SIGILL, SIG_DFL);
    signal(SIGINT, SIG_DFL);
    signal(SIGIO, SIG_DFL);
    signal(SIGKILL, SIG_DFL);
    signal(SIGQUIT, SIG_DFL);
    signal(SIGPIPE, SIG_DFL);
    signal(SIGPROF, SIG_DFL);
    signal(SIGSEGV, SIG_DFL);
    signal(SIGSTOP, SIG_DFL);
    signal(SIGTERM, SIG_DFL);
    signal(SIGTRAP, SIG_DFL);
    signal(SIGTSTP, SIG_DFL);
    signal(SIGTTIN, SIG_DFL);
    signal(SIGTTOU, SIG_DFL);
    signal(SIGWINCH, SIG_DFL);
    signal(SIGURG, SIG_DFL);
    signal(SIGUSR1, SIG_DFL);
    signal(SIGUSR2, SIG_DFL);
    signal(SIGXCPU, SIG_DFL);
    signal(SIGXFSZ, SIG_DFL);
    signal(SIGVTALRM, SIG_DFL);
}

void set_signal_mfiler2()
{
    signal(SIGWINCH, sig_winch);
    signal(SIGTTOU, SIG_IGN);
    signal(SIGTTIN, SIG_IGN);
    signal(SIGINT, SIG_IGN);
    signal(SIGQUIT, SIG_IGN);
    signal(SIGTSTP, SIG_IGN);
    signal(SIGCHLD, SIG_IGN);
}

///////////////////////////////////////////////////////////////////////////////
// C֐
///////////////////////////////////////////////////////////////////////////////
int main(int argc, char* argv[])
{
CHECKML_BEGIN();
LOG_BEGIN();

    char tmp_path[PATH_MAX];
    
#if defined(MYCYGWINCOMPILE)
    sprintf(tmp_path, "%s/tmp", gProgramHome);
#else
    sprintf(tmp_path, "/tmp");
#endif
    
    char* tmp_dir = getenv("TMP");
    if(tmp_dir == NULL) {
        strcpy(gTempDir, tmp_path);
        setenv("TMP", tmp_path, 0);
    }
    else {
        strcpy(gTempDir, tmp_dir);
    }

    char* temp_dir = getenv("TEMP");
    if(temp_dir == NULL) {
        strcpy(gTempDir, tmp_path);
        setenv("TEMP", tmp_path, 0);
    }
    else {
        strcpy(gTempDir, temp_dir);
    }
    
    char* home_dir = getenv("HOME");
    if(home_dir == NULL) {
        fprintf(stderr, "set $HOME");
        exit(1);
    }
    strcpy(gHomeDir, home_dir);
    
#if defined(MYCYGWINCOMPILE)
    char* cwd = mygetcwd();
    strcpy(gProgramHome, cwd);
    free(cwd);
#endif
    
    srandom(1000);

    signal(SIGWINCH, SIG_IGN);

    /// W͂Əo͂[ǂmF ///
    if(!isatty(0) || !isatty(1)) {
        fprintf(stderr, "standard input is not a tty\n");
        return 1;
    }

    /// IvV ///
    bool refresh = false;
    bool move_dir = false;
    char move_dir_path[PATH_MAX];
    
    char init_path[PATH_MAX];   // fBNg
    strcpy(init_path, "");

    bool script = false;
    char script_path[PATH_MAX];
    
    int opt;
    while((opt = getopt(argc, argv, "rvm:i:")) != -1) {
        switch(opt) {
        case 'r':
            refresh = true;
            break;

        case 'm':
            move_dir = true;
            sprintf(move_dir_path, "m%s", optarg);
            break;

        case 'i':
            strcpy(init_path, optarg);
            break;

        case 'v':
            printf("the Minnu's Filer2 version %s by Daisuke Minato@kyoto\n", gVersion);
            exit(0);
            break;

        case ':':
            printf("option needs a value\n");
            exit(1);
            break;

        case '?':
            printf("usage mfiler2 [-r | -m path | -i path]\n\n");
            printf("-r : send a command to running all mfiler2. The command is rereading disk and refreshing screen\n");
            printf("-m path : send a command to running all mfiler2. The command is moving to argument path\n");
            printf("-i path : set init path\n");
            exit(1);
            break;
        }
    }

#if defined(MYCYGWINCOMPILE)
    /// t@CЂƂȂAs ///
    if(argc == 2 && !refresh && !move_dir) {
        script = true;
        strcpy(script_path, argv[1]);
    }
#endif

    /// IvVŎw肳ĂȂ瓮Ămfiler2ɉʃtbṼbZ[W𑗂  ///
    if(refresh && gUnixDomainSocket) {
        DIR* dir = opendir(gTempDir);
        if(dir == NULL) {
            fprintf(stderr, "$TEMP directory doesn't exist");
            exit(1);
        }

        struct dirent* entry;
        while(entry = readdir(dir)) {
            if(strstr(entry->d_name, "mfiler")) {
                char soc_name[256];
                sprintf(soc_name, "%s/%s", gTempDir, entry->d_name);

                int soc = socket(AF_UNIX, SOCK_DGRAM, 0);
                if(soc < 0) {
                    perror("socket");
                    return 1;
                }

                struct sockaddr_un addr;
                addr.sun_family = AF_UNIX;
                strcpy(addr.sun_path, soc_name);
                if(connect(soc, (struct sockaddr *)&addr, sizeof(addr)) == 0) {
                    write(soc, "r", 2);
                }

                close(soc);
            }
        }
        
        return 0;
    }
    if(move_dir && gUnixDomainSocket) {
        DIR* dir = opendir(gTempDir);
        if(dir == NULL) {
            fprintf(stderr, "$TEMP directory doesn't exist");
            exit(1);
        }

        struct dirent* entry;
        while(entry = readdir(dir)) {
            if(strstr(entry->d_name, "mfiler")) {
                char soc_name[256];
                sprintf(soc_name, "%s/%s", gTempDir, entry->d_name);

                int soc = socket(AF_UNIX, SOCK_DGRAM, 0);
                if(soc < 0) {
                    perror("socket");
                    return 1;
                }

                struct sockaddr_un addr;
                addr.sun_family = AF_UNIX;
                strcpy(addr.sun_path, soc_name);
                if(connect(soc, (struct sockaddr *)&addr, sizeof(addr)) == 0) {
                    write(soc, move_dir_path, strlen(move_dir_path)+1);
                }

                close(soc);
            }
        }
        
        return 0;
    }

    /// tHOhWuɂȂ܂Ń[v ///
    int status;
    pid_t pgrp;
    while((status = tcgetpgrp(0)) >= 0) {
        if(status == (pgrp = getpgrp())) {
            break;
        }
        kill(- pgrp, SIGTTIN);
    }

    /// VZbVn߂ăvZXO[v[_[ɂȂ ///
    setsid();
    pid_t shell_pgrp = getpid();
    setpgid(shell_pgrp, shell_pgrp);

    /// [̐ ///
    tcsetpgrp(0, shell_pgrp);

    /// RubyC^v^ ///
    myruby_init();

#if defined(MYCYGWINCOMPILE)
    /// Ŏw肳ꂽXNvgs ///
    if(script) {
        rb_eval_string("load 'mfiler_dand.rb'");
        rb_funcall(rb_cObject, rb_intern("run_argument_script"), 1, rb_str_new2(script_path));

        ruby_cleanup(0);
        return 0;
    }
#endif
    
    /// W[̏ ///
    variable_init();
    command_init();
    cMenu::Init();
    cDirWnd::Init();
    mcurses_init();
    cmdline_init();
    sisearch_init();

    /// O[oϐ̏ ///
    initialize_global_vars(init_path);

    /// \Pbg̏ ///
    char soc_name[256];
    int soc;
    if(gUnixDomainSocket) {
        sprintf(soc_name, "%s/mfiler%d", gTempDir, getpid());
        
        if(access(soc_name, F_OK) == 0) {
            unlink(soc_name);
        }
        
        soc = socket(AF_UNIX, SOCK_DGRAM, 0);
        if(soc < 0) {
            perror("socket");
            return 1;
        }
        
        struct sockaddr_un addr;
        addr.sun_family = AF_UNIX;
        strcpy(addr.sun_path, soc_name);
        if(bind(soc, (struct sockaddr *)&addr, sizeof(addr)) == -1) {
            perror("bind");
            return 1;
        }
    }

    /// ^CXNvgs ///
    read_rc_file();

    cmdline_init_after_reading_rc_file();
    isearch_init_after_reading_rc_file();

    /// locale̐ݒ ///
    if(gKanjiCode == kUtf8) setlocale(LC_CTYPE, "ja_JP.UTF-8");

    /// IvVɂ鏉fBNg̎w ///
    if(strcmp(init_path, "") != 0) {
        gLDir->Move(init_path);
        gLDir->SetScrollTop(0);
        gLDir->MoveCursor(0);

        gRDir->Move(init_path);
        gRDir->SetScrollTop(0);
        gRDir->MoveCursor(0);
    }

    gLDir->Reread();
    gRDir->Reread();

    /// ANeBufBNgݒ ///
    gLDir->Activate(gRDir);

    /// VOiݒ ///
    set_signal_mfiler2();
    
    /// J[VX̋N ///
    minitscr();
    mclear_immediately();

    /// atexito^ ///
    atexit(atexit_fun);
    
    /// C[v ///
    gMainLoop = true;

    fd_set mask;
    fd_set read_ok;

    FD_ZERO(&mask);
    FD_SET(0, &mask);
    if(gUnixDomainSocket) FD_SET(soc, &mask);

    while(gMainLoop) {
        /// C[vtbN ///
        rb_funcall(rb_cObject, rb_intern("mloop_hook"), 0);
        
        /// ` ///
        mclear();
        view(true);
        mrefresh();

        /// selectœ͑҂ ///
        read_ok = mask;

        if(!mkbuf_exist()) {            // L[{[h̃obt@ȂȂselect
            if(gUnixDomainSocket) {
                if(vector_size(gJobs) > 0) {
                    struct timeval tv;
                    tv.tv_sec = 5;
                    tv.tv_usec = 0;

                    select(soc + 1, &read_ok, NULL, NULL, &tv);
                }
                else {
                    select(soc + 1, &read_ok, NULL, NULL, NULL);
                }
            }
            else {
                if(vector_size(gJobs) > 0) {
                    struct timeval tv;
                    tv.tv_sec = 5;
                    tv.tv_usec = 0;

                    select(1, &read_ok, NULL, NULL, &tv);
                }
                else {
                    select(1, &read_ok, NULL, NULL, NULL);
                }
            }
        }

        /// L[ ///
        if(FD_ISSET(0, &read_ok) || mkbuf_exist()) {    // L[͂AL[{[h̃obt@Ȃ
            /// R}hC͒ ///
            if(gCmdLineActive) {
                while(1) {
                    /// ͂̂selectœ͂ ///
                    struct timeval tv;
                    tv.tv_sec = 0;
                    tv.tv_usec = 0;

                    read_ok = mask;

                    select(1, &read_ok, NULL, NULL, &tv);

                    /// L[͒ ///
                    if(FD_ISSET(0, &read_ok) || mkbuf_exist()) {
                        int meta;
                        int key = mgetch(&meta);

                        if(key == -1) {
                        }
                        else if(meta) {
                            input(1, key);
                        }
                        /// normal key ///
                        else {
                           input(0, key);
                        }
                    }
                    /// L[͂I ///
                    else {
                        break;
                    }
                }
            }

            /// ̑ ///
            else {
                int meta;
                int key = mgetch_nonblock(&meta);

                /// ESCL[ ///
                if(key == -1) {
                }
                else if(meta) {
                    input(1, key);
                }
                
                /// meta key ///
                else if(key >= kKeyMetaFirst && key <= kKeyMetaFirst+127) {
                    input(1, key - kKeyMetaFirst);
                }

                /// normal key ///
                else {
                   input(0, key);
                }
            }
        }

        /// UNIX Domain\Pbg ///
        else if(gUnixDomainSocket && FD_ISSET(soc, &read_ok)) {
            char buf[PATH_MAX];
            
            struct sockaddr_un caddr;
            socklen_t caddr_len;
            int len = recvfrom(soc, buf, PATH_MAX, 0, (struct sockaddr *)&caddr, &caddr_len);

            if(buf[0] == 'r') {
                gLDir->Reread();
                gRDir->Reread();
            }
            else if(buf[0] == 'm') {
                ActiveDir()->Move(buf + 1);
            }
        }

        /// Wu ///
        shell_wait_backgroud_job();
    }

    /// J[VXI ///
    mmove_immediately(0,0);
    mclear_immediately();
    mendwin();

    /// VOi ///
    set_signal_clear();
    
    /// SẴWukill ///
    shell_kill_all_jobs();
    
    /// ItbN ///
    rb_funcall(rb_cObject, rb_intern("atexit_hook"), 0);
    ruby_cleanup(0);
    putp(tigetstr("rmkx"));

    /// W[ ///
    cDirWnd::Final();
    cmdline_final();
    command_final();
    cMenu::Final();
    mcurses_final();
    isearch_final();
    variable_final();
    sisearch_final();
    
    /// O[oϐ ///    
    finalize_global_vars();

    /// \Pbg ///
    if(gUnixDomainSocket) unlink(soc_name);

CHECKML_BEGIN();
LOG_BEGIN();

    return 0;
}

