#include "config.h"
#include <termios.h>
#include <sys/ioctl.h>
#include <sys/types.h>
#include <termios.h>
#include <unistd.h>
#include <stdlib.h>
#include <string.h>
#include <wctype.h>
#include <stdio.h>
#include "wkf.h"

#ifdef __CYGWIN__
#include <ncurses/term.h>
#include <sys/time.h>
#else
#include <term.h>
#endif

#include "minato_curses.h"
#include "minato_vector.h"
#include "minato_debug.h"

///////////////////////////////////////////////////////////////////////////////
// `
///////////////////////////////////////////////////////////////////////////////
#define TERM_SIZE_MAX 512               // ^[~iTCY̍ől
#define UTF_CHAR_SIZE_MAX 6                      // UTF̈ꕶő剽oCg

static struct termios gTtySave;                     // [̐ݒۑ

static char gBuf[TERM_SIZE_MAX][TERM_SIZE_MAX];             // ̉
static char gBufBfr[TERM_SIZE_MAX][TERM_SIZE_MAX];          // Orefresh̃̉
static wchar_t gWBuf[TERM_SIZE_MAX][TERM_SIZE_MAX];         // UTF̃̉
static wchar_t gWBufBfr[TERM_SIZE_MAX][TERM_SIZE_MAX];      // UTF̑Orefresh̃̉
static int gBufAttr[TERM_SIZE_MAX][TERM_SIZE_MAX];          // ʂ̕񑮐
static int gBufAttrBfr[TERM_SIZE_MAX][TERM_SIZE_MAX];       // Orefresh̉ʂ̕񑮐
static int gBufAttrNow = 0;                                 // ݂̕񑮐

static int gX = 0, gY = 0;                  // ̃J[\
static int gCurses = 0;                     // cursesNĂ邩ǂ
int gKeyEscapeWait = 150000;                // EscapeL[̑҂

/* L[Ɣro镶̑Ή\ */
struct sKeyMap
{
    int mKey;
    char mKeys[kKeyMapKeysMax];
    int mNum;
};

vector_obj* gKeyMap = NULL;         // L[}bv̓Iz

char gKanjiCodeName[5][256];        // R[h̖O

char* gKanjiCodeString[6] = {
    "eucjp", "sjis", "utf8", "utf8-mac", "ascii", "unknown"
};

///////////////////////////////////////////////////////////////////////////////
// ֐
///////////////////////////////////////////////////////////////////////////////

// ʏłQJ̕H
static int wis_2cols(wchar_t c)
{
    wchar_t buf[256];

    buf[0] = c;
    buf[1] = 0;

    return wcswidth(buf, 10) == 2;
}

// J[[
static int mhas_color()
{
    return tigetstr("setaf") == NULL;
}

///////////////////////////////////////////////////////////////////////////////
// W[
///////////////////////////////////////////////////////////////////////////////
void mcurses_init()
{
    char keymaps[][kKeyMapKeysMax] = {
        {27,   '[',   'A',   -1,   -1,  -1, -1,-1,-1,-1},   // KEY_UP
        {27,   '[',   'B',   -1,   -1,  -1, -1,-1,-1,-1},   // KYE_DOWN
        {27,   '[',   'C',   -1,   -1,  -1, -1,-1,-1,-1},   // KEY_RIGHT
        {27,   '[',   'D',   -1,   -1,  -1, -1,-1,-1,-1},   // KEY_LEFT
        {27,   '[',   '2',  '~',  -1,  -1, -1,-1,-1,-1},   // KEY_IC
        {27,   91,    51,   126,   -1,  -1, -1,-1,-1,-1},   // KEY_DC
        {27,   'O',   'H',   -1,   -1,  -1, -1,-1,-1,-1},   // KEY_HOME
        {27,   'O',   'F',   -1,   -1,  -1, -1,-1,-1,-1},   // KEY_END
        {27,   '[',   '5',  '~',  -1,  -1, -1,-1,-1,-1},   // KEY_PPAGE PageUp
        {27,   '[',   '6',  '~',  -1,  -1, -1,-1,-1,-1},   // KEY_NPAGE PageDown
        {27,   '[',   '1',  '1', '~', -1, -1,-1,-1,-1},   // F1
        {27,   '[',   '1',  '2', '~', -1, -1,-1,-1,-1},   // F2
        {27,   '[',   '1',  '3', '~', -1, -1,-1,-1,-1},   // F3
        {27,   '[',   '1',  '4', '~', -1, -1,-1,-1,-1},   // F4
        {27,   '[',   '1',  '5', '~', -1, -1,-1,-1,-1},   // F5
        {27,   '[',   '1',  '7', '~', -1, -1,-1,-1,-1},   // F6
        {27,   '[',   '1',  '8', '~', -1, -1,-1,-1,-1},   // F7
        {27,   '[',   '1',  '9', '~', -1, -1,-1,-1,-1},   // F8
        {27,   '[',   '2',  '0', '~', -1, -1,-1,-1,-1},   // F9
        {27,   '[',   '2',  '1', '~', -1, -1,-1,-1,-1},   // F1-1
        {27,   '[',   '2',  '3', '~', -1, -1,-1,-1,-1},   // F11
        {27,   '[',   '2',  '4', '~', -1, -1,-1,-1,-1},    // F12
        {27,   'O',   'A',   -1,   -1,  -1, -1,-1,-1,-1},   // KEY_UP
        {27,   'O',   'B',   -1,   -1,  -1, -1,-1,-1,-1},   // KYE_DOWN
        {27,   'O',   'C',   -1,   -1,  -1, -1,-1,-1,-1},   // KEY_RIGHT
        {27,   'O',   'D',   -1,   -1,  -1, -1,-1,-1,-1},   // KEY_LEFT
        {127,   -1,    -1,   -1,   -1,  -1, -1,-1,-1,-1}    // KEY_BACKSPACE
    };

    gKeyMap = vector_new(10);

    madd_keymap(KEY_UP, keymaps[0]);
    madd_keymap(KEY_DOWN, keymaps[1]);
    madd_keymap(KEY_RIGHT, keymaps[2]);
    madd_keymap(KEY_LEFT, keymaps[3]);
    madd_keymap(KEY_IC, keymaps[4]);
    madd_keymap(KEY_DC, keymaps[5]);
    madd_keymap(KEY_HOME, keymaps[6]);
    madd_keymap(KEY_END, keymaps[7]);
    madd_keymap(KEY_PPAGE, keymaps[8]);
    madd_keymap(KEY_NPAGE, keymaps[9]);
    madd_keymap(KEY_F(1), keymaps[10]);
    madd_keymap(KEY_F(2), keymaps[11]);
    madd_keymap(KEY_F(3), keymaps[12]);
    madd_keymap(KEY_F(4), keymaps[13]);
    madd_keymap(KEY_F(5), keymaps[14]);
    madd_keymap(KEY_F(6), keymaps[15]);
    madd_keymap(KEY_F(7), keymaps[16]);
    madd_keymap(KEY_F(8), keymaps[17]);
    madd_keymap(KEY_F(9), keymaps[18]);
    madd_keymap(KEY_F(10), keymaps[19]);
    madd_keymap(KEY_F(11), keymaps[20]);
    madd_keymap(KEY_F(12), keymaps[21]);
    madd_keymap(KEY_UP, keymaps[22]);
    madd_keymap(KEY_DOWN, keymaps[23]);
    madd_keymap(KEY_RIGHT, keymaps[24]);
    madd_keymap(KEY_LEFT, keymaps[25]);
    madd_keymap(KEY_BACKSPACE, keymaps[26]);

    strcpy(gKanjiCodeName[kEucjp], "eucjp");
//    strcpy(gKanjiCodeName[kSjis], "cp932");
    strcpy(gKanjiCodeName[kSjis], "sjis");
    strcpy(gKanjiCodeName[kUtf8], "utf-8");
    strcpy(gKanjiCodeName[kUtf8Mac], "utf-8-mac");
}

///////////////////////////////////////////////////////////////////////////////
// W[
///////////////////////////////////////////////////////////////////////////////
void mcurses_final()
{
    int i;

    for(i=0; i<vector_size(gKeyMap); i++) {
        FREE(vector_item(gKeyMap, i));
    }
    vector_delete(gKeyMap);
}

///////////////////////////////////////////////////////////////////////////////
// J[VX
///////////////////////////////////////////////////////////////////////////////
void minitscr()
{
    struct termios t;
    int x,y;
    int i, j;
    struct sKeyMap* item;

    if(gCurses == 0) {
        tcgetattr(STDIN_FILENO, &gTtySave);
    }

    gCurses++;
    
    if(setupterm(NULL, STDOUT_FILENO, (int*) 0) == ERR) {
        fprintf(stderr, "invalid TERM setting");
        exit(1);
    }
    
    tcgetattr(STDIN_FILENO, &t);

    //putp(tigetstr("smkx"));

    t.c_lflag &= ~(ICANON | ECHO | ISIG | ECHOE);

# if defined(IEXTEN) && !defined(__MINT__)
    t.c_lflag &= ~IEXTEN; 
# endif

/*    
# ifdef ONLCR
   t.c_oflag &= ~ONLCR;
# endif
    t.c_iflag &= ~ICRNL;
*/    
    
/*
#ifdef ECHOPRT
    t.c_lflag &= ~(ICANON | ISIG | ECHO | ECHOCTL | ECHOE| ECHOK | ECHOKE
                         | ECHONL | ECHOPRT);
#else
    t.c_lflag &= ~(ICANON | ISIG | ECHO | ECHOCTL | ECHOE | ECHOK | ECHOKE
                  | ECHONL);
#endif
*/
    t.c_iflag |= IGNBRK;
    t.c_iflag &= ~(IXOFF|IXON);
   
    t.c_cc[VMIN] = 0;
    t.c_cc[VTIME] = 0;
    t.c_cc[VLNEXT] = 0;
    t.c_cc[VDISCARD] = 0;

    tcsetattr(STDIN_FILENO, TCSANOW, &t);

    if(gKanjiCode == kUtf8) {
        for(x=0; x<TERM_SIZE_MAX; x++) {
            for(y=0; y<TERM_SIZE_MAX; y++) {
                gWBufBfr[y][x] = 0;
                gBufAttrBfr[y][x] = 0;
            }
        }
    }
    else {
        for(x=0; x<TERM_SIZE_MAX; x++) {
            for(y=0; y<TERM_SIZE_MAX; y++) {
                gBufBfr[y][x] = 0;
                gBufAttrBfr[y][x] = 0;
            }
        }
    }
    

    mclear();
    
    gBufAttrNow = 0;
}

///////////////////////////////////////////////////////////////////////////////
// J[VX
///////////////////////////////////////////////////////////////////////////////
void mendwin()
{
/*
    mmove_immediately(0, 0);
    mclear_immediately();
    mrefresh();
*/    

    gCurses--;
    if(gCurses == 0) {
        tcsetattr(STDIN_FILENO, TCSANOW, &gTtySave);
        //tcgetattr(STDIN_FILENO, &gTtySave);
    }
}

///////////////////////////////////////////////////////////////////////////////
// L[}bvɃL[ǉ
///////////////////////////////////////////////////////////////////////////////
void madd_keymap(int key, char keys[kKeyMapKeysMax])
{
    int i;

    struct sKeyMap* keymap = (struct sKeyMap*)MALLOC(sizeof(struct sKeyMap));
    keymap->mKey = key;
    keymap->mNum = -1;
    for(i=0; i<kKeyMapKeysMax; i++) {
        keymap->mKeys[i] = keys[i];

        if(keys[i] == -1 && keymap->mNum == -1) {
            keymap->mNum = i;
        }
    }

    vector_add(gKeyMap, keymap);
}

///////////////////////////////////////////////////////////////////////////////
// ʂ
///////////////////////////////////////////////////////////////////////////////
void mclear()
{
    char space[1024];
    char space2[1024];
    int x, y;
    const int maxx = mgetmaxx();
    const int maxy = mgetmaxy();
    
    /// ʂ̏ ///
    for(x=0; x<maxx; x++) {
       space[x] = ' ';
    }
    space[x] = 0;
    
#ifdef __CYGWIN__
    for(x=0; x<maxx-1; x++) {
       space2[x] = ' ';
    }
    space2[x] = 0;
    
    mattron(0);
    for(y=0; y<maxy-1; y++) {
       mmvprintw(y, 0, space);
    }
    mmvprintw(maxy-1, 0, space2);
#else   
    mattron(0);
    for(y=0; y<maxy; y++) {
       mmvprintw(y, 0, space);
    }
#endif

    gX = 0;
    gY = 0;
}

///////////////////////////////////////////////////////////////////////////////
// ʂ𒼐ڏ
///////////////////////////////////////////////////////////////////////////////
void mclear_immediately()
{
    /// NA ///
    mclear();
    mrefresh();

    /// ʂ ///
    putp(tigetstr("clear"));
}

///////////////////////////////////////////////////////////////////////////////
// ʂs폜
///////////////////////////////////////////////////////////////////////////////
void mclear_online(int y)
{
    char space[1024];
    int x;

    const int maxx = mgetmaxx();

#ifdef __CYGWIN__
    const int maxy = mgetmaxy();
    
    if(y == maxy-1) {
        for(x=0; x<maxx-1; x++) {
            space[x] = ' ';
        }
    }
    else {   
        for(x=0; x<maxx; x++) {
            space[x] = ' ';
        }
    }
#else
    for(x=0; x<maxx; x++) {
        space[x] = ' ';
    }
#endif    
    space[x] = 0;
    
    mattron(0);
    mmvprintw(y, 0, space);
}

///////////////////////////////////////////////////////////////////////////////
// J[\ړ
///////////////////////////////////////////////////////////////////////////////
void mmove(int y, int x)
{
    gX = x;
    gY = y;
}

///////////////////////////////////////////////////////////////////////////////
// ʏ̃J[\ړ
///////////////////////////////////////////////////////////////////////////////
void mmove_immediately(int y, int x)
{
    putp(tparm(tigetstr("cup"), y, x));
    fflush(stdout);
}

///////////////////////////////////////////////////////////////////////////////
// J[\ړăɕ`
///////////////////////////////////////////////////////////////////////////////
int mmvprintw(int y, int x, char* str, ...)
{
    char buf[BUFSIZ];
    int i;
    char* p;
    wchar_t wbuf[BUFSIZ];
    wchar_t* wp;

    const int maxx = mgetmaxx();
    const int maxy = mgetmaxy();
    
    va_list args;
    va_start(args, str);
    i = vsprintf(buf, str, args);
    va_end(args);
    
    mmove(y, x);

    if(gKanjiCode == kUtf8) {
        if(mbstowcs(wbuf, buf, BUFSIZ) == -1) {
            mbstowcs(wbuf, "?????", BUFSIZ);
        }

        wp = wbuf;
        while(*wp) {
            if(wis_2cols(*wp)) {
                gWBuf[gY][gX] = *wp;
                gWBuf[gY][gX+1] = 0;
                gBufAttr[gY][gX] = gBufAttrNow;
                gBufAttr[gY][gX+1] = 0;
                gX+=2;
            }
            else {
                gWBuf[gY][gX] = *wp;
                gBufAttr[gY][gX] = gBufAttrNow;
                gX++;
            }

            if(gX >= maxx) {
                gX = 0;
                gY++;
            }
            wp++;
        }
    }
    else {
        p = buf;
        while(*p) {
            gBuf[gY][gX] = *p;
            gBufAttr[gY][gX] = gBufAttrNow;
            gX++;
            if(gX >= maxx) {
                gX = 0;
                gY++;
            }
            p++;
        }
    }
    
    return i;
}

///////////////////////////////////////////////////////////////////////////////
// ɕ`
///////////////////////////////////////////////////////////////////////////////
int mprintw(char* str, ...)
{
    char buf[BUFSIZ];
    wchar_t wbuf[BUFSIZ];
    wchar_t* wp;
    int i;
    char* p;

    const int maxx = mgetmaxx();
    const int maxy = mgetmaxy();
    
    va_list args;
    va_start(args, str);
    i = vsprintf(buf, str, args);
    va_end(args);

    if(gKanjiCode == kUtf8) {
        if(mbstowcs(wbuf, buf, BUFSIZ) == -1) {
            mbstowcs(wbuf, "?????", BUFSIZ);
        }

        wp = wbuf;
        while(*wp) {
            if(wis_2cols(*wp)) {
                gWBuf[gY][gX] = *wp;
                gWBuf[gY][gX+1] = 0;
                gBufAttr[gY][gX] = gBufAttrNow;
                gBufAttr[gY][gX+1] = 0;
                gX+=2;
            }
            else {
                gWBuf[gY][gX] = *wp;
                gBufAttr[gY][gX] = gBufAttrNow;
                gX++;
            }

            if(gX >= maxx) {
                gX = 0;
                gY++;
            }
            wp++;
        }
    }
    else {
        p = buf;
        while(*p) {
            gBuf[gY][gX] = *p;
            gBufAttr[gY][gX] = gBufAttrNow;
            gX++;
            if(gX >= maxx) {
                gX = 0;
                gY++;
            }
            p++;
        }
    }
    
    return i;
}

///////////////////////////////////////////////////////////////////////////////
// ޕ̑ݒ
///////////////////////////////////////////////////////////////////////////////
void mattron(int attrs)
{
    gBufAttrNow = attrs;
}

///////////////////////////////////////////////////////////////////////////////
// ޕ̑̐ݒ
///////////////////////////////////////////////////////////////////////////////
void mattroff()
{
    gBufAttrNow = 0;
}

///////////////////////////////////////////////////////////////////////////////
// {bNXɕ`
///////////////////////////////////////////////////////////////////////////////
void mbox(int y, int x, int width, int height)
{
   char hbar[256];
   int i;
   
   hbar[0] = '+';
   for(i=1; i<width-1; i++) {
      hbar[i] = '-';
   }
   hbar[i] = '+';
   hbar[i+1] = 0;

   mmvprintw(y, x, hbar);
   for(i=0; i<height-2; i++) {
       char hbar2[256];
       
       int j;
       hbar2[0] = '|';
       for(j=1; j<width-1; j++) {
           hbar2[j] = ' ';
       }
       hbar2[j] = '|';
       hbar2[j+1] = 0;

       mmvprintw(y + 1 +i, x, hbar2);

/*
       mmvprintw(y + 1 + i, x, "|");
       mmvprintw(y + 1 + i, x + width-1, "|");
*/
   }
   
   mmvprintw(y + height-1, x, hbar);
}

///////////////////////////////////////////////////////////////////////////////
// ̓eʂɔf
///////////////////////////////////////////////////////////////////////////////
void mrefresh()
{
    int x, y;
    const int maxx = mgetmaxx();
    const int maxy = mgetmaxy();
    char* p;
    char mbs[256];
    wchar_t wcs[256];
    
    if(gKanjiCode == kUtf8) {
        for(y=0; y<maxy; y++) {
            for(x=0; x<maxx; x++) {
                if(gWBuf[y][x] != gWBufBfr[y][x] 
                    || gBufAttr[y][x] != gBufAttrBfr[y][x]
                    
                    || (wis_2cols(gWBuf[y][x])
                        && (gWBuf[y][x] != gWBufBfr[y][x]
                            || gBufAttr[y][x] != gBufAttrBfr[y][x]
                            || gWBuf[y][x+1] != gWBufBfr[y][x+1]
                            || gBufAttr[y][x+1] != gBufAttrBfr[y][x+1]
                            )))
                {
                    putp(tparm(tigetstr("cup"), y, x));
        
                    if(gBufAttr[y][x] & kCAReverse) putp(tigetstr("rev"));
                    if(gBufAttr[y][x] & kCABold) putp(tigetstr("bold"));
                    if(gBufAttr[y][x] & kCAUnderline) putp(tigetstr("rmul"));
                    if(gBufAttr[y][x] & kCABlack) {
                        p = tigetstr("setaf");
                        if(p) putp(tparm(p, 0, 0));
                    }
                    if(gBufAttr[y][x] & kCARed) {
                        p = tigetstr("setaf");
                        if(p) putp(tparm(p, 1, 0));
                    }        
                    if(gBufAttr[y][x] & kCAGreen) {
                        p = tigetstr("setaf");
                        if(p) putp(tparm(p, 2, 0));
                    }
                    if(gBufAttr[y][x] & kCAYellow) {
                        p = tigetstr("setaf");
                        if(p) putp(tparm(p, 3, 0));
                    }        
                    if(gBufAttr[y][x] & kCABlue) {
                        p = tigetstr("setaf");
                        if(p) putp(tparm(p, 4, 0));
                    }        
                    if(gBufAttr[y][x] & kCAMagenta) {
                        p = tigetstr("setaf");
                        if(p) putp(tparm(p, 5, 0));
                    }        
                    if(gBufAttr[y][x] & kCACyan) {
                        p = tigetstr("setaf");
                        if(p) putp(tparm(p, 6, 0));
                    }        
                    if(gBufAttr[y][x] & kCAWhite) {
                        p = tigetstr("setaf");
                        if(p) putp(tparm(p, 7, 0));
                    }        
                    if(gBufAttr[y][x] & kCABackBlack) {
                        p = tigetstr("setab");
                        if(p) putp(tparm(p, 0, 0));
                    }        
                    if(gBufAttr[y][x] & kCABackRed) {
                        p = tigetstr("setab");
                        if(p) putp(tparm(p, 1, 0));
                    }        
                    if(gBufAttr[y][x] & kCABackGreen) {
                        p = tigetstr("setab");
                        if(p) putp(tparm(p, 2, 0));
                    }        
                    if(gBufAttr[y][x] & kCABackYellow) {
                        p = tigetstr("setab");
                        if(p) putp(tparm(p, 3, 0));
                    }        
                    if(gBufAttr[y][x] & kCABackBlue) {
                        p = tigetstr("setab");
                            if(p) putp(tparm(p, 4, 0));
                    }        
                    if(gBufAttr[y][x] & kCABackMagenta) {
                        p = tigetstr("setab");
                        if(p) putp(tparm(p, 5, 0));
                    }
                    if(gBufAttr[y][x] & kCABackCyan) {
                        p = tigetstr("setab");
                        if(p) putp(tparm(p, 6, 0));
                    }
                    if(gBufAttr[y][x] & kCABackWhite) {
                        p = tigetstr("setab");
                        if(p) putp(tparm(p, 7, 0));
                    }        

#if defined(__FREEBSD__)
                    putwc(gWBuf[y][x], stdout);
#endif
#if defined(__LINUX__) || defined(__DARWIN__) || defined(__SOLARIS__)
                    wcs[0] = gWBuf[y][x];
                    wcs[1] = 0;
                    wcstombs(mbs, wcs, 256);
                    printf("%s", mbs);
#endif
                
                    if(gBufAttr[y][x]) putp(tigetstr("sgr0"));
                }
                
                if(wis_2cols(gWBuf[y][x])) {
                    x++;
                }
            }
        }
    }
    else {
        for(y=0; y<maxy; y++) {
            for(x=0; x<maxx; x++) {
                if(gBuf[y][x] !=0 
                    && (
                        gBuf[y][x] != gBufBfr[y][x] 
                        || gBufAttr[y][x] != gBufAttrBfr[y][x]
                    
                    || (is_kanji(gBuf[y][x])
                        && (gBuf[y][x] != gBufBfr[y][x]
                            || gBufAttr[y][x] != gBufAttrBfr[y][x]
                            || gBuf[y][x+1] != gBufBfr[y][x+1]
                            || gBufAttr[y][x+1] != gBufAttrBfr[y][x+1]
                            ))))
                {
                    putp(tparm(tigetstr("cup"), y, x));
        
                    if(gBufAttr[y][x] & kCAReverse) putp(tigetstr("rev"));
                    if(gBufAttr[y][x] & kCABold) putp(tigetstr("bold"));
                    if(gBufAttr[y][x] & kCAUnderline) putp(tigetstr("rmul"));
                    if(gBufAttr[y][x] & kCABlack) {
                        p = tigetstr("setaf");
                        if(p) putp(tparm(p, 0, 0));
                    }
                    if(gBufAttr[y][x] & kCARed) {
                        p = tigetstr("setaf");
                        if(p) putp(tparm(p, 1, 0));
                    }        
                    if(gBufAttr[y][x] & kCAGreen) {
                        p = tigetstr("setaf");
                        if(p) putp(tparm(p, 2, 0));
                    }
                    if(gBufAttr[y][x] & kCAYellow) {
                        p = tigetstr("setaf");
                        if(p) putp(tparm(p, 3, 0));
                    }        
                    if(gBufAttr[y][x] & kCABlue) {
                        p = tigetstr("setaf");
                        if(p) putp(tparm(p, 4, 0));
                    }        
                    if(gBufAttr[y][x] & kCAMagenta) {
                        p = tigetstr("setaf");
                        if(p) putp(tparm(p, 5, 0));
                    }        
                    if(gBufAttr[y][x] & kCACyan) {
                        p = tigetstr("setaf");
                        if(p) putp(tparm(p, 6, 0));
                    }        
                    if(gBufAttr[y][x] & kCAWhite) {
                        p = tigetstr("setaf");
                        if(p) putp(tparm(p, 7, 0));
                    }        
                    if(gBufAttr[y][x] & kCABackBlack) {
                        p = tigetstr("setab");
                        if(p) putp(tparm(p, 0, 0));
                    }        
                    if(gBufAttr[y][x] & kCABackRed) {
                        p = tigetstr("setab");
                        if(p) putp(tparm(p, 1, 0));
                    }        
                    if(gBufAttr[y][x] & kCABackGreen) {
                        p = tigetstr("setab");
                        if(p) putp(tparm(p, 2, 0));
                    }        
                    if(gBufAttr[y][x] & kCABackYellow) {
                        p = tigetstr("setab");
                        if(p) putp(tparm(p, 3, 0));
                    }        
                    if(gBufAttr[y][x] & kCABackBlue) {
                        p = tigetstr("setab");
                            if(p) putp(tparm(p, 4, 0));
                    }        
                    if(gBufAttr[y][x] & kCABackMagenta) {
                        p = tigetstr("setab");
                        if(p) putp(tparm(p, 5, 0));
                    }
                    if(gBufAttr[y][x] & kCABackCyan) {
                        p = tigetstr("setab");
                        if(p) putp(tparm(p, 6, 0));
                    }
                    if(gBufAttr[y][x] & kCABackWhite) {
                        p = tigetstr("setab");
                        if(p) putp(tparm(p, 7, 0));
                    }        

                    if(is_kanji(gBuf[y][x]) && !is_hankaku(gBuf[y][x])) {
                        putchar(gBuf[y][x]);
                        putchar(gBuf[y][x+1]);
                    }
                    else if(is_kanji(gBuf[y][x]) && is_hankaku(gBuf[y][x])) {
                        putchar(gBuf[y][x]);
                        putchar(gBuf[y][x+1]);
                        putchar(' ');
                    }
                    else {       
                        putchar(gBuf[y][x]);
                    }
                
                    if(gBufAttr[y][x]) putp(tigetstr("sgr0"));
                }
                
                if(is_kanji(gBuf[y][x])) {
                    x++;
                }
            }
        }
    }
    
    putp(tparm(tigetstr("cup"), gY, gX));
    
    fflush(stdout);

    if(gKanjiCode == kUtf8) {
        for(y=0; y<maxy; y++) {
            for(x=0; x<maxx; x++) {
                gWBufBfr[y][x] = gWBuf[y][x];
                gBufAttrBfr[y][x] = gBufAttr[y][x];
            }
        }    
    }
    else {
        for(y=0; y<maxy; y++) {
            for(x=0; x<maxx; x++) {
                gBufBfr[y][x] = gBuf[y][x];
                gBufAttrBfr[y][x] = gBufAttr[y][x];
            }
        }    
    }
}

///////////////////////////////////////////////////////////////////////////////
// X̉ʂ̃TCY
///////////////////////////////////////////////////////////////////////////////
int mgetmaxx()
{
    struct winsize ws;
    ioctl(STDOUT_FILENO, TIOCGWINSZ, &ws);

    return ws.ws_col;
}

///////////////////////////////////////////////////////////////////////////////
// Ỷʂ̃TCY
///////////////////////////////////////////////////////////////////////////////
int mgetmaxy()
{
    struct winsize ws;
    ioctl(STDOUT_FILENO, TIOCGWINSZ, &ws);

#ifdef __CYGWIN__
    return ws.ws_row-1;
#else
    return ws.ws_row;
#endif
}

///////////////////////////////////////////////////////////////////////////////
// ݃J[VXNĂ邩ǂ
///////////////////////////////////////////////////////////////////////////////
int mis_curses()
{
    return gCurses;
}

///////////////////////////////////////////////////////////////////////////////
// L[{[h
///////////////////////////////////////////////////////////////////////////////
static int gKeyBuf[1024];
static int gKeyBufNum = 0;

static int mgetch_(int* meta, int block)
{
    int i, j;
    int specialkey_check;
    int result;
    char buf[128];
    char tmp[128];
    int n;
    int n2;
    fd_set mask;
    struct timeval tv;
    int on_the_way;
    int match;
    struct sKeyMap* item;
    double count;
    
static int y = 0;
    
    *meta = 0;
    
    /// exist key buf ///
    if(gKeyBufNum > 0) {

        while(1) {
            on_the_way = 0;

            /// meta special key ///
            if(gKeyBuf[0] == 27) {
                for(i=0; i<vector_size(gKeyMap); i++) {
                    item = (struct sKeyMap*)vector_item(gKeyMap, i);
                    match = 1;
                        
                    for(j=1; j<gKeyBufNum; j++) {
                        if(gKeyBuf[j] != item->mKeys[j-1]) {
                            match = 0;
                            break;
                        }
                    }
                        
                    if(gKeyBufNum-1 == item->mNum) {
                        match = 0;
                    }
    
                    if(match) {
                        on_the_way = 1;
                        break;
                    }
                }
            }
                
            /// special key ///
            for(i=0; i<vector_size(gKeyMap); i++) {
                item = (struct sKeyMap*)vector_item(gKeyMap, i);
                match = 1;
    
                for(j=0; j<gKeyBufNum; j++) {
                    if(gKeyBuf[j] != item->mKeys[j]) {
                        match = 0;
                        break;
                    }
                }
                    
                if(gKeyBufNum == item->mNum) {
                    match = 0;
                }
    
                if(match) {
                    on_the_way = 1;
                    break;
                }
            }
                
            if(on_the_way) {
                count = 0;
                while(count < gKeyEscapeWait) {
                    usleep(1);
                    count++;

                    fd_set mask;

                    FD_ZERO(&mask);
                    FD_SET(0, &mask);

                    struct timeval tv;
                    tv.tv_sec = 0;
                    tv.tv_usec = 0;

                    select(1, &mask, NULL, NULL, &tv);
                    
                    if(FD_ISSET(0, &mask)) {
                        break;
                    }
                }
                //usleep(500000);

#if defined(__CYGWIN__)
                fd_set mask;

                FD_ZERO(&mask);
                FD_SET(0, &mask);

                struct timeval tv;
                tv.tv_sec = 0;
                tv.tv_usec = 0;

                select(1, &mask, NULL, NULL, &tv);
                
                if(FD_ISSET(0, &mask)) {
                    if((n2 = read(0, tmp, 10)) < 0) {
                        perror("read");
                        exit(1);
                    }
                }
                else {
                    n2 = 0;
                }
#else
                if((n2 = read(0, tmp, 10)) < 0) {
                    perror("read");
                    exit(1);
                }
#endif
                
                if(n2 != 0)
                    for(i=0; i<n2; i++) gKeyBuf[gKeyBufNum++] = tmp[i];
                else
                    break;
            }
            else
                break;
        }

/*
mmvprintw(y, 10, "gKeyBufNum %d", gKeyBufNum);
for(i=0; i<gKeyBufNum; i++) {
mmvprintw(y,i*5+25, "(%d)", gKeyBuf[i]);
}
y++;
*/

        /// special key - meta ///
        if(gKeyBuf[0] == 27) {
            for(i=0; i<vector_size(gKeyMap); i++) {
                item = (struct sKeyMap*)vector_item(gKeyMap, i);

                specialkey_check = 1;
                    
                if(gKeyBufNum-1 < item->mNum) {
                    specialkey_check = 0;
                }
                else {
                    for(j=0; j<item->mNum; j++) {
                        if(item->mKeys[j] != gKeyBuf[j+1]) {
                            specialkey_check = 0;
                            break;
                        }
                    }
                }
                          
                if(specialkey_check) {
                    memmove(gKeyBuf, gKeyBuf + item->mNum+1,
                            sizeof(int)*(gKeyBufNum-item->mNum-1));
                    gKeyBufNum-=(item->mNum+1);
                    *meta = 1;
                    return item->mKey;
                }
            }
        }
        
        /// special key ///
        for(i=0; i<vector_size(gKeyMap); i++) {
            item = (struct sKeyMap*)vector_item(gKeyMap, i);

            specialkey_check = 1;
                
            if(gKeyBufNum < item->mNum) {
                specialkey_check = 0;
            }
            else {
                for(j=0; j<item->mNum; j++) {
                    if(item->mKeys[j] != gKeyBuf[j]) {
                        specialkey_check = 0;
                        break;
                    }
                }
            }
                      
            if(specialkey_check) {
                memmove(gKeyBuf, gKeyBuf + item->mNum,
                             sizeof(int)*(gKeyBufNum-item->mNum));
                gKeyBufNum-=item->mNum;
                return item->mKey;
            }
        }
    
        if(gKeyBuf[0] == 27 && gKeyBufNum > 1) {
            result = gKeyBuf[1];
            memmove(gKeyBuf, gKeyBuf + 2, sizeof(int)*(gKeyBufNum-2));
            gKeyBufNum-=2;
        
            *meta = 1;
            return result;
        }
        else {
            if(gKeyBufNum == 1) {
                gKeyBufNum--;
                return gKeyBuf[0];
            }
            else {
                result = gKeyBuf[0];
                memmove(gKeyBuf, gKeyBuf + 1, sizeof(int)*(gKeyBufNum-1));
                gKeyBufNum--;
                return result;
            }
        }
    }
    
    /// no exist key buf ///
    else {

        while(1) {

            n = 0;

            if(block) {
                while(n == 0) {


#if defined(__CYGWIN__)
                    fd_set mask;

                    FD_ZERO(&mask);
                    FD_SET(0, &mask);

                    struct timeval tv;
                    tv.tv_sec = 0;
                    tv.tv_usec = 0;

                    select(1, &mask, NULL, NULL, &tv);
                    
                    if(FD_ISSET(0, &mask)) {
                        if((n = read(0, buf, 10)) < 0) {
                            perror("read");
                            exit(1);
                        }
                    }
                    else {
                        n = 0;
                    }
#else

                    fd_set mask;

                    FD_ZERO(&mask);
                    FD_SET(0, &mask);

                    select(1, &mask, NULL, NULL, NULL);

                    if(FD_ISSET(0, &mask)) {
                        if((n = read(0, buf, 10)) < 0) {
                            perror("read");
                            exit(1);
                        }
                    }

#endif
                }
            }
            else {
#if defined(__CYGWIN__)
                fd_set mask;

                FD_ZERO(&mask);
                FD_SET(0, &mask);

                struct timeval tv;
                tv.tv_sec = 0;
                tv.tv_usec = 0;

                select(1, &mask, NULL, NULL, &tv);
                
                if(FD_ISSET(0, &mask)) {
                    if((n = read(0, buf, 10)) < 0) {
                        perror("read");
                        exit(1);
                    }
                }
                else {
                    n = 0;
                }
#else
                if((n = read(0, buf, 10)) < 0) {
                    perror("read");
                    exit(1);
                }
#endif
                if(n == 0) {
                    *meta = 0;
                    return -1;
                }
            }

            while(1) {
                on_the_way = 0;

                /// meta special key ///
                if(buf[0] == 27) {

                    for(i=0; i<vector_size(gKeyMap); i++) {
                        item = (struct sKeyMap*)vector_item(gKeyMap, i);

                        match = 1;
                        
                        for(j=1; j<n; j++) {
                            if(buf[j] != item->mKeys[j-1]) {
                                match = 0;
                                break;
                            }
                        }
                        
                        if(n-1 == item->mNum) {
                            match = 0;
                        }
    
                        if(match) {
                            on_the_way = 1;
                            break;
                        }
                    }
                }
            

                /// special key ///
                for(i=0; i<vector_size(gKeyMap); i++) {

                    item = (struct sKeyMap*)vector_item(gKeyMap, i);
                    match = 1;
    
                    for(j=0; j<n; j++) {
                        if(buf[j] != item->mKeys[j]) {
                            match = 0;
                            break;
                        }
                    }
                    
                    if(n == item->mNum) {
                        match = 0;
                    }
    
                    if(match) {
                        on_the_way = 1;
                        break;
                    }
                }
                
                if(on_the_way) {
                    count = 0;
                    while(count < gKeyEscapeWait) {
                        usleep(1);
                        count++;

                        fd_set mask;

                        FD_ZERO(&mask);
                        FD_SET(0, &mask);

                        struct timeval tv;
                        tv.tv_sec = 0;
                        tv.tv_usec = 0;

                        select(1, &mask, NULL, NULL, &tv);
                        
                        if(FD_ISSET(0, &mask)) {
                            break;
                        }
                    }
                    //usleep(500000);

#if defined(__CYGWIN__)
                    fd_set mask;

                    FD_ZERO(&mask);
                    FD_SET(0, &mask);

                    struct timeval tv;
                    tv.tv_sec = 0;
                    tv.tv_usec = 0;

                    select(1, &mask, NULL, NULL, &tv);
                    
                    if(FD_ISSET(0, &mask)) {
                        if((n2 = read(0, tmp, 10)) < 0) {
                            perror("read");
                            exit(1);
                        }
                    }
                    else {
                        n2 = 0;
                    }
#else

                    if((n2 = read(0, tmp, 10)) < 0) {
                        perror("read");
                        exit(1);
                    }
#endif
                    
                    if(n2 != 0)
                        for(i=0; i<n2; i++) buf[n++] = tmp[i];
                    else
                        break;
                    
                }
                else
                    break;
            }

/*
mmvprintw(y, 10, "read1 n %d", n);            
for(i=0; i<n; i++) {
mmvprintw(y, i*5 + 25, "(%d)", buf[i]);
}
mrefresh();
y++;
*/

            /// meta special key ///

            if(buf[0] == 27) {
                for(i=0; i<vector_size(gKeyMap); i++) {
                    item = (struct sKeyMap*)vector_item(gKeyMap, i);
                    specialkey_check = 1;
                    
                    if(n-1 < item->mNum) {
                         specialkey_check = 0;
                    }
                    else {
                        for(j=0; j<item->mNum; j++) {
                            if(item->mKeys[j] != buf[j+1]) {
                                specialkey_check = 0;
                                break;
                            }
                        }
                    }
                          
                    if(specialkey_check) {
                        if(n-1 > item->mNum) {
                            for(j=item->mNum+1; j<n; j++) {
                                gKeyBuf[gKeyBufNum++] = buf[j];
                            }
                        }

                        *meta = 1;
                        return item->mKey;
                    }
                }
            }
            

            /// special key ///

            for(i=0; i<vector_size(gKeyMap); i++) {
                item = (struct sKeyMap*)vector_item(gKeyMap, i);
                specialkey_check = 1;
                
                if(n < item->mNum) {
                    specialkey_check = 0;
                }
                else {
                    for(j=0; j<item->mNum; j++) {
                        if(item->mKeys[j] != buf[j]) {
                            specialkey_check = 0;
                            break;
                        }
                    }
                }
                      
                if(specialkey_check) {
                    if(n > item->mNum) {
                        for(j=item->mNum; j<n; j++) {
                            gKeyBuf[gKeyBufNum++] = buf[j];
                        }
                    }
                    
                    return item->mKey;
                }
            }

            //// other key ///
            if(buf[0] == 27 && n>1) {
                for(i=2; i<n; i++) {
                    gKeyBuf[gKeyBufNum++] = buf[i];
                }
                    
                *meta = 1;
                return buf[1];
            }
            else {
                for(i=1; i<n; i++) {
                    gKeyBuf[gKeyBufNum++] = buf[i];
                }
                    
                return buf[0];
            }
        }
    }
}

int mgetch(int* meta)
{
    return mgetch_(meta, 1);
}

int mgetch_nonblock(int* meta)
{
    return mgetch_(meta, 0);
}

///////////////////////////////////////////////////////////////////////////////
// pꕶڂǂ
///////////////////////////////////////////////////////////////////////////////
enum eKanjiCode gKanjiCode = kEucjp;

int is_hankaku(unsigned char c)
{
    if(gKanjiCode == kEucjp)
        return c == 0x8e;
    else
        return 0;
}

///////////////////////////////////////////////////////////////////////////////
// ꕶڂǂ
///////////////////////////////////////////////////////////////////////////////
int is_kanji(unsigned char c)
{
    if(gKanjiCode == kEucjp) {
        return c >= 0xA1 && c <= 0xFE || c == 0x8e;
//        return c >= 161 && c <= 254;
    }
    else if(gKanjiCode == kSjis) {
        return c >= 0x81 && c <= 0x9f || c >= 0xE0;
    }
    else if(gKanjiCode == kUtf8) {
        return !(c>=' ' && c<='~');
    }
}

///////////////////////////////////////////////////////////////////////////////
// ̕񂪉ʂŉ
///////////////////////////////////////////////////////////////////////////////
int str_termlen(char* mbs)
{
/*
    int i;
    int english_words;
    wchar_t* wcs;
    int all_size, len;
    
    wcs = (wchar_t*)MALLOC(sizeof(wchar_t)*(strlen(mbs)+1)*5);
    len = strlen(mbs);
    english_words = 0;
    for(i=0; i<len; i++) {
        if(mbs[i] >= ' ' && mbs[i] <= '~') {
            english_words++;
        }
    }
    
    mbstowcs(wcs, mbs, (strlen(mbs)+1)*5);
    
    all_size = wcslen(wcs);

    FREE(wcs);
    
    return (all_size-english_words)*2 + english_words;
*/
    int result;
    wchar_t* wcs;

    wcs = (wchar_t*)MALLOC(sizeof(wchar_t)*((strlen(mbs)+1)*UTF_CHAR_SIZE_MAX));
    if(mbstowcs(wcs, mbs, (strlen(mbs)+1)*UTF_CHAR_SIZE_MAX) == -1) {
        mbstowcs(wcs, "?????", (strlen(mbs)+1)*UTF_CHAR_SIZE_MAX);
    }
    result = wcswidth(wcs, wcslen(wcs));
    FREE(wcs);

    return result;
}

///////////////////////////////////////////////////////////////////////////////
// mbsUTFƌƂutfposڂ܂ł̒[ł̕񐔂Ԃ
///////////////////////////////////////////////////////////////////////////////
int str_termlen2(char* mbs, int utfpos)
{
    char* mbs2;
    int result;
    char* point;

    mbs2 = STRDUP(mbs);
    point = str_utfpos2pointer(mbs2, utfpos);
    if(point == NULL) {
        if(utfpos < 0) 
            result = -1;
        else
            result = str_termlen(mbs2);
    }
    else {
        *(mbs2 + (point-mbs2)) = 0;
        result = str_termlen(mbs2);
    }

    FREE(mbs2);

    return result;
}

///////////////////////////////////////////////////////////////////////////////
// ̕񂪉ʂŉ
///////////////////////////////////////////////////////////////////////////////
int wcs_termlen(wchar_t* wcs)
{
/*
    int english_words;
    int i;
    int len;
    
    len = wcslen(wcs);
    english_words = 0;
    for(i=0; i<len; i++) {
        if(wcs[i] >= ' ' && wcs[i] <= '~') {
            english_words++;
        }
    }
    
    return (len-english_words)*2 + english_words;
*/
    return wcswidth(wcs, wcslen(wcs));
}

///////////////////////////////////////////////////////////////////////////////
// UTFŉ
///////////////////////////////////////////////////////////////////////////////
int str_utflen(char* mbs)
{
    int result;
    wchar_t* wcs;
    
    wcs = (wchar_t*)MALLOC(sizeof(wchar_t)*(strlen(mbs)+1)*UTF_CHAR_SIZE_MAX);

    if(mbstowcs(wcs, mbs, (strlen(mbs)+1)*UTF_CHAR_SIZE_MAX) == -1) {
        mbstowcs(wcs, "?????", (strlen(mbs)+1)*UTF_CHAR_SIZE_MAX);
    }

    result = wcslen(wcs);

    FREE(wcs);

    return result;
}

///////////////////////////////////////////////////////////////////////////////
// mbsUTFƌƂposڂ̈ʒuԂ
///////////////////////////////////////////////////////////////////////////////
char* str_utfpos2pointer(char* mbs, int pos)
{
    char* result;
    wchar_t* wcs;
    char* mbs2;
    
    if(pos<0) return mbs;
    if(pos >= str_utflen(mbs)) return mbs + strlen(mbs);

    mbs2 = (char*)MALLOC(sizeof(char)*(strlen(mbs)+1));
    wcs = (wchar_t*)MALLOC(sizeof(wchar_t)*(strlen(mbs)+1)*UTF_CHAR_SIZE_MAX);

    if(mbstowcs(wcs, mbs, (strlen(mbs)+1)*UTF_CHAR_SIZE_MAX) == -1) {
        mbstowcs(wcs, "?????", (strlen(mbs)+1)*UTF_CHAR_SIZE_MAX);
    }

    wcs[pos] = 0;

    wcstombs(mbs2, wcs, strlen(mbs)+1);

    result = mbs + strlen(mbs2);

    FREE(wcs);
    FREE(mbs2);

    return result;
}

///////////////////////////////////////////////////////////////////////////////
// mbsUTFƌƂpoint̏ꏊ͉ڂԂ
///////////////////////////////////////////////////////////////////////////////
int str_pointer2utfpos(char* mbs, char* point)
{
    char* mbs2;
    int result;

    mbs2 = STRDUP(mbs);
    *(mbs2 + (point-mbs)) = 0;

    result = str_utflen(mbs2);

    FREE(mbs2);

    return result;
}

///////////////////////////////////////////////////////////////////////////////
// mbs[̕(termsize)̂ݎcĎĉĂdest_mbsɕԂ dest_byte: dest_mbs̃TCY
///////////////////////////////////////////////////////////////////////////////
void str_cut(char* mbs, int termsize, char* dest_mbs, int dest_byte)
{
    wchar_t* wcs;
    wchar_t* wcs_tmp;
    int i;

    wcs = (wchar_t*)MALLOC(sizeof(wchar_t)*(termsize+1)*UTF_CHAR_SIZE_MAX);
    wcs_tmp = (wchar_t*)MALLOC(sizeof(wchar_t)*(termsize+1)*UTF_CHAR_SIZE_MAX);

    if(mbstowcs(wcs, mbs, (termsize+1)*UTF_CHAR_SIZE_MAX) == -1) {
        mbstowcs(wcs, "?????", (termsize+1)*UTF_CHAR_SIZE_MAX);
    }

    for(i=0; i<wcslen(wcs); i++) {
        wcs_tmp[i] = wcs[i];
        wcs_tmp[i+1] = 0;

        if(wcs_termlen(wcs_tmp) > termsize) {
            wcs_tmp[i] = 0;
            break;
        }
    }

    wcstombs(dest_mbs, wcs_tmp, dest_byte);

    FREE(wcs);
    FREE(wcs_tmp);
}

///////////////////////////////////////////////////////////////////////////////
// mbs[̕(termsize)̂ݎcĎĉĂdest_mbsɕԂ dest_byte: dest_mbs̃TCY
// ؂̂ĂXy[XŖ߂
///////////////////////////////////////////////////////////////////////////////
void str_cut2(char* mbs, int termsize, char* dest_mbs, int dest_byte)
{
    int i;
    int n;

    wchar_t* wcs;
    wchar_t* tmp;

    wcs = (wchar_t*)MALLOC(sizeof(wchar_t)*(termsize+1)*UTF_CHAR_SIZE_MAX);
    tmp = (wchar_t*)MALLOC(sizeof(wchar_t)*(termsize+1)*UTF_CHAR_SIZE_MAX);

    if(mbstowcs(wcs, mbs, (termsize+1)*UTF_CHAR_SIZE_MAX) == -1) {
        mbstowcs(wcs, "?????", (termsize+1)*UTF_CHAR_SIZE_MAX);
    }

    i = 0;
    while(1) {
        if(i < wcslen(wcs)) {
            tmp[i] = wcs[i];
            tmp[i+1] = 0;
        }
        else {
            tmp[i] = ' ';
            tmp[i+1] = 0;
        }

        n = wcs_termlen(tmp);
        if(n < 0) {
            strcpy(dest_mbs, "?????");
            FREE(wcs);
            FREE(tmp);
            return;
        }
        else {
            if(n > termsize) {
                tmp[i] = 0;

                if(wcs_termlen(tmp) != termsize) {
                    tmp[i] = ' ';
                    tmp[i+1] = 0;
                }
                break;
            }
        }

        i++;
    }

    wcstombs(dest_mbs, tmp, dest_byte);

    FREE(wcs);
    FREE(tmp);
}

///////////////////////////////////////////////////////////////////////////////
// mbs[̕(termsize)̂ݎcĎĉĂdest_mbsɕԂ 
// dest_byte: dest_mbs̃TCY
// ؂̂ĂXy[XŖ߂
// ؂̂Ă͕̂̑O
///////////////////////////////////////////////////////////////////////////////
void str_cut3(char* mbs, int termsize, char* dest_mbs, int dest_byte)
{
    wchar_t* wcs;
    wchar_t* tmp;
    int i;
    int j;

    wcs = (wchar_t*)MALLOC(sizeof(wchar_t)*(termsize+1)*UTF_CHAR_SIZE_MAX);
    tmp = (wchar_t*)MALLOC(sizeof(wchar_t)*(termsize+1)*UTF_CHAR_SIZE_MAX);
//    wcs = (wchar_t*)MALLOC(sizeof(wchar_t)*(strlen(mbs)+1)*UTF_CHAR_SIZE_MAX);
//    tmp = (wchar_t*)MALLOC(sizeof(wchar_t)*(strlen(mbs)+1)*UTF_CHAR_SIZE_MAX);

    if(str_termlen(mbs) <= termsize) {
        str_cut2(mbs, termsize, dest_mbs, dest_byte);
    }
    else {
        if(mbstowcs(wcs, mbs, (termsize+1)*UTF_CHAR_SIZE_MAX) == -1) {
            mbstowcs(wcs, "?????", (termsize+1)*UTF_CHAR_SIZE_MAX);
        }

        i = wcslen(wcs)-1;
        j = 0;
        while(1) {
            tmp[j++] = wcs[i--];
            tmp[j] = 0;

            if(wcs_termlen(tmp) > termsize) {
                tmp[j-1] = 0;
                i+=2;

                if(wcs_termlen(tmp) == termsize) {
                    wcscpy(tmp, wcs + i);
                    break;
                }
                else {
                    tmp[0] = ' ';
                    wcscpy(tmp + 1, wcs + i);
                    break;
                }
            }
        }

        wcstombs(dest_mbs, tmp, dest_byte);
    }

    FREE(wcs);
    FREE(tmp);
}

///////////////////////////////////////////////////////////////////////////////
// str_cut3eucjp,sjis
///////////////////////////////////////////////////////////////////////////////
void str_cut3_nonutf8(char* mbs, int termsize, char* dest_mbs)
{
    bool* kanji;
    int i;
    const int len = strlen(mbs);
    char* buf;

    if(len < termsize) {
        strcpy(dest_mbs, mbs);
        for(i=len; i<termsize; i++) {
            strcat(dest_mbs, " ");
        }
    }
    else {
        kanji = MALLOC(sizeof(bool)*len);
        for(i=0; i<len; i++) {
            if(is_kanji(mbs[i])) {
                kanji[i] = true;
                i++;
                kanji[i] = false;
            }
            else {
                kanji[i] = false;
            }
        }

        if(kanji[len-termsize-1]) {
            int i;
            for(i=len-termsize; i<len; i++) {
                dest_mbs[i-len+termsize] = mbs[i];
            }
            dest_mbs[i-len+termsize] = 0;
            dest_mbs[0] = ' ';
        }
        else {
            int i;
            for(i=len-termsize; i<len; i++) {
                dest_mbs[i-len+termsize] = mbs[i];
            }
            dest_mbs[i-len+termsize] = 0;
        }

        FREE(kanji);
    }
}

///////////////////////////////////////////////////////////////////////////////
// L[{[hobt@݂ΐ^Ԃ
///////////////////////////////////////////////////////////////////////////////
int mkbuf_exist() 
{
    if(gKeyBufNum > 0) 
        return 1;
    else
        return 0;
}

///////////////////////////////////////////////////////////////////////////////
// ̊̕R[hԂ
///////////////////////////////////////////////////////////////////////////////
#if defined(HAVE_ICONV_H) || defined(HAVE_BICONV_H)

#if defined(HAVE_BICONV_H)
#include <biconv.h>
#else
#include <iconv.h>
#endif

enum eKanjiCode kanji_encode_type(char* buf)
{
    iconv_t ic;
    char* str_in;
    char* str_out;
    char* ptr_in;
    char* ptr_out;
    kcode_t kcode;
    const int len = strlen(buf);
    size_t bufsz_in = (size_t) len;
    size_t bufsz_out = (size_t) len * UTF_CHAR_SIZE_MAX;
    size_t result;

    if(is_all_ascii(buf)) {
        return kAscii;
    }

#if defined(__CYGWIN__)
    return ruby_kconv_guess(buf);
#else
    str_in = (char*)malloc(len*2);
    str_out = (char*)malloc(len * UTF_CHAR_SIZE_MAX);

    ptr_in = str_in;
    ptr_out = str_out;
    strcpy(str_in, buf);


    ic = iconv_open(gKanjiCodeName[kUtf8Mac], gKanjiCodeName[kUtf8Mac]);
    if(!(iconv(ic, &ptr_in, &bufsz_in, &ptr_out, &bufsz_out) < 0 || len-bufsz_in < len)) {
        iconv_close(ic);

        free(str_in);
        free(str_out);
        return kUtf8Mac;
    }
    else {
        ic = iconv_open(gKanjiCodeName[kUtf8], gKanjiCodeName[kUtf8]);
        if(!(iconv(ic, &ptr_in, &bufsz_in, &ptr_out, &bufsz_out) < 0 || len-bufsz_in < len)) {
            iconv_close(ic);

            free(str_in);
            free(str_out);
            return kUtf8;
        }
        else {
            iconv_close(ic);

            kcode = wkfGuessKanjiCodeOfString(buf);

            if(kcode == KC_SJIS) {
            //if(kcode == KC_SJIS|| KC_EUCorSJIS) {
                return kSjis;
            }
            if(kcode == KC_EUC) {
                return kEucjp;
            }
            else {
                return kUnknown;
            }
        }
    }
#endif
}

///////////////////////////////////////////////////////////////////////////////
// GR[h̕ϊBiconṽbp[
///////////////////////////////////////////////////////////////////////////////
int kanji_convert(char* input_buf, char* output_buf, size_t output_buf_size, enum eKanjiCode input_kanji_encode_type, enum eKanjiCode output_kanji_encode_type)
{
    iconv_t ic;
    char* ptr_in;
    char* ptr_out;
    const int len = strlen(input_buf);
    size_t result;
    size_t bufsz_in;
    size_t bufsz_out;

    if(is_all_ascii(input_buf) || input_kanji_encode_type == kAscii || output_kanji_encode_type == kAscii) {
        strcpy(output_buf, input_buf);
        return 0;
    }

    if(input_kanji_encode_type == kUnknown) {
        input_kanji_encode_type = kanji_encode_type(input_buf);
    }
    else {
        if(input_kanji_encode_type != kanji_encode_type(input_buf)) {
            return -1;
        }
    }
    if(input_kanji_encode_type == output_kanji_encode_type) {
        strcpy(output_buf, input_buf);
        return 0;
    }
    
    if(input_kanji_encode_type == kUnknown || output_kanji_encode_type == kUnknown) return -1;

#if defined(__CYGWIN__)
    ruby_nkf(input_buf, output_buf, output_kanji_encode_type);

#else
    
    ptr_in = input_buf;
    ptr_out = output_buf;
    bufsz_in = (size_t) len;
    bufsz_out = (size_t) output_buf_size;

    ic = iconv_open(gKanjiCodeName[output_kanji_encode_type], gKanjiCodeName[input_kanji_encode_type]);
    if(iconv(ic, &ptr_in, &bufsz_in, &ptr_out, &bufsz_out) < 0 || len-bufsz_in < len) {
        iconv_close(ic);

        return -1;
    }
    output_buf[output_buf_size - bufsz_out] = 0;

    iconv_close(ic);
#endif

    return 0;
}

///////////////////////////////////////////////////////////////////////////////
// GR[h̕ϊBiconṽbp[
///////////////////////////////////////////////////////////////////////////////
int kanji_convert2(string_obj* input_buf, string_obj* output_buf, enum eKanjiCode input_kanji_encode_type, enum eKanjiCode output_kanji_encode_type)
{
    int result;
    char* tmp;
    const int len = string_length(input_buf)*UTF_CHAR_SIZE_MAX + 1;
    
    tmp = MALLOC(len);

    result = kanji_convert(string_c_str(input_buf), tmp, len, input_kanji_encode_type, output_kanji_encode_type);

    if(result != -1) string_put(output_buf, tmp);

    FREE(tmp);

    return result;
}

#endif

BOOL is_all_ascii(char* buf)
{
    int i;

    for(i=0; i<strlen(buf); i++) {
        if(buf[i] < ' ' || buf[i] > '~') {
            return FALSE;
        }
    }

    return TRUE;
}
