/* 
 * ʐ䃉Cu
 */

#ifndef MINATO_CURSES_H
#define MINATO_CURSES_H

#if defined(HAVE_CURSES_H)
#include <curses.h>
#elif defined(HAVE_NCURSES_H)
#include <ncurses.h>
#endif

#include <stdarg.h>
#include <sys/ioctl.h>
#include <sys/types.h>

#include "config.h"
#include "minato_string.h"

#include <wchar.h>

///////////////////////////////////////////////////////////////////////////////
// ϐ`
///////////////////////////////////////////////////////////////////////////////
extern int gKeyEscapeWait;      // GXP[vL[̑҂

///////////////////////////////////////////////////////////////////////////////
// }N`
///////////////////////////////////////////////////////////////////////////////
#define kCAReverse 0x1          // ̑
#define kCABold 0x2
#define kCAUnderline 0x4
#define kCABlack 0x8
#define kCARed 0x10
#define kCAGreen 0x20
#define kCAYellow 0x40
#define kCABlue 0x80
#define kCAMagenta 0x100
#define kCACyan 0x200
#define kCAWhite 0x400
#define kCABackBlack 0x800
#define kCABackRed 0x1000
#define kCABackGreen 0x2000
#define kCABackYellow 0x4000
#define kCABackBlue 0x8000
#define kCABackMagenta 0x10000
#define kCABackCyan 0x20000
#define kCABackWhite 0x40000

///////////////////////////////////////////////////////////////////////////////
// ֐`
///////////////////////////////////////////////////////////////////////////////
void mcurses_init();            // minato_cursesW[ vOJnɌĂ
void mcurses_final();           // minato_cursesW[ vOIɌĂ

void minitscr();                // minato_curses minato_cursesgOɌĂ
void mendwin();                 // minato_curses minato_cursesgIɌĂ

#define kKeyMapKeysMax 10
void madd_keymap(int key, char keyes[kKeyMapKeysMax]);      // L[}bvɃL[ǉ

void mclear();                          // ̉ʂ
void mclear_immediately();              // ډʂ
void mclear_online(int y);              // ̉ʂs

void mmove(int y, int x);                           // ̃J[\ړ
void mmove_immediately(int y, int x);               // ډʏ̃J[\ړ
int mmvprintw(int y, int x, char* str, ...);        // ̃J[\ړăɕ
int mprintw(char* str, ...);                        // ɕ

void mattron(int attrs);                // ޕ̑ݒ
void mattroff();                        // ޕ̑̐ݒ

void mbox(int y, int x, int width, int height);     // Ƀ{bNX`
void mrefresh();                                    // ̓eʂɔf

int mgetmaxx();                 // ʂ̃TCY(X)
int mgetmaxy();                 // ʂ̃TCY(Y)
int mis_curses();               // ݃J[VXNĂ邩ǂ 1ȏ: true 0:false

int mgetch(int* meta);          // L[{[h
int mgetch_nonblock(int* meta); // L[{[h ͂Ȃ-1Ԃ

int mkbuf_exist(); // L[{[hobt@݂ΐ^Ԃ

/// ֘A֐ /////////////////////////////////////////////////////////////
enum eKanjiCode { kEucjp, kSjis, kUtf8, kUtf8Mac, kAscii, kUnknown };          // R[h
extern enum eKanjiCode gKanjiCode;
extern char* gKanjiCodeString[6];

extern char gKanjiCodeName[5][256];                         // R[h̖O

extern int is_kanji(unsigned char c);           // oCgڂǂ
extern int is_hankaku(unsigned char c);         // poCgڂǂ

int str_termlen(char* mbs);         // ̕񂪉ʂŉ
int str_termlen2(char* mbs, int utfpos);// mbsUTFƌƂutfposڂ܂ł̒[ł̕񐔂Ԃ
int wcs_termlen(wchar_t* wcs);      // ̕񂪉ʂŉ
int str_utflen(char* mbs);          // ̕UTFŉ

char* str_utfpos2pointer(char* mbs, int pos);       // mbsUTFƌƂposڂ̈ʒuԂ
int str_pointer2utfpos(char* mbs, char* point);     // mbsUTFƌƂpoint̏ꏊ͉ڂԂ

void str_cut(char* mbs, int termsize, char* dest_mbs, int dest_byte);       
    // mbs[̕(termsize)̂ݎcĎĉĂdest_mbsɕԂ dest_byte: dest_mbs̃TCY
void str_cut2(char* mbs, int termsize, char* dest_mbs, int dest_byte);
    // mbs[̕(termsize)̂ݎcĎĉĂdest_mbsɕԂ dest_byte: dest_mbs̃TCY
    // ؂̂ĂXy[XŖ߂
void str_cut3(char* mbs, int termsize, char* dest_mbs, int dest_byte);
    // mbs[̕(termsize)̂ݎcĎĉĂdest_mbsɕԂ dest_byte: dest_mbs̃TCY
    // ؂̂ĂXy[XŖ߂
    // ؂̂Ă͕̂̑O
void str_cut3_nonutf8(char* mbs, int termsize, char* dest_mbs);
    // str_cut3eucjp,sjis

#if defined(HAVE_ICONV_H) || defined(HAVE_BICONV_H)

enum eKanjiCode kanji_encode_type(char* buf);
    // ̊̕GR[hԂ

int kanji_convert(char* input_buf, char* output_buf, size_t output_buf_size, enum eKanjiCode input_kanji_encode_type, enum eKanjiCode output_kanji_encode_type);
    // GR[h̕ϊBiconṽbp[
    // output_buf͏\ȃXy[X蓖ĂĂKv
    // Ԃl-1̓G[ 0͐

int kanji_convert2(string_obj* input_buf, string_obj* output_buf, enum eKanjiCode input_kanji_encode_type, enum eKanjiCode output_kanji_encode_type);

#endif

int is_all_ascii(char* buf);
    // FALSE:܂ TRUE:Sp

#endif

