#include "common.h"
#include <time.h>

BOOL gCmdLineActive = FALSE;

BOOL gCmdLineEscapeKey = FALSE;

string_obj* gCmdLine;
int gCmdLineCursor = 0;

string_obj* gCmdLineSaved;

vector_obj* gHistory;

vector_obj* gHCandidate;

int gHistoryScrollTop = 0;
int gHistoryCursor = -1;

void cmdline_init()
{
    gCmdLine = string_new("");
    gHistory = vector_new(1000);
    gHCandidate = vector_new(1000);
}

void cmdline_history_refresh()
{
    /// qXg ///
    vector_clear(gHistory);

    /// qXg.mhisotryǂݍ ///
    char path[PATH_MAX];
    sprintf(path, "%s/.mhistory3", gHomeDir);

    if(access(path, R_OK) == 0) {
        char line[kCmdLineMax];

        FILE* f = fopen(path, "r+");
        while(fgets(line, kCmdLineMax, f) != NULL) {
            line[strlen(line)-1] = 0; // chomp
            vector_add(gHistory, string_new(line));
        }
        fclose(f);
    }
}
void cmdline_start(char* str, int cursor)
{
    gCmdLineActive = TRUE;
    string_put(gCmdLine, str);

    if(cursor < 0) {
        gCmdLineCursor = strlen(string_c_str(gCmdLine)) + cursor +1;
    }
    else if(cursor < strlen(string_c_str(gCmdLine))){
        gCmdLineCursor = cursor;
    }
    else {
        gCmdLineCursor = 0;
    }
    cmdline_history_refresh();

    vector_clear(gHCandidate);

    const int len = vector_size(gHistory);
    int i;
    for(i=len-1; i>=0; i--) {
        string_obj* cmd = (string_obj*)vector_item(gHistory, i);

        if(strstr(string_c_str(cmd), string_c_str(gCmdLine))) {
            vector_add(gHCandidate, string_new(string_c_str(cmd)));
        }
    }

    gHistoryScrollTop = 0;
    gHistoryCursor = -1;
}

///////////////////////////////////////////////////////////////////////////////
// R}hC⊮
///////////////////////////////////////////////////////////////////////////////

///////////////////////////////////////////////////////////////////////////////
// 
///////////////////////////////////////////////////////////////////////////////

/// J[\ړ ///
static void cursor_move(int v)
{
    if(gKanjiCode == kUtf8) {
        char* str = string_c_str(gCmdLine);
        int utfpos = str_pointer2utfpos(str, str + gCmdLineCursor);
        utfpos+=v;
        gCmdLineCursor = str_utfpos2pointer(str, utfpos) - str;
    }
    else {
        gCmdLineCursor += v;

        if(gCmdLineCursor < 0) gCmdLineCursor = 0;
        char* str = string_c_str(gCmdLine);
        if(gCmdLineCursor > strlen(str)) gCmdLineCursor = strlen(str);
    }
}

void cmdline_input(int meta, int key)
{
    bool kanji[kCmdLineMax];
    char* p = string_c_str(gCmdLine);
    int len = strlen(p);
    int i;
    for(i=0; i<len; i++) {
        if(is_kanji(p[i])) {
            kanji[i] = true;
            kanji[i+1] = false;
            i++;
        }
        else {
            kanji[i] = false;
        }
    }

    if(key == 14 || key == KEY_DOWN) {    // CTRL-N
        if(gHistoryCursor == 0) {
            gCmdLine = string_new(string_c_str(gCmdLineSaved));
            gCmdLineCursor = strlen(string_c_str(gCmdLine));
            gHistoryCursor = -1;
        }
        else if(gHistoryCursor != -1) {
            gHistoryCursor--;
        }
    }

    else if(key == 16 || key == KEY_UP) {    //CTRL-P
        if(gHistoryCursor != -1) {
            gHistoryCursor++;
        }
        else if(vector_size(gHCandidate) > 0) {
            gHistoryCursor = 0;
            gHistoryScrollTop = 0;

            gCmdLineSaved = string_new(string_c_str(gCmdLine));
        }
    }
    // CTRL-V
    else if(key==22 || key == KEY_NPAGE)
    {
        if(gHistoryCursor != -1) {
            gHistoryCursor+=5;
        }
        else {
            gHistoryCursor = 0;
            gHistoryScrollTop = 0;
        }
    }
    // CTRL-U Meta-v
    else if(key == 21 || meta==1&&key=='v' || key == KEY_PPAGE) 
    {
        if(gHistoryCursor != -1) {
            gHistoryCursor-=5;
        }
        else {
            gHistoryCursor = 0;
            gHistoryScrollTop = 0;
        }
    }

    /// J[\OɈړ ///
    else if(key == 6 || key == KEY_RIGHT) {    // CTRL-F
        if(gKanjiCode == kUtf8) {
            cursor_move(1);
        }
        else {
            if(kanji[gCmdLineCursor])
                cursor_move(2);
            else
                cursor_move(1);
        }

        gHistoryCursor = -1;
    }

    /// J[\Ɉړ ///
    else if(key == 2 || key == KEY_LEFT) {    // CTRL-B
        if(gKanjiCode == kUtf8) {
            cursor_move(-1);
        }
        else {
            if(gCmdLineCursor > 0) {
                if(gCmdLineCursor == 1) {
                    cursor_move(-1);
                }
                else {
                    if(kanji[gCmdLineCursor-2])
                        cursor_move(-2);
                    else 
                        cursor_move(-1);
                }
            }
        }
        
        gHistoryCursor = -1;
    }

    /// ɕ񕪈ړ ///
    else if(meta==1 && key == 'b' || meta==1 && key == KEY_LEFT // Meta-b CTRL-LEFT Meta-Left
        || key==KEY_F(13) || key==KEY_F(17))
    {
        if(gCmdLineCursor > 0) {
            string_obj* str = gCmdLine;

            const char* s = string_c_str(str);
            int pos = gCmdLineCursor;
            pos--;
            while(pos>=0 && (s[pos] == ' ' || s[pos] == '/' || s[pos] == '\'' || s[pos] == '"' || s[pos] == '.')) {
                pos--;
            }
            while(pos>=0 && s[pos] != ' ' && s[pos] != '/' && s[pos] != '\'' && s[pos] != '"' && s[pos] != '.') {
                pos--;
            gCmdLineCursor = pos+1;
            }
        }

        gHistoryCursor = -1;
    }

    /// Oɕ񕪈ړ ///
    else if(meta==1 && key == 'f' || meta==1 && key == KEY_RIGHT // Meta-f CTRL-RIGHT Meta-Right
        || key==KEY_F(14) || key==KEY_F(18))
    {
        string_obj* str = gCmdLine;
        const char* s = string_c_str(str);

        if(s[gCmdLineCursor] != 0) {
            int pos = gCmdLineCursor;
            pos++;
            while(s[pos]!=0 && (s[pos] == ' ' || s[pos] == '/' || s[pos] == '\'' || s[pos] == '"' || s[pos] == '.')) {
                pos++;
            }
            while(s[pos]!=0 && s[pos] != ' ' && s[pos] != '/' && s[pos] != '\'' && s[pos] != '"' && s[pos] != '.') {
                pos++;
            }

            gCmdLineCursor = pos;
        }

        gHistoryCursor = -1;
    }

    /// J[\ԑOɈړ ///
    else if(key == 1 || key == KEY_HOME) {    // CTRL-A
        cursor_move(-999);
        gHistoryCursor = -1;
    }

    /// J[\𖖔Ɉړ ///
    else if(key == 5 || key == KEY_END) {    // CTRL-E
        cursor_move(999);
        gHistoryCursor = -1;
    }

    /// 폜 ///
    else if(key == 4 || key == KEY_DC) {    // CTRL-D DELETE
        string_obj* str = gCmdLine;
        char* cstr = string_c_str(str);

        /// ҏWeLXg̃TCY0ȂR}hCI ///
        if(strlen(cstr) == 0) {
            gCmdLineActive = FALSE;
        }
        /// ҏWeLXg̃TCY0ȏȂ當폜 ///
        else {
            if(gCmdLineCursor < strlen(cstr)) {
                /// 폜 ///
                if(gKanjiCode == kUtf8) {
                    int utfpos = str_pointer2utfpos(cstr, cstr + gCmdLineCursor);
                    char* next_point = str_utfpos2pointer(cstr, utfpos+1);

                    string_erase(str, gCmdLineCursor, next_point - (cstr + gCmdLineCursor));
                }
                else {
                    if(kanji[gCmdLineCursor]) {
                        string_erase(str, gCmdLineCursor, 2);
                    }
                    else {
                        string_erase(str, gCmdLineCursor, 1);
                    }
                }
            }
        }
        gHistoryCursor = -1;
    }

    /// 폜 ///
    else if(key == 8 || key == KEY_BACKSPACE) {    // CTRL-H
        if(gCmdLineCursor > 0) {
            string_obj* str = gCmdLine;
            char* cstr = string_c_str(str);

            /// 폜 ///
            if(gKanjiCode == kUtf8) {
                int utfpos = str_pointer2utfpos(cstr, cstr + gCmdLineCursor);
                char* before_point = str_utfpos2pointer(cstr, utfpos-1);
                int new_cursor = before_point-cstr;

                string_erase(str, before_point - cstr, (cstr + gCmdLineCursor) - before_point);
                gCmdLineCursor = new_cursor;
            }
            else {
                if(gCmdLineCursor == 1) {
                    string_erase(str, gCmdLineCursor-1, 1);
                    cursor_move(-1);
                }
                else {
                    if(kanji[gCmdLineCursor-2]) {
                        string_erase(str, gCmdLineCursor-2, 2);

                        cursor_move(-2);
                    } else {
                        string_erase(str, gCmdLineCursor-1, 1);

                        cursor_move(-1);
                    }
                }
            }
        }
        gHistoryCursor = -1;
    }

    /// s폜 ///
    else if(key == 21) {    // CTRL-U
        string_obj* str = gCmdLine;
        char* cstr = string_c_str(str);

        /// s폜 ///
        string_put(str, "");

        gCmdLineCursor = 0;
        gHistoryCursor = -1;
    }

    /// O폜 ///
    else if(key == 23) {     // CTRL-W
        string_obj* str = gCmdLine;
        char* cstr = string_c_str(str);

        /// 폜 ///
        if(gCmdLineCursor > 0) {
            int pos = gCmdLineCursor-1;
            if(cstr[pos]==' ' || cstr[pos]=='/' || cstr[pos]=='\'' || cstr[pos]=='"' || cstr[pos]=='.') {
                while(pos>=0 && (cstr[pos]==' ' || cstr[pos]=='/' || cstr[pos]=='\'' || cstr[pos]=='"' || cstr[pos]=='.'))
                {
                    pos--;
                }
            }
            while(pos>=0 && cstr[pos]!=' ' && cstr[pos]!='/' && cstr[pos]!='\'' && cstr[pos]!='"' && cstr[pos]!='.')
            {
                pos--;
            }

            string_erase(str, pos+1, gCmdLineCursor-pos-1);

            gCmdLineCursor = pos+1;
        }
        gHistoryCursor = -1;
    }

    /// 폜 ///
    else if(meta==1 && key == 'd' || meta==0 && key==KEY_F(21)) {     // Meta-d CTRL + DELETE
        string_obj* str = gCmdLine;
        char* cstr = string_c_str(str);

        /// 폜 ///
        if(cstr[gCmdLineCursor] != 0) {
            int pos = gCmdLineCursor;
            pos++;
            while(cstr[pos]!=0 && (cstr[pos] == ' ' || cstr[pos] == '/' || cstr[pos] == '\'' || cstr[pos] == '"' || cstr[pos] == '.')) {
                pos++;
            }
            while(cstr[pos]!=0 && cstr[pos] != ' ' && cstr[pos] != '/' && cstr[pos] != '\'' && cstr[pos] != '"' && cstr[pos] != '.') {
                pos++;
            }

            string_erase(str, gCmdLineCursor, pos-gCmdLineCursor);
            //gCmdLineCursor = pos;
        }
        gHistoryCursor = -1;
    }

    /// J[\疖܂ō폜 ///
    else if(key == 11) {    // CTRL-K
        string_obj* str = gCmdLine;
        char* cstr = string_c_str(str);

        /// ܂ō폜 ///
        string_erase(str, gCmdLineCursor, string_length(str)-gCmdLineCursor);
        gHistoryCursor = -1;
    }
    else if(key == 9) {        // CTRL-I
        if(vector_size(gCCandidate) > 0) {
            gHistoryCursor = 0;
        }
        else {
            cmdline_completion_main();
            gHistoryCursor = -1;
        }
    }
    else if(key == 12) {// CTRL-L
        filer_reread(0);
        filer_reread(1);

        mclear_immediately();
        gHistoryCursor = -1;
    }
    // CTRL-C CTRL-G Escape
    else if(!gCmdLineEscapeKey && (key == 3 || key == 7)
            || gCmdLineEscapeKey && (key == 3 || key ==7 || key==27))
    {
        char* p = string_c_str(gCmdLine);
        BOOL all_space = TRUE;
        while(*p) {
            if(*p == ' ' || *p == '\t' || *p == '\n') {
                p++;
            }
            else {
                p++;
                all_space = FALSE;
                break;
            }
        }
        gCmdLineActive = false;
        if(!all_space) {
            add_history(string_c_str(gCmdLine));
        }
    }
    else if(key == 10 || key == 13) {       // CTRL-J CTRL-M
        string_obj* str = gCmdLine;
        shell(string_c_str(gCmdLine), NULL, -1, FALSE, FALSE, -1);
        gCmdLineActive = false;
    }
    else {
        string_obj* str = gCmdLine;
        char* cstr = string_c_str(str);

        /// ǉ ///
        if(gKanjiCode == kUtf8) {
            if(meta == 0 && !(key >= 0 && key <= 27)) {
                char tmp[128];

                sprintf(tmp, "%c", key);
                string_insert(str, gCmdLineCursor, tmp);
                gCmdLineCursor++;
            }
        }
        else {
            if(is_kanji(key)) {
                int meta;
                int key2 = mgetch(&meta);

                char tmp[128];
                sprintf(tmp, "%c%c", (char)key, (char)key2);
                string_insert(str, gCmdLineCursor, tmp);
                gCmdLineCursor+=2;
            }
            else if(meta == 0 && ' ' <= key && key <= '~') {
                char tmp[128];
                sprintf(tmp, "%c", key);
                string_insert(str, gCmdLineCursor, tmp);
                gCmdLineCursor++;
            }
        }
        gHistoryCursor = -1;
    }


    if(gHistoryCursor == -1) {
        vector_clear(gHCandidate);

        len = vector_size(gHistory);
        for(i=len-1; i>=0; i--) {
            string_obj* cmd = (string_obj*)vector_item(gHistory, i);

            if(strstr(string_c_str(cmd), string_c_str(gCmdLine))) {
                vector_add(gHCandidate, string_new(string_c_str(cmd)));
            }
        }
    }
    else {
        if(gHistoryCursor < 0) {
            gHistoryCursor = 0;
        }
        if(gHistoryCursor >= vector_size(gHCandidate)) {
            gHistoryCursor = vector_size(gHCandidate)-1;
        }

        const int maxy = mgetmaxy();
        if(gHistoryCursor < gHistoryScrollTop) {
            gHistoryScrollTop = (gHistoryCursor/(maxy-2))*(maxy-2);
        }
        if(gHistoryCursor > gHistoryScrollTop + maxy-3) {
            gHistoryScrollTop = (gHistoryCursor/(maxy-2))*(maxy-2);
        }

        string_obj* candidate = (string_obj*)vector_item(
                                             gHCandidate, gHistoryCursor);
        if(candidate) {
            gCmdLine = string_new(string_c_str(candidate));
            gCmdLineCursor = strlen(string_c_str(gCmdLine));
        }
    }
}

void cmdline_hcandidate_refresh()
{
    vector_clear(gHCandidate);

    int len = vector_size(gHistory);
    int i;
    for(i=len-1; i>=0; i--) {
        string_obj* cmd = (string_obj*)vector_item(gHistory, i);

        if(strstr(string_c_str(cmd), string_c_str(gCmdLine))) {
            vector_add(gHCandidate, string_new(string_c_str(cmd)));
        }
    }
}

///////////////////////////////////////////////////////////////////////////////
// `
///////////////////////////////////////////////////////////////////////////////

static void print_cmdline_core(char* buf, bool* cmd)
{
    if(strcmp(buf, "") != 0) {
        if(*cmd) {
            char buf2[PATH_MAX];
            {
                char* p2 = buf2;
                char* p = buf;
                bool dquote = false;
                bool squote = false;
                while(*p) {
                    if(!dquote && *p == '\'') {
                        p++;
                        squote = !squote;
                    }
                    else if(!squote && *p == '"') {
                        p++;
                        dquote = !dquote;
                    }
                    else if(squote || dquote) {
                        *p2++ = *p++;
                    }
                    else if(*p == '\\') {
                        p++;

                        if(*p) *p2++ = *p++;
                    }
                    else {
                        *p2++ = *p++;
                    }
                }
                *p2 = 0;
            }

            bool flg = false;
            int i;
            for(i=0; i<vector_size(gPrograms); i++) {
                if(strcmp(buf2, string_c_str(vector_item(gPrograms, i))) == 0)
                {
                    flg = true;
                    break;
                }
            }

            char buf3[PATH_MAX];
            {
                char* p2 = buf3;
                char* p = buf2;
                while(*p) {
                    if(*p == '\'') {
                        p++;

                        *p2++ = '\\';
                        *p2++ = '\'';
                    }
                    else {
                        *p2++ = *p++;
                    }
                }
                *p2 = 0;
            }

            char tmp[PATH_MAX];
            sprintf(tmp, "path = File.expand_path('%s'); !File.directory?(path) && File.executable?(path)", buf3);
            VALUE v = rb_eval_string(tmp);
            if(v == Qtrue) {
                flg = true;
            }

            if(strcmp(getenv("COLOR"), "1") == 0) {
                if(flg) {
                    mattron(kCAGreen);
                }
                else {
                    mattron(kCARed);
                }
            }
            else {
                if(flg) {
                    mattron(kCABold);
                }
            }

            mprintw("%s", buf);

            mattroff();

            *cmd = false;
        }
        else {
            if(strcmp(getenv("COLOR"), "1") == 0) {
                if(buf[0] == '-') {
                    mattron(kCAYellow);
                }
            }

            mprintw("%s", buf);

            if(strcmp(getenv("COLOR"), "1") == 0) {
                if(buf[0] == '-') {
                    mattroff();
                }
            }
        }
    }
}

static void print_cmdline(char* str, bool* cmd)
{
    char* p = str;

    bool dquote = false;
    bool squote = false;
    bool expand_cmd1 = false;
    bool expand_cmd2 = false;

    char buf[PATH_MAX];
    char* p2 = buf;

    while(1) {
        if(!dquote && !expand_cmd1 && !expand_cmd2 && *p == '\'') {
            p++;

            *p2++ = '\'';

            squote = !squote;
        }
        else if(!squote && !expand_cmd1 && !expand_cmd2 && *p == '"') {
            p++;

            *p2++ = '"';

            dquote = !dquote;
        }
        else if(!dquote && !squote && !expand_cmd2 && *p == '$' && *(p+1) == '(') {
            *p2++ = *p++;
            *p2++ = *p++;

            expand_cmd1 = true;
        }
        else if(!dquote && !squote && expand_cmd1 && !expand_cmd2 && *p == ')') {
            *p2++ = *p++;

            expand_cmd1 = false;
        }
        else if(!dquote && !squote && !expand_cmd1 && *p == '`') {
            *p2++ = *p++;

            expand_cmd2 = !expand_cmd2;
        }
        else if(*p != 0 && (squote || dquote || expand_cmd1 || expand_cmd2)) {
            *p2++ = *p++;
        }
        else if(*p == '\\') {
            p++;

            *p2++ = '\\';

            if(*p) *p2++ = *p++;
        }
        else if(*p == '&') {
            p++;

            *p2 = 0;
            p2 = buf;

            print_cmdline_core(buf, cmd);
            if(strcmp(getenv("COLOR"), "1") == 0) {
                mattron(kCACyan);
            }
            else {
                mattron(kCABold);
            }
            mprintw("&");
            mattroff();
        }
        else if(*p == '|') {
            p++;

            *p2 = 0;
            p2 = buf;

            print_cmdline_core(buf, cmd);
            if(strcmp(getenv("COLOR"), "1") == 0) {
                mattron(kCACyan);
            }
            else {
                mattron(kCABold);
            }
            mprintw("|");
            mattroff();

            *cmd = true;
        }
        else if(*p == ';') {
            p++;

            *p2 = 0;
            p2 = buf;

            print_cmdline_core(buf, cmd);
            if(strcmp(getenv("COLOR"), "1") == 0) {
                mattron(kCACyan);
            }
            else {
                mattron(kCABold);
            }
            mprintw(";");
            mattroff();

            *cmd = true;
        }
        else if(*p == '2' && *(p+1) == '>' && *(p+2) == '>' && *(p+3) == '1') {
            p+=4;

            *p2 = 0;
            p2 = buf;

            print_cmdline_core(buf, cmd);
            if(strcmp(getenv("COLOR"), "1") == 0) {
                mattron(kCACyan);
            }
            else {
                mattron(kCABold);
            }
            mprintw("2>>1");
            mattroff();
        }
        else if(*p == '2' && *(p+1) == '>' && *(p+2) == '>') {
            p+=3;

            *p2 = 0;
            p2 = buf;

            print_cmdline_core(buf, cmd);
            if(strcmp(getenv("COLOR"), "1") == 0) {
                mattron(kCACyan);
            }
            else {
                mattron(kCABold);
            }
            mprintw("2>>");
            mattroff();
        }
        else if(*p == '2' && *(p+1) == '>' && *(p+2) == '1') {
            p+=3;

            *p2 = 0;
            p2 = buf;

            print_cmdline_core(buf, cmd);
            if(strcmp(getenv("COLOR"), "1") == 0) {
                mattron(kCACyan);
            }
            else {
                mattron(kCABold);
            }
            mprintw("2>1");
            mattroff();
        }
        else if(*p == '1' && *(p+1) == '>' && *(p+2) == '>') {
            p+=3;

            *p2 = 0;
            p2 = buf;

            print_cmdline_core(buf, cmd);
            if(strcmp(getenv("COLOR"), "1") == 0) {
                mattron(kCACyan);
            }
            else {
                mattron(kCABold);
            }
            mprintw("1>>");
            mattroff();
        }
        else if(*p == '1' && *(p+1) == '>') {
            p+=2;

            *p2 = 0;
            p2 = buf;

            print_cmdline_core(buf, cmd);
            if(strcmp(getenv("COLOR"), "1") == 0) {
                mattron(kCACyan);
            }
            else {
                mattron(kCABold);
            }
            mprintw("1>");
            mattroff();
        }
        else if(*p == '2' && *(p+1) == '>') {
            p+=2;

            *p2 = 0;
            p2 = buf;

            print_cmdline_core(buf, cmd);
            if(strcmp(getenv("COLOR"), "1") == 0) {
                mattron(kCACyan);
            }
            else {
                mattron(kCABold);
            }
            mprintw("2>");
            mattroff();
        }
        else if(*p == '>' && *(p+1) == '>') {
            p+=2;

            *p2 = 0;
            p2 = buf;

            print_cmdline_core(buf, cmd);
            if(strcmp(getenv("COLOR"), "1") == 0) {
                mattron(kCACyan);
            }
            else {
                mattron(kCABold);
            }
            mprintw(">>");
            mattroff();
        }
        else if(*p =='>' ) {
            p++;

            *p2 = 0;
            p2 = buf;

            print_cmdline_core(buf, cmd);
            if(strcmp(getenv("COLOR"), "1") == 0) {
                mattron(kCACyan);
            }
            else {
                mattron(kCABold);
            }
            mprintw(">");
            mattroff();
        }
        else if(*p =='<') {
            p++;

            *p2 = 0;
            p2 = buf;

            print_cmdline_core(buf, cmd);
            if(strcmp(getenv("COLOR"), "1") == 0) {
                mattron(kCACyan);
            }
            else {
                mattron(kCABold);
            }
            mprintw("<");
            mattroff();
        }
        else if(*p == ' ' || *p == '\t') {
            *p2 = 0;
            p2 = buf;

            print_cmdline_core(buf, cmd);

            while(*p == ' ' || *p == '\t') {
                mprintw("%c", *p);
                p++;
            }
        }
        else if(*p == 0) {
            *p2 = 0;
            p2 = buf;

            print_cmdline_core(buf, cmd);

            break;
        }
        else if(*p == '%') {
            *p2 = 0;
            p2 = buf;

            print_cmdline_core(buf, cmd);

            p++;

            switch(*p) {
                case '%':
                    p++;

                    if(strcmp(getenv("COLOR"), "1") == 0) {
                        mattron(kCAMagenta);
                    }
                    else {
                        mattron(kCABold);
                    }

                    mprintw("%s", "%%");

                    mattroff();
                    break;

                case 'r':
                    p++;

                    if(strcmp(getenv("COLOR"), "1") == 0) {
                        mattron(kCAMagenta);
                    }
                    else {
                        mattron(kCABold);
                    }
                    mprintw("%s", "%r");
                    mattroff();
                    break;

                case 't':
                    p++;

                    if(strcmp(getenv("COLOR"), "1") == 0) {
                        mattron(kCAMagenta);
                    }
                    else {
                        mattron(kCABold);
                    }
                    mprintw("%s", "%t");
                    mattroff();
                    break;

                case 's':
                    p++;

                    if(strcmp(getenv("COLOR"), "1") == 0) {
                        mattron(kCAMagenta);
                    }
                    else {
                        mattron(kCABold);
                    }
                    mprintw("%s", "%s");
                    mattroff();
                    break;

                case 'q':
                    p++;

                    if(strcmp(getenv("COLOR"), "1") == 0) {
                        mattron(kCAMagenta);
                    }
                    else {
                        mattron(kCABold);
                    }
                    mprintw("%s", "%q");
                    mattroff();
                    break;

                case 'Q':
                    p++;

                    if(strcmp(getenv("COLOR"), "1") == 0) {
                        mattron(kCAMagenta);
                    }
                    else {
                        mattron(kCABold);
                    }
                    mprintw("%s", "%Q");
                    mattroff();
                    break;

                case 'o':
                    p++;

                    if(strcmp(getenv("COLOR"), "1") == 0) {
                        mattron(kCAMagenta);
                    }
                    else {
                        mattron(kCABold);
                    }
                    mprintw("%s", "%o");
                    mattroff();
                    break;

                case 'h':
                    p++;

                    if(strcmp(getenv("COLOR"), "1") == 0) {
                        mattron(kCAMagenta);
                    }
                    else {
                        mattron(kCABold);
                    }

                    mprintw("%s", "%h");
                    mattroff();
                    break;

                case 'f':
                    p++;

                    if(strcmp(getenv("COLOR"), "1") == 0) {
                        mattron(kCAMagenta);
                    }
                    else {
                        mattron(kCABold);
                    }
                    mprintw("%s", "%f");
                    mattroff();
                    break;

                case 'F':
                    p++;

                    if(strcmp(getenv("COLOR"), "1") == 0) {
                        mattron(kCAMagenta);
                    }
                    else {
                        mattron(kCABold);
                    }
                    mprintw("%s", "%F");
                    mattroff();
                    break;

                case 'x':
                    p++;

                    if(strcmp(getenv("COLOR"), "1") == 0) {
                        mattron(kCAMagenta);
                    }
                    else {
                        mattron(kCABold);
                    }
                    mprintw("%s", "%x");
                    mattroff();
                    break;

                case 'X':
                    p++;

                    if(strcmp(getenv("COLOR"), "1") == 0) {
                        mattron(kCAMagenta);
                    }
                    else {
                        mattron(kCABold);
                    }
                    mprintw("%s", "%X");
                    mattroff();
                    break;

                case 'd':
                    p++;

                    if(*p == '2') {
                        p++;

                        if(strcmp(getenv("COLOR"), "1") == 0) {
                            mattron(kCAMagenta);
                        }
                        else {
                            mattron(kCABold);
                        }
                        mprintw("%s", "%d2");
                        mattroff();
                    }
                    else {
                        if(strcmp(getenv("COLOR"), "1") == 0) {
                            mattron(kCAMagenta);
                        }
                        else {
                            mattron(kCABold);
                        }

                        mprintw("%s", "%d");
                        mattroff();
                    }

                    break;

                case 'D':
                    p++;

                    if(*p == '2') {
                        p++;

                        if(strcmp(getenv("COLOR"), "1") == 0) {
                            mattron(kCAMagenta);
                        }
                        else {
                            mattron(kCABold);
                        }
                        mprintw("%s", "%D2");
                        mattroff();
                    }
                    else {
                        if(strcmp(getenv("COLOR"), "1") == 0) {
                            mattron(kCAMagenta);
                        }
                        else {
                            mattron(kCABold);
                        }
                        mprintw("%s", "%D");
                        mattroff();
                    }
                    break;

                case 'M':
                    p++;

                    if(strcmp(getenv("COLOR"), "1") == 0) {
                        mattron(kCAMagenta);
                    }
                    else {
                        mattron(kCABold);
                    }
                    mprintw("%s", "%M");
                    mattroff();

                    break;

                case 'm':
                    p++;

                    if(strcmp(getenv("COLOR"), "1") == 0) {
                        mattron(kCAMagenta);
                    }
                    else {
                        mattron(kCABold);
                    }
                    mprintw("%s", "%m");
                    mattroff();

                    break;

                default:
                    mattroff();
                    mprintw("%s", "%");
                    break;
            }
        }
        else {
            *p2++ = *p++;
        }
    }
}


static void cmdline_view_euc_sjis_multi_line()
{
    const int maxx = mgetmaxx();
    const int maxy = mgetmaxy();

    /// vvg` ///
    mclear();

    mmvprintw(0, 0, "$ ");
    
    /// es` ///
    char* cstr = string_c_str(gCmdLine);

    int line = 0;
    char* line_top = cstr;
    int n = 0;

    int cursor_y = -1;
    int cursor_x = -1;
    while(1) {
        char* line_end = line_top + n;

        /// J[\`ʈʒuۑ ///
        if(line_end == cstr+gCmdLineCursor) {
            cursor_y = line;
            cursor_x = n;
        }

        /// s̏I܂ŒBĂ ///
        if(line == 0 && (n+2 > maxx) 
                || line > 0 && (n > maxx))
        {
            if(is_kanji((unsigned char)*(line_top+n-2))) {
                line_end-=2;
            }
            else {
                line_end--;
            }

            char buf[4089];
            memcpy(buf, line_top, line_end-line_top);
            buf[line_end-line_top] = 0;

            if(line == 0) {
                mprintw("%s", buf);
            }
            else {
                mmvprintw(line, 0, "%s", buf);
            }

            line_top = line_end;
            n = 0;
            line++;
        }
        
        /// šE܂ł ///
        else if(line >= maxy) {
            break;
        }
        
        /// ̏I[܂ŒBĂ ///
        else if(!*line_end) {
            if(cursor_x == maxx) {
                cursor_x = 0;
                cursor_y++;
            }

            mmvprintw(line, 0, "%s", line_top);

            break;
        }

        /// ȊO ///
        else {
            n++;

            if(is_kanji((unsigned char)*(line_top + n-1))) {
                n++;
            }
        }
    }

    /// J[\ړ ///
    if(cursor_y == -1 && cursor_x == -1) {
        mmove(maxy-1, maxx-2);
    }
    else if(cursor_y == 0) {
        mmove(cursor_y, cursor_x+2);
    }
    else {
        mmove(cursor_y, cursor_x);
    }
}

static void cmdline_view_euc_sjis_2line()
{
    const int maxx = mgetmaxx();
    const int maxy = mgetmaxy();

    mmvprintw(maxy - 2, 0, "$ ");
    
    char* cstr = string_c_str(gCmdLine);

    bool kanji_zure = false;
    bool kanji = false;
    int i;
    for(i=0; i<strlen(cstr); i++) {
        char c = cstr[i];

        if(kanji) {
            kanji = false;
        }
        else if(is_kanji(c)) {
            kanji = true;
        }

        if(i+2 == maxx-1) {
            if(kanji) {
                kanji_zure = true;
                break;
            }
        }
    }

    BOOL ruby_cmdline;
    if(strstr(cstr, "%r")) {
        ruby_cmdline = TRUE;
    }
    else {
        ruby_cmdline = FALSE;
    }

    if(kanji_zure) {
        char line1[2048];
        char line2[2048];

        memcpy(line1, cstr, maxx-3);
        line1[maxx-3] = 0;
        strcpy(line2, cstr + maxx-3);

        if(ruby_cmdline) {
            mprintw("%s", line1);
            mmvprintw(maxy -1, 0, "%s", line2);
        }
        else {
            bool cmd = true;
            print_cmdline(line1, &cmd);
            mmove(maxy -1, 0);
            print_cmdline(line2, &cmd);
        }
    }
    else {
        if(ruby_cmdline) {
            mprintw("%s", cstr);
        }
        else {
            bool cmd = true;
            print_cmdline(cstr, &cmd);
        }
    }
/*
    if(kanji_zure) {
        char line1[2048];
        char line2[2048];

        memcpy(line1, cstr, maxx-3);
        line1[maxx-3] = 0;
        strcpy(line2, cstr + maxx-3);

        mprintw("%s", line1);
        mmvprintw(maxy -1, 0, "%s", line2);
    }
    else {
        mprintw(maxy -1, 0, cstr);
    }
*/
    if(kanji_zure) {    
        if(gCmdLineCursor+2 < maxx-1) {
            mmove(maxy -2, 2 + gCmdLineCursor);
        }
        else {
            mmove(maxy-1, 2+ gCmdLineCursor -maxx+1);
        }
    }
    else {
        if(gCmdLineCursor+2 < maxx) {
            mmove(maxy -2, 2 + gCmdLineCursor);
        }
        else {
            mmove(maxy -1, 2 + gCmdLineCursor - maxx);
        }
    }
}


static void cmdline_view_utf8_multi_line()
{
    const int maxx = mgetmaxx();
    const int maxy = mgetmaxy();

    /// vvg` ///
    mclear();

    mmvprintw(0, 0, "$ ");
    
    /// es` ///
    char* cstr = string_c_str(gCmdLine);

    int line = 0;
    char* line_top = cstr;
    int n = 0;
    int n2 = 0;

    int cursor_y = -1;
    int cursor_x = -1;
    while(1) {
        char* line_end = str_utfpos2pointer(line_top, n);

        char buf[4089];
        memcpy(buf, line_top, line_end-line_top);
        buf[line_end-line_top] = 0;

        /// J[\`ʈʒuۑ ///
        if(line_end == cstr+gCmdLineCursor) {
            cursor_y = line;
            cursor_x = str_termlen(buf);
        }
        
        /// šE܂ł ///
        else if(line >= maxy) {
            break;
        }

        /// s̏I܂ŒBĂ ///
        if(line == 0 && (str_termlen(buf)+2 > maxx)
                || line > 0 && (str_termlen(buf) > maxx))
        {
            line_end = str_utfpos2pointer(line_top, n-1);

            memcpy(buf, line_top, line_end-line_top);
            buf[line_end-line_top] = 0;

            if(line == 0) {
                mprintw("%s", buf);
            }
            else {
                mmvprintw(line, 0, "%s", buf);
            }

            line_top = line_end;
            n = 0;
            line++;
        }

        /// ̏I[܂ŒBĂ ///
        else if(!*line_end) {
            if(cursor_x == maxx) {
                cursor_x = 0;
                cursor_y++;
            }

            mmvprintw(line, 0, "%s", line_top);

            break;
        }

        /// ȊO ///
        else {
            n++;
        }
    }

    /// J[\ړ ///
    if(cursor_y == -1 && cursor_x == -1) {
        mmove(maxy-1, maxx-2);
    }
    else if(cursor_y == 0) {
        mmove(cursor_y, cursor_x+2);
    }
    else {
        mmove(cursor_y, cursor_x);
    }
}

static void cmdline_view_utf8_2line()
{
    const int maxx = mgetmaxx();
    const int maxy = mgetmaxy();

    mmvprintw(maxy - 2, 0, "$ ");
    
    char* cstr = string_c_str(gCmdLine);

    bool kanji_zure = false;
    int i;
    for(i=0; i<str_kanjilen(cstr); i++) {
        int termpos = str_termlen2(cstr, i);

        if(termpos+2 == maxx-1) {
            char* pointer = str_utfpos2pointer(cstr, i);
            if(is_kanji(*pointer)) {
                kanji_zure = true;
                break;
            }
        }
    }

    BOOL ruby_cmdline;
    if(strstr(cstr, "%r")) {
        ruby_cmdline = TRUE;
    }
    else {
        ruby_cmdline = FALSE;
    }

    if(kanji_zure) {
        int i;
        for(i=0; i<str_kanjilen(cstr); i++) {
            int termpos = str_termlen2(cstr, i);

            if(termpos+2 == maxx-1) {
                char* pointer = str_utfpos2pointer(cstr, i);

                if(is_kanji(*pointer)) {
                    char line1[2048];

                    memcpy(line1, cstr, pointer-cstr);
                    line1[pointer-cstr] = 0;

                    if(ruby_cmdline) {
                        mprintw("%s", line1);
                        mmvprintw(maxy -1, 0, "%s", pointer);
                    }
                    else {
                        bool cmd = true;
                        print_cmdline(line1, &cmd);
                        mmove(maxy -1, 0);
                        print_cmdline(pointer, &cmd);
                    }

                    break;
                }
            }
        }
    }
    else {
        if(ruby_cmdline) {
            mprintw("%s", cstr);
        }
        else {
            bool cmd = true;
            print_cmdline(cstr, &cmd);
        }
    }

/*
    if(kanji_zure) {
        int i;
        for(i=0; i<str_kanjilen(cstr); i++) {
            int termpos = str_termlen2(cstr, i);

            if(termpos+2 == maxx-1) {
                char* pointer = str_utfpos2pointer(cstr, i);

                if(is_kanji(*pointer)) {
                    char line1[2048];

                    memcpy(line1, cstr, pointer-cstr);
                    line1[pointer-cstr] = 0;

                    mprintw("%s", line1);
                    mmvprintw(maxy -1, 0, "%s", pointer);

                    break;
                }
            }
        }
    }
    else {
        mprintw("%s", cstr);
    }
*/

    int utfpos = str_pointer2utfpos(cstr, cstr + gCmdLineCursor);
    int termpos = str_termlen2(cstr, utfpos);

    if(kanji_zure) {
        if(termpos+2 < maxx-1)
            mmove(maxy -2, 2 + termpos);
        else
            mmove(maxy -1, 2 + termpos - maxx+1);
    }
    else {
        if(termpos+2 < maxx) {
            mmove(maxy -2, 2 + termpos);
        }
        else {
            mmove(maxy -1, 2 + termpos - maxx);
        }
    }
}

static void cmdline_view_utf8()
{
    const int maxx = mgetmaxx();
    const int maxy = mgetmaxy();

    char* cstr = string_c_str(gCmdLine);

    /// ̂ꂪ邩ǂH ///
    bool kanji_zure = false;
    int i;
    for(i=0; i<str_kanjilen(cstr); i++) {
        int termpos = str_termlen2(cstr, i);

        if(termpos+2 == maxx-1) {
            char* pointer = str_utfpos2pointer(cstr, i);
            if(is_kanji(*pointer)) {
                kanji_zure = true;
                break;
            }
        }
    }

    /// [łQsȏ̏ꍇ ///
    const int len = str_termlen(cstr);
    if(kanji_zure && (len+3 >= maxx*2)
            || !kanji_zure && (len+2 >= maxx*2)) 
    {
        cmdline_view_utf8_multi_line();
    }
    /// [łQsȉ̏ꍇ ///
    else {
        cmdline_view_utf8_2line();
    }
}

static void cmdline_view_euc_sjis()
{
    const int maxx = mgetmaxx();
    const int maxy = mgetmaxy();

    char* cstr = string_c_str(gCmdLine);

    /// ̂ꂪ邩ǂH ///
    bool kanji_zure = false;
    int i;
    for(i=0; i<strlen(cstr); i++) {
        if(i==maxx-3 && is_kanji((unsigned char)cstr[i])) {
            kanji_zure = true;
            break;
        }
    }

    /// [łQsȏ̏ꍇ ///
    const int len = strlen(cstr);
    if(kanji_zure && (len+3 >= maxx*2)
            || !kanji_zure && (len+2 >= maxx*2)) 
    {
        cmdline_view_euc_sjis_multi_line();
    }
    /// [łQsȉ̏ꍇ ///
    else {
        cmdline_view_euc_sjis_2line();
    }
}

static void cmdline_view_filer()
{
    const int maxx = mgetmaxx();        // ʃTCY
    const int maxy = mgetmaxy();
    
    char* env = getenv("PROMPT");
    if(env) {
        int pipefds[2];

        if(pipe(pipefds) < 0) {
            perror("pipe");
            exit(1);
        }

        shell(env, "prompt", pipefds[1], FALSE, TRUE, -1);

        string_obj* str = string_new("");
        while(1) {
            char tmp[BUFSIZ];
            int r = read(pipefds[0], tmp, BUFSIZ);
            tmp[r] = 0;

            if(r == 0) break;

            string_push_back(str, tmp);
        }
        close(pipefds[0]);

        mmvprintw(maxy -2, 0, "%s", string_c_str(str));

        if(gISearchExplore) isearch_explore_view();
    }

    /// J[\̃t@C̏` ///          
    char buf[1024];
    sFile* file = filer_cursor_file(adir());

    char permission[12];
    strcpy(permission, "----------");

    if(S_ISDIR(file->mLStat.st_mode)) permission[0] = 'd';  // t@C̎
    if(S_ISCHR(file->mLStat.st_mode)) permission[0] = 'c';
    if(S_ISBLK(file->mLStat.st_mode)) permission[0] = 'b';
    if(S_ISFIFO(file->mLStat.st_mode)) permission[0] = 'p';
    if(S_ISLNK(file->mLStat.st_mode)) permission[0] = 'l';
    if(S_ISSOCK(file->mLStat.st_mode)) permission[0] = 's';

    mode_t smode = file->mLStat.st_mode;        // p[~bV
    if(smode & S_IRUSR) permission[1] = 'r';
    if(smode & S_IWUSR) permission[2] = 'w';
    if(smode & S_IXUSR) permission[3] = 'x';
    if(smode & S_IRGRP) permission[4] = 'r';
    if(smode & S_IWGRP) permission[5] = 'w';
    if(smode & S_IXGRP) permission[6] = 'x';
    if(smode & S_IROTH) permission[7] = 'r';
    if(smode & S_IWOTH) permission[8] = 'w';
    if(smode & S_IXOTH) permission[9] = 'x';
    if(smode & S_ISUID) permission[3] = 's';
    if(smode & S_ISGID) permission[6] = 's';
#if defined(S_ISTXT)
    if(smode & S_ISTXT) permission[9] = 't';
#endif
#if defined(S_ISVTX)
    if(smode & S_ISVTX) permission[9] = 't';
#endif
    
    permission[10] = 0;

    time_t t = file->mLStat.st_mtime;                   // 
    struct tm* tm_ = (struct tm*)localtime(&t);
    
    char buf2[1024];

    char owner[256];
    char* tmp = file->mUser;
    if(tmp) {
        str_cut2(tmp, 8, owner, 256);
    }
    else {
        sprintf(owner, "%d", file->mLStat.st_uid);
    }

    char group[256];
    tmp = file->mGroup;
    if(tmp) {
        str_cut2(tmp, 7, group, 256);
    }
    else {
        sprintf(group, "%d", file->mLStat.st_gid);
    }

    char size_buf[256];
    int width = make_size_str(size_buf, file->mLStat.st_size);

    if(S_ISDIR(file->mStat.st_mode)) {
        strcpy(size_buf, "<DIR>");
    }

    char format[128];
    strcpy(format, "%");
    sprintf(format + strlen(format), "%d", width);
    strcat(format, "s");

    char size_buf2[256];
    sprintf(size_buf2, format, size_buf);

    if(!S_ISLNK(file->mLStat.st_mode)) {
        int year = tm_->tm_year-100;
        if(year < 0) year+=100;
        while(year > 100) year-=100;
        
        sprintf(buf2
            , "%s %3d %-8s %-7s%s %02d-%02d-%02d %02d:%02d %s"
            //, "%s %3d %-8s %-7s%10lld %02d-%02d-%02d %02d:%02d %s"
            , permission, file->mLStat.st_nlink
            , owner, group
                                
            , size_buf2
            
            , year, tm_->tm_mon+1, tm_->tm_mday
            , tm_->tm_hour, tm_->tm_min
            , file->mNameView);
            
        char buf3[1024];
        str_cut2(buf2, maxx-1, buf3, 1024);
                            
        mmvprintw(maxy-1, 0, "%s", buf3);
    }
    else {
        sprintf(buf
           , "%s %3d %s%s%s %02d-%02d-%02d %02d:%02d %s -> %s"
           //, "%s %3d %s%s%10lld %02d-%02d-%02d %02d:%02d %s -> %s"
           , permission, file->mLStat.st_nlink
           , owner, group
                                
           , size_buf2

           , tm_->tm_year-100, tm_->tm_mon+1, tm_->tm_mday
           , tm_->tm_hour, tm_->tm_min
           , file->mNameView
           , file->mLinkTo);
           
        char buf2[1024];
        str_cut2(buf, maxx-1, buf2, 1024);
                   
        mmvprintw(maxy-1, 0, "%s", buf2);
    }

    mmove(maxy-1, maxx-2);
}

void cmdline_view()
{
    if(!gCmdLineActive) {
        cmdline_view_filer();
    }
    else {
        if(gKanjiCode == kUtf8) {
            cmdline_view_utf8();
        }
        else {
            cmdline_view_euc_sjis();
        }
    }
}

void cmdline_history_view()
{
    const int maxx = mgetmaxx();
    const int maxy = mgetmaxy();

    int line = maxy-3;
    int i;
    for(i= gHistoryScrollTop; i<vector_size(gHCandidate); i++) {
        string_obj* item = (string_obj*)vector_item(gHCandidate, i);

        char* tmp = (char*)malloc(sizeof(char)*kCmdLineMax);
        str_cut2(string_c_str(item), maxx-1, tmp, kCmdLineMax);

        if(gHistoryCursor == i) mattron(kCAReverse);        
        mmvprintw(line, 0, "%s", tmp);
        if(gHistoryCursor == i) mattroff();
        line--;
        
        free(tmp);

        if(line < 0) {
            break;
        }
    }
}
