#include "common.h"
#include <dirent.h>

vector_obj* gCCandidate;
static vector_obj* gCExplanation;

static BOOL gCompletionAddSpace;
static BOOL gCompletionSqort;
static BOOL gCompletionDqort;
static BOOL gCompletionLastSqort;
static BOOL gCompletionLastDqort;
static int gCompletionCandidateLen;
static int gEditingLen;
static char gEditing[2048];
static int gCmdLineCompletionMaxRow;

static int gCompletionScrollTop = 0;
static int gCompletionCursor = -1;

vector_obj* gPrograms;             // vO⊮
vector_obj* gEnvirons;             // ϐ⊮

static BOOL name_sort(void* left, void* right)
{
    string_obj* l = left;
    string_obj* r = right;

    return strcmp(string_c_str(l), string_c_str(r)) < 0;
}


///////////////////////////////////////////////////////////////////////////////
// 
///////////////////////////////////////////////////////////////////////////////
void cmdline_completion_init()
{
#if !HAVE_DECL_ENVIRON
    extern char **environ;
#endif
    gCCandidate = vector_new(10);
    gCExplanation = vector_new(10);
    
    gEnvirons = vector_new(100);
    char** p;
    for(p = environ; *p; p++) {
        char env_name[256];

        char* p2 = env_name;
        char* p3 = *p;

        *p2++ = '$';
        while(*p3 != '=') {
            *p2++ = *p3++;
        }

        char* env = getenv(*p);
        struct stat estat;
        if(stat(env, &estat) >= 0) {
            if(S_ISDIR(estat.st_mode)) {
                *p2++ = '/';
            }
        }
        *p2 = 0;

        vector_add(gEnvirons, string_new(env_name));
    }

    vector_sort(gEnvirons, name_sort);
    gPrograms = vector_new(100);
}

///////////////////////////////////////////////////////////////////////////////
// vO⊮ēǂݍ
///////////////////////////////////////////////////////////////////////////////
void cmdline_rehash()
{
    hash_obj* check = hash_new(10);

    gPrograms = vector_new(100);

    /// mfiler3 IWiR}h ///
    vector_add(gPrograms, string_new("keycommand"));
    vector_add(gPrograms, string_new("mfiler3_keycommand"));
    vector_add(gPrograms, string_new("export"));
    vector_add(gPrograms, string_new("mfiler3_export"));
    vector_add(gPrograms, string_new("["));
    vector_add(gPrograms, string_new("mfiler3_["));
    vector_add(gPrograms, string_new("defmenu"));
    vector_add(gPrograms, string_new("mfiler3_defmenu"));
    vector_add(gPrograms, string_new("keymap"));
    vector_add(gPrograms, string_new("mfiler3_keymap"));
    vector_add(gPrograms, string_new("cd"));
    vector_add(gPrograms, string_new("mfiler3_cd"));
    vector_add(gPrograms, string_new("rehash"));
    vector_add(gPrograms, string_new("mfiler3_rehash"));
    vector_add(gPrograms, string_new("menu"));
    vector_add(gPrograms, string_new("mfiler3_menu"));
    vector_add(gPrograms, string_new("mfiler3_view"));
    vector_add(gPrograms, string_new("mfiler3_mfiler3_view"));
    vector_add(gPrograms, string_new("mclear_immediately"));
    vector_add(gPrograms, string_new("mfiler3_mclear_immediately"));
    vector_add(gPrograms, string_new("isearch"));
    vector_add(gPrograms, string_new("mfiler3_isearch"));
    vector_add(gPrograms, string_new("cmdline"));
    vector_add(gPrograms, string_new("mfiler3_cmdline"));
    vector_add(gPrograms, string_new("get_mark"));
    vector_add(gPrograms, string_new("mfiler3_get_mark"));
    vector_add(gPrograms, string_new("set_toggle_mark"));
    vector_add(gPrograms, string_new("mfiler3_set_toggle_mark"));
    vector_add(gPrograms, string_new("set_mark"));
    vector_add(gPrograms, string_new("mfiler3_set_mark"));
    vector_add(gPrograms, string_new("mark_clear"));
    vector_add(gPrograms, string_new("mfiler3_mark_clear"));
    vector_add(gPrograms, string_new("mark_all_files"));
    vector_add(gPrograms, string_new("mfiler3_mark_all_files"));
    vector_add(gPrograms, string_new("mark_all_files_and_directory"));
    vector_add(gPrograms, string_new("mfiler3_mark_all_files_and_directory"));
    vector_add(gPrograms, string_new("sisearch_cache_exist"));
    vector_add(gPrograms, string_new("mfiler3_sisearch_cache_exist"));
    vector_add(gPrograms, string_new("sisearch"));
    vector_add(gPrograms, string_new("mfiler3_sisearch"));
    vector_add(gPrograms, string_new("sisearch_getcache"));
    vector_add(gPrograms, string_new("mfiler3_sisearch_getcache"));
    vector_add(gPrograms, string_new("mask"));
    vector_add(gPrograms, string_new("mfiler3_mask"));
    vector_add(gPrograms, string_new("set_mask"));
    vector_add(gPrograms, string_new("mfiler3_set_mask"));
    vector_add(gPrograms, string_new("set_dotdir_mask"));
    vector_add(gPrograms, string_new("mfiler3_set_dotdir_mask"));
    vector_add(gPrograms, string_new("dotdir_mask"));
    vector_add(gPrograms, string_new("mfiler3_dotdir_mask"));
    vector_add(gPrograms, string_new("redraw"));
    vector_add(gPrograms, string_new("mfiler3_redraw"));
    vector_add(gPrograms, string_new("reread"));
    vector_add(gPrograms, string_new("mfiler3_reread"));
    vector_add(gPrograms, string_new("index"));
    vector_add(gPrograms, string_new("mfiler3_index"));
    vector_add(gPrograms, string_new("rindex"));
    vector_add(gPrograms, string_new("mfiler3_rindex"));
    vector_add(gPrograms, string_new("toggle"));
    vector_add(gPrograms, string_new("mfiler3_toggle"));
    vector_add(gPrograms, string_new("chomp"));
    vector_add(gPrograms, string_new("mfiler3_chomp"));
    vector_add(gPrograms, string_new("set_sort_kind"));
    vector_add(gPrograms, string_new("mfiler3_set_sort_kind"));
    vector_add(gPrograms, string_new("sort_kind"));
    vector_add(gPrograms, string_new("mfiler3_sort_kind"));
    vector_add(gPrograms, string_new("sort_markup"));
    vector_add(gPrograms, string_new("mfiler3_sort_markup"));
    vector_add(gPrograms, string_new("set_sort_markup"));
    vector_add(gPrograms, string_new("mfiler3_set_sort_markup"));
    vector_add(gPrograms, string_new("toggle_sort_markup"));
    vector_add(gPrograms, string_new("mfiler3_toggle_sort_markup"));
    vector_add(gPrograms, string_new("sort_dirup"));
    vector_add(gPrograms, string_new("mfiler3_sort_dirup"));
    vector_add(gPrograms, string_new("toggle_sort_dirup"));
    vector_add(gPrograms, string_new("mfiler3_toggle_sort_dirup"));
    vector_add(gPrograms, string_new("set_sort_dirup"));
    vector_add(gPrograms, string_new("mfiler3_set_sort_dirup"));
    vector_add(gPrograms, string_new("sort"));
    vector_add(gPrograms, string_new("mfiler3_sort"));
    vector_add(gPrograms, string_new("load"));
    vector_add(gPrograms, string_new("mfiler3_load"));
    vector_add(gPrograms, string_new("eval"));
    vector_add(gPrograms, string_new("mfiler3_eval"));
    vector_add(gPrograms, string_new("vdfinish"));
    vector_add(gPrograms, string_new("mfiler3_vdfinish"));
    vector_add(gPrograms, string_new("open"));
    vector_add(gPrograms, string_new("mfiler3_open"));
    vector_add(gPrograms, string_new("close"));
    vector_add(gPrograms, string_new("mfiler3_close"));
    vector_add(gPrograms, string_new("vd"));
    vector_add(gPrograms, string_new("mfiler3_vd"));
    vector_add(gPrograms, string_new("vd2"));
    vector_add(gPrograms, string_new("mfiler3_vd2"));
    vector_add(gPrograms, string_new("read"));
    vector_add(gPrograms, string_new("mfiler3_read"));
    vector_add(gPrograms, string_new("print"));
    vector_add(gPrograms, string_new("mfiler3_print"));
    vector_add(gPrograms, string_new("fg"));
    vector_add(gPrograms, string_new("mfiler3_fg"));
    vector_add(gPrograms, string_new("bg"));
    vector_add(gPrograms, string_new("mfiler3_bg"));
    vector_add(gPrograms, string_new("new_dir"));
    vector_add(gPrograms, string_new("mfiler3_new_dir"));
    vector_add(gPrograms, string_new("del_dir"));
    vector_add(gPrograms, string_new("mfiler3_del_dir"));
    vector_add(gPrograms, string_new("dir_num"));
    vector_add(gPrograms, string_new("mfiler3_dir_num"));
    vector_add(gPrograms, string_new("path"));
    vector_add(gPrograms, string_new("mfiler3_path"));
    vector_add(gPrograms, string_new("cursor"));
    vector_add(gPrograms, string_new("mfiler3_cursor"));
    vector_add(gPrograms, string_new("kanjicode"));
    vector_add(gPrograms, string_new("mfiler3_kanjicode"));
    vector_add(gPrograms, string_new("adir"));
    vector_add(gPrograms, string_new("mfiler3_adir"));
    vector_add(gPrograms, string_new("sdir"));
    vector_add(gPrograms, string_new("mfiler3_sdir"));
    vector_add(gPrograms, string_new("job_name"));
    vector_add(gPrograms, string_new("mfiler3_job_name"));
    vector_add(gPrograms, string_new("markfiles"));
    vector_add(gPrograms, string_new("mfiler3_markfiles"));
    vector_add(gPrograms, string_new("job_num"));
    vector_add(gPrograms, string_new("mfiler3_job_num"));
    vector_add(gPrograms, string_new("file_name"));
    vector_add(gPrograms, string_new("mfiler3_file_name"));
    vector_add(gPrograms, string_new("file_ext"));
    vector_add(gPrograms, string_new("mfiler3_file_ext"));
    vector_add(gPrograms, string_new("file_index"));
    vector_add(gPrograms, string_new("mfiler3_file_index"));
    vector_add(gPrograms, string_new("file_user"));
    vector_add(gPrograms, string_new("mfiler3_filer_user"));
    vector_add(gPrograms, string_new("file_group"));
    vector_add(gPrograms, string_new("mfiler3_filer_group"));
    vector_add(gPrograms, string_new("file_perm"));
    vector_add(gPrograms, string_new("mfiler3_filer_permission"));
    vector_add(gPrograms, string_new("file_num"));
    vector_add(gPrograms, string_new("mfiler3_file_num"));
    vector_add(gPrograms, string_new("row"));
    vector_add(gPrograms, string_new("mfiler3_row"));
    vector_add(gPrograms, string_new("row_max"));
    vector_add(gPrograms, string_new("mfiler3_row_max"));
    vector_add(gPrograms, string_new("line_max"));
    vector_add(gPrograms, string_new("mfiler3_line_max"));
    vector_add(gPrograms, string_new("fcolor"));
    vector_add(gPrograms, string_new("mfiler3_fcolor"));
    vector_add(gPrograms, string_new("init256"));
    vector_add(gPrograms, string_new("mfiler3_init256"));
    vector_add(gPrograms, string_new("final256"));
    vector_add(gPrograms, string_new("mfiler3_final256"));
    vector_add(gPrograms, string_new("activate"));
    vector_add(gPrograms, string_new("mfiler3_activate"));
    vector_add(gPrograms, string_new("length"));
    vector_add(gPrograms, string_new("mfiler3_length"));
    vector_add(gPrograms, string_new("msg"));
    vector_add(gPrograms, string_new("mfiler3_msg"));
    vector_add(gPrograms, string_new("cursor_right"));
    vector_add(gPrograms, string_new("mfiler3_cursor_right"));
    vector_add(gPrograms, string_new("cursor_left"));
    vector_add(gPrograms, string_new("mfiler3_cursor_left"));
    vector_add(gPrograms, string_new("cursor_move"));
    vector_add(gPrograms, string_new("mfiler3_cursor_move"));
    vector_add(gPrograms, string_new("exit"));
    vector_add(gPrograms, string_new("mfiler3_exit"));
    vector_add(gPrograms, string_new("input"));
    vector_add(gPrograms, string_new("mfiler3_input"));
    vector_add(gPrograms, string_new("msg"));
    vector_add(gPrograms, string_new("mfiler3_msg"));
    vector_add(gPrograms, string_new("choice"));
    vector_add(gPrograms, string_new("mfiler3_choice"));
    vector_add(gPrograms, string_new("selector"));
    vector_add(gPrograms, string_new("mfiler3_selector"));
    vector_add(gPrograms, string_new("mcp"));
    vector_add(gPrograms, string_new("mfiler3_mcp"));
    vector_add(gPrograms, string_new("mmv"));
    vector_add(gPrograms, string_new("mfiler3_mmv"));
    vector_add(gPrograms, string_new("mrm"));
    vector_add(gPrograms, string_new("mfiler3_mrm"));
    vector_add(gPrograms, string_new("let"));
    vector_add(gPrograms, string_new("mfiler3_let"));
    vector_add(gPrograms, string_new("related_prog"));
    vector_add(gPrograms, string_new("mfiler3_related_prog"));
    vector_add(gPrograms, string_new("set_related_prog"));
    vector_add(gPrograms, string_new("mfiler3_set_related_prog"));
    vector_add(gPrograms, string_new("related_prog_num"));
    vector_add(gPrograms, string_new("mfiler3_related_prog_num"));
    vector_add(gPrograms, string_new("related_prog_prog"));
    vector_add(gPrograms, string_new("mfiler3_related_prog_prog"));
    vector_add(gPrograms, string_new("related_prog_ext"));
    vector_add(gPrograms, string_new("mfiler3_related_prog_ext"));
    vector_add(gPrograms, string_new("hadd"));
    vector_add(gPrograms, string_new("mfiler3_hadd"));
    vector_add(gPrograms, string_new("hnumber"));
    vector_add(gPrograms, string_new("mfiler3_hnumber"));
    vector_add(gPrograms, string_new("focus"));
    vector_add(gPrograms, string_new("mfiler3_focus"));
    vector_add(gPrograms, string_new("unfocus"));
    vector_add(gPrograms, string_new("mfiler3_unfocus"));
    vector_add(gPrograms, string_new("archive_title"));
    vector_add(gPrograms, string_new("mfiler3_archive_title"));
    vector_add(gPrograms, string_new("set_archive_title"));
    vector_add(gPrograms, string_new("mfiler3_set_archive_title"));
    vector_add(gPrograms, string_new("ary_erase"));
    vector_add(gPrograms, string_new("mfiler3_erase"));
    vector_add(gPrograms, string_new("ary_insert"));
    vector_add(gPrograms, string_new("mfiler3_ary_insert"));
    vector_add(gPrograms, string_new("ary_add"));
    vector_add(gPrograms, string_new("mfiler3_ary_add"));
    vector_add(gPrograms, string_new("ary_new"));
    vector_add(gPrograms, string_new("mfiler3_ary_new"));
    vector_add(gPrograms, string_new("ary_length"));
    vector_add(gPrograms, string_new("mfiler3_ary_length"));

    /// [U[IWi֐ ///
    int i;
    for(i=0; i<vector_size(gFuncs2); i++) {
        vector_add(gPrograms, vector_item(gFuncs2, i));
    }

    /// $PATHɂt@CSgProgramsɓĂ ///
    char* path = getenv("PATH");
    if(path == NULL) {
        fprintf(stderr, "$PATH is NULL\n");
        exit(1);
    }

    char* p = path;
    char buf[512];
    char* p2 = buf;

    while(*p) {
        if(*p != ':') {
            *p2++ = *p;
        }
        else {
            *p2 = 0;

            DIR* dir = opendir(buf);
            if(dir) {
                struct dirent* entry;
                while(entry = readdir(dir)) {
                    char path2[512];
                    sprintf(path2, "%s/%s", buf, entry->d_name);

                    struct stat stat_;
                    memset(&stat_, 0, sizeof(struct stat));
                    stat(path2, &stat_);

#if defined(__CYGWIN__)
                    if(strcmp(entry->d_name, ".") != 0
                            && strcmp(entry->d_name, "..") != 0)
                    {
                        if(strstr(entry->d_name, ".exe")) {
                            char tmp[PATH_MAX];
                            memcpy(tmp
                                , entry->d_name
                                , strstr(entry->d_name, ".exe") - entry->d_name
                                );
                            tmp[strstr(entry->d_name, ".exe") - entry->d_name]
                             = 0;

                            if(hash_item(check, tmp) == NULL) {
                                hash_put(check, tmp, (void*)1);
                                vector_add(gPrograms, string_new(tmp));
                            }
                        }
                        else if(strstr(entry->d_name, ".EXE")) {
                            char tmp[PATH_MAX];
                            memcpy(tmp
                                , entry->d_name
                                , strstr(entry->d_name, ".EXE") - entry->d_name
                                );
                            tmp[strstr(entry->d_name, ".EXE") - entry->d_name]
                             = 0;


                            if(hash_item(check, tmp) == NULL) {
                                hash_put(check, tmp, (void*)1);
                                vector_add(gPrograms, string_new(tmp));
                            }
                        }
#else
                    if(strcmp(entry->d_name, ".") != 0
                            && strcmp(entry->d_name, "..") != 0
                            &&
                            (stat_.st_mode & S_IXUSR
                             ||stat_.st_mode & S_IXGRP
                             ||stat_.st_mode & S_IXOTH))
                    {
                        if(hash_item(check, entry->d_name) == NULL) {
                            hash_put(check, entry->d_name, (void*)1);
                            vector_add(gPrograms, string_new(entry->d_name));
                        }
#endif
                    }
                }

                closedir(dir);
            }

            p2 = buf;
        }

        p++;
    }

    *p2 = 0;

    DIR* dir = opendir(buf);
    if(dir) {
        struct dirent* entry;
        while(entry = readdir(dir)) {
            if(strcmp(entry->d_name, ".") != 0
                    && strcmp(entry->d_name, "..") != 0)
            {
                vector_add(gPrograms, string_new(entry->d_name));
            }
        }

        closedir(dir);
    }

/*
    /// gProgramsɃGCAX ///    
    const int len = vector_size(gAlias);
    for(int i=0; i<len; i++) {
        sAlias* alias = (sAlias*)vector_item(gAlias, i);

        vector_add(gPrograms, rb_str_new2(alias->mAlias));
    }
*/
    vector_sort(gPrograms, name_sort);
}

///////////////////////////////////////////////////////////////////////////////
// R}hC⊮NA
///////////////////////////////////////////////////////////////////////////////
void cmdline_completion_clear()
{
    vector_clear(gCCandidate);
    vector_clear(gCExplanation);
}

///////////////////////////////////////////////////////////////////////////////
// R}hC⊮1
///////////////////////////////////////////////////////////////////////////////
void cmdline_completion(vector_obj* all_candidate, char* editing, BOOL add_space)
{
    string_obj* str = gCmdLine;
    char* cstr = string_c_str(str);

    /// go ///
    gCompletionAddSpace = add_space;

    gEditingLen = strlen(editing);
    strcpy(gEditing, editing);

    cmdline_completion_clear();

    if(strcmp(editing, "") == 0) {
        int i;
        for(i=0; i<vector_size(all_candidate); i++) {
            string_obj* str = vector_item(all_candidate, i);
            vector_add(gCCandidate , string_new(string_c_str(str)));
        }
    }
    else {
        int i;
        for(i=0; i<vector_size(all_candidate); i++) {
            char* item = string_c_str(vector_item(all_candidate, i));

            if(strstr(item, editing) == item) {
                vector_add(gCCandidate, string_new(item));
            }
        }
    }

    if(vector_size(gCCandidate) > 0) {
        int l = strlen(editing);

        const int len = strlen(string_c_str(vector_item(gCCandidate, 0)));
        char c = 0;
        BOOL kanji = FALSE;
        while(l < len) {
            BOOL same = TRUE;

            int i;
            for(i= 0; i<vector_size(gCCandidate); i++) {
                char* item = string_c_str(vector_item(gCCandidate, i));

                if(item[l] != (string_c_str(vector_item(gCCandidate, 0)))[l]) {
                    same = FALSE;
                }
            }

            if(same) {
                char tmp[256];
                c = (string_c_str(vector_item(gCCandidate, 0)))[l];
                
                BOOL kanji_before = kanji;
                if(gKanjiCode != kUtf8) {
                    if(kanji) {
                        kanji = FALSE;
                    }
                    else {
                        if(is_kanji(c)) {
                            kanji = TRUE;
                        }
                    }
                }

                if(!gCompletionSqort && !gCompletionDqort && (gKanjiCode==kUtf8 || !kanji_before) && (c==' ' || c=='!' || c=='*' || c=='>' || c=='&' || c=='~' || c=='#' || c =='$' || c=='(' || c==')' || c=='\\' || c=='|' || c=='[' || c==']' || c=='{' || c=='}' || c==';' || c=='\'' || c=='"' || c=='<' || c=='>' || c=='?'))
                {
                    sprintf(tmp, "\\%c", c);
                    string_insert(str, gCmdLineCursor, tmp);
                    gCmdLineCursor+=2;

                    gEditingLen++;
                    sprintf(gEditing + strlen(gEditing), "%c", c);
                }
                else {
                    sprintf(tmp, "%c", c);
                    string_insert(str, gCmdLineCursor, tmp);
                    gCmdLineCursor++;

                    gEditingLen++;
                    strcat(gEditing, tmp);
                }
            }
            else {
                break;
            }

            l++;
        }

        if(kanji) {
            gCmdLineCursor--;
            string_erase(str, gCmdLineCursor, 1);
            gEditingLen--;
            gEditing[strlen(gEditing)-1] = 0;
        }

        if(l == len && vector_size(gCCandidate) == 1) {
            if(c != '/') {
                if(gCompletionSqort && !gCompletionLastSqort) {
                    char tmp[128];
                    sprintf(tmp, "' ");
                    string_insert(str, gCmdLineCursor, tmp);
                    gCmdLineCursor+=2;
                }
                else if(gCompletionDqort && !gCompletionLastDqort) {
                    char tmp[128];
                    sprintf(tmp, "\" ");
                    string_insert(str, gCmdLineCursor, tmp);
                    gCmdLineCursor+=2;
                }
                else if(gCompletionAddSpace && !gCompletionLastSqort
                        && !gCompletionLastDqort)
                {
                    char tmp[128];
                    sprintf(tmp, " ");
                    string_insert(str, gCmdLineCursor, tmp);
                    gCmdLineCursor++;
                }
            }

            cmdline_completion_clear();
        }
    }
}

///////////////////////////////////////////////////////////////////////////////
// R}hC⊮2
///////////////////////////////////////////////////////////////////////////////
void cmdline_completion2(vector_obj* all_candidate, char* editing, bool add_space, int candidate_len)
{
    string_obj* str = gCmdLine;
    char* cstr = string_c_str(str);

    /// go ///
    gCompletionAddSpace = add_space;
    gCompletionCandidateLen = candidate_len;
    gEditingLen = strlen(editing);
    strcpy(gEditing, editing);

    cmdline_completion_clear();

    if(strcmp(editing, "") == 0) {
        int i;
        for(i=0; i<vector_size(all_candidate); i++) {
            vector_obj* array = vector_item(all_candidate, i);

            vector_add(gCCandidate, vector_item(array, 0));
            vector_add(gCExplanation, vector_item(array, 1));
        }
    }
    else {
        int i;
        for(i=0; i<vector_size(all_candidate); i++) {
            vector_obj* array = vector_item(all_candidate, i);

            if(strstr(string_c_str(vector_item(array, 0)), editing) == string_c_str(vector_item(array, 0)))
            {
                vector_add(gCCandidate, vector_item(array, 0));
                vector_add(gCExplanation, vector_item(array, 1));
            }
        }
    }

    if(vector_size(gCCandidate) > 0) {
        int l = strlen(editing);

        const int len = strlen((char*)vector_item(gCCandidate, 0));
        char c = 0;
        bool kanji = false;
        while(l < len) {
            bool same = true;

            int i;
            for(i= 0; i<vector_size(gCCandidate); i++) {
                char* item = (char*)vector_item(gCCandidate, i);

                if(item[l] != ((char*)vector_item(gCCandidate, 0))[l]) {
                    same = false;
                }
            }

            if(same) {
                char tmp[256];
                c = ((char*)vector_item(gCCandidate, 0))[l];
                
                bool kanji_before = kanji;
                if(gKanjiCode != kUtf8) {
                    if(kanji) {
                        kanji = false;
                    }
                    else {
                        if(is_kanji(c)) {
                            kanji = true;
                        }
                    }
                }

                if(!gCompletionSqort && !gCompletionDqort && (gKanjiCode==kUtf8 || !kanji_before) && (c==' ' || c=='!' || c=='*' || c=='>' || c=='&' || c=='~' || c=='#' || c =='$' || c=='(' || c==')' || c=='\\' || c=='|' || c=='[' || c==']' || c=='{' || c=='}' || c==';' || c=='\'' || c=='"' || c=='<' || c=='>' || c=='?'))
                {
                    sprintf(tmp, "\\%c", c);
                    string_insert(str, gCmdLineCursor, tmp);
                    gCmdLineCursor+=2;

                    gEditingLen++;
                    sprintf(gEditing + strlen(gEditing), "%c", c);
                }
                else {
                    sprintf(tmp, "%c", c);
                    string_insert(str, gCmdLineCursor, tmp);
                    gCmdLineCursor++;

                    gEditingLen++;
                    strcat(gEditing, tmp);
                }
            }
            else {
                break;
            }

            l++;
        }

        if(kanji) {
            gCmdLineCursor--;
            string_erase(str, gCmdLineCursor, 1);
            gEditingLen--;
            gEditing[strlen(gEditing)-1] = 0;
        }

        if(l == len && vector_size(gCCandidate) == 1 && c != '/') {
            if(c != '/') {
                if(gCompletionSqort && !gCompletionLastSqort) {
                    char tmp[128];
                    sprintf(tmp, "' ");
                    string_insert(str, gCmdLineCursor, tmp);
                    gCmdLineCursor+=2;
                }
                else if(gCompletionDqort && !gCompletionLastDqort) {
                    char tmp[128];
                    sprintf(tmp, "\" ");
                    string_insert(str, gCmdLineCursor, tmp);
                    gCmdLineCursor+=2;
                }
                else if(gCompletionAddSpace && !gCompletionLastSqort
                        && !gCompletionLastDqort)
                {
                    char tmp[128];
                    sprintf(tmp, " ");
                    string_insert(str, gCmdLineCursor, tmp);
                    gCmdLineCursor++;
                }
            }

            cmdline_completion_clear();
        }
    }
}

///////////////////////////////////////////////////////////////////////////////
// t@C̕⊮
///////////////////////////////////////////////////////////////////////////////
void cmdline_completion_file(char* editing_dir, char* editing_file, char* editing, int editing_position)
{
    char editing_dir2[kCmdLineMax];
    strcpy(editing_dir2, editing_dir);

    /// editing_dir݂Ȃ ///
    if(strcmp(editing_dir2, "") != 0) {
        /// ϐn܂Ăꍇ ///
        if(editing_dir2[0] == '$') {
            char new_editing_dir[kCmdLineMax];
            char env_name[256];

            char *p = editing_dir2;
            p++;
            
            
            char *p2 = env_name;
            
            
            while(*p != '/') {
                *p2++ = *p++;                
            }
            *p2 = 0;
            
            char* env = getenv(env_name);
            if(env) {
                strcpy(new_editing_dir, env);
                strcat(new_editing_dir, p);

                strcpy(editing_dir2, new_editing_dir);
            }
        }

        /// `_n܂Ăꍇ ///
        else if(editing_dir2[0] == '~') {
            char new_editing_dir[kCmdLineMax];

            char* p = editing_dir2;
            p++;

            strcpy(new_editing_dir, getenv("HOME"));
            strcat(new_editing_dir, p);

            strcpy(editing_dir2, new_editing_dir);
        }

        DIR* dir = opendir(editing_dir2);
        vector_obj* files = vector_new(10);

        if(dir) {
            struct dirent* entry;
            while(entry = readdir(dir)) {
                if(strcmp(entry->d_name, ".") != 0
                        && strcmp(entry->d_name, "..") != 0)
                {
                    char buf[PATH_MAX];

                    struct stat _stat;
                    strcpy(buf, editing_dir2);
                    strcat(buf, entry->d_name);
                    stat(buf, &_stat);

                    strcpy(buf, entry->d_name);
                    if(S_ISDIR(_stat.st_mode)) {
                        strcat(buf, "/");
                    }

                    vector_add(files, string_new(buf));
                }
            }

            closedir(dir);

            vector_sort(files,name_sort);

            cmdline_completion(files, editing_file, TRUE);
        }
    }
    /// not exist editing_dir ///
    else {
        /// editing enverion ///
        if(editing[0] == '$') {
            cmdline_completion(gEnvirons, editing, TRUE);
        }
        else if(editing[0] == '~') {
            vector_obj* tilda = vector_new(10);
            vector_add(tilda, string_new("~/"));

            cmdline_completion(tilda, editing, TRUE);
        }
        else {
            DIR* dir = opendir(".");
            vector_obj* files = vector_new(100);

            if(dir) {
                struct dirent* entry;
                while(entry = readdir(dir)) {
                    if(strcmp(entry->d_name, ".") != 0
                            && strcmp(entry->d_name, "..") != 0)
                    {
                        char buf[PATH_MAX];

                        struct stat _stat;
                        strcpy(buf, "./");
                        strcat(buf, entry->d_name);
                        stat(buf, &_stat);

                        strcpy(buf, entry->d_name);
                        if(S_ISDIR(_stat.st_mode)) {
                            strcat(buf, "/");
                        }
                        vector_add(files, string_new(buf));
                    }
                }

                closedir(dir);

                vector_sort(files, name_sort);
                cmdline_completion(files, editing_file, TRUE);
            }
        }
    }
}

///////////////////////////////////////////////////////////////////////////////
// vO̕⊮
///////////////////////////////////////////////////////////////////////////////
void cmdline_completion_program(char* editing_dir, char* editing_file, char* editing, int editing_position)
{
    if(strcmp(editing_dir, "") != 0) {
        cmdline_completion_file(editing_dir, editing_file, editing, editing_position);
    }
    else {
        cmdline_completion(gPrograms, editing, TRUE);
    }
}

///////////////////////////////////////////////////////////////////////////////
// R}hCp[X
///////////////////////////////////////////////////////////////////////////////
void cmdline_parse(char* cmdname, char* editing, char* editing_before, char* editing_dir, char* editing_file, int* editing_position, vector_obj** earray, BOOL* squote, BOOL* dquote, BOOL* last_squote, BOOL* last_dquote)
{
    char* cmdline = string_c_str(gCmdLine);

    BOOL qort = FALSE;
    char* p = cmdline;
    char* e = editing;

    *e = 0;
    *editing_position = 0;
    strcpy(cmdname, "");
    strcpy(editing_before, "");
    *squote = FALSE;
    *dquote = FALSE;
    *last_squote = FALSE;
    *last_dquote = FALSE;
   
    *earray = vector_new(10);
   
    while(*p && *p == ' ') p++;

    while(*p && (p-cmdline)<gCmdLineCursor) {
        if(*dquote && (*p == '`' || *(p-1)=='$' && *p=='(' )) {
            *dquote = FALSE;
        }
        
        if(!*squote && !*dquote && *p=='\\') {
            p++;

            qort = TRUE;
        }
        else if(!*dquote && !qort && *p=='\'') {
            p++;

            *squote = !*squote;
        }
        else if(!*squote && !qort && *p=='"') {
            p++;

            *dquote = !*dquote;
        }
        else if(!*squote && !*dquote && !qort && *p == ' ') {
            p++;

            *e = 0;
            vector_add(*earray, string_new(editing));
            strcpy(editing_before, editing);

            if(strcmp(editing, "do") == 0 || strcmp(editing, "then") == 0
                    || strcmp(editing, "else") == 0)
            {
                *editing_position = 0;
                *earray = vector_new(10);
            }
            else {
                if(editing[0] != '%' && editing[0] != '-') {
                    if(*editing_position == 0) strcpy(cmdname, editing);
                    (*editing_position)++;
                }
            }

            e = editing;

            while(*p && *p == ' ') p++;
        }
        else if(!qort && !*squote && !*dquote && (*p==',' || *p=='>'|| *p=='<'))
        {
            p++;

            *e = 0;
            vector_add(*earray, string_new(editing));
            strcpy(editing_before, editing);

            if(editing[0] != '%' && editing[0] != '-') {
                if(*editing_position == 0) strcpy(cmdname, editing);
                (*editing_position)++;
            }

            e = editing;

            while(*p && *p == ' ') p++;
        }
        else if(!qort && !*squote && !*dquote && (*p == '|' || *p == ';' || *p == '&' || *p=='(' || *p=='`'))
        {
            p++;

            *e = 0;
            vector_add(*earray, string_new(editing));
            strcpy(editing_before, editing);

            e = editing;

            strcpy(cmdname, "");                
            *editing_position = 0;
            *earray = vector_new(10);
 
            while(*p && *p == ' ') p++;
        }
        else {
            *e++ = *p++;

            qort = FALSE;
        }
    }
    *e = 0;
    vector_add(*earray, string_new(editing));
    //strcpy(editing_before, editing);
    if(editing[0] != '%' && editing[0] != '-')
    {
        if(*editing_position == 0) strcpy(cmdname, editing);
    }

    if(strlen(cmdline) >= gCmdLineCursor && cmdline[gCmdLineCursor] == '\'') {
        *last_squote = TRUE;
    }

    if(strlen(cmdline) >= gCmdLineCursor && cmdline[gCmdLineCursor] == '"') {
        *last_dquote = TRUE;
    }

    /// divide editing into dir part and file part ///
    strcpy(editing_dir, "");
    strcpy(editing_file, "");

    e = editing + strlen(editing);
    while(e >= editing) {
        if(*e == '/') {
            memcpy(editing_dir, editing, e - editing + 1);
            editing_dir[e-editing + 1] = 0;

            memcpy(editing_file, e + 1, editing + strlen(editing) - e);
            editing_file[editing + strlen(editing) -e] = 0;
            break;
        }

        e--;
    }

    if(strcmp(editing_dir, "") == 0) {
        strcpy(editing_file, editing);
    }
}

///////////////////////////////////////////////////////////////////////////////
// R}hCŃ^uꂽ̏
///////////////////////////////////////////////////////////////////////////////
void cmdline_completion_main()
{
    char* cmdline = string_c_str(gCmdLine);

    if(vector_size(gCCandidate) > 0)
    {
        gCompletionScrollTop = 0;
        gCompletionCursor = 0;
    }
    else {
        /// R}hCp[X ///
        int editing_position;
        char cmdname[kCmdLineMax];
        char editing[kCmdLineMax];
        char editing_before[kCmdLineMax];
        vector_obj* earray;
        BOOL squote;
        BOOL dquote;
        BOOL last_squote;
        BOOL last_dquote;
        char editing_dir[kCmdLineMax];
        char editing_file[kCmdLineMax];

        cmdline_parse(cmdname, editing, editing_before, editing_dir, editing_file, &editing_position, &earray, &squote, &dquote, &last_squote, &last_dquote);

        gCompletionScrollTop = 0;

        gCompletionSqort = squote;
        gCompletionDqort = dquote;
        gCompletionLastSqort = last_squote;
        gCompletionLastDqort = last_dquote;

        /// earray  Ruby ///
        VALUE earray_rb = rb_ary_new();

        int i;
        for(i=0; i<vector_size(earray); i++) {
            rb_ary_push(earray_rb, rb_str_new2(string_c_str(vector_item(earray, i))));
        }

        /// Rubyxɍs ///
        rb_funcall(rb_cObject, rb_intern("completion_hook"), 7, rb_str_new2(editing), rb_str_new2(editing_dir), rb_str_new2(editing_file), rb_str_new2(editing_before), earray_rb, rb_str_new2(cmdname), INT2NUM(editing_position));
/*
        if(editing_position == 0) {
            cmdline_completion_program(editing_dir, editing_file, editing
                                , editing_position);
        }
        else {
            cmdline_completion_file(editing_dir, editing_file, editing
                                    , editing_position);
        }
*/

        /// gCmdLineCompletionMaxRow𓾂 ///
        const int maxx = mgetmaxx();
        const int maxy = mgetmaxy();

        gCmdLineCompletionMaxRow = 10;
        for(i=0; i<vector_size(gCCandidate); i++) {
            char* str = string_c_str(vector_item(gCCandidate, i));
            if(str_termlen(str) > maxx/gCmdLineCompletionMaxRow) {
                int j=0;
                for(j=gCmdLineCompletionMaxRow; j>=1; j--) {
                    if(str_termlen(str) < maxx/j) {
                        break;
                    }
                }
                gCmdLineCompletionMaxRow = j;
            }
        }
    }
}

///////////////////////////////////////////////////////////////////////////////
// `
///////////////////////////////////////////////////////////////////////////////
void cmdline_completion_view()
{
    const int maxx = mgetmaxx();
    const int maxy = mgetmaxy();

    if(vector_size(gCExplanation) == 0) {   
        int row = 0;
        int line = 0;
        int i;
        for(i= gCompletionScrollTop; i<vector_size(gCCandidate); i++) {
            char* item = (char*)string_c_str(vector_item(gCCandidate, i));

            if(row == gCmdLineCompletionMaxRow) {
                row = 0;
                line++;
            }

            if(line >= maxy-2) break;

            int editing_len;
            if(gKanjiCode == kUtf8) {
                editing_len = str_termlen(gEditing);
            }
            else {
                editing_len = strlen(gEditing);
            }
            int editing_len2 = strlen(gEditing);

            if(editing_len < maxx/gCmdLineCompletionMaxRow-1) {
                char tmp[4096];
                str_cut2(item, editing_len, tmp, 4096);

                char tmp2[4096];
                str_cut2(item + editing_len2, maxx/gCmdLineCompletionMaxRow-1-editing_len, tmp2, 4096);

                if(gCompletionCursor == i) {
                    mattron(kCAReverse);
                    mmvprintw(line, row * (maxx/gCmdLineCompletionMaxRow), "%s", tmp);
                    mprintw("%s", tmp2);
                    mattroff();
                }
                else {
                    char* env = getenv("COLOR");
                    if(strcmp(env, "1") == 0) mattron(kCACyan); else mattron(kCABold);
                    mmvprintw(line, row * (maxx/gCmdLineCompletionMaxRow), "%s", tmp);
                    mattroff();
                    mprintw("%s", tmp2);
                }

                row++;
            }
            else {
                char tmp[4096];
                str_cut2(item, maxx/gCmdLineCompletionMaxRow-1, tmp, 4096);

                if(gCompletionCursor == i) {
                    mattron(kCAReverse);
                    mmvprintw(line, row * (maxx/gCmdLineCompletionMaxRow), "%s", tmp);
                    mattroff();
                }
                else {
                    char* env = getenv("COLOR");
                    if(strcmp(env, "1") == 0) 
                        mattron(kCACyan); 
                    else 
                        mattron(kCABold);
                    mmvprintw(line, row * (maxx/gCmdLineCompletionMaxRow), "%s", tmp);
                    mattroff();
                }

                row++;
            }
        }
    }
    else {
        int line = 0;
        int i;
        for(i= gCompletionScrollTop; i<vector_size(gCCandidate); i++) {
            char* item = (char*)string_c_str(vector_item(gCCandidate, i));
            char* explanation = (char*)string_c_str(
                            vector_item(gCExplanation, i));

            char tmp[256];
            sprintf(tmp, "%%-%ds %%s", gCompletionCandidateLen);

            char buf[4096];
            sprintf(buf, tmp, item, explanation);

            char tmp2[4096];
            str_cut2(buf, maxx-1, tmp2, 256);

            if(gCompletionCursor == i) mattron(kCAReverse);        
            mmvprintw(line, 0, "%s", tmp2);
            if(gCompletionCursor == i) mattroff();
            line++;

            if(line >= maxy-2) break;
        }
    }
}

///////////////////////////////////////////////////////////////////////////////
// ͏
///////////////////////////////////////////////////////////////////////////////
void cmdline_completion_input(int meta, int key)
{
    if(key == 14 || key == KEY_DOWN) {    // CTRL-N
        if(vector_size(gCExplanation) == 0) 
            gCompletionCursor+=gCmdLineCompletionMaxRow;
        else
            gCompletionCursor++;
    }
    else if(key == 16 || key == KEY_UP) {    //CTRL-P
        if(vector_size(gCExplanation) == 0)
            gCompletionCursor-=gCmdLineCompletionMaxRow;
        else
            gCompletionCursor--;
    }
    else if(key == 6 || key == KEY_RIGHT) {    // CTRL-F
        gCompletionCursor++;
    }
    else if(key == 2 || key == KEY_LEFT) {    // CTRL-B
        gCompletionCursor--;
    }
    else if(key == 9) {    // CTRL-I
        gCompletionCursor++;
    }
    // CTRL-J CTRL-M
    else if((key == 10 || key == 13) && gCompletionCursor != -1) {
        char* candidate = (char*)string_c_str(
                            vector_item(gCCandidate, gCompletionCursor));

        BOOL kanji[2048];
        if(gKanjiCode != kUtf8) {
            BOOL kanji_ = FALSE;
            int i;
            for(i=0; i<strlen(candidate); i++) {
                if(kanji_) {
                    kanji_ = FALSE;
                }
                else {
                    if(is_kanji(candidate[i])) {
                        kanji_ = TRUE;
                    }
                }

                kanji[i] = kanji_;
            }
        }

        char tmp[2048];
        char* p = tmp;
        int i;
        for(i=gEditingLen; i<strlen(candidate); i++) {
            char c = candidate[i];
            
            if(!gCompletionSqort && !gCompletionDqort && (gKanjiCode==kUtf8 || !kanji[i-1]) && (c==' ' || c=='!' || c=='*' || c=='>' || c=='&' || c=='~' || c=='#' || c =='$' || c=='(' || c==')' || c=='\\' || c=='|' || c=='[' || c==']' || c=='{' || c=='}' || c==';' || c=='\'' || c=='"' || c=='<' || c=='>' || c=='?'))
            {
                *p++ = '\\';
                *p++ = c;
            }
            else {
                *p++ = c;
            }
        }
        if(*(p-1) != '/') {
            if(gCompletionSqort && !gCompletionLastSqort) {
                *p++ = '\'';
                *p++ = ' ';
            }
            else if(gCompletionDqort && !gCompletionLastDqort) {
                *p++ = '"';
                *p++ = ' ';
            }
            else if(gCompletionAddSpace && !gCompletionLastSqort
                    && !gCompletionLastDqort)
            {
                *p++ = ' ';
            }
        }
        *p = 0;

        
        string_obj* str = gCmdLine;
        char* cstr = string_c_str(str);

        /// ⊮} ///
        string_insert(str, gCmdLineCursor, tmp);
        gCmdLineCursor+=strlen(tmp);

        cmdline_completion_clear();
        gCompletionCursor = -1;
        cmdline_hcandidate_refresh();
        return;
    }
    else if(key == 4 || key == 22 || key == KEY_NPAGE) {    // CTRL-D CTRL-V
        if(vector_size(gCExplanation) == 0) 
            gCompletionCursor+=20;
        else
            gCompletionCursor+=5;
    }
    else if(key == 21 || meta==1&&key=='v' || key == KEY_PPAGE) {    // CTRL-U Meta-v
        if(vector_size(gCExplanation) == 0)
            gCompletionCursor-=20;
        else
            gCompletionCursor-=5;
    }
    else if(key == 3 || key == 7 || key == 27 || key == 8) { // CTRL-C CTRL-G Escape
        gCompletionCursor = -1;
        gCompletionScrollTop = 0;

        cmdline_completion_clear();
        return;
    }
    else {
        gCompletionCursor = -1;
        gCompletionScrollTop = 0;
        
        cmdline_completion_clear();

        cmdline_input(meta, key);
    }

    if(gCompletionCursor < 0) {
        gCompletionCursor = vector_size(gCCandidate)-1;
    }
    if(gCompletionCursor >= vector_size(gCCandidate)) {
        gCompletionCursor = 0;
        //        gCompletionCursor = vector_size(gCCandidate)-1;
    }

    const int maxy = mgetmaxy();
    if(vector_size(gCExplanation) == 0) {
        if(gCompletionCursor < gCompletionScrollTop) {
            gCompletionScrollTop = (gCompletionCursor/((maxy-2)*gCmdLineCompletionMaxRow))*((maxy-2)*gCmdLineCompletionMaxRow);
        }
        if(gCompletionCursor > gCompletionScrollTop + (maxy-3)*gCmdLineCompletionMaxRow) {
            gCompletionScrollTop = (gCompletionCursor/((maxy-2)*gCmdLineCompletionMaxRow))*((maxy-2)*gCmdLineCompletionMaxRow);
        }
    }
    else {
        if(gCompletionCursor < gCompletionScrollTop) {
            gCompletionScrollTop = (gCompletionCursor/(maxy-2))*(maxy-2);
        }
        if(gCompletionCursor > gCompletionScrollTop + maxy-3) {
            gCompletionScrollTop = (gCompletionCursor/(maxy-2))*(maxy-2);
        }
    }
}
