#ifndef MFILER3_COMMON_H
#define MFILER3_COMMON_H

#define _LARGEFILE_SOURCE
#define _LARGEFILE64_SOURCE
#define _FILE_OFFSET_BITS 64

#include "config.h"

#include <string.h>

#if defined(HAVE_BOEHMGC_H)
#include <gc.h>
#elif defined(HAVE_BOEHMGC2_H)
#include <gc/gc.h>
#endif

#if !defined(HAVE_GCSTRDUP)
extern char* GC_strdup(char* str);
#endif

#include <ruby.h>

extern VALUE ruby_errinfo;          // eval後のエラーメッセージで必要

#define TAG_RETURN	0x1             // 同上
#define TAG_BREAK	0x2
#define TAG_NEXT	0x3
#define TAG_RETRY	0x4
#define TAG_REDO	0x5
#define TAG_RAISE	0x6
#define TAG_THROW	0x7
#define TAG_FATAL	0x8


#include "minato_extra.h"
#include "minato_curses.h"
#include "minato_vector.h"
#include "minato_string.h"
#include "minato_list.h"
#include "minato_hash.h"

#include <stdio.h>
#include <stdlib.h>
#include <limits.h>

#if defined(S_ISTXT)
    #define S_ALLPERM (S_IRWXU|S_IRWXG|S_IRWXO|S_ISUID|S_ISGID|S_ISTXT)
#elif defined(S_ISVTX)
    #define S_ALLPERM (S_IRWXU|S_IRWXG|S_IRWXO|S_ISUID|S_ISGID|S_ISVTX)
#else
    #define S_ALLPERM (S_IRWXU|S_IRWXG|S_IRWXO|S_ISUID|S_ISGID)
#endif

///////////////////////////////////////////////////////////////////////////////
// main.c
///////////////////////////////////////////////////////////////////////////////
extern char gTempDir[PATH_MAX];
extern char gHomeDir[PATH_MAX];
extern BOOL gMainLoop;          // メインループを回すかどうか
extern BOOL gChangeTerminalTitle;

extern void (*gView)();          // 登録描写関数
extern void (*gView2)();          // 登録描写関数

extern int gBreak;
void set_signal_sigint_clear();
void set_signal_sigint();

void set_signal_clear();
void set_signal_mfiler3();
void set_signal_subshell();
void set_signal_clear_all();
void view();

extern BOOL gFocus;
extern char gTitleBar[BUFSIZ];

///////////////////////////////////////////////////////////////////////////////
// menu.c
///////////////////////////////////////////////////////////////////////////////
typedef struct {
    char* mName;
    int mKey;
    char* mCmd;
} sMenuItem;

typedef struct {
    char mTitle[256];

    int mScrollTop;
    int mCursor;

    vector_obj* mMenuItems; 
} sMenu;

extern hash_obj* gMenu;
extern sMenu* gActiveMenu;

sMenu* sMenu_new(char* title);
void menu_view(sMenu* self);
void menu_input(sMenu* self, int meta, int key);
void menu_append(sMenu* self, char* name, int key, char* cmd);
void menu_init();

///////////////////////////////////////////////////////////////////////////////
// isearch.c
///////////////////////////////////////////////////////////////////////////////
#include "oniguruma.h"

#if defined(HAVE_MIGEMO_H)

#include "migemo.h"

extern migemo* gMigemo;
#endif

extern BOOL gISearch;           // インクリメンタルサーチ中かどうか

void isearch_init();                           // インクリメンタルサーチ初期化
void isearch_final();                          // インクリメンタルサーチ解放

void isearch_input(int meta, int key); // インクリメンタルサーチキー入力
void isearch_view();                            // インクリメンタルサーチ描写

void isearch_reload_migemo_dict(); // エンコードにあわせたmigemoの辞書再ロード

BOOL gISearchExplore;           // エキスプローラー風インクリメンタルサーチ
BOOL IsISearchExploreChar(int meta, int key);
void isearch_explore_input(int meta, int key);
void isearch_explore_view();
BOOL IsISearchNULL();
void ISearchClear();

///////////////////////////////////////////////////////////////////////////////
// cmdline
///////////////////////////////////////////////////////////////////////////////
BOOL gCmdLineActive;
string_obj* gCmdLine;
int gCmdLineCursor;
#define kCmdLineMax 16000

void cmdline_init();
void cmdline_input(int meta, int key);
void cmdline_view();

int gHistoryScrollTop;
int gHistoryCursor;

vector_obj* gHCandidate;

void cmdline_history_view();
void cmdline_history_input(int meta, int key);
void cmdline_hcandidate_refresh();
void cmdline_start(char* str, int cursor);

///////////////////////////////////////////////////////////////////////////////
// cmdline_completion.c
///////////////////////////////////////////////////////////////////////////////
extern vector_obj* gCCandidate;
extern vector_obj* gPrograms;             // プログラム名補完候補
extern vector_obj* gEnvirons;             // 環境変数補完候補

void cmdline_completion_init();
void cmdline_rehash();

void cmdline_completion_view();
void cmdline_completion_input(int meta, int key);

void cmdline_completion_main();

void cmdline_completion(vector_obj* all_candidate, char* editing, BOOL add_space);
void cmdline_completion2(vector_obj* all_candidate, char* editing, bool add_space, int candidate_len);

void cmdline_completion_file(char* editing_dir, char* editing_file, char* editing, int editing_position);
void cmdline_completion_program(char* editing_dir, char* editing_file, char* editing, int editing_position);

void cmdline_completion_clear();

///////////////////////////////////////////////////////////////////////////////
// gui.c
///////////////////////////////////////////////////////////////////////////////
int msg(char* msg, ...);
int select_str(char* msg, char* str[], int len, int cancel);
int select_str2(char* msg, char* str[], int len, int cancel);
int input_box(char* msg, char* result, char* def_input, int def_cursor);
void msg_nonstop(char* msg, ...);

///////////////////////////////////////////////////////////////////////////////
// filer.c
///////////////////////////////////////////////////////////////////////////////
#include "filer.h"

///////////////////////////////////////////////////////////////////////////////
// shell.c
///////////////////////////////////////////////////////////////////////////////
#include "shell.h"

///////////////////////////////////////////////////////////////////////////////
// command.c
///////////////////////////////////////////////////////////////////////////////
void command_exit();

///////////////////////////////////////////////////////////////////////////////
// file.c
///////////////////////////////////////////////////////////////////////////////
enum eCopyOverride { kNone, kYesAll, kNoAll, kCancel, kSelectNewer };
extern enum eCopyOverride gCopyOverride;

enum eWriteProtected { kWPNone, kWPYesAll, kWPNoAll, kWPCancel };
extern enum eWriteProtected gWriteProtected;

BOOL file_copy(char* spath, char* dpath, BOOL move, BOOL preserve);
BOOL file_remove(char* path, BOOL no_ctrl_c, BOOL msg);

///////////////////////////////////////////////////////////////////////////////
// ruby fun
///////////////////////////////////////////////////////////////////////////////
void ruby_fun_init();

///////////////////////////////////////////////////////////////////////////////
// tar
///////////////////////////////////////////////////////////////////////////////
int tar_print_long_ls_all(char* path);

/*
///////////////////////////////////////////////////////////////////////////////
// super isearch
///////////////////////////////////////////////////////////////////////////////
extern BOOL gSISearch;
extern int gCandiateMaxAscii;
extern int gCandidateMaxMigemo;
extern BOOL gSISearchMigemo;

void sisearch_init();
void sisearch_final();
void sisearch_get_cache();
void sisearch_view();
void sisearch_input(int meta, int key);
bool sisearch_cache_exist();
void sisearch_start();
void sisearch_check();
*/
#endif
